/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.rest.inventory;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedApi;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.InventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.InventoryOrderSalesRefundReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.InventoryOrderShipmentCheckReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.LogicPreemptInventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.inventory.service.entity.inventory.ILogicInventoryExposedService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u5e93\u5b58\u4e2d\u5fc3-\u903b\u8f91\u4ed3\u5e93\u5b58\u64cd\u4f5c\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"/v1/logicInventoryExposed"})
public class LogicInventoryExposedController
implements ILogicInventoryExposedApi {
    @Resource
    private ILogicInventoryExposedService inventoryExposedService;

    @PostMapping(value={"/preemptInventoryBackResult"}, produces={"application/json"})
    @ApiOperation(value="\u5e93\u5b58\u9884\u5360\u8fd4\u56de\u9884\u5360\u7ed3\u679c\u4fe1\u606f", notes="\u5e93\u5b58\u9884\u5360\u8fd4\u56de\u9884\u5360\u7ed3\u679c\u4fe1\u606f")
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=200L, maxDelay=1000L, multiplier=1.0))
    public RestResponse<InventoryOperateRespDto> preemptInventoryBackResult(@RequestBody LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        return new RestResponse((Object)this.inventoryExposedService.preemptInventoryBackResult(logicPreemptInventoryOperateReqDto));
    }

    @PostMapping(value={"/{orderNo}/continueDelivery"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u8ba2\u5355\u53f7\u8fdb\u884c\u7ee7\u7eed\u53d1\u8d27", notes="\u6839\u636e\u8ba2\u5355\u53f7\u8fdb\u884c\u7ee7\u7eed\u53d1\u8d27")
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=200L, maxDelay=1000L, multiplier=1.0))
    public RestResponse<Boolean> continueDelivery(@PathVariable(value="orderNo") String orderNo) {
        return new RestResponse(InventoryConfig.lock(() -> this.inventoryExposedService.continueDelivery(orderNo), (String)orderNo, (String)"continueDelivery"));
    }

    @PostMapping(value={"/orderShipmentCheck"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u5355\u4e0e\u672c\u6b21\u7269\u6d41\u5355\u53f7\u662f\u5426\u4e00\u81f4", notes="\u67e5\u8be2\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u5355\u4e0e\u672c\u6b21\u7269\u6d41\u5355\u53f7\u662f\u5426\u4e00\u81f4")
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=200L, maxDelay=1000L, multiplier=1.0))
    public RestResponse<Boolean> orderShipmentCheck(@RequestBody InventoryOrderShipmentCheckReqDto inventoryOrderShipmentCheckReqDto) {
        return new RestResponse((Object)this.inventoryExposedService.orderShipmentCheck(inventoryOrderShipmentCheckReqDto));
    }

    @PostMapping(value={"/releaseAndPreemptInventory"}, produces={"application/json"})
    @ApiOperation(value="\u91ca\u653e\u5355\u636e\u539f\u5df2\u9884\u5360\u7684\u903b\u8f91\u4ed3\u5e93\u5b58\u5e76\u4e14\u6839\u636e\u4fe1\u606f\u91cd\u65b0\u9884\u5360", notes="\u91ca\u653e\u5355\u636e\u539f\u5df2\u9884\u5360\u7684\u903b\u8f91\u4ed3\u5e93\u5b58\u5e76\u4e14\u6839\u636e\u4fe1\u606f\u91cd\u65b0\u9884\u5360")
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=200L, maxDelay=1000L, multiplier=1.0))
    public RestResponse<Boolean> releaseAndPreemptInventory(@Validated @RequestBody LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        return new RestResponse((Object)this.inventoryExposedService.releaseAndPreemptInventory(logicPreemptInventoryOperateReqDto));
    }

    @PostMapping(value={"/deductionInventoryOrder"}, produces={"application/json"})
    @ApiOperation(value="\u751f\u6210\u53d1\u3001\u6536\u8d27\u7ed3\u679c\u5355\uff0c\u51fa\u3001\u5165\u5e93\u7ed3\u679c\u5355\uff08\u51fa\u5e93\u76f4\u63a5\u6263\u51cf\u5e93\u5b58\uff09", notes="\u751f\u6210\u53d1\u3001\u6536\u8d27\u7ed3\u679c\u5355\uff0c\u51fa\u3001\u5165\u5e93\u7ed3\u679c\u5355\uff08\u51fa\u5e93\u76f4\u63a5\u6263\u51cf\u5e93\u5b58\uff09")
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=200L, maxDelay=1000L, multiplier=1.0))
    public RestResponse<Boolean> deductionInventoryOrder(@RequestBody LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        return new RestResponse((Object)this.inventoryExposedService.deductionInventoryOrder(logicPreemptInventoryOperateReqDto));
    }

    @PostMapping(value={"/releaseInventoryByStrategy"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u4f20\u5165\u7684\u5e93\u5b58\u7b56\u7565\u8fdb\u884c\u5bf9\u5e94\u5e93\u5b58\u91ca\u653e", notes="\u6839\u636e\u4f20\u5165\u7684\u5e93\u5b58\u7b56\u7565\u8fdb\u884c\u5bf9\u5e94\u5e93\u5b58\u91ca\u653e")
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=200L, maxDelay=1000L, multiplier=1.0))
    public RestResponse<Boolean> releaseInventoryByStrategy(@Validated @RequestBody InventoryOperateReqDto inventoryOperateReqDto) {
        return new RestResponse((Object)this.inventoryExposedService.releaseInventoryByStrategy(inventoryOperateReqDto));
    }

    @PostMapping(value={"/addInventory"}, produces={"application/json"})
    @ApiOperation(value="\u589e\u52a0\u5e93\u5b58", notes="\u589e\u52a0\u5e93\u5b58")
    public RestResponse<Void> addInventory(@RequestBody InventoryOperateReqDto inventoryOperateReqDto) {
        this.inventoryExposedService.addInventory(inventoryOperateReqDto);
        return new RestResponse();
    }

    @GetMapping(value={"/{sourceNo}/checkHangUp"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u9500\u552e\u5355\u53f7\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u6302\u8d77", notes="\u6839\u636e\u9500\u552e\u5355\u53f7\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u6302\u8d77")
    public RestResponse<Boolean> checkHangUp(@PathVariable(value="sourceNo") String sourceNo) {
        return new RestResponse((Object)this.inventoryExposedService.checkHangUp(sourceNo));
    }

    @GetMapping(value={"/{sourceNo}/checkCancelHangUp"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u9500\u552e\u5355\u53f7\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u89e3\u6302", notes="\u6839\u636e\u9500\u552e\u5355\u53f7\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u89e3\u6302")
    public RestResponse<Boolean> checkCancelHangUp(@PathVariable(value="sourceNo") String sourceNo) {
        return new RestResponse((Object)this.inventoryExposedService.checkCancelHangUp(sourceNo));
    }

    @PostMapping(value={"/orderSalesRefundConfirm"}, produces={"application/json"})
    @ApiOperation(value="\u9500\u552e\u9000\u786e\u8ba4\u64cd\u4f5c", notes="\u9500\u552e\u9000\u786e\u8ba4\u64cd\u4f5c")
    public RestResponse<List<String>> orderSalesRefundConfirm(@RequestBody InventoryOrderSalesRefundReqDto outDeliveryReqDto) {
        return new RestResponse((Object)this.inventoryExposedService.orderSalesRefundConfirm(outDeliveryReqDto));
    }
}

