/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.dict.proxy.query.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.data.DataDictDto;
import com.yunxi.dg.base.center.dict.api.query.IPcpDictQueryApi;
import com.yunxi.dg.base.center.dict.dto.Schemas.DictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.Schemas.DictExtRespDto;
import com.yunxi.dg.base.center.inventory.dto.Schemas.DictQueryExtReqDto;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.api.proxy.AbstractApiProxyImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcpDictQueryApiProxyImpl
extends AbstractApiProxyImpl<IPcpDictQueryApi, IPcpDictQueryApiProxy>
implements IPcpDictQueryApiProxy {
    private static final Logger log = LoggerFactory.getLogger(PcpDictQueryApiProxyImpl.class);
    @Resource
    private IPcpDictQueryApi api;

    public IPcpDictQueryApi api() {
        return (IPcpDictQueryApi)Optional.ofNullable(super.api()).orElse(this.api);
    }

    @Override
    public RestResponse<List<DictDto>> queryByGroupCode(String groupCode) {
        return Optional.ofNullable(this.proxy()).flatMap(proxy -> Optional.ofNullable(proxy.queryByGroupCode(groupCode))).orElseGet(() -> this.api().queryByGroupCode(groupCode));
    }

    @Override
    public DictDto queryByGroupCodeAndCode(String groupCode, String code) {
        DictQueryExtReqDto dictQueryExtReqDto = new DictQueryExtReqDto();
        dictQueryExtReqDto.setGroupCodes(Collections.singletonList(groupCode));
        dictQueryExtReqDto.setValues(Collections.singletonList(code));
        List dictExtRespDtos = (List)RestResponseHelper.extractData(this.api.queryByParam(dictQueryExtReqDto));
        DictDto dictDto = new DictDto();
        Optional.ofNullable(dictExtRespDtos).filter(CollectionUtils::isNotEmpty).map(dicts -> (DictExtRespDto)dicts.get(0)).ifPresent(o -> {
            dictDto.setStatement(o.getStatement());
            dictDto.setSubDescr(o.getSubDescr());
            dictDto.setSubLabel(o.getSubLabel());
            dictDto.setSubValue(o.getSubValue());
            dictDto.setGroupCode(o.getGroupCode());
            dictDto.setCode(o.getCode());
            dictDto.setValue(o.getValue());
        });
        return dictDto;
    }

    @Override
    public DataDictDto basicDataInfo(String basicDataBusinessType) {
        if (null != this.proxy()) {
            return ((IPcpDictQueryApiProxy)this.proxy()).basicDataInfo(basicDataBusinessType);
        }
        try {
            log.info("\u57fa\u7840\u5355\u636e\u751f\u6210,basicDataInfo==>basicDataBusinessType:{}", (Object)basicDataBusinessType);
            if (StringUtils.isBlank((CharSequence)basicDataBusinessType)) {
                return new DataDictDto();
            }
            DictQueryExtReqDto dictQueryExtReqDto1 = new DictQueryExtReqDto();
            dictQueryExtReqDto1.setGroupCodes(Arrays.asList("inventoryOrderType"));
            List<String> valueList = Optional.ofNullable(RestResponseHelper.extractData(this.api.queryByParam(dictQueryExtReqDto1))).orElse(Arrays.asList(new DictExtRespDto[0])).stream().map(DictExtRespDto::getSubValue).collect(Collectors.toList());
            DictQueryExtReqDto dictQueryExtReqDto = new DictQueryExtReqDto();
            dictQueryExtReqDto.setValues(Collections.singletonList(basicDataBusinessType));
            dictQueryExtReqDto.setCodes(valueList);
            List dictExtRespDtos = (List)RestResponseHelper.extractData(this.api.queryByParam(dictQueryExtReqDto));
            log.info("basicDataInfo==>dictExtRespDtos:{}", (Object)LogUtils.buildLogContent((Collection)dictExtRespDtos));
            DataDictDto dataDictDto = new DataDictDto();
            Optional.ofNullable(dictExtRespDtos).filter(CollectionUtils::isNotEmpty).map(dicts -> (DictExtRespDto)dicts.get(0)).ifPresent(o -> {
                dataDictDto.setStatement(o.getStatement());
                dataDictDto.setSubValue(o.getSubValue());
                dataDictDto.setSubLabel(o.getSubLabel());
                dataDictDto.setSubDescr(o.getSubDescr());
                dataDictDto.setGroupCode(o.getGroupCode());
                dataDictDto.setCode(o.getCode());
                dataDictDto.setValue(o.getValue());
            });
            return dataDictDto;
        }
        catch (Throwable e) {
            log.error("basicDataInfo==>e:{}", e);
            return new DataDictDto();
        }
    }

    @Override
    public List<DataDictDto> queryByCodeList(List<String> codeList) {
        return codeList.stream().map(this::basicDataInfo).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<DataDictDto> generalBasicDataInfo(List<String> codeList) {
        ArrayList<DataDictDto> dataDictDtoList = new ArrayList<DataDictDto>();
        if (null != this.proxy()) {
            return ((IPcpDictQueryApiProxy)this.proxy()).generalBasicDataInfo(codeList);
        }
        try {
            log.info("\u67e5\u8be2\u5b57\u5178code,basicDataInfo==>basicDataBusinessType:{}", (Object)JSONObject.toJSONString(codeList));
            if (CollectionUtils.isEmpty(codeList)) {
                return dataDictDtoList;
            }
            DictQueryExtReqDto dictQueryExtReqDto = new DictQueryExtReqDto();
            dictQueryExtReqDto.setCodes(codeList);
            List dictExtRespDtos = (List)RestResponseHelper.extractData(this.api.queryByParam(dictQueryExtReqDto));
            List dataDictDtoList1 = BeanUtil.copyToList((Collection)dictExtRespDtos, DataDictDto.class);
            log.info("basicDataInfo==>dictExtRespDtos:{}", (Object)LogUtils.buildLogContent((Collection)dictExtRespDtos));
            return dataDictDtoList1;
        }
        catch (Throwable e) {
            log.error("basicDataInfo==>e:{}", e);
            return dataDictDtoList;
        }
    }

    @Override
    public DictDto querySameTableByGroupCodeAndCode(String groupCode, String code) {
        return Optional.ofNullable(this.proxy()).flatMap(proxy -> Optional.ofNullable(proxy.queryByGroupCodeAndCode(groupCode, code))).orElseGet(() -> (DictDto)this.api.queryByGroupCodeAndCode(groupCode, code).getData());
    }

    @Override
    public List<DictExtRespDto> queryByParam(DictQueryExtReqDto dictQueryExtReqDto) {
        return Optional.ofNullable(this.proxy()).flatMap(proxy -> Optional.ofNullable(proxy.queryByParam(dictQueryExtReqDto))).orElseGet(() -> (List)this.api.queryByParam(dictQueryExtReqDto).getData());
    }
}

