/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.abstracts;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsOutNoticePushStatusEnum;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.PushOrderWmsEvent;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public abstract class AbstractInOutNoticeOrderAble
implements InOutNoticeOrderAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractInOutNoticeOrderAble.class);
    @Resource
    GenerateCodeUtil generateCodeUtil;
    @Resource
    public IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    public IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    public ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void doGenerate(InOutNoticeOrderContext context) {
        log.info("\u751f\u6210\u5165\u51fa\u5e93\u901a\u77e5\u5355,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)context));
        InOutNoticeOrderEo inOutNoticeOrderEo = this.getInOutNoticeOrderEo(context);
        List<InOutNoticeOrderDetailEo> detailEoList = context.getOrderBasicsDetailReqDtoList().stream().map(d -> this.getInOutNoticeOrderDetailEo(context, inOutNoticeOrderEo, (BaseOrderDetailReqDto)d)).collect(Collectors.toList());
        context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        context.setInOutNoticeOrderDetailEoList(detailEoList);
        this.wrapperGenerate(context);
        context.execBefore();
        log.info("\u751f\u6210\u5165\u51fa\u5e93\u901a\u77e5\u5355 execBefore:{}", (Object)LogUtils.buildLogContent((Object)context));
        if (!context.isOnlyGenResult() || !context.getAutoComplete().booleanValue()) {
            this.inOutNoticeOrderDomain.insert((BaseEo)context.getInOutNoticeOrderEo());
            this.inOutNoticeOrderDetailDomain.insertBatch(context.getInOutNoticeOrderDetailEoList());
        }
        this.wrapperGenerateAfter(context);
        context.execAfter();
    }

    protected abstract void wrapperGenerate(InOutNoticeOrderContext var1);

    protected abstract void wrapperGenerateAfter(InOutNoticeOrderContext var1);

    private InOutNoticeOrderDetailEo getInOutNoticeOrderDetailEo(InOutNoticeOrderContext context, InOutNoticeOrderEo inOutNoticeOrderEo, BaseOrderDetailReqDto d) {
        InOutNoticeOrderDetailEo detailEo = (InOutNoticeOrderDetailEo)BeanUtil.copyProperties((Object)d, InOutNoticeOrderDetailEo.class, (String[])new String[]{"id"});
        detailEo.setSkuCode(d.getSkuCode());
        detailEo.setSkuName(d.getSkuName());
        detailEo.setBatch(d.getBatch());
        detailEo.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        detailEo.setPlanQuantity(d.getQuantity());
        detailEo.setCancelQuantity(BigDecimal.ZERO);
        if (context.getAutoComplete().booleanValue()) {
            detailEo.setWaitQuantity(BigDecimal.ZERO);
            detailEo.setDoneQuantity(d.getQuantity());
        } else {
            detailEo.setDoneQuantity(BigDecimal.ZERO);
            detailEo.setWaitQuantity(d.getQuantity());
        }
        detailEo.setExternalOrderNo(context.getExternalOrderNo());
        detailEo.setPreOrderNo(context.getPreOrderNo());
        detailEo.setRelevanceNo(context.getRelevanceNo());
        detailEo.setInitFlag(YesNoEnum.YES.getValue());
        detailEo.setExtension(d.getExtension());
        detailEo.setPreOrderItemId(d.getPreOrderItemId());
        detailEo.setItemStatus(StringUtils.isNotBlank((CharSequence)d.getItemStatus()) ? d.getItemStatus() : CsPlannedOrderItemStatusEnum.COMMON.getCode());
        detailEo.setProduceTime(d.getProduceTime());
        detailEo.setExpireTime(d.getExpireTime());
        return detailEo;
    }

    private InOutNoticeOrderEo getInOutNoticeOrderEo(InOutNoticeOrderContext context) {
        InOutNoticeOrderEo inOutNoticeOrderEo = Optional.ofNullable(context.getInOutNoticeOrderEo()).orElse(new InOutNoticeOrderEo());
        context.setDocumentNo(this.getDocumentNo(context));
        BeanUtil.copyProperties((Object)context, (Object)inOutNoticeOrderEo, (String[])new String[]{"shipmentEnterpriseCode", "shipmentEnterpriseName"});
        inOutNoticeOrderEo.setRelevanceTableName(context.getRelevanceTableName().getCode());
        inOutNoticeOrderEo.setPreOrderNo(context.getPreOrderNo());
        inOutNoticeOrderEo.setRelevanceNo(context.getRelevanceNo());
        inOutNoticeOrderEo.setExternalOrderNo(context.getExternalOrderNo());
        inOutNoticeOrderEo.setBusinessType(context.getBusinessType());
        inOutNoticeOrderEo.setOrderStatus(context.getOrderStatus().getCode());
        inOutNoticeOrderEo.setOrderType(BaseOrderOperateTypeEnum.OUT.equals((Object)context.getOperateTypeEnum()) ? "out" : "in");
        inOutNoticeOrderEo.setTotalQuantity(context.getTotalQuantity() == null ? BigDecimal.ZERO : context.getTotalQuantity());
        inOutNoticeOrderEo.setRemark(context.getRemark());
        inOutNoticeOrderEo.setExtension(context.getExtension());
        inOutNoticeOrderEo.setNoBatch(context.getNoBatch());
        if (StringUtils.isNotBlank((CharSequence)context.getShipmentEnterpriseCode())) {
            inOutNoticeOrderEo.setShipmentEnterpriseCode(context.getShipmentEnterpriseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)context.getShipmentEnterpriseName())) {
            inOutNoticeOrderEo.setShipmentEnterpriseName(context.getShipmentEnterpriseName());
        }
        log.info("context\u7684\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606finitInOutNoticeOrderEo\uff1a{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderEo));
        return inOutNoticeOrderEo;
    }

    protected String getDocumentNo(InOutNoticeOrderContext context) {
        if (BaseOrderOperateTypeEnum.OUT.equals((Object)context.getOperateTypeEnum())) {
            return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.OUT_NOTICE_ORDER.getCode()));
        }
        return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.IN_NOTICE_ORDER.getCode()));
    }

    @Override
    public void doClose(InOutNoticeOrderContext context) {
    }

    @Override
    public void pushWms(InOutNoticeOrderContext inOutNoticeOrderContext) {
        PushOrderWmsEvent pushOrderWmsEvent = new PushOrderWmsEvent(inOutNoticeOrderContext);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)pushOrderWmsEvent);
    }

    @Override
    public void validRepeat(InOutNoticeOrderContext context) {
        ArrayList focusStatusList;
        String logicWarehouseCode;
        String orderType;
        switch (context.getOperateTypeEnum()) {
            case IN: {
                orderType = "in";
                logicWarehouseCode = context.getLogicWarehouseCode();
                focusStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode()});
                if (!context.getMultipleOut().booleanValue()) break;
                return;
            }
            case OUT: {
                orderType = "out";
                logicWarehouseCode = context.getLogicWarehouseCode();
                focusStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode(), BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode()});
                break;
            }
            default: {
                return;
            }
        }
        HashMap repeatMap = Maps.newHashMap();
        List csOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"order_type", (Object)orderType)).eq((Object)"in_logic_warehouse_code", (Object)logicWarehouseCode)).eq((Object)"relevance_no", (Object)context.getRelevanceNo())).in((Object)"order_status", (Collection)focusStatusList)).list();
        if (CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderEos)) {
            List noticeNoList = csOutNoticeOrderEos.stream().map(InOutNoticeOrderEo::getDocumentNo).distinct().collect(Collectors.toList());
            List detailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().in((Object)"document_no", noticeNoList)).list();
            for (BaseOrderDetailReqDto csBasicsOrderDetailReqDto : context.getOrderBasicsDetailReqDtoList()) {
                for (InOutNoticeOrderDetailEo detailEo : detailEoList) {
                    if (!StringUtils.equals((CharSequence)csBasicsOrderDetailReqDto.getSkuCode(), (CharSequence)detailEo.getSkuCode()) || !StringUtils.equals((CharSequence)csBasicsOrderDetailReqDto.getBatch(), (CharSequence)detailEo.getBatch())) continue;
                    repeatMap.put(detailEo.getSkuCode(), detailEo.getBatch());
                }
            }
        }
        log.info("repeatMap: {}", (Object)JSON.toJSONString((Object)repeatMap));
        if (MapUtils.isNotEmpty((Map)repeatMap)) {
            if (context.getIgnoreRepeat().booleanValue()) {
                context.getOrderBasicsDetailReqDtoList().removeIf(o -> StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)((CharSequence)repeatMap.get(o.getSkuCode()))));
            } else {
                throw new BizException(context.getRelevanceNo() + "\u5355\u636e\u5df2\u751f\u6210\u51fa/\u5165\u5e93\u901a\u77e5\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            }
        }
    }

    @Override
    public boolean validCancel(InOutNoticeOrderContext context) {
        this.validHas(context);
        return true;
    }

    @Override
    public boolean validClose(InOutNoticeOrderContext context) {
        this.validHas(context);
        if (BaseOrderStatusEnum.FINISH_OVER.getCode().equals(context.getInOutNoticeOrderEo().getOrderStatus())) {
            log.error("\u5df2\u5b8c\u7ed3\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u5b8c\u7ed3:{}", (Object)context.getDocumentNo());
            return false;
        }
        return true;
    }

    private void validHas(InOutNoticeOrderContext context) {
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)context.getDocumentNo())).last(" limit 1")).one();
        AssertUtil.isTrue((null != inOutNoticeOrderEo ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        context.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutNoticeOrderEo.getRelevanceTableName()));
    }

    @Override
    public void complete(InOutNoticeOrderContext inOutNoticeOrderContext) {
        log.info("\u5b8c\u6210\u66f4\u65b0\u5165\u51fa\u5e93\u901a\u77e5\u5355\u72b6\u6001\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderContext));
        Optional inOutNoticeOrderEoOpt = ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderContext.getDocumentNo())).oneOpt();
        AssertUtils.isTrue((boolean)inOutNoticeOrderEoOpt.isPresent(), (String)"\u8c03\u7528\u5b8c\u6210\u5355\u636e\u4e0d\u5b58\u5728");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoOpt.get();
        List detailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderContext.getDocumentNo())).list();
        Map<String, BigDecimal> orderDetailReqDtoMap = inOutNoticeOrderContext.getOrderBasicsDetailReqDtoList().stream().collect(Collectors.groupingBy(r -> r.getPreOrderItemId() + "_" + r.getLineNo(), Collectors.mapping(BaseOrderDetailReqDto::getQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        detailEoList.forEach(detailEo -> Optional.ofNullable(orderDetailReqDtoMap.get(String.format("%s_%s", detailEo.getPreOrderItemId(), detailEo.getLineNo()))).ifPresent(q -> {
            detailEo.setDoneQuantity(BigDecimalUtils.add((BigDecimal)detailEo.getDoneQuantity(), (BigDecimal)q));
            detailEo.setWaitQuantity(DataExtractUtils.ifLtZeroSetZero((BigDecimal)detailEo.getWaitQuantity().subtract((BigDecimal)q)));
        }));
        if (!inOutNoticeOrderContext.isNoticeEnd() && this.checkEnd(inOutNoticeOrderContext, detailEoList)) {
            inOutNoticeOrderContext.setNoticeEnd(true);
        }
        inOutNoticeOrderEo.setOrderStatus(this.getCompleteStatus(inOutNoticeOrderContext));
        this.inOutNoticeOrderDomain.getMapper().updateById((BaseEo)inOutNoticeOrderEo);
        this.inOutNoticeOrderDetailDomain.getMapper().updateBatchByIds(detailEoList);
        inOutNoticeOrderContext.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        inOutNoticeOrderContext.setInOutNoticeOrderDetailEoList(detailEoList);
    }

    private boolean checkEnd(InOutNoticeOrderContext inOutNoticeOrderContext, List<InOutNoticeOrderDetailEo> detailEoList) {
        return detailEoList.stream().noneMatch(r -> BigDecimalUtils.gtZero((BigDecimal)r.getWaitQuantity())) || inOutNoticeOrderContext.isNoticeEndModule() && detailEoList.stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode, Collectors.mapping(r -> BigDecimalUtils.subtract((BigDecimal)r.getPlanQuantity(), (BigDecimal)r.getDoneQuantity()), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))).values().stream().allMatch(BigDecimalUtils::eqZero);
    }

    protected abstract String getCompleteStatus(InOutNoticeOrderContext var1);

    @Override
    public void doSubmit(InOutNoticeOrderContext context) {
        log.info("doSubmit\uff1a{}", (Object)JSON.toJSONString((Object)context));
        String documentNo = context.getInOutNoticeOrderEo().getDocumentNo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)documentNo);
        queryWrapper.eq((Object)"dr", (Object)0);
        List eoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        log.info("eoList:{}", (Object)JSON.toJSONString((Object)eoList));
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)eoList), (String)"\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u5165\u51fa\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)eoList.get(0);
        AssertUtil.isFalse((CsOutNoticePushStatusEnum.SUCCESS.getCode().equals(inOutNoticeOrderEo.getPushStatus()) || CsOutNoticePushStatusEnum.WITHOUT_PUSH.getCode().equals(inOutNoticeOrderEo.getPushStatus()) ? 1 : 0) != 0, (String)String.format("\u5355\u53f7\uff1a%s \u63a8\u9001\u6210\u529f\u548c\u65e0\u9700\u63a8\u9001\u4e0d\u7528\u63a8\u9001\u5230wms", documentNo));
        AssertUtil.isFalse((!BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)String.format("\u5355\u53f7\uff1a%s \u975e\u5f85\u63d0\u4ea4\u6216\u5f85\u5165\u5e93\u72b6\u6001\u4e0d\u80fd\u63a8\u9001\u5230wms", documentNo));
        if ("in".equals(inOutNoticeOrderEo.getOrderType())) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", new Object[]{inOutNoticeOrderEo.getId()});
        updateWrapper.eq((Object)"dr", (Object)0);
        InOutNoticeOrderEo noticeOrderEo = new InOutNoticeOrderEo();
        noticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_OUT.getCode());
        this.inOutNoticeOrderDomain.getMapper().update((Object)noticeOrderEo, (Wrapper)updateWrapper);
    }

    public void updateStatus(InOutNoticeOrderEo inOutNoticeOrderEo, BaseOrderStatusEnum status) {
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        updateEo.setId(inOutNoticeOrderEo.getId());
        updateEo.setOrderStatus(status.getCode());
        ArrayList businessTypeList = Lists.newArrayList((Object[])new String[]{"internal_deal_return", "internal_deal", "sale_return_internal_deal", "route_internal_deal"});
        if (businessTypeList.contains(inOutNoticeOrderEo.getBusinessType())) {
            updateEo.setDr(YesNoHelper.YES);
        }
        this.inOutNoticeOrderDomain.getMapper().updateById((BaseEo)updateEo);
    }

    public void updateDetailQuantity(InOutNoticeOrderContext context) {
        List outNoticeOrderDetailEoList = Optional.ofNullable(context.getInOutNoticeOrderDetailEoList()).filter(CollectionUtils::isNotEmpty).orElseGet(() -> ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)context.getDocumentNo())).list());
        context.setInOutNoticeOrderDetailEoList(outNoticeOrderDetailEoList);
        for (InOutNoticeOrderDetailEo outNoticeOrderDetailEo : outNoticeOrderDetailEoList) {
            outNoticeOrderDetailEo.setCancelQuantity(outNoticeOrderDetailEo.getWaitQuantity());
            outNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
        }
        outNoticeOrderDetailEoList.forEach(out -> {
            InOutNoticeOrderDetailEo outUpdate = new InOutNoticeOrderDetailEo();
            outUpdate.setId(out.getId());
            outUpdate.setCancelQuantity(out.getCancelQuantity());
            outUpdate.setWaitQuantity(out.getWaitQuantity());
            this.inOutNoticeOrderDetailDomain.updateSelective((BaseEo)out);
        });
    }
}

