/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commons;

import com.alibaba.fastjson.JSON;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class LuaExecutor {
    private static final Logger log = LoggerFactory.getLogger(LuaExecutor.class);
    private final RedisTemplate<String, Object> stringRedisTemplate;

    public LuaExecutor(RedisTemplate<String, Object> redisConnectionFactory) {
        this.stringRedisTemplate = redisConnectionFactory;
    }

    public Object executeLua(String script, List<String> keys, List<String> args) {
        if (log.isDebugEnabled()) {
            log.debug("\u811a\u672c\u4e3a\uff1a{}", (Object)script);
            log.debug("lua\u811a\u672c key:{}\uff0cvalue:{}", (Object)JSON.toJSONString(keys), (Object)JSON.toJSONString(args));
        }
        return this.stringRedisTemplate.execute((RedisScript)new DefaultRedisScript(script, Object.class), keys, args.toArray());
    }

    public List<String> executeLuaList(String script, List<String> keys, List<String> args) {
        if (log.isDebugEnabled()) {
            log.debug("\u811a\u672c\u4e3a\uff1a{}", (Object)script);
            log.debug("lua\u811a\u672c key:{}\uff0cvalue:{}", (Object)JSON.toJSONString(keys), (Object)JSON.toJSONString(args));
        }
        return (List)this.stringRedisTemplate.execute((RedisScript)new DefaultRedisScript(script, List.class), keys, args.toArray());
    }
}

