/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.context;

import com.yunxi.dg.base.center.enums.ProjectEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.DefaultPushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties
@ConfigurationProperties(prefix="inventory.dg.config", ignoreInvalidFields=true)
@Configuration
public class InventoryConfig
implements ApplicationContextAware {
    protected static String projectCode;
    protected static boolean noneBatch;
    protected static boolean multipleOut;
    protected static boolean multipleIn;
    protected static int inventoryPrecision;
    protected static boolean enableUnit;
    protected static Map<String, CodeGenEnum> codeGenEnumMap;
    protected static PushWmsAble pushWmsAble;
    protected static ApplicationEventPublisher applicationEventPublisher;
    protected static GenerateCodeUtil generateCodeUtil;
    protected static boolean logisticsMapping;
    protected static boolean dispatchOrderEnable;

    @Value(value="${yunxi.dg.base.project}")
    public void setProjectCode(String projectCode) {
        InventoryConfig.projectCode = projectCode;
    }

    public void setNoneBatch(boolean noneBatch) {
        InventoryConfig.noneBatch = noneBatch;
    }

    public void setMultipleOut(boolean multipleOut) {
        InventoryConfig.multipleOut = multipleOut;
    }

    public void setMultipleIn(boolean multipleIn) {
        InventoryConfig.multipleIn = multipleIn;
    }

    public static String getProjectCode() {
        return projectCode;
    }

    public static boolean isNoneBatch() {
        return noneBatch;
    }

    public static boolean isMultipleOut() {
        return multipleOut;
    }

    public static boolean isMultipleIn() {
        return multipleIn;
    }

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        InventoryConfig.applicationEventPublisher = applicationEventPublisher;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String property = applicationContext.getEnvironment().getProperty("yunxi.dg.base.project");
        Optional.ofNullable(property).map(ProjectEnum::getByCode).ifPresent(byCode -> {
            noneBatch = byCode.getNoneBatch();
            multipleOut = byCode.getMultipleOut();
            multipleIn = byCode.getMultipleIn();
            inventoryPrecision = byCode.getInventoryPrecision();
            projectCode = property;
        });
        Arrays.stream(CodeGenEnum.values()).sorted(Comparator.comparing(o -> Optional.ofNullable(o.getRefProject()).map(List::size).orElse(-1))).forEach(codeGenEnum -> {
            if (codeGenEnum.getRefProject() == null) {
                codeGenEnumMap.put(codeGenEnum.getCode(), (CodeGenEnum)((Object)codeGenEnum));
            } else {
                boolean hasProjectCodeGen;
                boolean bl = hasProjectCodeGen = codeGenEnumMap.containsKey(codeGenEnum.getCode()) && StringUtils.isNotBlank((CharSequence)property) && codeGenEnum.getRefProject().contains(property);
                if (hasProjectCodeGen) {
                    codeGenEnumMap.put(codeGenEnum.getCode(), (CodeGenEnum)((Object)codeGenEnum));
                }
            }
        });
        pushWmsAble = Optional.of(applicationContext.getBeansOfType(PushWmsAble.class).values()).map(set -> set.stream().filter(s -> Objects.equals(s.getType(), projectCode)).findFirst().orElse((PushWmsAble)applicationContext.getBean(DefaultPushWmsAble.class))).orElse((PushWmsAble)applicationContext.getBean(DefaultPushWmsAble.class));
        generateCodeUtil = (GenerateCodeUtil)applicationContext.getBean(GenerateCodeUtil.class);
        String logisticsMapping = applicationContext.getEnvironment().getProperty("yunxi.dg.base.inventory.logisticsMapping");
        InventoryConfig.logisticsMapping = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{logisticsMapping});
    }

    public static CodeGenEnum getCodeGenByCode(String code) {
        return codeGenEnumMap.get(code);
    }

    public static PushWmsAble getPushWms() {
        return pushWmsAble;
    }

    public static ApplicationEventPublisher getEventPublisher() {
        return applicationEventPublisher;
    }

    public static GenerateCodeUtil getGenerateCodeUtil() {
        return generateCodeUtil;
    }

    public static boolean isLogisticsMapping() {
        return logisticsMapping;
    }

    public static void setLogisticsMapping(ApplicationContext applicationContext) {
        String logisticsMapping = applicationContext.getEnvironment().getProperty("yunxi.dg.base.inventory.logisticsMapping");
        InventoryConfig.logisticsMapping = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{logisticsMapping});
    }

    public static boolean isEnableUnit() {
        return enableUnit;
    }

    @Value(value="${yunxi.dg.base.inventory.enableUnit:false}")
    public void setEnableUnit(boolean enableUnit) {
        InventoryConfig.enableUnit = enableUnit;
    }

    public static int getInventoryPrecision() {
        return inventoryPrecision;
    }

    @Value(value="${yunxi.dg.base.inventory.inventoryPrecision:0}")
    public void setInventoryPrecision(Integer inventoryPrecision) {
        InventoryConfig.inventoryPrecision = inventoryPrecision;
    }

    public static boolean isDispatchOrderEnable() {
        return dispatchOrderEnable;
    }

    @Value(value="${yunxi.dg.base.inventory.dispatchOrder.enable:false}")
    public void setDispatchOrderEnable(boolean dispatchOrderEnable) {
        InventoryConfig.dispatchOrderEnable = dispatchOrderEnable;
    }

    static {
        inventoryPrecision = 0;
        enableUnit = false;
        codeGenEnumMap = new HashMap<String, CodeGenEnum>(CodeGenEnum.values().length);
    }
}

