/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IReleasePreemptAble;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReleasePreemptAbleImpl
extends BaseAble
implements IReleasePreemptAble {
    private static final Logger log = LoggerFactory.getLogger(ReleasePreemptAbleImpl.class);

    @Override
    public void releasePreempt(ReleasePreemptDto dto) {
        List inventoryPreemptionEos;
        log.info("warehouse inventory releasePreempt(\u91ca\u653e\u9884\u5360), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        if (!dto.getAllRelease().booleanValue()) {
            this.checkDetails((CalcDto)dto);
        }
        if (null == dto.getIsSaleOrder()) {
            dto.setIsSaleOrder(Boolean.FALSE);
        }
        if (CollectionUtil.isEmpty((Collection)(inventoryPreemptionEos = this.inventoryPreemptionDomain.queryBySourceNo(dto.getSourceNo())))) {
            if (!dto.getEmptyForError().booleanValue()) {
                return;
            }
            throw new BizException(StrUtil.format((CharSequence)"\u8be5\u5355\u636e[%s]\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55", (Object[])new Object[]{dto.getSourceNo()}));
        }
        dto.setSourceType(((InventoryPreemptionEo)inventoryPreemptionEos.get(0)).getSourceType());
        dto.setExternalOrderNo(((InventoryPreemptionEo)inventoryPreemptionEos.get(0)).getExternalOrderNo());
        if (dto.getAllRelease().booleanValue()) {
            List preemptIds = inventoryPreemptionEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.inventoryPreemptionDomain.allRelease(preemptIds);
            ArrayList details = Lists.newArrayList();
            for (InventoryPreemptionEo preemptionEo : inventoryPreemptionEos) {
                CalcDetailDto detail = new CalcDetailDto();
                detail.setNum(BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()));
                if (BigDecimalUtils.leZero((BigDecimal)detail.getNum()).booleanValue()) continue;
                detail.setLineNo(preemptionEo.getLineNo());
                detail.setSkuCode(preemptionEo.getSkuCode());
                detail.setCargoCode(preemptionEo.getSkuCode());
                detail.setCargoName(preemptionEo.getSkuName());
                detail.setArtNo(preemptionEo.getSkuCode());
                detail.setLogicWarehouseCode(preemptionEo.getWarehouseCode());
                detail.setBatch(preemptionEo.getBatch());
                details.add(detail);
            }
            dto.setDetails((List)details);
            this.checkDetails((CalcDto)dto);
        } else {
            dto.setNoneBatch(Boolean.valueOf(false));
            dto.setNoneLineNo(Boolean.valueOf(false));
            String mapKeyStr = "%s_%s_%s";
            Map calcDetailDtoMap = dto.getDetails().stream().collect(Collectors.toMap(o -> String.format(mapKeyStr, o.getLineNo(), o.getSkuCode(), o.getBatch()), Function.identity()));
            ArrayList updatePreemptionEoList = Lists.newArrayList();
            for (InventoryPreemptionEo preemptionEo : inventoryPreemptionEos) {
                String key = String.format(mapKeyStr, preemptionEo.getLineNo(), preemptionEo.getSkuCode(), preemptionEo.getBatch());
                CalcDetailDto detailDto = (CalcDetailDto)calcDetailDtoMap.get(key);
                if (null == detailDto) continue;
                BigDecimal avaliableReleaseNum = BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum());
                if (BigDecimalUtils.leZero((BigDecimal)avaliableReleaseNum).booleanValue()) {
                    throw new BizException("\u5df2\u8d85\u9884\u5360\u91ca\u653e, \u5df2\u65e0\u53ef\u91ca\u653e\u5e93\u5b58");
                }
                if (BigDecimalUtils.lt((BigDecimal)avaliableReleaseNum, (BigDecimal)detailDto.getNum()).booleanValue()) {
                    detailDto.setNum(avaliableReleaseNum);
                }
                preemptionEo.setReleaseNum(BigDecimalUtils.add((BigDecimal)preemptionEo.getReleaseNum(), (BigDecimal)detailDto.getNum()));
                if (BigDecimalUtils.equals((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()).booleanValue()) {
                    preemptionEo.setValid(ValidFlagEnum.DISABLE.getCode());
                }
                updatePreemptionEoList.add(preemptionEo);
            }
            this.inventoryPreemptionDomain.updatePreempt((List)updatePreemptionEoList);
        }
        this.doRelease(dto);
    }

    private void doRelease(ReleasePreemptDto dto) {
        List details = dto.getDetails();
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        this.checkSku(details);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private CalcInventoryDto createLogicCalcDto(ReleasePreemptDto dto) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setRemark(dto.getDesc());
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        ArrayList details = Lists.newArrayList();
        for (CalcDetailDto pd : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc());
            detailDto.setChangeAvailable(pd.getNum());
            detailDto.setChangePreempt(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            if (dto.getIsSaleOrder().booleanValue()) {
                detailDto.setChangeAllocate(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            }
            if (dto.getIsActivityPreempt().booleanValue()) {
                detailDto.setChangeActivityAllocate(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            }
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setCargoCode(pd.getSkuCode());
            detailDto.setCargoName(pd.getSkuName());
            detailDto.setArtNo(pd.getSkuCode());
            detailDto.setBatch(pd.getBatch());
            detailDto.setValidNegative(dto.getValidNegative());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }
}

