/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.AssemblyDisassemblyOrderBizTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.ReceiveDeliveryNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.AssembleDisassembleResultGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.InOutNoticeOrderCompleteEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.AssembleDisassembleOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.AssemblyDisassemblyNoticeOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.AssemblyDisassemblyResultOrderAbleImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseOrderFacadeHelper {
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseOrderFacadeHelper.class);
    @Resource
    public ReceiveDeliveryNoticeOrderAble receiveNoticeOrderAbleImpl;
    @Resource
    public ReceiveDeliveryNoticeOrderAble deliveryNoticeOrderAbleImpl;
    @Resource
    public IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    protected IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    protected AssemblyDisassemblyNoticeOrderAbleImpl assemblyDisassemblyNoticeOrderAble;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    protected AssemblyDisassemblyResultOrderAbleImpl assemblyDisassemblyResultOrderAble;
    @Resource
    protected IBaseOrderAddressDomain baseOrderAddressDomain;

    public void doDrNoticeOrder(ReceiveDeliveryResultOrderContext context) {
        if (context.getAutoComplete().booleanValue() || !context.isLinkNoticeUpdate()) {
            return;
        }
        Arrays.stream(context.getPreOrderNo().split(",")).forEach(preOrderNo -> {
            ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = this.receiveDeliveryNoticeOrderDomain.getReceiveDeliveryNoticeOrderByResultOrder(preOrderNo);
            Optional.ofNullable(receiveDeliveryNoticeOrderEo).ifPresent(doc -> {
                ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)context, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
                receiveDeliveryNoticeOrderContext.setDocumentNo(doc.getDocumentNo());
                if (context.getOperateTypeEnum().equals((Object)BaseOrderOperateTypeEnum.RECEIVE)) {
                    this.receiveNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
                } else {
                    this.deliveryNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
                }
            });
        });
    }

    public void cover(List<BaseOrderDetailReqDto> orderBasicsDetailReqDtoList, InOutNoticeOrderEo inOutNoticeOrderEo) {
        List noticeOrderDetailEos = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo())).list();
        if (CollectionUtils.isEmpty((Collection)noticeOrderDetailEos)) {
            throw new RuntimeException("\u51fa\u5e93\u5355\u8be6\u60c5\u4e3a\u7a7a\uff01");
        }
        int type = AssemblyDisassemblyOrderBizTypeEnum.getByName((String)inOutNoticeOrderEo.getDisplayBusinessType()).getType();
        Map detailEoMap = noticeOrderDetailEos.stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getSkuCode, Function.identity()));
        for (BaseOrderDetailReqDto baseOrderDetailReqDto : orderBasicsDetailReqDtoList) {
            InOutNoticeOrderDetailEo detailEo = (InOutNoticeOrderDetailEo)detailEoMap.get(baseOrderDetailReqDto.getSkuCode());
            if (detailEo == null) {
                baseOrderDetailReqDto.setPackType(type == AssemblyDisassemblyOrderBizTypeEnum.assemble.getType() ? 0 : 1);
                continue;
            }
            baseOrderDetailReqDto.setLineNo(detailEo.getLineNo());
            baseOrderDetailReqDto.setPreOrderItemId(detailEo.getPreOrderItemId());
            baseOrderDetailReqDto.setPackType(detailEo.getPackType());
        }
    }

    protected void coverExtension(List<BaseOrderDetailReqDto> orderBasicsDetailReqDtoList, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEos) {
        if (CollectionUtils.isEmpty(inOutNoticeOrderDetailEos)) {
            return;
        }
        Map<String, String> skuCode2ExtensionMap = inOutNoticeOrderDetailEos.stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getSkuCode, InOutNoticeOrderDetailEo::getExtension));
        for (BaseOrderDetailReqDto reqDto : orderBasicsDetailReqDtoList) {
            reqDto.setExtension(skuCode2ExtensionMap.get(reqDto.getSkuCode()));
        }
    }

    public void assembleDisassembleResultOrderComplete(InOutResultOrderContext context, InOutNoticeOrderEo inOutNoticeOrderEo) {
        this.assemblyDisassemblyResultOrderAble.doComplete(context);
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)context, InOutNoticeOrderContext.class, (String[])new String[0]);
        outNoticeOrderContext.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        log.info("\u7ec4\u88c5\u62c6\u5378\u5b8c\u6210\u64cd\u4f5c\uff1a{}", (Object)JSONObject.toJSONString((Object)outNoticeOrderContext));
        outNoticeOrderContext.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        this.assemblyDisassemblyNoticeOrderAble.complete(outNoticeOrderContext);
        context.execComplete(context);
        if (outNoticeOrderContext.isNoticeEnd()) {
            InventoryConfig.pushEvent(new InOutNoticeOrderCompleteEvent(outNoticeOrderContext));
        }
    }

    protected void assembleDisassembleReceiveGen(AssembleDisassembleOrderFacadeBo noticeOrderFacadeBo, InOutNoticeOrderEo inOutNoticeOrderEo) {
        noticeOrderFacadeBo.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        noticeOrderFacadeBo.setAutoComplete(true);
        noticeOrderFacadeBo.setSendWms(false);
        noticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.ASSEMBLY_DISASSEMBLY_ORDER);
        noticeOrderFacadeBo.setLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        noticeOrderFacadeBo.setLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
        noticeOrderFacadeBo.setBusinessType(inOutNoticeOrderEo.getBusinessType());
        noticeOrderFacadeBo.setDisplayBusinessType(inOutNoticeOrderEo.getDisplayBusinessType());
        noticeOrderFacadeBo.setExternalOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        noticeOrderFacadeBo.setJumpDocumentType(inOutNoticeOrderEo.getJumpDocumentType());
        noticeOrderFacadeBo.setBaseOrderAddressEoList(((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).list());
        InventoryConfig.pushEvent(new AssembleDisassembleResultGenEvent(noticeOrderFacadeBo));
    }

    @NotNull
    protected <FACADE extends BaseOrderFacadeBo> InOutResultOrderFacadeBo getInOutResultOrderFacadeBo(FACADE facadeBo, String k, List<InOutNoticeOrderDetailEo> v, Map<String, InOutNoticeOrderEo> noticeOrderEoMap) {
        InOutResultOrderFacadeBo inFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties(facadeBo, InOutResultOrderFacadeBo.class, (String[])new String[0]);
        inFacadeBo.setPushEvent(true);
        inFacadeBo.setInOutNoticeOrderEo(noticeOrderEoMap.get(k));
        inFacadeBo.setInOutNoticeOrderDetailEos(v);
        Map idMap = v.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        inFacadeBo.setOrderBasicsDetailReqDtoList(BeanUtil.copyToList(inFacadeBo.getOrderBasicsDetailReqDtoList(), BaseOrderDetailReqDto.class, (CopyOptions)CopyOptions.create().setIgnoreProperties(new String[]{"id"})).stream().filter(de -> Objects.nonNull(de.getLineNo()) && idMap.containsKey(de.getLineNo())).peek(de -> {
            InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)idMap.get(de.getLineNo());
            de.setPreOrderItemId(inOutNoticeOrderDetailEo.getPreOrderItemId());
            de.setLineNo(inOutNoticeOrderDetailEo.getLineNo());
        }).collect(Collectors.toList()));
        return inFacadeBo;
    }

    @NotNull
    protected LoadMergeResult getLoadMergeResult(List<Long> longs) {
        Map<String, List<InOutNoticeOrderDetailEo>> detailMap = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().in((Object)"id", longs)).list().stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getDocumentNo));
        Map<String, InOutNoticeOrderEo> noticeOrderEoMap = ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().in((Object)"document_no", detailMap.keySet())).list().stream().collect(Collectors.toMap(InOutNoticeOrderEo::getDocumentNo, Function.identity()));
        return new LoadMergeResult(detailMap, noticeOrderEoMap);
    }

    protected static class LoadMergeResult {
        public final Map<String, List<InOutNoticeOrderDetailEo>> detailMap;
        public final Map<String, InOutNoticeOrderEo> noticeOrderEoMap;

        public LoadMergeResult(Map<String, List<InOutNoticeOrderDetailEo>> detailMap, Map<String, InOutNoticeOrderEo> noticeOrderEoMap) {
            this.detailMap = detailMap;
            this.noticeOrderEoMap = noticeOrderEoMap;
        }
    }
}

