/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.actions;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicLockOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicLockOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.LockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.eo.LogicLockOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.LogicLockOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.enums.LogicLockOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.enums.LogicLockOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class LogicLockOrderEffectiveAction
extends AbstractAction<LogicLockOrderStatusEnum, LogicLockOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(LogicLockOrderEffectiveAction.class);
    @Resource
    private ILogicLockOrderDomain logicLockOrderDomain;
    @Resource
    private ILogicLockOrderDetailDomain logicLockOrderDetailDomain;
    @Resource
    private ICalcInventoryService iCalcInventoryService;

    @Override
    protected void doExecute(StateContext<LogicLockOrderStatusEnum, LogicLockOrderStatusEventEnum> context) {
        log.info("\u8fdb\u5165\u903b\u8f91\u9501\u5e93\u5355\u751f\u6548\u52a8\u4f5c");
        StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        LogicLockOrderEo insertEo = (LogicLockOrderEo)executorBo.getEo();
        try {
            InventoryConfig.executorNewTransaction(s -> {
                this.lockInventory(insertEo);
                return s;
            });
        }
        catch (Exception e) {
            log.info("\u9501\u5b9a\u5e93\u5b58\u5931\u8d25:{}", (Object)e.getMessage());
            LogicLockOrderEo updateEo = new LogicLockOrderEo();
            updateEo.setId(insertEo.getId());
            updateEo.setErrorRemark("\u9501\u5b9a\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            this.logicLockOrderDomain.updateSelective((BaseEo)updateEo);
        }
    }

    private void lockInventory(LogicLockOrderEo insertEo) {
        List detailEoList = ((ExtQueryChainWrapper)this.logicLockOrderDetailDomain.filter().eq((Object)"order_no", (Object)insertEo.getOrderNo())).list();
        AssertUtil.assertNotEmpty((Collection)detailEoList, (String)"\u903b\u8f91\u9501\u5e93\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LockDto lockDto = new LockDto();
        lockDto.setSourceNo(insertEo.getOrderNo());
        lockDto.setBusinessType(insertEo.getBusinessType());
        lockDto.setSourceType(insertEo.getOrderType());
        lockDto.setExternalOrderNo(insertEo.getExternalOrderNo());
        lockDto.setNoneBatch(Boolean.TRUE);
        lockDto.setNoneLineNo(Boolean.TRUE);
        ArrayList calcDetailDtoList = Lists.newArrayList();
        detailEoList.forEach(eo -> {
            CalcDetailDto calcDetailDto = new CalcDetailDto();
            calcDetailDto.setSkuCode(eo.getSkuCode());
            calcDetailDto.setBatch(eo.getBatch());
            calcDetailDto.setLogicWarehouseCode(insertEo.getLogicWarehouseCode());
            calcDetailDto.setExpireDate(eo.getExpireTime());
            calcDetailDto.setLineNo(eo.getId());
            calcDetailDto.setPreOrderItemId(eo.getId());
            calcDetailDto.setInventoryProperty(eo.getInventoryProperty());
            calcDetailDto.setProduceDate(eo.getProduceTime());
            calcDetailDto.setNum(eo.getPlanQuantity());
            calcDetailDtoList.add(calcDetailDto);
        });
        lockDto.setDetails((List)calcDetailDtoList);
        this.iCalcInventoryService.lock(lockDto);
        ArrayList updateDetailEoList = Lists.newArrayList();
        detailEoList.forEach(o -> {
            LogicLockOrderDetailEo updateEo = new LogicLockOrderDetailEo();
            updateEo.setId(o.getId());
            updateEo.setDoneQuantity(o.getPlanQuantity());
            updateDetailEoList.add(updateEo);
        });
        updateDetailEoList.forEach(o -> this.logicLockOrderDetailDomain.updateSelective((BaseEo)o));
    }
}

