/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.inspection.Impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.dict.dto.Schemas.DictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.DictEnum;
import com.yunxi.dg.base.center.enums.InspectionPassStatusEnum;
import com.yunxi.dg.base.center.enums.InspectionResultEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.InspectionPassConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IDgInspectionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInspectionPassDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryBatchDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.InspectionPassDto;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassEo;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassRecordEo;
import com.yunxi.dg.base.center.inventory.eo.InspectionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryBatchEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.IAdjustmentOrderService;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IInspectionPassRecordService;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IInspectionPassService;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IInventoryBatchService;
import com.yunxi.dg.base.center.inventory.service.third.InspectionSystemBo;
import com.yunxi.dg.base.center.inventory.service.third.api.IInspectionSystemApi;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuExtListDgRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionPassServiceImpl
extends BaseServiceImpl<InspectionPassDto, InspectionPassEo, IInspectionPassDomain>
implements IInspectionPassService {
    private static final Logger log = LoggerFactory.getLogger(InspectionPassServiceImpl.class);
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IDgInspectionRecordDomain inspectionRecordDomain;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource(name="inventoryStatusAdjustmentOrderServiceImpl")
    private IAdjustmentOrderService inventoryStatusAdjustmentOrderServiceImpl;
    @Resource
    private IInventoryBatchDomain inventoryBatchDomain;
    @Resource
    private IPcpDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IInspectionPassRecordService inspectionPassRecordService;
    @Resource
    private IInventoryBatchService inventoryBatchService;
    @Resource
    private IInspectionSystemApi inspectionSystemApi;
    @Resource
    private ICommonsMqService commonsMqService;

    public InspectionPassServiceImpl(IInspectionPassDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InspectionPassDto, InspectionPassEo> converter() {
        return InspectionPassConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void batchGenerate(List<InspectionPassDto> dtos) {
        log.info("\u6dfb\u52a0\u8d28\u68c0\u653e\u884c\u5355\u636e,\u53c2\u6570:{}", (Object)JSON.toJSONString(dtos));
        HashSet<String> logicWarehouseCodes = new HashSet<String>();
        HashSet<String> skuCodes = new HashSet<String>();
        HashSet<String> multiBatch = new HashSet<String>();
        this.checkParam(dtos, logicWarehouseCodes, skuCodes, multiBatch);
        List<LogicWarehouseEo> logicWarehouseEos = this.checkLogicWarehouseList(Lists.newArrayList(logicWarehouseCodes));
        ArrayList<InspectionPassEo> insertEos = new ArrayList<InspectionPassEo>();
        ArrayList<InspectionPassEo> updateEos = new ArrayList<InspectionPassEo>();
        ArrayList<InspectionPassEo> freeInspectionEos = new ArrayList<InspectionPassEo>();
        ArrayList<InspectionPassEo> inspectionEos = new ArrayList<InspectionPassEo>();
        this.setList(dtos, insertEos, updateEos, freeInspectionEos, inspectionEos, logicWarehouseCodes, skuCodes, multiBatch);
        if (CollectionUtils.isNotEmpty(updateEos)) {
            ((IInspectionPassDomain)this.domain).updateBatchQuantityByIds(updateEos);
        }
        if (CollectionUtils.isNotEmpty(insertEos)) {
            ((IInspectionPassDomain)this.domain).insertBatch(insertEos);
        }
        this.freeInspection(skuCodes, logicWarehouseEos, freeInspectionEos);
        this.pullInspectionSystem(inspectionEos);
    }

    private void freeInspection(Set<String> skuCodes, List<LogicWarehouseEo> logicWarehouseEos, List<InspectionPassEo> freeInspectionEos) {
        if (CollectionUtils.isEmpty(freeInspectionEos)) {
            return;
        }
        this.freeInspectionUpdateInventoryBatch(freeInspectionEos);
        List<InspectionPassRecordEo> inspectionPassRecordEos = this.updateInventoryStatusAdjustmentOrder(skuCodes, logicWarehouseEos, freeInspectionEos);
        this.freeInspectionAddInspectionPassRecord(inspectionPassRecordEos);
    }

    private void freeInspectionAddInspectionPassRecord(List<InspectionPassRecordEo> inspectionPassRecordEos) {
        inspectionPassRecordEos.forEach(e -> {
            this.inspectionPassRecordService.add((InspectionPassRecordEo)e, DgInspectionPassRecordStatusEventEnum.BUSINESS_ORDER_COMPLETE);
            OptUtil.addOptLog((String)OperationLogTypeEnum.PASSING.name(), (String)"EMPTY", (String)e.getInspectionNo(), (String)CodeGenEnum.INSPECTION_PASS_ORDER.getCode());
        });
    }

    private void pullInspectionSystem(List<InspectionPassEo> inspectionEos) {
        String enableStatus;
        if (CollectionUtils.isEmpty(inspectionEos)) {
            return;
        }
        DictDto dictDto = this.dictQueryApiProxy.querySameTableByGroupCodeAndCode(DictEnum.DOCKING_INSPECTION_SYSTEM.getGroupCode(), DictEnum.DOCKING_INSPECTION_SYSTEM.getCode());
        log.info("\u6839\u636e\u8d28\u68c0\u653e\u884c\u914d\u7f6ecode\u3010{}\u3011\u83b7\u53d6\u5b57\u5178\u8868\u4fe1\u606f\uff1a{}", (Object)DictEnum.DOCKING_INSPECTION_SYSTEM.getCode(), (Object)JSON.toJSONString((Object)dictDto));
        String string = enableStatus = Objects.nonNull(dictDto) ? dictDto.getValue() : null;
        if (ValidFlagEnum.ENABLE.getCode().equals(enableStatus)) {
            List<InspectionSystemBo> list = inspectionEos.stream().map(e -> {
                InspectionSystemBo bo = new InspectionSystemBo();
                bo.setBatch(e.getBatch());
                bo.setSkuCode(e.getSkuCode());
                return bo;
            }).collect(Collectors.toList());
            RestResponseHelper.extractData(this.inspectionSystemApi.generate(list));
        }
    }

    private void freeInspectionUpdateInventoryBatch(List<InspectionPassEo> freeInspectionEos) {
        List<InventoryBatchReqDto> inventoryBatchReqDtos = freeInspectionEos.stream().map(e -> {
            InventoryBatchReqDto inventoryBatchReqDto = new InventoryBatchReqDto();
            inventoryBatchReqDto.setBatch(e.getBatch());
            inventoryBatchReqDto.setSkuCode(e.getSkuCode());
            inventoryBatchReqDto.setInspectionResult(InspectionResultEnum.ELIGIBLE.getKey());
            inventoryBatchReqDto.setInspectionTime(new Date());
            return inventoryBatchReqDto;
        }).collect(Collectors.toList());
        this.inventoryBatchService.save(inventoryBatchReqDtos, false);
    }

    @NotNull
    private String mapKey(String logicWarehouseCode, String skuCode, String batch) {
        return logicWarehouseCode + InventoryConfig.getCommonSeparate() + skuCode + InventoryConfig.getCommonSeparate() + batch;
    }

    private void setList(List<InspectionPassDto> dtos, List<InspectionPassEo> insertEos, List<InspectionPassEo> updateEos, List<InspectionPassEo> freeInspectionEos, List<InspectionPassEo> inspectionEos, Set<String> logicWarehouseCodes, Set<String> skuCodes, Set<String> multiBatch) {
        List itemSkuExtListDgRespDtos = Optional.ofNullable(this.itemSkuDgQueryApiProxy.querySkuExtBySkuCodes((List)Lists.newArrayList(skuCodes))).orElse(new ArrayList());
        Map itemMap = itemSkuExtListDgRespDtos.stream().collect(Collectors.toMap(ItemSkuExtListDgRespDto::getSkuCode, Function.identity(), (K1, K2) -> K1));
        List eos = Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInspectionPassDomain)this.domain).filter().in((Object)"logic_warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).in((Object)"batch", multiBatch)).in((Object)"pass_status", (Collection)Lists.newArrayList((Object[])new String[]{InspectionPassStatusEnum.WAIT_PASS.getKey(), InspectionPassStatusEnum.PART_PASS.getKey()}))).gt((Object)"wait_quantity", (Object)0)).list()).orElse(new ArrayList());
        log.info("\u67e5\u8be2\u5230\u8d28\u68c0\u653e\u884c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)eos));
        Map map = eos.stream().collect(Collectors.toMap(e -> this.mapKey(e.getRelevanceNo(), e.getSkuCode(), e.getBatch()), Function.identity(), (k1, k2) -> k1));
        List inventoryBatchEos = Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryBatchDomain.filter().in((Object)"sku_code", skuCodes)).in((Object)"batch", multiBatch)).list()).orElse(new ArrayList());
        Map inventoryBatchMap = inventoryBatchEos.stream().collect(Collectors.toMap(r -> this.mapKey(r.getSkuCode(), InventoryConfig.getCommonSeparate(), r.getBatch()), Function.identity(), (o, o1) -> o));
        dtos.stream().forEach(e -> {
            String key = this.mapKey(e.getRelevanceNo(), e.getSkuCode(), e.getBatch());
            InspectionPassEo inspectionPassEo = (InspectionPassEo)map.get(key);
            InventoryBatchEo inventoryBatchEo = (InventoryBatchEo)inventoryBatchMap.get(this.mapKey(e.getSkuCode(), InventoryConfig.getCommonSeparate(), e.getBatch()));
            Boolean isFreeInspection = 1 == ((ItemSkuExtListDgRespDto)Optional.ofNullable(itemMap.get(e.getSkuCode())).get()).getFreeInspection();
            if (Objects.nonNull(inspectionPassEo)) {
                inspectionPassEo.setQuantity(BigDecimalUtils.check((BigDecimal)e.getQuantity()));
                inspectionPassEo.setWaitQuantity(BigDecimalUtils.check((BigDecimal)e.getWaitQuantity()));
                updateEos.add(inspectionPassEo);
            } else {
                inspectionPassEo = new InspectionPassEo();
                CubeBeanUtils.copyProperties((Object)inspectionPassEo, (Object)e, (String[])new String[0]);
                inspectionPassEo.setInspectionNo(InventoryConfig.getGenerateCodeUtil().generateCode(CodeGenEnum.INSPECTION_PASS_ORDER));
                inspectionPassEo.setInspectionTime(new Date());
                inspectionPassEo.setFirstInTime(inspectionPassEo.getInspectionTime());
                if (isFreeInspection.booleanValue()) {
                    inspectionPassEo.setPassStatus(InspectionPassStatusEnum.EXEMPTION.getKey());
                    inspectionPassEo.setInspectionResult(InspectionResultEnum.ELIGIBLE.getKey());
                    freeInspectionEos.add(inspectionPassEo);
                } else {
                    inspectionPassEo.setPassStatus(Objects.nonNull(inventoryBatchEo) && InspectionResultEnum.UN_ELIGIBLE.getKey().equals(inventoryBatchEo.getInspectionResult()) ? InspectionPassStatusEnum.DISQUALIFICATION.getKey() : InspectionPassStatusEnum.WAIT_PASS.getKey());
                    inspectionEos.add(inspectionPassEo);
                }
                insertEos.add(inspectionPassEo);
            }
        });
    }

    private List<InspectionPassRecordEo> updateInventoryStatusAdjustmentOrder(Set<String> skuCodes, List<LogicWarehouseEo> logicWarehouseEos, List<InspectionPassEo> freeInspectionEos) {
        ArrayList<InspectionPassRecordEo> inspectionPassRecordEos = new ArrayList<InspectionPassRecordEo>();
        Map skuCodeMap = ((ExtQueryChainWrapper)this.inventoryBatchDomain.filter().in((Object)"sku_code", skuCodes)).list().stream().collect(Collectors.toMap(r -> this.mapKey(r.getSkuCode(), InventoryConfig.getCommonSeparate(), r.getBatch()), Function.identity(), (o, o1) -> o));
        Map logicWarehouseEoMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        for (InspectionPassEo inspectionPassEo : freeInspectionEos) {
            AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
            ArrayList<AdjustmentOrderDetailDto> adjustmentOrderDetailDtoList = new ArrayList<AdjustmentOrderDetailDto>();
            adjustmentOrderDto.setBusinessType("inventory_status_adjustment");
            adjustmentOrderDto.setBizDate(new Date());
            adjustmentOrderDto.setWarehouseCode(inspectionPassEo.getLogicWarehouseCode());
            adjustmentOrderDto.setWarehouseName(inspectionPassEo.getLogicWarehouseName());
            adjustmentOrderDto.setOrigWarehouseCode(inspectionPassEo.getLogicWarehouseCode());
            adjustmentOrderDto.setOrganizationName(inspectionPassEo.getLogicWarehouseName());
            adjustmentOrderDto.setOrganizationCode(inspectionPassEo.getOrganizationCode());
            adjustmentOrderDto.setOrganizationName(inspectionPassEo.getOrganizationName());
            adjustmentOrderDto.setInventoryProperty(inspectionPassEo.getInventoryProperty());
            adjustmentOrderDto.setNewInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
            adjustmentOrderDto.setExternalOrderNo(inspectionPassEo.getInspectionNo());
            adjustmentOrderDto.setEvent(DgAdjustmentInventoryOrderEventEnum.SUBMIT.getKey());
            adjustmentOrderDto.setRemark("\u8d28\u68c0\u653e\u884c\u5546\u54c1\u514d\u68c0\u8c03\u6574");
            LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(inspectionPassEo.getLogicWarehouseCode());
            adjustmentOrderDto.setPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
            adjustmentOrderDto.setPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
            adjustmentOrderDto.setOrderType(AdjustmentOrderTypeEnum.BATCH_ADJUSTMENT.getType());
            adjustmentOrderDto.setPushSap(Integer.valueOf(1));
            adjustmentOrderDto.setPushWms(Integer.valueOf(1));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pushFeiShu", "0");
            adjustmentOrderDto.setExtension(JSON.toJSONString(map));
            AdjustmentOrderDetailDto adjustmentOrderDetailDto = new AdjustmentOrderDetailDto();
            adjustmentOrderDetailDto.setSkuCode(inspectionPassEo.getSkuCode());
            adjustmentOrderDetailDto.setSkuName(inspectionPassEo.getSkuName());
            adjustmentOrderDetailDto.setBatch(inspectionPassEo.getBatch());
            adjustmentOrderDetailDto.setOrigBatch(inspectionPassEo.getBatch());
            adjustmentOrderDetailDto.setInventoryProperty(inspectionPassEo.getInventoryProperty());
            if (skuCodeMap.containsKey(this.mapKey(inspectionPassEo.getSkuCode(), InventoryConfig.getCommonSeparate(), inspectionPassEo.getBatch()))) {
                InventoryBatchEo inventoryBatchEo = (InventoryBatchEo)skuCodeMap.get(this.mapKey(inspectionPassEo.getSkuCode(), InventoryConfig.getCommonSeparate(), inspectionPassEo.getBatch()));
                adjustmentOrderDetailDto.setExpireTime(inventoryBatchEo.getExpireTime());
                adjustmentOrderDetailDto.setProduceTime(inventoryBatchEo.getProduceTime());
                adjustmentOrderDetailDto.setOrigProduceTime(inventoryBatchEo.getExpireTime());
                adjustmentOrderDetailDto.setOrigExpireTime(inventoryBatchEo.getProduceTime());
                adjustmentOrderDetailDto.setSpuCode(inventoryBatchEo.getSpuCode());
                adjustmentOrderDetailDto.setSpuName(inventoryBatchEo.getSpuName());
            }
            adjustmentOrderDetailDto.setChangeQuantity(inspectionPassEo.getQuantity());
            adjustmentOrderDetailDto.setUnit(inspectionPassEo.getUnit());
            adjustmentOrderDetailDto.setNewInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
            adjustmentOrderDetailDtoList.add(adjustmentOrderDetailDto);
            adjustmentOrderDto.setAdjustmentOrderDetailDtos(adjustmentOrderDetailDtoList);
            adjustmentOrderDto.setAuditRemark("\u8d28\u68c0\u653e\u884c\u5546\u54c1\u514d\u68c0\u8c03\u6574");
            adjustmentOrderDto.setEvent(DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS.getKey());
            Long id = this.inventoryStatusAdjustmentOrderServiceImpl.addAdjustmentOrder(adjustmentOrderDto);
            AdjustmentOrderDto adjustmentOrderDto1 = this.inventoryStatusAdjustmentOrderServiceImpl.queryById(id);
            log.info("\u63a8\u9001\u8d28\u68c0\u653e\u884c\u751f\u6210\u5e93\u5b58\u8c03\u6574\u5355:{},{}", (Object)adjustmentOrderDto.getAdjustmentNo(), (Object)adjustmentOrderDto.getExternalOrderNo());
            this.commonsMqService.publishMessage("PUBLISH_TOPIC", "PUSH_INSPECTION_PASS_GEN_ADJUSTMENT_ORDER", (Object)JSONObject.toJSONString((Object)adjustmentOrderDto));
            InspectionPassRecordEo inspectionPassRecordEo = new InspectionPassRecordEo();
            CubeBeanUtils.copyProperties((Object)inspectionPassRecordEo, (Object)inspectionPassEo, (String[])new String[]{"id"});
            inspectionPassRecordEo.setRelevanceNo(adjustmentOrderDto1.getAdjustmentNo());
            inspectionPassRecordEo.setBusinessType(adjustmentOrderDto1.getBusinessType());
            inspectionPassRecordEo.setOrderType(adjustmentOrderDto1.getOrderType());
            inspectionPassRecordEo.setQuantity(inspectionPassEo.getQuantity());
            inspectionPassRecordEo.setPassStatus(DgInspectionPassRecordStatusEnum.WAIT_COMMIT.getKey());
            inspectionPassRecordEos.add(inspectionPassRecordEo);
        }
        return inspectionPassRecordEos;
    }

    private void checkParam(List<InspectionPassDto> dtos, Set<String> logicWarehouseCodes, Set<String> skuCodes, Set<String> multiBatch) {
        AssertUtil.isTrue((boolean)CollectionUtil.isNotEmpty(dtos), (String)"\u8d28\u68c0\u653e\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        dtos.forEach(e -> {
            AssertUtil.isTrue((boolean)LogicWarehouseQualityEnum.WAIT_INSPECTION.getCode().equals(e.getInventoryProperty()), (String)"\u5f85\u68c0\u7684\u5c5e\u6027\u624d\u80fd\u65b0\u589e\u5e93\u5b58\u8d28\u68c0\u653e\u884c");
            this.checkDetail((InspectionPassDto)e);
            logicWarehouseCodes.add(e.getLogicWarehouseCode());
            skuCodes.add(e.getSkuCode());
            multiBatch.add(e.getBatch());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void pass(InspectionPassDto dto) {
        log.info("\u653e\u884c\u64cd\u4f5c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        this.checkDetail(dto);
        InspectionPassEo inspectionPassEo = (InspectionPassEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInspectionPassDomain)this.domain).filter().eq((Object)"inspection_no", (Object)dto.getInspectionNo())).last("limit 1")).one();
        AssertUtil.isTrue((boolean)Objects.nonNull(inspectionPassEo), (String)"\u627e\u4e0d\u5230\u8d28\u68c0\u653e\u884c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5");
        AssertUtil.isTrue((inspectionPassEo.getWaitQuantity().compareTo(dto.getQuantity()) >= 0 ? 1 : 0) != 0, (String)"\u672c\u6b21\u653e\u884c\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5f85\u653e\u884c\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5");
        List inspectionRecordEos = Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionRecordDomain.filter().eq((Object)"sku_code", (Object)dto.getSkuCode())).eq((Object)"batch", (Object)dto.getBatch())).orderByDesc((Object)"id")).list()).orElse(new ArrayList());
        log.info("\u67e5\u8be2\u6700\u65b0\u8d28\u68c0\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)inspectionRecordEos));
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inspectionRecordEos), (String)"\u627e\u4e0d\u5230\u8d28\u68c0\u7ed3\u679c\uff0c\u4e0d\u80fd\u653e\u884c");
        InspectionRecordEo inspectionRecordEo = (InspectionRecordEo)inspectionRecordEos.get(0);
        AssertUtil.isTrue((boolean)InspectionResultEnum.ELIGIBLE.getKey().equals(inspectionRecordEo.getInspectionResult()), (String)"\u8d28\u68c0\u7ed3\u679c\u4e0d\u5408\u683c\uff0c\u4e0d\u80fd\u653e\u884c");
        InspectionPassEo updateInspectionPassEo = new InspectionPassEo();
        updateInspectionPassEo.setId(inspectionPassEo.getId());
        updateInspectionPassEo.setWaitQuantity(dto.getQuantity().negate());
        updateInspectionPassEo.setAuditQuantity(dto.getQuantity());
        updateInspectionPassEo.setOperator((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)""));
        updateInspectionPassEo.setOperatorTime(new Date());
        this.updateQuantityAndStatus(updateInspectionPassEo, true);
        InspectionPassRecordEo inspectionPassRecordEo = new InspectionPassRecordEo();
        CubeBeanUtils.copyProperties((Object)inspectionPassRecordEo, (Object)inspectionPassEo, (String[])new String[]{"id", "relevanceNo", "orderType", "businessType"});
        inspectionPassRecordEo.setQuantity(dto.getQuantity());
        inspectionPassRecordEo.setPassStatus(DgInspectionPassRecordStatusEnum.WAIT_COMMIT.getKey());
        inspectionPassRecordEo.setOperator(updateInspectionPassEo.getOperator());
        inspectionPassRecordEo.setOperatorTime(updateInspectionPassEo.getOperatorTime());
        this.inspectionPassRecordService.add(inspectionPassRecordEo, DgInspectionPassRecordStatusEventEnum.COMMIT);
        OptUtil.addOptLog((String)OperationLogTypeEnum.PASSING.name(), (String)"EMPTY", (String)dto.getInspectionNo(), (String)CodeGenEnum.INSPECTION_PASS_ORDER.getCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void updateQuantityAndStatus(InspectionPassEo eo, Boolean updateStatus) {
        AssertUtil.isTrue((Objects.nonNull(eo) && Objects.nonNull(eo.getId()) ? 1 : 0) != 0, (String)"\u66f4\u65b0\u8d28\u68c0\u653e\u884c\u6570\u91cf\u548c\u72b6\u6001id\u4e0d\u80fd\u4e3a\u7a7a");
        ((IInspectionPassDomain)this.domain).updateInspectionPassQuantity(eo);
        if (!updateStatus.booleanValue()) {
            return;
        }
        this.updateStatus(eo.getId(), null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void updateStatus(Long id, String newStatus) {
        InspectionPassEo inspectionPassEo = (InspectionPassEo)((IInspectionPassDomain)this.domain).getMapper().selectById((Serializable)id);
        InspectionPassEo updateEo = new InspectionPassEo();
        if (StringUtils.isBlank((CharSequence)newStatus)) {
            if (BigDecimal.ZERO.compareTo(inspectionPassEo.getProcessedQuantity()) == 0) {
                updateEo.setPassStatus(InspectionPassStatusEnum.WAIT_PASS.getKey());
            }
            if (inspectionPassEo.getProcessedQuantity().compareTo(BigDecimal.ZERO) > 0 && inspectionPassEo.getQuantity().compareTo(inspectionPassEo.getProcessedQuantity()) > 0) {
                updateEo.setPassStatus(InspectionPassStatusEnum.PART_PASS.getKey());
            }
            if (inspectionPassEo.getQuantity().compareTo(inspectionPassEo.getProcessedQuantity()) == 0) {
                updateEo.setPassStatus(InspectionPassStatusEnum.PASS.getKey());
            }
        } else {
            updateEo.setPassStatus(newStatus);
        }
        if (Objects.equals(inspectionPassEo.getPassStatus(), updateEo.getPassStatus()) || StringUtils.isBlank((CharSequence)updateEo.getPassStatus())) {
            return;
        }
        updateEo.setId(id);
        ((IInspectionPassDomain)this.domain).updateSelective((BaseEo)updateEo);
        log.info("\u8d28\u91cf\u653e\u884c\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u63a8\u9001");
        this.commonsMqService.publishMessage("PUBLISH_TOPIC", "PUSH_INSPECTION_PASS", (Object)JSON.toJSONString((Object)((ExtQueryChainWrapper)((IInspectionPassDomain)this.domain).filter().eq((Object)"id", (Object)updateEo.getId())).one()));
    }

    @Override
    public void updateBatchRecordPass(List<ReceiveDeliveryResultOrderDetailEo> receiveDeliveryResultOrderDetailEoList) {
        this.inventoryBatchService.updatePass(receiveDeliveryResultOrderDetailEoList);
    }

    private void checkDetail(InspectionPassDto e) {
        AssertUtil.isTrue((boolean)Objects.nonNull(e), (String)"\u8d28\u68c0\u653e\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)Objects.nonNull(e.getQuantity()), (String)"\u8d28\u68c0\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((e.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8d28\u68c0\u5e93\u5b58\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)e.getUnit()), (String)"\u8d28\u68c0\u653e\u884c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)e.getSkuCode()), (String)"\u8d28\u68c0\u653e\u884csku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (Objects.nonNull(e.getId())) {
            AssertUtil.isTrue((boolean)Objects.nonNull(e.getInspectionNo()), (String)"\u8d28\u68c0\u653e\u884c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<LogicWarehouseEo> checkLogicWarehouseList(List<String> warehouseCodes) {
        List logicWarehouseEos = this.logicWarehouseDomain.queryByCodes(warehouseCodes);
        AssertUtil.isTrue((CollectionUtils.isNotEmpty((Collection)logicWarehouseEos) && logicWarehouseEos.size() == warehouseCodes.size() ? 1 : 0) != 0, (String)"\u903b\u8f91\u4ed3\u5e93\u4e0d\u5b58\u5728");
        return logicWarehouseEos;
    }
}

