/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.order.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.yunxi.dg.base.center.enums.InspectionResultEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IDgInspectionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryBatchDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.InspectionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryBatchEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.business.adjust.IAdjustmentOrderService;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.order.AbstractAdapter;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveEvent;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.stereotype.Service;

@Service
public class TransferOrder
extends AbstractAdapter {
    private static final Logger log = LoggerFactory.getLogger(TransferOrder.class);
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    ITransferOrderDomain transferOrderDomain;
    @Autowired
    private ICommonsMqService mqService;
    @Resource
    private StateMachineFactory<TransferOrderReceiveState, TransferOrderReceiveEvent> receiveStateMachineFactory;
    @Autowired
    private StateMachinePersister<TransferOrderReceiveState, TransferOrderReceiveEvent, String> receivePersister;
    @Autowired
    private StateMachinePersister<TransferOrderDeliveryState, TransferOrderDeliveryEvent, String> deliveryPersister;
    @Resource
    private StateMachineFactory<TransferOrderDeliveryState, TransferOrderDeliveryEvent> deliveryStateMachineFactory;
    @Resource(name="inventoryStatusAdjustmentOrderServiceImpl")
    private IAdjustmentOrderService inventoryStatusAdjustmentOrderServiceImpl;
    @Resource
    private IInventoryBatchDomain iInventoryBatchDomain;
    @Resource
    private IDgInspectionRecordDomain iInspectionRecordDomain;
    @Resource
    private IOrderUnitConversionRecordDomain iOrderUnitConversionRecordDomain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outBackEvent(ReceiveDeliveryResultOrderContext context) {
        if (this.isVirtual(context)) {
            return;
        }
        log.info("\u8c03\u62e8\u51fa\u5355\u51fa\u5e93\u4e8b\u4ef6\uff1a{}, \u662f\u5426\u81ea\u52a8\u5b8c\u6210\uff1a{}\uff0c \u662f\u5426\u81ea\u52a8\u5165\u5e93\uff1a{}", new Object[]{JSONUtil.toJsonStr((Object)context), context.getAutoComplete(), context.getCanProcessIn()});
        if (context.getAutoComplete().booleanValue() && context.getCanProcessIn().booleanValue()) {
            return;
        }
        String relevanceNo = context.getRelevanceNo();
        StateMachine outStateMachine = this.deliveryStateMachineFactory.getStateMachine(relevanceNo);
        try {
            outStateMachine.start();
            this.deliveryPersister.restore(outStateMachine, (Object)relevanceNo);
            outStateMachine.getExtendedState().getVariables().put("transferOrderNo", relevanceNo);
            outStateMachine.getExtendedState().getVariables().put("receiveDeliveryResultOrderContext", context);
            boolean result = outStateMachine.sendEvent((Object)TransferOrderDeliveryEvent.DELIVERY);
            log.info("\u6267\u884c\u7ed3\u679c:{}", (Object)result);
            this.deliveryPersister.persist(outStateMachine, (Object)relevanceNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            outStateMachine.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inBackEvent(ReceiveDeliveryResultOrderContext context) {
        try {
            this.paramTransferInWaitInspection(context);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5165\u5e93\u56de\u4f20\u5165\u5f85\u68c0\u5931\u8d25");
        }
        String relevanceNo = context.getRelevanceNo();
        StateMachine receiveEventStateMachine = this.receiveStateMachineFactory.getStateMachine(relevanceNo);
        try {
            receiveEventStateMachine.start();
            this.receivePersister.restore(receiveEventStateMachine, (Object)relevanceNo);
            receiveEventStateMachine.getExtendedState().getVariables().put("transferOrderNo", relevanceNo);
            receiveEventStateMachine.getExtendedState().getVariables().put("transferOrderEo", ((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)relevanceNo)).one());
            receiveEventStateMachine.getExtendedState().getVariables().put("receiveDeliveryResultOrderContext", context);
            boolean result = receiveEventStateMachine.sendEvent((Object)TransferOrderReceiveEvent.RECEIVE);
            log.info("\u6267\u884c\u7ed3\u679c:{}", (Object)result);
            this.receivePersister.persist(receiveEventStateMachine, (Object)relevanceNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            receiveEventStateMachine.stop();
        }
    }

    private boolean isVirtual(ReceiveDeliveryResultOrderContext context) {
        TransferOrderRespDto transferOrderRespDto = this.transferOrderDomain.queryByTransferOrderNo(context.getRelevanceNo());
        TransferOrderTypeEnum transferOrderTypeEnum = TransferOrderTypeEnum.getEnumByCode((String)transferOrderRespDto.getType());
        return Objects.nonNull(transferOrderTypeEnum) && "VIRTUAL".equals(transferOrderTypeEnum.getVirtualTag()) || ObjectUtil.equals((Object)YesNoEnum.YES.getValue(), (Object)transferOrderRespDto.getIsVirtual());
    }

    private void paramTransferInWaitInspection(ReceiveDeliveryResultOrderContext context) {
        if (!InventoryConfig.isEnableInspction()) {
            return;
        }
        if (context.getReceiveDeliveryResultOrderDetailEoList().stream().noneMatch(r -> ObjectUtil.equals((Object)r.getInventoryProperty(), (Object)LogicWarehouseQualityEnum.WAIT_INSPECTION.getCode()))) {
            return;
        }
        List<ReceiveDeliveryResultOrderDetailEo> receiveDeliveryResultOrderDetailEoList = context.getReceiveDeliveryResultOrderDetailEoList();
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = context.getReceiveDeliveryResultOrderEo();
        AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
        ArrayList<AdjustmentOrderDetailDto> adjustmentOrderDetailDtoList = new ArrayList<AdjustmentOrderDetailDto>();
        adjustmentOrderDto.setBusinessType("inventory_status_adjustment");
        adjustmentOrderDto.setBizDate(new Date());
        adjustmentOrderDto.setWarehouseCode(receiveDeliveryResultOrderEo.getReceiveLogicWarehouseCode());
        adjustmentOrderDto.setWarehouseName(receiveDeliveryResultOrderEo.getReceiveLogicWarehouseName());
        adjustmentOrderDto.setOrganizationCode(receiveDeliveryResultOrderEo.getOrganizationName());
        adjustmentOrderDto.setOrganizationName(receiveDeliveryResultOrderEo.getOrganizationName());
        adjustmentOrderDto.setInventoryProperty(receiveDeliveryResultOrderEo.getInventoryProperty());
        adjustmentOrderDto.setPhysicsWarehouseCode(receiveDeliveryResultOrderEo.getReceivePhysicsWarehouseCode());
        adjustmentOrderDto.setPhysicsWarehouseName(receiveDeliveryResultOrderEo.getReceivePhysicsWarehouseName());
        adjustmentOrderDto.setExternalOrderNo(receiveDeliveryResultOrderEo.getExternalOrderNo());
        adjustmentOrderDto.setEvent(DgAdjustmentInventoryOrderEventEnum.SUBMIT.getKey());
        adjustmentOrderDto.setRemark("\u8c03\u62e8\u5165\u5e93\u72b6\u6001\u8c03\u6574");
        adjustmentOrderDto.setOrderType(AdjustmentOrderTypeEnum.BATCH_ADJUSTMENT.getType());
        adjustmentOrderDto.setExternalOrderNo(receiveDeliveryResultOrderEo.getRelevanceNo());
        List skuCodeList = receiveDeliveryResultOrderDetailEoList.stream().map(ReceiveDeliveryResultOrderDetailEo::getSkuCode).collect(Collectors.toList());
        Map<String, InventoryBatchEo> skuCodeMap = ((ExtQueryChainWrapper)this.iInventoryBatchDomain.filter().in((Object)"sku_code", skuCodeList)).list().stream().collect(Collectors.toMap(r -> r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch(), Function.identity(), (o, o1) -> o));
        Map<String, String> inspectionResultMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.iInspectionRecordDomain.filter().in((Object)"sku_code", skuCodeList)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(r -> r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch(), InspectionRecordEo::getInspectionResult, (o, o1) -> o));
        Map<String, String> unitMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.iOrderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)context.getRelevanceNo())).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, OrderUnitConversionRecordEo::getUnit, (o, o1) -> o));
        for (ReceiveDeliveryResultOrderDetailEo r2 : receiveDeliveryResultOrderDetailEoList) {
            AdjustmentOrderDetailDto adjustmentOrderDetailDto = new AdjustmentOrderDetailDto();
            if (!ObjectUtil.equals((Object)r2.getInventoryProperty(), (Object)LogicWarehouseQualityEnum.WAIT_INSPECTION.getCode())) continue;
            this.extracted(adjustmentOrderDto, skuCodeMap, unitMap, r2, adjustmentOrderDetailDto);
            String inspectionResult = inspectionResultMap.get(r2.getSkuCode() + InventoryConfig.getCommonSeparate() + r2.getBatch());
            if (ObjectUtil.equals((Object)inspectionResult, (Object)InspectionResultEnum.ELIGIBLE.getKey())) {
                adjustmentOrderDetailDto.setNewInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
                adjustmentOrderDetailDtoList.add(adjustmentOrderDetailDto);
                continue;
            }
            if (!ObjectUtil.equals((Object)inspectionResult, (Object)InspectionResultEnum.UN_ELIGIBLE.getKey())) continue;
            adjustmentOrderDetailDto.setNewInventoryProperty(LogicWarehouseQualityEnum.FREEZE.getCode());
            adjustmentOrderDetailDtoList.add(adjustmentOrderDetailDto);
        }
        if (CollectionUtils.isEmpty(adjustmentOrderDetailDtoList)) {
            return;
        }
        adjustmentOrderDto.setNewInventoryProperty(((AdjustmentOrderDetailDto)adjustmentOrderDetailDtoList.get(0)).getNewInventoryProperty());
        adjustmentOrderDto.setAdjustmentOrderDetailDtos(adjustmentOrderDetailDtoList);
        if (CollectionUtils.isNotEmpty((Collection)adjustmentOrderDto.getAdjustmentOrderDetailDtos())) {
            adjustmentOrderDto.setEvent(DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS.getKey());
            this.inventoryStatusAdjustmentOrderServiceImpl.addAdjustmentOrder(adjustmentOrderDto);
        }
    }

    private void extracted(AdjustmentOrderDto adjustmentOrderDto, Map<String, InventoryBatchEo> skuCodeMap, Map<String, String> unitMap, ReceiveDeliveryResultOrderDetailEo r, AdjustmentOrderDetailDto adjustmentOrderDetailDto) {
        adjustmentOrderDetailDto.setAdjustmentNo(adjustmentOrderDto.getAdjustmentNo());
        adjustmentOrderDetailDto.setSkuCode(r.getSkuCode());
        adjustmentOrderDetailDto.setSkuName(r.getSkuName());
        adjustmentOrderDetailDto.setBatch(r.getBatch());
        adjustmentOrderDetailDto.setOrigBatch(r.getBatch());
        adjustmentOrderDetailDto.setInventoryProperty(r.getInventoryProperty());
        if (skuCodeMap.containsKey(r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch())) {
            InventoryBatchEo inventoryBatchEo = skuCodeMap.get(r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch());
            adjustmentOrderDetailDto.setExpireTime(inventoryBatchEo.getExpireTime());
            adjustmentOrderDetailDto.setProduceTime(inventoryBatchEo.getProduceTime());
            adjustmentOrderDetailDto.setOrigExpireTime(inventoryBatchEo.getExpireTime());
            adjustmentOrderDetailDto.setOrigProduceTime(inventoryBatchEo.getProduceTime());
        }
        adjustmentOrderDetailDto.setChangeQuantity(r.getQuantity());
        if (unitMap.containsKey(r.getSkuCode())) {
            adjustmentOrderDetailDto.setUnit(unitMap.get(r.getSkuCode()));
        }
    }
}

