/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.action;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderInventoryExe;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalEvent;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TransferOrderCancelAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferOrderCancelAction.class);
    @Resource
    private TransferOrderInventoryExe transferOrderInventoryExe;
    @Resource
    private ITransferOrderDas transferOrderDas;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private BaseOrderFacade baseOrderFacade;

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void shipmentStatusCancel(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
        String transferOrderNo = (String)context.getExtendedState().get((Object)"transferOrderNo", String.class);
        LOGGER.info("\u8c03\u62e8\u5355: {}, \u88ab\u53d6\u6d88\u4e86", (Object)transferOrderNo);
        TransferOrderEo transferOrderEo = this.transferOrderDas.selectByTransferOrderNo(transferOrderNo);
        transferOrderEo.setOrderStatus(TransferOrderStatus.CANCELLED.code());
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
        StatemachineExecutorBo<TransferOrderEo> executorBo = new StatemachineExecutorBo<TransferOrderEo>();
        executorBo.setEo(transferOrderEo);
        context.getExtendedState().getVariables().put("executorBo", executorBo);
        ArrayList<String> orderStatus = new ArrayList<String>(4);
        orderStatus.add(BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode());
        orderStatus.add(BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode());
        orderStatus.add(BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        orderStatus.add(BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode());
        ArrayList<String> orderTypeList = new ArrayList<String>(2);
        orderTypeList.add("delivery");
        orderTypeList.add("receive");
        List csDeliveryNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).in((Object)"order_status", orderStatus)).in((Object)"order_type", orderTypeList)).list();
        if (CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderEoList)) {
            for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : csDeliveryNoticeOrderEoList) {
                BaseOrderCommonCancelBo commonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(deliveryNoticeOrderEo.getDocumentNo()).sourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER_RELEASE.getCode()).build();
                if ("receive".equals(deliveryNoticeOrderEo.getOrderType())) {
                    this.baseOrderFacade.receiveNoticeOrderCancel(commonCancelBo);
                    continue;
                }
                this.baseOrderFacade.deliveryNoticeOrderCancel(commonCancelBo);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void approvalStatusCancel(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        String transferOrderNo = (String)context.getExtendedState().get((Object)"transferOrderNo", String.class);
        TransferOrderEo transferOrderEo = this.transferOrderDas.selectByTransferOrderNo(transferOrderNo);
        this.transferOrderInventoryExe.release(transferOrderEo.getTransferOrderNo(), transferOrderEo.getType(), true);
        transferOrderEo.setOrderStatus(TransferOrderStatus.CANCELLED.code());
        transferOrderEo.setApprovalStatus(TransferOrderApprovalState.CANCELLED.getCode());
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
    }
}

