/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.action;

import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderReissueExe;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TransferOrderCloseAction {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderCloseAction.class);
    @Resource
    private ITransferOrderDas transferOrderDas;
    @Resource
    private ITransferOrderDomain transferOrderDomain;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Resource
    private TransferOrderReissueExe transferOrderReissueExe;

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void close(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
        String transferOrderNo = (String)context.getExtendedState().get((Object)"transferOrderNo", String.class);
        TransferOrderEo transferOrderEo = this.transferOrderDas.selectByTransferOrderNo(transferOrderNo);
        this.close(transferOrderNo);
        this.closedUpdateNotice(transferOrderEo, false);
        this.transferOrderReissueExe.reissue(transferOrderNo);
    }

    public void close(String transferOrderNo) {
        TransferOrderEo transferOrderEo = this.transferOrderDas.selectByTransferOrderNo(transferOrderNo);
        Integer i = this.transferOrderDomain.doClosedCheck(transferOrderNo);
        if (i == 1) {
            transferOrderEo.setOrderStatus(TransferOrderStatus.COMPLETED.code());
            transferOrderEo.setDeliveryStatus(TransferOrderReceiveState.PARTIALLY_RECEIVED_COMPLETED.getCode());
        }
        transferOrderEo.setShipmentStatus(TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED.getCode());
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
        log.info("-------------------\u5173\u95ed\u7edf\u8ba1--------------------------");
        this.transferOrderDetailDomain.statisticsDispatcherByTransferOrderNo(transferOrderNo, true, InventoryConfig.isDispatchOrderBatch());
    }

    public void closedUpdateNotice(TransferOrderEo transferOrderEo, Boolean canClose) {
        BaseOrderCommonCancelBo baseOrderCommonCancelBo = BaseOrderCommonCancelBo.builder().relevanceNo(transferOrderEo.getTransferOrderNo()).sourceType(transferOrderEo.getSubType()).businessType(transferOrderEo.getType()).build();
        baseOrderCommonCancelBo.setPushEvent(false);
        this.baseOrderFacade.deliveryNoticeOrderCloseByRelevanceNo(baseOrderCommonCancelBo);
    }
}

