/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.action;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.mapper.StateMachineMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.StateMachineEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderReissueExe;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderWithdrawExe;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TransferOrderDeliveryAction {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderDeliveryAction.class);
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Autowired
    private ITransferOrderDomain transferOrderDomain;
    @Autowired
    private IBaseOrderAddressDomain baseOrderAddressDomain;
    @Resource
    private StateMachineMapper stateMachineMapper;
    @Resource
    private TransferOrderWithdrawExe transferOrderWithdrawExe;
    @Resource
    private TransferOrderReissueExe transferOrderReissueExe;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Autowired
    protected IPhysicsWarehouseDomain physicsWarehouseDomain;

    public void waitingForDeliveryWithdraw(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
        String transferOrderNo = (String)context.getExtendedState().get((Object)"transferOrderNo", String.class);
        if (StringUtils.isBlank((CharSequence)transferOrderNo)) {
            return;
        }
        log.info("\u8c03\u62e8\u5355: {}, \u88ab\u64a4\u56de\u4e86", (Object)transferOrderNo);
        this.transferOrderWithdrawExe.notificationWithdrawStep(transferOrderNo);
        TransferOrderKeyDto keyDto = new TransferOrderKeyDto();
        keyDto.setTransferOrderNo(transferOrderNo);
        TransferOrderEo transferOrderEo = this.transferOrderDomain.selectByBizKey(keyDto);
        transferOrderEo.setOrderStatus(TransferOrderStatus.WAITING_APPROVAL.code());
        transferOrderEo.setApprovalStatus(TransferOrderApprovalState.PRIMARY_PENDING.getCode());
        this.transferOrderDomain.updateSelective((BaseEo)transferOrderEo);
        StateMachineEo db = this.stateMachineMapper.selectByTypeAndMachineKey("APPROVAL", transferOrderNo);
        db.setStatus(TransferOrderApprovalState.PRIMARY_PENDING.getCode());
        this.stateMachineMapper.updateById((BaseEo)db);
        JSONObject jsonFields = (JSONObject)JSONObject.parseObject((String)transferOrderEo.getExtension(), JSONObject.class);
        jsonFields.put("withdrawFlag", (Object)"true");
        transferOrderEo.setExtension(jsonFields.toJSONString());
        StatemachineExecutorBo<TransferOrderEo> executorBo = new StatemachineExecutorBo<TransferOrderEo>();
        executorBo.setEo(transferOrderEo);
        context.getExtendedState().getVariables().put("executorBo", executorBo);
        log.info("-----------------------------\u8c03\u62e8\u5355\u64a4\u56de\u7ed3\u675f!--------------------");
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void partiallyShip(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
        log.info("-----------------------------\u90e8\u5206\u53d1\u8d27Action--------------------");
        ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)receiveDeliveryResultOrderContext.getRelevanceNo())).one();
        this.generateReceiveNoticeOrder(receiveDeliveryResultOrderContext, transferOrderEo);
        transferOrderEo.setOrderStatus(TransferOrderStatus.PARTIALLY_DELIVERED_WAITING_FOR_DELIVERY.code());
        transferOrderEo.setShipmentStatus(TransferOrderDeliveryState.PARTIALLY_DELIVERED.getCode());
        if (StringUtils.isBlank((CharSequence)transferOrderEo.getDeliveryStatus())) {
            transferOrderEo.setOrderStatus(TransferOrderStatus.PARTIALLY_DELIVERED_WAITING_FOR_DELIVERY.code());
        } else {
            switch (TransferOrderReceiveState.getByCode((String)transferOrderEo.getDeliveryStatus())) {
                case WAITING_FOR_DELIVERY: {
                    transferOrderEo.setOrderStatus(TransferOrderStatus.PARTIALLY_DELIVERED_WAITING_FOR_DELIVERY.code());
                    break;
                }
                case PARTIALLY_RECEIVED: {
                    transferOrderEo.setOrderStatus(TransferOrderStatus.PARTIALLY_DELIVERED_PARTIALLY_RECEIVED.code());
                    break;
                }
            }
        }
        BigDecimal outboundTotalQuantity = this.transferOrderDomain.getResultOrderNumber(receiveDeliveryResultOrderContext.getRelevanceNo(), "delivery");
        transferOrderEo.setOutboundTotalQuantity(outboundTotalQuantity);
        transferOrderEo.setTotalWeight(receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderEo().getTotalWeight());
        transferOrderEo.setTotalVolume(receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderEo().getTotalVolume());
        if (CollectionUtils.isNotEmpty(receiveDeliveryResultOrderContext.getShippingInfoReqDtoList())) {
            CsWmsShippingInfoReqDto wmsShippingInfoReqDto = receiveDeliveryResultOrderContext.getShippingInfoReqDtoList().get(0);
            transferOrderEo.setShipmentEnterpriseCode(wmsShippingInfoReqDto.getShippingCompanyCode());
            transferOrderEo.setShipmentEnterpriseName(wmsShippingInfoReqDto.getShippingCompanyName());
        }
        this.transferOrderDomain.updateSelective((BaseEo)transferOrderEo);
        this.transferOrderDetailDomain.updateTransferOrderDetailQuantity(receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderDetailEoList(), transferOrderEo);
        ReceiveDeliveryResultOrderContext order = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
        if (!InventoryConfig.isDispatchOrderEnable() && !this.transferOrderDomain.isFinishShip(order.getRelevanceNo())) {
            this.transferOrderReissueExe.reissue(transferOrderEo.getTransferOrderNo());
        }
        this.pushSap(receiveDeliveryResultOrderContext);
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void allShip(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
        log.info("-----------------------------\u5168\u90e8\u53d1\u8d27Action--------------------");
        ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)receiveDeliveryResultOrderContext.getRelevanceNo())).one();
        this.generateReceiveNoticeOrder(receiveDeliveryResultOrderContext, transferOrderEo);
        transferOrderEo.setShipmentStatus(TransferOrderDeliveryState.DELIVERED.getCode());
        transferOrderEo.setOrderStatus(TransferOrderStatus.ALL_DELIVERED_WAITING_FOR_DELIVERY.code());
        if (StringUtils.isBlank((CharSequence)transferOrderEo.getDeliveryStatus())) {
            transferOrderEo.setOrderStatus(TransferOrderStatus.ALL_DELIVERED_WAITING_FOR_DELIVERY.code());
        } else {
            switch (TransferOrderReceiveState.getByCode((String)transferOrderEo.getDeliveryStatus())) {
                case WAITING_FOR_DELIVERY: {
                    transferOrderEo.setOrderStatus(TransferOrderStatus.ALL_DELIVERED_WAITING_FOR_DELIVERY.code());
                    break;
                }
                case PARTIALLY_RECEIVED: {
                    transferOrderEo.setOrderStatus(TransferOrderStatus.ALL_DELIVERED_PARTIALLY_RECEIVED.code());
                    break;
                }
            }
        }
        BigDecimal outboundTotalQuantity = this.transferOrderDomain.getResultOrderNumber(receiveDeliveryResultOrderContext.getRelevanceNo(), "delivery");
        transferOrderEo.setOutboundTotalQuantity(outboundTotalQuantity);
        transferOrderEo.setTotalWeight(receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderEo().getTotalWeight());
        transferOrderEo.setTotalVolume(receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderEo().getTotalVolume());
        if (CollectionUtils.isNotEmpty(receiveDeliveryResultOrderContext.getShippingInfoReqDtoList())) {
            CsWmsShippingInfoReqDto wmsShippingInfoReqDto = receiveDeliveryResultOrderContext.getShippingInfoReqDtoList().get(0);
            transferOrderEo.setShipmentEnterpriseCode(wmsShippingInfoReqDto.getShippingCompanyCode());
            transferOrderEo.setShipmentEnterpriseName(wmsShippingInfoReqDto.getShippingCompanyName());
        }
        this.transferOrderDomain.updateSelective((BaseEo)transferOrderEo);
        this.transferOrderDetailDomain.updateTransferOrderDetailQuantity(receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderDetailEoList(), transferOrderEo);
        this.transferOrderReissueExe.reissue(transferOrderEo.getTransferOrderNo());
        this.pushSap(receiveDeliveryResultOrderContext);
    }

    public boolean isAllShip(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
        ReceiveDeliveryResultOrderContext order = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
        return this.transferOrderDomain.isAllShip(order.getRelevanceNo());
    }

    public boolean isFinishShip(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
        ReceiveDeliveryResultOrderContext order = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
        return this.transferOrderDomain.isFinishShip(order.getRelevanceNo());
    }

    private void generateReceiveNoticeOrder(ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext, final TransferOrderEo transferOrderEo) {
        log.info("TransferOrderDeliveryAction\u751f\u6210\u6536\u8d27\u901a\u77e5\u5355\uff1a{}", (Object)JSON.toJSONString((Object)receiveDeliveryResultOrderContext));
        ReceiveDeliveryResultOrderEo resultRespDto = receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderEo();
        List<ReceiveDeliveryResultOrderDetailEo> detail = receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderDetailEoList();
        ReceiveDeliveryNoticeOrderFacadeBo csBasicsOrderReqDto = new ReceiveDeliveryNoticeOrderFacadeBo();
        csBasicsOrderReqDto.setPreOrderNo(resultRespDto.getDocumentNo());
        csBasicsOrderReqDto.setBizDate(resultRespDto.getBizDate());
        csBasicsOrderReqDto.setExternalOrderNo(resultRespDto.getExternalOrderNo());
        csBasicsOrderReqDto.setDisplayBusinessType(transferOrderEo.getType());
        csBasicsOrderReqDto.setRelevanceNo(transferOrderEo.getTransferOrderNo());
        csBasicsOrderReqDto.setBusinessType(transferOrderEo.getType());
        csBasicsOrderReqDto.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        csBasicsOrderReqDto.setLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
        csBasicsOrderReqDto.setLogicWarehouseName(transferOrderEo.getInLogicWarehouseName());
        csBasicsOrderReqDto.setPhysicsWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
        csBasicsOrderReqDto.setPhysicsWarehouseName(transferOrderEo.getInPhysicsWarehouseName());
        csBasicsOrderReqDto.setSourceType(CsInventorySourceTypeEnum.IN_ALLOT.getCode());
        csBasicsOrderReqDto.setRemark(transferOrderEo.getRemark());
        csBasicsOrderReqDto.setBaseOrderAddressEoList(((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)transferOrderEo.getTransferOrderNo())).list());
        ArrayList typeList = Lists.newArrayList((Object[])new String[]{TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_C.getCode(), TransferOrderTypeEnum.EXTERNAL_WAREHOUSE_B_C.getCode()});
        if (typeList.contains(transferOrderEo.getType())) {
            csBasicsOrderReqDto.setAutoComplete(Boolean.TRUE);
            csBasicsOrderReqDto.setSendWms(Boolean.FALSE);
        }
        if (TransferOrderTypeEnum.CW_WAREHOUSE_C_C.getCode().equals(transferOrderEo.getType()) && StringUtils.isNotEmpty((CharSequence)transferOrderEo.getExternalOrderNo())) {
            csBasicsOrderReqDto.setAutoComplete(Boolean.TRUE);
            csBasicsOrderReqDto.setSendWms(Boolean.FALSE);
        }
        if (InventoryConfig.isEnableInOutAutoComplete()) {
            log.info("\u8bbe\u7f6e\u8c03\u62e8\u5355{}\u5165\u5e93\u81ea\u52a8\u5b8c\u6210", (Object)transferOrderEo.getTransferOrderNo());
            PhysicsWarehouseEo inPhysicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)transferOrderEo.getInPhysicsWarehouseCode())).one();
            AssertUtil.assertNotNull((Object)inPhysicsWarehouseEo, (String)"\u8c03\u5165\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            csBasicsOrderReqDto.setAutoComplete(inPhysicsWarehouseEo.getInterconnectionFlag() == 0);
        }
        csBasicsOrderReqDto.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext relContext = (ReceiveDeliveryNoticeOrderContext)context;
                ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = relContext.getReceiveDeliveryNoticeOrderEo();
                receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(transferOrderEo.getOutLogicWarehouseCode());
                receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseName(transferOrderEo.getOutLogicWarehouseName());
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        csBasicsOrderReqDto.setOrderBasicsDetailReqDtoList(detail.stream().filter(re -> BigDecimalUtils.gtZero((BigDecimal)re.getQuantity())).map(re -> {
            BaseOrderDetailReqDto baseOrderDetailReqDto = new BaseOrderDetailReqDto();
            BeanUtil.copyProperties((Object)re, (Object)((Object)baseOrderDetailReqDto), (String[])new String[0]);
            BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)JSONObject.parseObject((String)re.getExtension(), BasicOrderDtoExtension.class);
            baseOrderDetailReqDto.setVolume(basicOrderDtoExtension.getVolume());
            baseOrderDetailReqDto.setWeight(basicOrderDtoExtension.getWeight());
            return baseOrderDetailReqDto;
        }).collect(Collectors.toList()));
        log.info("\u865a\u62df\u8c03\u62e8\u751f\u6210\u5165\u5e93\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)csBasicsOrderReqDto));
        if (CollectionUtils.isNotEmpty(csBasicsOrderReqDto.getOrderBasicsDetailReqDtoList())) {
            this.baseOrderFacade.receiveNoticeOrderGen(csBasicsOrderReqDto);
        }
    }

    @NotNull
    private BaseOrderCallBack<BaseOrderBaseContext> getInNoticeCallBack() {
        return new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutNoticeOrderContext) {
                    InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)context;
                    log.info("\u865a\u62df\u8c03\u62e8\u5355\u4e0d\u63a8\u9001wms");
                    outNoticeOrderContext.setSendWms(false);
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
            }
        };
    }

    private void pushSap(ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext) {
        if (InventoryConfig.getPushSapAble().canPush(PushAble.CanPushBo.builder().build())) {
            InventoryConfig.getPushSapAble().push(receiveDeliveryResultOrderContext);
        }
    }
}

