/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.BdTypeOfDocumentEnum;
import com.yunxi.dg.base.center.enums.TransferDispatcherStatusEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.das.IInventoryBatchDas;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDetailDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailResponseDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TransferOrderBatchDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TransferOrderSkuBatchItemBatchRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TransferOrderSkuBatchItemRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TransferOrderSkuBatchRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.transfer.order.TransferOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailSearchDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderSkuBatchSearchDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryBatchEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderDetailService;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicInventoryService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.item.dto.response.DirRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemDirQueryApiProxy;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransferOrderDetailServiceImpl
extends BaseServiceImpl<TransferOrderDetailDto, TransferOrderDetailEo, ITransferOrderDetailDomain>
implements ITransferOrderDetailService {
    @Resource
    private ITransferOrderDas transferOrderDas;
    @Resource
    private ITransferOrderDetailDas detailDas;
    @Resource
    private ILogicInventoryService logicInventoryService;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    protected ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private IInventoryBatchDas inventoryBatchDas;
    @Resource
    private IItemDirQueryApiProxy dirQueryApiProxy;
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderDetailServiceImpl.class);

    public TransferOrderDetailServiceImpl(ITransferOrderDetailDomain iTransferOrderDetailDomain) {
        super((IBaseDomain)iTransferOrderDetailDomain);
    }

    @Override
    public RestResponse<List<TransferOrderDetailRespDto>> queryList(TransferOrderKeyDto keyDto) {
        TransferOrderDetailRespDto item;
        Object transferOrderEo;
        List detail = ((ITransferOrderDetailDomain)this.domain).queryListByBizKey(keyDto);
        List<String> skuCodeList = detail.stream().map(TransferOrderDetailRespDto::getSkuCode).distinct().collect(Collectors.toList());
        Map lastDirMap = new HashMap(skuCodeList.size());
        HashMap skuMap = new HashMap(skuCodeList.size());
        if (CollectionUtil.isNotEmpty(skuCodeList)) {
            List dtoList = this.itemDataQueryHelper.getByCodes(skuCodeList);
            if (CollectionUtil.isNotEmpty(dtoList)) {
                Map respDtoMap = dtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o1, o2) -> o1));
                skuMap.putAll(respDtoMap);
            }
            lastDirMap = Optional.ofNullable(this.dirQueryApiProxy.queryLastDirBySkuCodes(skuCodeList)).orElse(new HashMap());
        }
        HashMap finalLastDirMap = lastDirMap;
        detail.forEach(o -> {
            DirRespDto itDirDto;
            if (skuMap.containsKey(o.getSkuCode())) {
                ItemSkuDto itemSkuDgRespDto = (ItemSkuDto)skuMap.get(o.getSkuCode());
                o.setSpuCode(itemSkuDgRespDto.getSpuCode());
                o.setSpuName(itemSkuDgRespDto.getSpuName());
                o.setBarCode(itemSkuDgRespDto.getBarCode());
                o.setSpecModel(itemSkuDgRespDto.getSpecModel());
                if (itemSkuDgRespDto.getMinPackage() != null) {
                    o.setMinimumPackingQuantity(new BigDecimal(itemSkuDgRespDto.getMinPackage()));
                }
            }
            if (Objects.nonNull(itDirDto = (DirRespDto)finalLastDirMap.get(o.getSkuCode()))) {
                o.setLastDirId(itDirDto.getId());
                o.setLastDirName(itDirDto.getName());
            }
        });
        if (StringUtils.isBlank((String)keyDto.getTransferOrderNo())) {
            transferOrderEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(keyDto.getId());
            keyDto.setTransferOrderNo(transferOrderEo.getTransferOrderNo());
        }
        transferOrderEo = detail.iterator();
        while (transferOrderEo.hasNext()) {
            item = (TransferOrderDetailRespDto)transferOrderEo.next();
            if (!StringUtils.isNotBlank((String)item.getBatch())) continue;
            InventoryBatchEo condition = new InventoryBatchEo();
            condition.setSkuCode(item.getSkuCode());
            condition.setBatch(item.getBatch());
            InventoryBatchEo result = (InventoryBatchEo)this.inventoryBatchDas.selectOne((BaseEo)condition);
            if (result == null) continue;
            item.setExpireTime(result.getExpireTime());
            item.setProduceTime(result.getProduceTime());
        }
        if (CollectionUtil.isNotEmpty((Collection)detail)) {
            this.queryAndSetAvailable(keyDto.getTransferOrderNo(), detail);
            transferOrderEo = detail.iterator();
            while (transferOrderEo.hasNext()) {
                item = (TransferOrderDetailRespDto)transferOrderEo.next();
                TransferOrderSkuBatchSearchDto skuBatchSearchDto = new TransferOrderSkuBatchSearchDto();
                skuBatchSearchDto.setTransferOrderNo(item.getTransferOrderNo());
                skuBatchSearchDto.setSkuCode(item.getSkuCode());
                skuBatchSearchDto.setBatch(item.getBatch());
                RestResponse<TransferOrderSkuBatchRespDto> skuBatchRespDto = this.querySkuBatchPage(skuBatchSearchDto);
                item.setBatchList((TransferOrderSkuBatchRespDto)skuBatchRespDto.getData());
            }
        }
        if (!TransferOrderStatus.isOverStatus((String)(transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.transferOrderDas.filter().eq((Object)"transfer_order_no", (Object)keyDto.getTransferOrderNo())).last("limit 1")).one()).getOrderStatus())) {
            this.formatWaitInfo(keyDto.getTransferOrderNo(), detail);
        }
        return new RestResponse((Object)detail);
    }

    private void queryAndSetAvailable(String transferOrderNo, List<TransferOrderDetailRespDto> list) {
        CsTransferOrderRespDto transfer = this.transferOrderDas.queryByTransferOrderNo(transferOrderNo);
        Set<String> longCodeSet = list.stream().map(TransferOrderDetailRespDto::getSkuCode).collect(Collectors.toSet());
        List<LogicInventoryDto> inventoryEos = this.logicInventoryService.queryBySkuCodesWithWarehouseCode(transfer.getOutLogicWarehouseCode(), longCodeSet);
        if (CollectionUtil.isNotEmpty(inventoryEos)) {
            Map<String, BigDecimal> availMap = inventoryEos.stream().collect(Collectors.groupingBy(LogicInventoryDto::getSkuCode, Collectors.mapping(LogicInventoryDto::getAvailable, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map<String, BigDecimal> availBatchMap = inventoryEos.stream().collect(Collectors.groupingBy(r -> String.join((CharSequence)"__", r.getSkuCode(), r.getBatch()), Collectors.mapping(LogicInventoryDto::getAvailable, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            list.forEach(d -> d.setAvailableInventory(availBatchMap.getOrDefault(String.join((CharSequence)"__", d.getSkuCode(), d.getBatch()), availMap.getOrDefault(d.getSkuCode(), BigDecimal.ZERO)).toString()));
        }
    }

    private void formatWaitInfo(String transferOrderNo, List<TransferOrderDetailRespDto> detail) {
        ArrayList notOutInNoticeStatusList = Lists.newArrayList();
        notOutInNoticeStatusList.add(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        notOutInNoticeStatusList.add(BaseOrderStatusEnum.INO_CANCEL.getCode());
        QueryWrapper csOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        csOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)transferOrderNo);
        csOutNoticeOrderEoQueryWrapper.notIn((Object)"order_status", (Collection)notOutInNoticeStatusList);
        List csOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).notIn((Object)"order_status", (Collection)notOutInNoticeStatusList)).list();
        InOutNoticeOrderEo outNoticeOrderEo = null;
        InOutNoticeOrderEo inNoticeOrderEo = null;
        if (CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderEoList)) {
            for (InOutNoticeOrderEo outInNoticeOrderEo : csOutNoticeOrderEoList) {
                String orderType = outInNoticeOrderEo.getOrderType();
                if ("out".equals(orderType)) {
                    outNoticeOrderEo = outInNoticeOrderEo;
                    continue;
                }
                if (!"in".equals(orderType)) continue;
                inNoticeOrderEo = outInNoticeOrderEo;
            }
        }
        Map<Object, Object> outNoticeOrderDetailMap = Maps.newHashMap();
        if (null != outNoticeOrderEo) {
            String documentNo = outNoticeOrderEo.getDocumentNo();
            List outNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
            if (CollectionUtils.isNotEmpty((Collection)outNoticeOrderDetailEoList)) {
                outNoticeOrderDetailMap = outNoticeOrderDetailEoList.stream().collect(Collectors.toMap(i1 -> i1.getPreOrderItemId() + InventoryConfig.getCommonSeparate() + InventoryConfig.getOrDefaultBatch(i1.getBatch()), Function.identity(), (o1, o2) -> o2));
            }
        }
        Map<Object, Object> inResultOrderDetailEoMap = Maps.newHashMap();
        Map<Object, Object> outResultOrderDetailEoMap = Maps.newHashMap();
        List inOutResultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).in((Object)"order_status", new Object[]{BaseOrderStatusEnum.IRO_DONE_IN.getCode(), BaseOrderStatusEnum.ORO_DONE_OUT.getCode()})).list();
        if (CollectionUtils.isNotEmpty((Collection)inOutResultOrderEoList)) {
            List resultDocumentNoList = inOutResultOrderEoList.stream().map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList());
            List csOutResultOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", resultDocumentNoList)).list();
            Map<String, List<InOutResultOrderDetailEo>> resultDetailMap = csOutResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getDocumentNo));
            outResultOrderDetailEoMap = inOutResultOrderEoList.stream().filter(r -> "out".equals(r.getOrderType())).flatMap(r -> ((List)resultDetailMap.getOrDefault(r.getDocumentNo(), new ArrayList())).stream().peek(rd -> rd.setBatch(InventoryConfig.getOrDefaultBatch(rd.getBatch())))).collect(Collectors.groupingBy(i1 -> i1.getPreOrderItemId() + InventoryConfig.getCommonSeparate() + i1.getBatch()));
            inResultOrderDetailEoMap = inOutResultOrderEoList.stream().filter(r -> "in".equals(r.getOrderType())).flatMap(r -> ((List)resultDetailMap.getOrDefault(r.getDocumentNo(), new ArrayList())).stream().peek(rd -> rd.setBatch(InventoryConfig.getOrDefaultBatch(rd.getBatch())))).collect(Collectors.groupingBy(i1 -> i1.getPreOrderItemId() + InventoryConfig.getCommonSeparate() + i1.getBatch()));
        }
        Map<Object, Object> inNoticeOrderDetailMap = Maps.newHashMap();
        if (null != inNoticeOrderEo) {
            String documentNo = inNoticeOrderEo.getDocumentNo();
            List inNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
            if (CollectionUtils.isNotEmpty((Collection)inNoticeOrderDetailEoList)) {
                inNoticeOrderDetailMap = inNoticeOrderDetailEoList.stream().collect(Collectors.toMap(i1 -> i1.getPreOrderItemId() + InventoryConfig.getCommonSeparate() + InventoryConfig.getOrDefaultBatch(i1.getBatch()), Function.identity(), (o1, o2) -> {
                    o1.setDoneQuantity(BigDecimalUtils.add((BigDecimal)o2.getDoneQuantity(), (BigDecimal)o1.getDoneQuantity()));
                    return o1;
                }));
            }
        }
        List unitConversionRecordEos = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)transferOrderNo)).list();
        Map<String, BigDecimal> ratioMap = unitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
        Map<String, BigDecimal> toRatioMap = unitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getNum(), (BigDecimal)r.getToNum(), (int)6), (o, o1) -> o));
        for (TransferOrderDetailRespDto detailRespDto : detail) {
            String batch = InventoryConfig.getOrDefaultBatch(detailRespDto.getBatch());
            Long id = detailRespDto.getId();
            BigDecimal ratio = ratioMap.getOrDefault(detailRespDto.getSkuCode(), BigDecimal.ONE);
            InOutNoticeOrderDetailEo inNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)inNoticeOrderDetailMap.get(id + InventoryConfig.getCommonSeparate() + batch);
            if (null != inNoticeOrderDetailEo) {
                detailRespDto.setWaitInQuantity(BigDecimalUtils.divide((BigDecimal)inNoticeOrderDetailEo.getWaitQuantity(), (BigDecimal)ratio, (int)6));
            } else {
                detailRespDto.setWaitInQuantity(BigDecimal.ZERO);
            }
            List inResultOrderDetailEoList = (List)inResultOrderDetailEoMap.get(id + InventoryConfig.getCommonSeparate() + batch);
            if (CollectionUtils.isNotEmpty((Collection)inResultOrderDetailEoList)) {
                BigDecimal totalDoneQuantity = inResultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                detailRespDto.setDoneInQuantity(BigDecimalUtils.divide((BigDecimal)totalDoneQuantity, (BigDecimal)ratio, (int)6));
            } else {
                detailRespDto.setDoneInQuantity(BigDecimal.ZERO);
            }
            InOutNoticeOrderDetailEo outNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)outNoticeOrderDetailMap.get(id + InventoryConfig.getCommonSeparate() + batch);
            if (null != outNoticeOrderDetailEo) {
                detailRespDto.setWaitOutQuantity(BigDecimalUtils.divide((BigDecimal)outNoticeOrderDetailEo.getWaitQuantity(), (BigDecimal)ratio, (int)6));
            } else {
                detailRespDto.setWaitOutQuantity(BigDecimal.ZERO);
            }
            List outResultOrderDetailEos = (List)outResultOrderDetailEoMap.get(id + InventoryConfig.getCommonSeparate() + batch);
            if (CollectionUtils.isNotEmpty((Collection)outResultOrderDetailEos)) {
                BigDecimal totalDoneQuantity = outResultOrderDetailEos.stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                detailRespDto.setDoneOutQuantity(BigDecimalUtils.divide((BigDecimal)totalDoneQuantity, (BigDecimal)ratio, (int)6));
                continue;
            }
            detailRespDto.setDoneOutQuantity(BigDecimal.ZERO);
        }
    }

    @Override
    public RestResponse<PageInfo<CsTransferOrderDetailResponseDto>> queryPage(TransferOrderDetailSearchDto detailSearchDto) {
        PageInfo page;
        block10: {
            ArrayList list;
            block11: {
                List<InOutResultOrderDetailEo> in;
                PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.detailDas.filter().eq((Object)"transfer_order_no", (Object)detailSearchDto.getTransferOrderNo())).orderByAsc((Object)"id")).select(new String[0]).page(detailSearchDto.getPageNum(), detailSearchDto.getPageSize());
                page = new PageInfo();
                CubeBeanUtils.copyProperties((Object)page, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                list = new ArrayList();
                DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), list, CsTransferOrderDetailResponseDto.class);
                page.setList(list);
                List csDeliveryNoticeOrderEoList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)detailSearchDto.getTransferOrderNo())).list();
                ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderEo = null;
                if (CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderEoList)) {
                    csDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)csDeliveryNoticeOrderEoList.get(0);
                }
                if (!CollectionUtil.isNotEmpty(list)) break block10;
                Map<String, List<InOutResultOrderDetailEo>> map = this.queryInOutResult(detailSearchDto.getTransferOrderNo());
                if (!CollectionUtil.isNotEmpty(map)) break block11;
                List<InOutResultOrderDetailEo> out = map.get("out");
                if (CollectionUtil.isNotEmpty(out)) {
                    Map<Long, Double> outFinishMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
                    Map<Long, Double> outFinishPreOrderItemIdMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
                    Map<Long, List<InOutResultOrderDetailEo>> batchMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId));
                    Map<Long, List<InOutResultOrderDetailEo>> batchPreOrderItemIdMap = out.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId));
                    for (CsTransferOrderDetailResponseDto transfer : list) {
                        Double outTotal = Objects.nonNull(outFinishPreOrderItemIdMap.get(transfer.getId())) ? outFinishPreOrderItemIdMap.get(transfer.getId()) : outFinishMap.get(transfer.getId());
                        transfer.setDoneDeliveryQuantity(outTotal == null ? BigDecimal.ZERO : new BigDecimal(outTotal));
                        List<InOutResultOrderDetailEo> outBatch = Objects.nonNull(batchPreOrderItemIdMap.get(transfer.getId())) ? batchPreOrderItemIdMap.get(transfer.getId()) : batchMap.get(transfer.getId());
                        if (!CollectionUtil.isNotEmpty(outBatch)) continue;
                        ArrayList<TransferOrderBatchDetailRespDto> batchList = new ArrayList<TransferOrderBatchDetailRespDto>();
                        for (InOutResultOrderDetailEo batch : outBatch) {
                            TransferOrderBatchDetailRespDto t = new TransferOrderBatchDetailRespDto();
                            t.setBatch(batch.getBatch());
                            t.setDoneDeliveryQuantity(batch.getQuantity() == null ? BigDecimal.ZERO : batch.getQuantity());
                            t.setDoneReceiveQuantity(BigDecimal.ZERO);
                            t.setOutResultNo(batch.getDocumentNo());
                            t.setInResultNo("-");
                            if (null != csDeliveryNoticeOrderEo) {
                                t.setJumpDocumentType(csDeliveryNoticeOrderEo.getJumpDocumentType());
                                t.setJumpDocumentName(csDeliveryNoticeOrderEo.getJumpDocumentName());
                            }
                            t.setJumpDocumentName("\u53d1\u8d27\u7ed3\u679c\u5355");
                            batchList.add(t);
                        }
                        transfer.setBatchList(batchList);
                    }
                }
                if (!CollectionUtil.isNotEmpty(in = map.get("in"))) break block10;
                Map<Long, Double> inFinishMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId, Collectors.summingDouble(c -> TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(c.getDispatcherStatus()) ? c.getQuantity().add(Optional.ofNullable(c.getDispatcherQuantity()).orElse(BigDecimal.ZERO)).doubleValue() : c.getQuantity().doubleValue())));
                Map<Long, Double> inFinishPreOrderItemIdMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
                Map<Long, List<InOutResultOrderDetailEo>> batchMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId));
                Map<Long, List<InOutResultOrderDetailEo>> batchPreOrderItemIdMap = in.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId));
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    CsTransferOrderDetailResponseDto transfer;
                    Double inTotal = (Double)DataExtractUtils.ifNullElse((Object)inFinishMap.get((transfer = (CsTransferOrderDetailResponseDto)iterator.next()).getId()), (Object)inFinishPreOrderItemIdMap.get(transfer.getId()));
                    transfer.setDoneReceiveQuantity(inTotal == null ? BigDecimal.ZERO : new BigDecimal(inTotal));
                    List<InOutResultOrderDetailEo> inBatch = Objects.nonNull(batchPreOrderItemIdMap.get(transfer.getId())) ? batchPreOrderItemIdMap.get(transfer.getId()) : batchMap.get(transfer.getId());
                    if (!CollectionUtil.isNotEmpty(inBatch)) continue;
                    List batchList = transfer.getBatchList();
                    for (InOutResultOrderDetailEo batch : inBatch) {
                        TransferOrderBatchDetailRespDto t = new TransferOrderBatchDetailRespDto();
                        t.setBatch(batch.getBatch());
                        t.setDoneReceiveQuantity(batch.getQuantity() == null ? BigDecimal.ZERO : batch.getQuantity());
                        t.setDoneDeliveryQuantity(BigDecimal.ZERO);
                        t.setInResultNo(batch.getDocumentNo());
                        if (TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(batch.getDispatcherStatus())) {
                            t.setDoneReceiveQuantity(t.getDoneReceiveQuantity().add(Optional.ofNullable(batch.getDispatcherQuantity()).orElse(BigDecimal.ZERO)));
                        }
                        t.setOutResultNo("-");
                        if (null != csDeliveryNoticeOrderEo) {
                            t.setJumpDocumentType(csDeliveryNoticeOrderEo.getJumpDocumentType());
                            t.setJumpDocumentName(csDeliveryNoticeOrderEo.getJumpDocumentName());
                        }
                        t.setJumpDocumentName("\u6536\u8d27\u7ed3\u679c\u5355");
                        batchList.add(t);
                    }
                }
                break block10;
            }
            for (CsTransferOrderDetailResponseDto responseDto : list) {
                List batchList = responseDto.getBatchList();
                if (!CollectionUtils.isEmpty((Collection)batchList)) continue;
                responseDto.setBatchList(null);
            }
        }
        return new RestResponse((Object)page);
    }

    @Override
    public RestResponse<TransferOrderSkuBatchRespDto> querySkuBatchPage(TransferOrderSkuBatchSearchDto skuBatchSearchDto) {
        Set<String> in;
        TransferOrderSkuBatchRespDto resp = new TransferOrderSkuBatchRespDto();
        HashMap map = new HashMap(2);
        List resultList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)skuBatchSearchDto.getTransferOrderNo())).ne((Object)"business_type", (Object)BdTypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode())).list();
        Map longCodeMap = resultList.stream().collect(Collectors.groupingBy(InOutResultOrderEo::getOrderType, Collectors.mapping(InOutResultOrderEo::getDocumentNo, Collectors.toSet())));
        Set<String> out = longCodeMap.get("out");
        if (CollectionUtils.isNotEmpty(out)) {
            List<TransferOrderSkuBatchItemRespDto> outList = this.extracted(skuBatchSearchDto, out);
            resp.setOut(outList);
        }
        if (CollectionUtils.isNotEmpty(in = longCodeMap.get("in"))) {
            List<TransferOrderSkuBatchItemRespDto> outList = this.extracted(skuBatchSearchDto, in);
            resp.setIn(outList);
        }
        return new RestResponse((Object)resp);
    }

    private List<TransferOrderSkuBatchItemRespDto> extracted(TransferOrderSkuBatchSearchDto skuBatchSearchDto, Set<String> out) {
        ArrayList<TransferOrderSkuBatchItemRespDto> outSkuBatch = new ArrayList<TransferOrderSkuBatchItemRespDto>();
        List outList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", out)).eq((Object)"sku_code", (Object)skuBatchSearchDto.getSkuCode())).eq(StringUtils.isNotBlank((String)skuBatchSearchDto.getBatch()), (Object)"batch", (Object)skuBatchSearchDto.getBatch())).list();
        List batchNoList = outList.stream().map(InOutResultOrderDetailEo::getBatch).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)outList)) {
            return Arrays.asList(new TransferOrderSkuBatchItemRespDto[0]);
        }
        List inventoryBatchEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryBatchDas.filter().eq((Object)"sku_code", (Object)skuBatchSearchDto.getSkuCode())).in((Object)"batch", batchNoList)).list();
        HashMap<String, InventoryBatchEo> inventoryBatchEoMap = new HashMap<String, InventoryBatchEo>(inventoryBatchEoList.size());
        for (InventoryBatchEo inBaEo : inventoryBatchEoList) {
            inventoryBatchEoMap.put(inBaEo.getBatch(), inBaEo);
        }
        Map<String, List<InOutResultOrderDetailEo>> documentNoMap = outList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getDocumentNo));
        for (String key : documentNoMap.keySet()) {
            List<InOutResultOrderDetailEo> value = documentNoMap.get(key);
            List relevanceNoList = value.stream().map(InOutResultOrderDetailEo::getRelevanceNo).collect(Collectors.toList());
            List unitConversionRecordEoList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtil.isNotEmpty(relevanceNoList), (Object)"document_code", relevanceNoList)).list();
            Map unitConversionRecordEoMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode(), Function.identity(), (o2, o1) -> o2));
            TransferOrderSkuBatchItemRespDto skuBatchItemRespDto = new TransferOrderSkuBatchItemRespDto();
            skuBatchItemRespDto.setDocumentNo(key);
            ArrayList<TransferOrderSkuBatchItemBatchRespDto> batchList = new ArrayList<TransferOrderSkuBatchItemBatchRespDto>();
            for (InOutResultOrderDetailEo resultEo : value) {
                TransferOrderSkuBatchItemBatchRespDto batchItemBatchRespDto = new TransferOrderSkuBatchItemBatchRespDto();
                batchItemBatchRespDto.setBatch(resultEo.getBatch());
                batchItemBatchRespDto.setInventoryProperty(resultEo.getInventoryProperty());
                batchItemBatchRespDto.setQuantity(resultEo.getQuantity());
                batchItemBatchRespDto.setDoneQuantity(resultEo.getDoneQuantity());
                batchItemBatchRespDto.setDifferenceQuantity(resultEo.getDispatcherQuantity());
                batchItemBatchRespDto.setTime(resultEo.getUpdateTime());
                InventoryBatchEo inBaEo = (InventoryBatchEo)inventoryBatchEoMap.get(resultEo.getBatch());
                if (inBaEo != null) {
                    batchItemBatchRespDto.setProduceTime(inBaEo.getProduceTime());
                    batchItemBatchRespDto.setExpireTime(inBaEo.getExpireTime());
                }
                batchList.add(batchItemBatchRespDto);
                if (!unitConversionRecordEoMap.containsKey(resultEo.getRelevanceNo() + resultEo.getSkuCode())) continue;
                OrderUnitConversionRecordEo unitConversionRecordEo = (OrderUnitConversionRecordEo)unitConversionRecordEoMap.get(resultEo.getRelevanceNo() + resultEo.getSkuCode());
                BigDecimal rate = unitConversionRecordEo.getNum().divide(unitConversionRecordEo.getToNum(), 6, RoundingMode.HALF_UP);
                BigDecimal doneQuantity = null != batchItemBatchRespDto.getDoneQuantity() ? batchItemBatchRespDto.getDoneQuantity().multiply(rate) : null;
                batchItemBatchRespDto.setDoneQuantity(doneQuantity);
            }
            skuBatchItemRespDto.setBatchList(batchList);
            outSkuBatch.add(skuBatchItemRespDto);
        }
        return outSkuBatch;
    }

    private void unitConversion(TransferOrderSkuBatchItemBatchRespDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        BigDecimal rate = unitConversionEo.getNum().divide(unitConversionEo.getToNum(), 6, RoundingMode.HALF_UP);
        BigDecimal doneOutQuantity = null != dto.getDoneQuantity() ? dto.getDoneQuantity().multiply(rate) : null;
    }

    private Map<String, List<InOutResultOrderDetailEo>> queryInOutResult(String transferOrderNo) {
        Set in;
        HashMap<String, List<InOutResultOrderDetailEo>> map = new HashMap<String, List<InOutResultOrderDetailEo>>(2);
        List resultList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).ne((Object)"business_type", (Object)BdTypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode())).list();
        Map longCodeMap = resultList.stream().collect(Collectors.groupingBy(InOutResultOrderEo::getOrderType, Collectors.mapping(InOutResultOrderEo::getDocumentNo, Collectors.toSet())));
        Set out = longCodeMap.get("out");
        if (CollectionUtil.isNotEmpty(out)) {
            List outList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", out)).list();
            map.put("out", outList);
        }
        if (CollectionUtil.isNotEmpty(in = longCodeMap.get("in"))) {
            List inList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", in)).list();
            map.put("in", inList);
        }
        return map;
    }

    private Map<String, List<InOutResultOrderDetailEo>> queryInOutResultBySku(String transferOrderNo, String skuCode) {
        Set in;
        HashMap<String, List<InOutResultOrderDetailEo>> map = new HashMap<String, List<InOutResultOrderDetailEo>>(2);
        List resultList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).eq((Object)"sku_code", (Object)skuCode)).ne((Object)"business_type", (Object)BdTypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode())).list();
        Map longCodeMap = resultList.stream().collect(Collectors.groupingBy(InOutResultOrderEo::getOrderType, Collectors.mapping(InOutResultOrderEo::getDocumentNo, Collectors.toSet())));
        Set out = longCodeMap.get("out");
        if (CollectionUtil.isNotEmpty(out)) {
            List outList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", out)).list();
            map.put("out", outList);
        }
        if (CollectionUtil.isNotEmpty(in = longCodeMap.get("in"))) {
            List inList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", in)).list();
            map.put("in", inList);
        }
        return map;
    }
}

