/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FormOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.LockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseFutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseIntransitDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseLockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.UpdatePreemptBatchDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.calc.IFormInAble;
import com.yunxi.dg.base.center.inventory.service.calc.IFormOutAble;
import com.yunxi.dg.base.center.inventory.service.calc.IFutureInAble;
import com.yunxi.dg.base.center.inventory.service.calc.ILockAble;
import com.yunxi.dg.base.center.inventory.service.calc.IPreemptAble;
import com.yunxi.dg.base.center.inventory.service.calc.IReleaseFutureInAble;
import com.yunxi.dg.base.center.inventory.service.calc.IReleaseIntransitAble;
import com.yunxi.dg.base.center.inventory.service.calc.IReleaseLockAble;
import com.yunxi.dg.base.center.inventory.service.calc.IReleasePreemptAble;
import com.yunxi.dg.base.center.inventory.service.calc.ISyncAble;
import com.yunxi.dg.base.center.inventory.service.calc.ITransferInAble;
import com.yunxi.dg.base.center.inventory.service.calc.ITransferOutAble;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CalcInventoryServiceImpl
implements ICalcInventoryService {
    private static final Logger log = LoggerFactory.getLogger(CalcInventoryServiceImpl.class);
    @Autowired
    IFormInAble formInAble;
    @Autowired
    IFormOutAble formOutAble;
    @Autowired
    IFutureInAble futureInAble;
    @Autowired
    IReleaseFutureInAble releaseFutureInAble;
    @Autowired
    ILockAble lockAble;
    @Autowired
    IPreemptAble preemptAble;
    @Autowired
    IReleaseLockAble releaseLockAble;
    @Autowired
    IReleasePreemptAble releasePreemptAble;
    @Autowired
    ITransferInAble transferInAble;
    @Autowired
    ITransferOutAble transferOutAble;
    @Autowired
    ISyncAble syncAble;
    @Autowired
    IReleaseIntransitAble releaseIntransitAble;

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void formIn(FormInDto dto) {
        this.formInAble.formIn(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void updatePreemptBatch(UpdatePreemptBatchDto dto) {
        if (CollectionUtils.isNotEmpty((Collection)dto.getReleasePreemptDtos())) {
            dto.getReleasePreemptDtos().forEach(this.releasePreemptAble::releasePreempt);
        }
        dto.getPreemptDtos().forEach(this.preemptAble::updatePreempt);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void formOut(FormOutDto dto) {
        this.formOutAble.formOut(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void futureIn(FutureInDto dto) {
        this.futureInAble.futureIn(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void releaseFutureIn(ReleaseFutureInDto dto) {
        this.releaseFutureInAble.releaseFutureIn(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void lock(LockDto dto) {
        this.lockAble.lock(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public List<InventoryUsageRecordEo> preempt(PreemptDto dto) {
        return this.preemptAble.preempt(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public List<InventoryUsageRecordEo> updatePreempt(PreemptDto dto) {
        return this.preemptAble.updatePreempt(dto);
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public List<InventoryUsageRecordEo> batchPreempt(List<PreemptDto> dtoList) {
        return this.preemptAble.batchPreempt(dtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void releaseLock(ReleaseLockDto dto) {
        this.releaseLockAble.releaseLock(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void releasePreempt(ReleasePreemptDto dto) {
        dto.setValidNegative(Boolean.valueOf(false));
        this.releasePreemptAble.releasePreempt(dto);
    }

    @Override
    public void releaseInransit(ReleaseIntransitDto dto) {
        this.releaseIntransitAble.releaseIntransit(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void transferIn(TransferInDto dto) {
        this.transferInAble.transferIn(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void transferOut(TransferOutDto dto) {
        this.transferOutAble.transferOut(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void syncInventory(List<LogicInventoryDto> inventoryEoList) {
        if (inventoryEoList.size() == 1) {
            LogicInventoryDto dto = inventoryEoList.get(0);
            InventoryConfig.lock(() -> {
                this.syncAble.sync(inventoryEoList);
                return new LogicInventoryDto();
            }, String.join((CharSequence)InventoryConfig.getCommonSeparate(), dto.getWarehouseCode(), dto.getSkuCode(), dto.getBatch(), dto.getInventoryProperty()), "syncInventory");
            return;
        }
        this.syncAble.sync(inventoryEoList);
    }
}

