/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FormOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IFormOutAble;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FormOutAbleImpl
extends BaseAble
implements IFormOutAble {
    private static final Logger log = LoggerFactory.getLogger(FormOutAbleImpl.class);
    @Value(value="${inventory.order.out.valid.inventory:true}")
    private boolean outValidInventory;

    @Override
    public void formOut(FormOutDto dto) {
        log.info("warehouse inventory formOut(\u5355\u636e\u51fa\u5e93), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        if (null == dto.getIsSaleOrder()) {
            dto.setIsSaleOrder(Boolean.FALSE);
        }
        List details = dto.getDetails();
        List inventoryUsageRecordEos = this.inventoryPreemptionDomain.queryBySourceNo(dto.getSourceNo());
        if (CollectionUtil.isEmpty((Collection)inventoryUsageRecordEos) && !dto.getIgnorePreempt().booleanValue()) {
            throw new BizException(StrUtil.format((CharSequence)"\u8be5\u5355\u636e[%s]\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55", (Object[])new Object[]{dto.getSourceNo()}));
        }
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        List<ItemSkuDto> skuDtos = this.checkSku(details);
        if (InventoryConfig.isPreemptHiddenBatch() && dto.getDetails().stream().anyMatch(r -> "99999999-hidden".equals(r.getBatch()))) {
            List noMatchDetails = dto.getDetails().stream().filter(r -> !"99999999-hidden".equals(r.getBatch())).collect(Collectors.toList());
            dto.setDetails(dto.getDetails().stream().filter(r -> "99999999-hidden".equals(r.getBatch())).collect(Collectors.toList()));
            this.shoutLogicInventoryEosByOut(dto, logicWarehouseEos, skuDtos, new ArrayList<LogicInventoryEo>());
            dto.getDetails().addAll(noMatchDetails);
        }
        dto.getDetails().stream().filter(r -> !r.isNeedFindBatch()).forEach(r -> r.setBatch(InventoryConfig.getDefaultBatch()));
        ArrayList<CalcDetailDto> releaseDetails = dto.getIgnorePreempt() != false ? new ArrayList(10) : this.updatePreempt(details, inventoryUsageRecordEos);
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto, releaseDetails);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private CalcInventoryDto createLogicCalcDto(FormOutDto dto, List<CalcDetailDto> releaseDetails) {
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto, (CalcDetailDto source, CalcInventoryDetailDto target) -> {
            target.setValidNegative(dto.getValidNegative());
            target.setOperate(dto.getDesc() + "-\u51fa\u5e93");
            target.setChangeBalance(BigDecimalUtils.negate((BigDecimal)source.getNum()));
            target.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)source.getNum()));
        });
        for (CalcDetailDto releaseDetail : releaseDetails) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc() + "-\u91ca\u653e\u9884\u5360");
            detailDto.setChangePreempt(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
            if (dto.getIsSaleOrder().booleanValue()) {
                detailDto.setChangeAllocate(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
            }
            detailDto.setChangeAvailable(releaseDetail.getNum());
            detailDto.setWarehouseCode(releaseDetail.getLogicWarehouseCode());
            detailDto.setSkuCode(releaseDetail.getSkuCode());
            FormOutAbleImpl.settingBatch(detailDto, releaseDetail);
            detailDto.setValidNegative(Boolean.valueOf(this.outValidInventory));
            detailDto.setInventoryProperty(releaseDetail.getInventoryProperty());
            detailDto.setPreemptId(releaseDetail.getPreemptId());
            detailDto.setBeforePreemptNum(releaseDetail.getBeforePreemptNum());
            detailDto.setAfterPreemptNum(releaseDetail.getAfterPreemptNum());
            logicCalcDto.getDetails().add(detailDto);
        }
        return logicCalcDto;
    }
}

