/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseFutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IReleaseFutureInAble;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReleaseFutureInAbleImpl
extends BaseAble
implements IReleaseFutureInAble {
    private static final Logger log = LoggerFactory.getLogger(ReleaseFutureInAbleImpl.class);

    @Override
    public void releaseFutureIn(ReleaseFutureInDto dto) {
        log.info("warehouse inventory futureIn(\u91ca\u653e\u5f85\u6536), param:{}", (Object)JSON.toJSONString((Object)dto));
        dto.setNoneBatch(Boolean.valueOf(true));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        dto.setValidNegative(Boolean.valueOf(false));
        List details = dto.getDetails();
        List<String> logicWarehouseCodes = details.stream().map(CalcDetailDto::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        List<String> skuCodes = details.stream().map(CalcDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(logicWarehouseCodes);
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(skuCodes);
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto, (source, target) -> {
            target.setValidNegative(dto.getValidNegative());
            target.setOperate(dto.getDesc());
            target.setChangeFutureIn(BigDecimalUtils.negate((BigDecimal)source.getNum()));
            target.setBatch((String)DataExtractUtils.ifNullElse((Object)target.getBatch(), (Object)InventoryConfig.getDefaultBatch()));
        });
        this.inventoryDueInDomain.insertBatch(this.transferDueIn(details, dto.getSourceNo()));
        CalcInventoryDto logicTotalCalcDto = this.createLogicTotalCalcDto(dto);
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(true).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    public CalcInventoryDto createLogicTotalCalcDto(ReleaseFutureInDto dto) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setRemark(dto.getDesc());
        ArrayList details = Lists.newArrayList();
        for (CalcDetailDto pd : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc());
            detailDto.setChangeFutureIn(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setValidNegative(dto.getValidNegative());
            detailDto.setInventoryProperty(pd.getInventoryProperty());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }
}

