/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseLockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IReleaseLockAble;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReleaseLockAbleImpl
extends BaseAble
implements IReleaseLockAble {
    private static final Logger log = LoggerFactory.getLogger(ReleaseLockAbleImpl.class);

    @Override
    public void releaseLock(ReleaseLockDto dto) {
        List inventoryUsageRecordEos;
        log.info("warehouse inventory releaseLock(\u91ca\u653e\u9501\u5b9a), param:{}", (Object)JSON.toJSONString((Object)dto));
        dto.setValidNegative(Boolean.valueOf(false));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        this.check((CalcDto)dto);
        dto.setAllRelease((Boolean)ObjectUtil.defaultIfNull((Object)dto.getAllRelease(), (Object)true));
        if (!dto.getAllRelease().booleanValue()) {
            this.checkDetails((CalcDto)dto);
        }
        if (CollectionUtil.isEmpty((Collection)(inventoryUsageRecordEos = this.inventoryPreemptionDomain.queryBySourceNos((List)Lists.newArrayList((Object[])dto.getSourceNo().split(",")))))) {
            throw new BizException(StrUtil.format((CharSequence)"\u8be5\u5355\u636e[%s]\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55", (Object[])new Object[]{dto.getSourceNo()}));
        }
        dto.setExternalOrderNo(((InventoryUsageRecordEo)inventoryUsageRecordEos.get(0)).getExternalOrderNo());
        this.releasePreemptAndSetDetail(dto, inventoryUsageRecordEos);
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(dto.getDetails());
        this.checkSku(dto.getDetails());
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private CalcInventoryDto createLogicCalcDto(ReleaseLockDto dto) {
        return this.createLogicCalcDto(dto, (source, target) -> {
            target.setChangeAvailable(source.getNum());
            target.setChangeLockInventory(BigDecimalUtils.negate((BigDecimal)source.getNum()));
        });
    }
}

