/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.data.DataDictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.InspectionResultEnum;
import com.yunxi.dg.base.center.inventory.constants.TagTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.InventoryBatchConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IDgInspectionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryBatchDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelInventoryBatchTagDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.RelInventoryBatchTagDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.InspectionRecordDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryBatchEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.RelInventoryBatchTagEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BatchUpdateEvent;
import com.yunxi.dg.base.center.inventory.service.entity.IInventoryBatchService;
import com.yunxi.dg.base.center.inventory.service.entity.enums.TagGroupEnum;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InventoryBatchServiceImpl
extends BaseServiceImpl<InventoryBatchDto, InventoryBatchEo, IInventoryBatchDomain>
implements IInventoryBatchService {
    private static final Logger log = LoggerFactory.getLogger(InventoryBatchServiceImpl.class);
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private IDgInspectionRecordDomain iDgInspectionRecordDomain;
    @Resource
    private IRelInventoryBatchTagDomain relInventoryBatchTagDomain;
    @Resource
    private IPcpDictQueryApiProxy pcpDictQueryApiProxy;

    public InventoryBatchServiceImpl(IInventoryBatchDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryBatchDto, InventoryBatchEo> converter() {
        return InventoryBatchConverter.INSTANCE;
    }

    @Override
    public void updatePass(List<ReceiveDeliveryResultOrderDetailEo> receiveDeliveryResultOrderDetailEoList) {
        List<InventoryBatchReqDto> inventoryBatchReqDtos = receiveDeliveryResultOrderDetailEoList.stream().map(e -> {
            InventoryBatchReqDto inventoryBatchReqDto = new InventoryBatchReqDto();
            inventoryBatchReqDto.setBatch(e.getBatch());
            inventoryBatchReqDto.setSkuCode(e.getSkuCode());
            inventoryBatchReqDto.setInspectionResult(InspectionResultEnum.ELIGIBLE.getKey());
            inventoryBatchReqDto.setInspectionTime(new Date());
            return inventoryBatchReqDto;
        }).collect(Collectors.toList());
        this.save(inventoryBatchReqDtos, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void save(List<InventoryBatchReqDto> dto, Boolean isUpdate) {
        List dataDictDtoList = Optional.ofNullable(this.pcpDictQueryApiProxy.generalBasicDataInfo(Arrays.asList("special_batch"))).orElse(new ArrayList());
        Set<String> specialBatchSet = dataDictDtoList.stream().map(DataDictDto::getSubValue).collect(Collectors.toSet());
        ArrayList<InventoryBatchEo> inventoryBatchEos = new ArrayList<InventoryBatchEo>();
        Map batchReqDtoMap = dto.stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), ((String)DataExtractUtils.ifNullElse((Object)o.getBatch(), (Object)"")).toUpperCase()), Function.identity(), (k1, k2) -> k1));
        List<String> skuCodeList = dto.stream().map(InventoryBatchReqDto::getSkuCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuCodeList)) {
            return;
        }
        HashMap<String, ItemSkuDto> itemDgDtoMap = new HashMap();
        try {
            itemDgDtoMap = Optional.ofNullable(this.itemDataQueryHelper.getByCodes(skuCodeList)).orElse(Arrays.asList(new ItemSkuDto[0])).stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getSkuCode())).collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (v1, v2) -> v1));
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u4e2d\u5fc3queryBySkuCode\u63a5\u53e3\u62a5\u9519\uff1a", (Throwable)e);
        }
        log.info("\u5546\u54c1\u4e2d\u5fc3\u8fd4\u56de\u7684\u5546\u54c1\u6570\u636e:{}", (Object)JSONObject.toJSONString(itemDgDtoMap));
        Map skuCodeBatchMap = ((ExtQueryChainWrapper)((IInventoryBatchDomain)this.domain).filter().in((Object)"sku_code", skuCodeList)).list().stream().collect(Collectors.toMap(r -> this.getKey(r.getSkuCode(), r.getBatch()), Function.identity(), (v1, v2) -> v1));
        ArrayList<InventoryBatchEo> updateInventoryBatchEos = new ArrayList<InventoryBatchEo>();
        for (InventoryBatchReqDto r2 : batchReqDtoMap.values()) {
            InventoryBatchEo inventoryBatchEo = new InventoryBatchEo();
            BeanUtil.copyProperties((Object)r2, (Object)inventoryBatchEo, (String[])new String[0]);
            this.processParameter(itemDgDtoMap, r2, inventoryBatchEo);
            String key = this.getKey(r2.getSkuCode(), r2.getBatch());
            if (skuCodeBatchMap.containsKey(key)) {
                inventoryBatchEo.setId(((InventoryBatchEo)skuCodeBatchMap.get(key)).getId());
                inventoryBatchEo.setProduceTime(r2.getProduceTime());
                try {
                    this.checkSetExpireTime(specialBatchSet, itemDgDtoMap, r2, inventoryBatchEo);
                }
                catch (Throwable e) {
                    log.info("\u6ca1\u67e5\u5230sku\u4fe1\u606f\uff0c\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a");
                }
                if (!isUpdate.booleanValue()) continue;
                ((IInventoryBatchDomain)this.domain).updateSelective((BaseEo)inventoryBatchEo);
                updateInventoryBatchEos.add(inventoryBatchEo);
                continue;
            }
            try {
                this.checkSetExpireTime(specialBatchSet, itemDgDtoMap, r2, inventoryBatchEo);
            }
            catch (Throwable e) {
                log.info("\u6ca1\u67e5\u5230sku\u4fe1\u606f\uff0c\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a");
            }
            inventoryBatchEo.setId(null);
            inventoryBatchEo.setProduceTime((Date)DataExtractUtils.ifNullElse((Object)inventoryBatchEo.getProduceTime(), (Object)new Date()));
            inventoryBatchEos.add(inventoryBatchEo);
        }
        if (CollectionUtil.isNotEmpty(inventoryBatchEos)) {
            ((IInventoryBatchDomain)this.domain).insertBatch(inventoryBatchEos);
        }
        updateInventoryBatchEos.addAll(inventoryBatchEos);
        MessageVo messageVo = new MessageVo();
        messageVo.setData(updateInventoryBatchEos);
        log.info("\u53d1\u9001\u6279\u6b21\u6863\u6848\u65b0\u589e\u66f4\u65b0\u6570\u636e,map:{}", (Object)LogUtils.buildLogContent((Object)messageVo));
        InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BatchUpdateEvent(updateInventoryBatchEos));
    }

    private void checkSetExpireTime(Set<String> specialBatchSet, Map<String, ItemSkuDto> itemDgDtoMap, InventoryBatchReqDto r, InventoryBatchEo inventoryBatchEo) {
        if (ObjectUtils.isEmpty((Object)r.getExpireTime()) && !specialBatchSet.contains(r.getBatch())) {
            Date date = this.calculateExpirationDate(r.getProduceTime(), itemDgDtoMap.get(r.getSkuCode()).getQuality(), itemDgDtoMap.get(r.getSkuCode()).getQualityUnit());
            inventoryBatchEo.setExpireTime(date);
        } else {
            inventoryBatchEo.setExpireTime(r.getExpireTime());
        }
    }

    private void processParameter(Map<String, ItemSkuDto> itemDgDtoMap, InventoryBatchReqDto r, InventoryBatchEo inventoryBatchEo) {
        String supplierCode = ServiceContext.getContext().getAttachment("supplierCode");
        String supplierName = ServiceContext.getContext().getAttachment("supplierName");
        inventoryBatchEo.setSupplierCode(supplierCode);
        inventoryBatchEo.setSupplierName(supplierName);
        if (itemDgDtoMap.containsKey(r.getSkuCode())) {
            inventoryBatchEo.setSpuCode(itemDgDtoMap.get(r.getSkuCode()).getSpuCode());
            inventoryBatchEo.setSpuName(itemDgDtoMap.get(r.getSkuCode()).getSpuName());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        if (ObjectUtil.isNotEmpty((Object)r.getProduceTime())) {
            String format = simpleDateFormat.format(r.getProduceTime());
            r.setProduceTime(DateUtil.parseDate((String)format, (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    @Override
    public PageInfo<InventoryBatchDto> queryPage(InventoryBatchReqDto dto) {
        List skuCodeList;
        ArrayList tagCodes = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getExpiryDateTagList())) {
            tagCodes.addAll(dto.getExpiryDateTagList());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getSkuCode()) && CollectionUtil.isNotEmpty(skuCodeList = Arrays.stream(dto.getSkuCode().split("[,\\s]+")).collect(Collectors.toList())) && skuCodeList.size() > 1) {
            dto.setSkuCode(null);
            dto.setSkuCodeList(skuCodeList);
        }
        List<Object> idList = new ArrayList();
        if (CollectionUtil.isNotEmpty(tagCodes)) {
            idList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relInventoryBatchTagDomain.filter().in((Object)"tag_code", tagCodes)).lt((Object)"effective_time", (Object)new Date())).gt((Object)"failure_time", (Object)new Date())).list().stream().map(RelInventoryBatchTagEo::getInventoryBatchId).collect(Collectors.toList());
        }
        PageInfo inventoryBatchEoPage = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInventoryBatchDomain)this.domain).filter().like(StringUtils.isNotBlank((CharSequence)dto.getSkuCode()), (Object)"sku_code", (Object)dto.getSkuCode())).like(StringUtils.isNotBlank((CharSequence)dto.getSkuName()), (Object)"sku_name", (Object)dto.getSkuName())).in(CollectionUtil.isNotEmpty((Collection)dto.getSkuCodeList()), (Object)"sku_code", (Collection)dto.getSkuCodeList())).eq(StringUtils.isNotBlank((CharSequence)dto.getBatch()), (Object)"batch", (Object)dto.getBatch())).eq(StringUtils.isNotBlank((CharSequence)dto.getInspectionResult()), (Object)"inspection_result", (Object)dto.getInspectionResult())).in(CollectionUtil.isNotEmpty((Collection)dto.getBatchList()), (Object)"batch", (Collection)dto.getBatchList())).eq(StringUtils.isNotBlank((CharSequence)dto.getInventoryBatch()), (Object)"inventory_batch", (Object)dto.getInventoryBatch())).in(CollectionUtil.isNotEmpty((Collection)dto.getSpuCodeList()), (Object)"spu_code", (Collection)dto.getSpuCodeList())).in(CollectionUtil.isNotEmpty((Collection)dto.getSupplierCodeList()), (Object)"supplier_code", (Collection)dto.getSupplierCodeList())).ge(ObjectUtils.isNotEmpty((Object)dto.getCreateTimeStart()), (Object)"create_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCreateTimeStart()))).le(ObjectUtils.isNotEmpty((Object)dto.getCreateTimeEnd()), (Object)"create_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCreateTimeEnd()).replace("00:00:00", "23:59:59"))).ge(ObjectUtils.isNotEmpty((Object)dto.getCheckTimeStart()), (Object)"inspection_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCheckTimeStart()))).le(ObjectUtils.isNotEmpty((Object)dto.getCheckTimeEnd()), (Object)"inspection_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCheckTimeEnd()).replace("00:00:00", "23:59:59"))).ge(ObjectUtils.isNotEmpty((Object)dto.getUpdateTimeStart()), (Object)"update_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getUpdateTimeStart()))).le(ObjectUtils.isNotEmpty((Object)dto.getUpdateTimeEnd()), (Object)"update_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getUpdateTimeEnd()).replace("00:00:00", "23:59:59"))).eq(StringUtils.isNotBlank((CharSequence)dto.getUpdatePerson()), (Object)"update_person", (Object)dto.getUpdatePerson())).eq(StringUtils.isNotBlank((CharSequence)dto.getCreatePerson()), (Object)"create_person", (Object)dto.getCreatePerson())).in(CollectionUtil.isNotEmpty((Collection)dto.getUpdatePersonList()), (Object)"update_person", (Collection)dto.getUpdatePersonList())).in(CollectionUtil.isNotEmpty((Collection)dto.getCreatePersonList()), (Object)"create_person", (Collection)dto.getCreatePersonList())).ne((Object)"batch", (Object)"99999999-hidden")).in(CollectionUtil.isNotEmpty(idList), (Object)"id", idList)).orderByDesc((Object)"id")).page(dto.getPageNum(), dto.getPageSize());
        PageInfo inventoryBatchDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)inventoryBatchDtoPageInfo, (Object)inventoryBatchEoPage, (String[])new String[]{"list", "navigatepageNums"});
        Map<String, List<RelInventoryBatchTagDto>> map = this.getRelInventoryBatchTagMap(inventoryBatchEoPage.getList());
        List inventoryBatchDtoList = inventoryBatchEoPage.getList().stream().map(r -> this.getInventoryBatchDto(map, (InventoryBatchEo)r)).collect(Collectors.toList());
        inventoryBatchDtoPageInfo.setList(inventoryBatchDtoList);
        return inventoryBatchDtoPageInfo;
    }

    @NotNull
    private InventoryBatchDto getInventoryBatchDto(Map<String, List<RelInventoryBatchTagDto>> map, InventoryBatchEo r) {
        InventoryBatchDto inventoryBatchDto = new InventoryBatchDto();
        CubeBeanUtils.copyProperties((Object)inventoryBatchDto, (Object)r, (String[])new String[0]);
        List<RelInventoryBatchTagDto> expiryDateTagList = map.get(this.getTagKey(r.getId(), TagGroupEnum.EXPIRY_DATE.getCode()));
        List<RelInventoryBatchTagDto> qualityInspectionTagList = map.get(this.getTagKey(r.getId(), TagTypeEnum.QUALITY_INSPECTION_TAG.getCode()));
        inventoryBatchDto.setExpiryDateTagList(expiryDateTagList);
        inventoryBatchDto.setQualityInspectionTagList(qualityInspectionTagList);
        return inventoryBatchDto;
    }

    @NotNull
    private Map<String, List<RelInventoryBatchTagDto>> getRelInventoryBatchTagMap(List<InventoryBatchEo> inventoryBatchEos) {
        List newIds = inventoryBatchEos.stream().map(e -> e.getId()).collect(Collectors.toList());
        List tagEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relInventoryBatchTagDomain.filter().in(newIds.size() > 0, (Object)"inventory_batch_id", newIds)).lt((Object)"effective_time", (Object)new Date())).ge((Object)"failure_time", (Object)new Date())).list();
        HashMap<String, List<RelInventoryBatchTagDto>> map = new HashMap<String, List<RelInventoryBatchTagDto>>();
        if (CollectionUtil.isNotEmpty((Collection)tagEos)) {
            for (RelInventoryBatchTagEo relInventoryBatchTagEo : tagEos) {
                String key = this.getTagKey(relInventoryBatchTagEo.getInventoryBatchId(), relInventoryBatchTagEo.getTagType());
                ArrayList<RelInventoryBatchTagDto> tagDtos = (ArrayList<RelInventoryBatchTagDto>)map.get(key);
                if (CollectionUtil.isEmpty((Collection)tagDtos)) {
                    tagDtos = new ArrayList<RelInventoryBatchTagDto>();
                }
                RelInventoryBatchTagDto relInventoryBatchTagDto = new RelInventoryBatchTagDto();
                CubeBeanUtils.copyProperties((Object)relInventoryBatchTagDto, (Object)relInventoryBatchTagEo, (String[])new String[0]);
                tagDtos.add(relInventoryBatchTagDto);
                map.put(key, tagDtos);
            }
        }
        return map;
    }

    @NotNull
    private String getTagKey(Long inventoryBatchId, String tagType) {
        return inventoryBatchId + " " + tagType;
    }

    @NotNull
    private List<Long> getTagInventoryBatchIds(InventoryBatchReqDto dto) {
        List tagEos;
        ArrayList tagCodes = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getExpiryDateTagList())) {
            tagCodes.addAll(dto.getExpiryDateTagList());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getQualityInspectionTagList())) {
            tagCodes.addAll(dto.getQualityInspectionTagList());
        }
        List<Long> ids = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty(tagCodes) && CollectionUtils.isNotEmpty((Collection)(tagEos = ((ExtQueryChainWrapper)this.relInventoryBatchTagDomain.filter().in((Object)"tag_code", tagCodes)).list()))) {
            ids = tagEos.stream().map(RelInventoryBatchTagEo::getInventoryBatchId).distinct().collect(Collectors.toList());
        }
        return ids;
    }

    @Override
    public List<InventoryBatchDto> queryList(InventoryBatchReqDto dto) {
        List<Long> ids = this.getTagInventoryBatchIds(dto);
        ArrayList tagCodes = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getExpiryDateTagList())) {
            tagCodes.addAll(dto.getExpiryDateTagList());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getQualityInspectionTagList())) {
            tagCodes.addAll(dto.getQualityInspectionTagList());
        }
        List inventoryBatchEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInventoryBatchDomain)this.domain).filter().like(StringUtils.isNotBlank((CharSequence)dto.getSkuCode()), (Object)"sku_code", (Object)dto.getSkuCode())).like(StringUtils.isNotBlank((CharSequence)dto.getSkuName()), (Object)"sku_name", (Object)dto.getSkuName())).in(CollectionUtil.isNotEmpty((Collection)dto.getSkuCodeList()), (Object)"sku_code", (Collection)dto.getSkuCodeList())).eq(StringUtils.isNotBlank((CharSequence)dto.getBatch()), (Object)"batch", (Object)dto.getBatch())).in(CollectionUtil.isNotEmpty((Collection)dto.getSupplierCodeList()), (Object)"supplier_code", (Collection)dto.getSupplierCodeList())).eq(StringUtils.isNotBlank((CharSequence)dto.getInventoryBatch()), (Object)"inventory_batch", (Object)dto.getInventoryBatch())).ge(ObjectUtils.isNotEmpty((Object)dto.getCreateTimeStart()), (Object)"create_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCreateTimeStart()))).le(ObjectUtils.isNotEmpty((Object)dto.getCreateTimeEnd()), (Object)"create_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCreateTimeEnd()).replace("00:00:00", "23:59:59"))).ge(ObjectUtils.isNotEmpty((Object)dto.getCheckTimeStart()), (Object)"inspection_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCheckTimeStart()))).le(ObjectUtils.isNotEmpty((Object)dto.getCheckTimeEnd()), (Object)"inspection_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCheckTimeEnd()).replace("00:00:00", "23:59:59"))).ge(ObjectUtils.isNotEmpty((Object)dto.getUpdateTimeStart()), (Object)"update_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getUpdateTimeStart()))).le(ObjectUtils.isNotEmpty((Object)dto.getUpdateTimeEnd()), (Object)"update_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getUpdateTimeEnd()).replace("00:00:00", "23:59:59"))).eq(StringUtils.isNotBlank((CharSequence)dto.getUpdatePerson()), (Object)"update_person", (Object)dto.getUpdatePerson())).eq(StringUtils.isNotBlank((CharSequence)dto.getCreatePerson()), (Object)"create_person", (Object)dto.getCreatePerson())).ne((Object)"batch", (Object)"99999999-hidden")).last(CollectionUtil.isNotEmpty(tagCodes), String.format(" AND id in ( select inventory_batch_id from in_rel_inventory_batch_tag where tag_code in (%s))", "\"" + String.join((CharSequence)"\",\"", tagCodes) + "\""))).in(CollectionUtil.isNotEmpty(ids), (Object)"id", ids)).list();
        Map<String, List<RelInventoryBatchTagDto>> map = this.getRelInventoryBatchTagMap(inventoryBatchEos);
        ArrayList<InventoryBatchDto> inventoryBatchDtoList = new ArrayList<InventoryBatchDto>(inventoryBatchEos.stream().map(r -> this.getInventoryBatchDto(map, (InventoryBatchEo)r)).collect(Collectors.toMap(InventoryBatchDto::getBatch, Function.identity(), (o, o1) -> o)).values());
        return inventoryBatchDtoList;
    }

    @Override
    public InventoryBatchDto queryDetail(InventoryBatchReqDto dto) {
        InventoryBatchEo inventoryBatchEo = (InventoryBatchEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInventoryBatchDomain)this.domain).filter().like(StringUtils.isNotBlank((CharSequence)dto.getSkuCode()), (Object)"sku_code", (Object)dto.getSkuCode())).like(StringUtils.isNotBlank((CharSequence)dto.getSkuName()), (Object)"sku_name", (Object)dto.getSkuName())).eq(StringUtils.isNotBlank((CharSequence)dto.getBatch()), (Object)"batch", (Object)dto.getBatch())).one();
        Map<String, List<RelInventoryBatchTagDto>> map = this.getRelInventoryBatchTagMap(Arrays.asList(inventoryBatchEo));
        InventoryBatchDto inventoryBatchDto = this.getInventoryBatchDto(map, inventoryBatchEo);
        List inspectionRecordEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgInspectionRecordDomain.filter().like(StringUtils.isNotBlank((CharSequence)dto.getSkuCode()), (Object)"sku_code", (Object)dto.getSkuCode())).like(StringUtils.isNotBlank((CharSequence)dto.getSkuName()), (Object)"sku_name", (Object)dto.getSkuName())).eq(StringUtils.isNotBlank((CharSequence)dto.getBatch()), (Object)"batch", (Object)dto.getBatch())).list(Integer.valueOf(1000));
        List inspectionRecordList = BeanUtil.copyToList((Collection)inspectionRecordEoList, InspectionRecordDto.class);
        inventoryBatchDto.setInspectionRecordDtoList(inspectionRecordList);
        return inventoryBatchDto;
    }

    @NotNull
    private String getKey(String skuCode, String batch) {
        return skuCode + ((String)DataExtractUtils.ifNullElse((Object)batch, (Object)"")).toUpperCase();
    }

    private Date calculateExpirationDate(Date productionDate, int shelfLifeInDays, String dataType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(productionDate);
        if ("DAY".equals(dataType) || "d".equals(dataType)) {
            calendar.add(6, shelfLifeInDays);
        } else if ("MONTH".equals(dataType) || "m".equals(dataType)) {
            calendar.add(2, shelfLifeInDays);
        } else if ("YEAR".equals(dataType) || "y".equals(dataType)) {
            calendar.add(1, shelfLifeInDays);
        }
        Date expirationDate = calendar.getTime();
        return expirationDate;
    }
}

