/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.convert.entity.InventoryOperateLogConverter;
import com.yunxi.dg.base.center.inventory.dao.mapper.InventoryOperateLogMapper;
import com.yunxi.dg.base.center.inventory.dao.mapper.ReceiveDeliveryResultOrderMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryOperateLogDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryOperateLogDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryOperateLogVerifyDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryResultOrderDetailDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryOperateLogEo;
import com.yunxi.dg.base.center.inventory.service.entity.IInventoryOperateLogService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class InventoryOperateLogServiceImpl
extends BaseServiceImpl<InventoryOperateLogDto, InventoryOperateLogEo, IInventoryOperateLogDomain>
implements IInventoryOperateLogService {
    @Resource
    InventoryOperateLogMapper inventoryOperateLogMapper;
    @Resource
    ILogicInventoryDomain logicInventoryDomain;
    @Resource
    ReceiveDeliveryResultOrderMapper receiveDeliveryResultOrderMapper;

    public InventoryOperateLogServiceImpl(IInventoryOperateLogDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryOperateLogDto, InventoryOperateLogEo> converter() {
        return InventoryOperateLogConverter.INSTANCE;
    }

    @Override
    public RestResponse<Void> verifyLog(InventoryOperateLogVerifyDto dto) {
        List logicInventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().eq(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getWarehouseCode()}), (Object)"warehouse_code", (Object)dto.getWarehouseCode())).eq(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getSkuCode()}), (Object)"sku_code", (Object)dto.getSkuCode())).eq(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getInventoryProperty()}), (Object)"inventory_property", (Object)dto.getInventoryProperty())).list(Integer.valueOf(10000));
        logicInventoryEos.forEach(e -> {
            dto.setWarehouseCode(e.getWarehouseCode());
            dto.setSkuCode(e.getSkuCode());
            dto.setBatch(e.getBatch());
            dto.setInventoryProperty(e.getInventoryProperty());
            this.inventoryOperateLogMapper.verifyLog(dto);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> repairLog(InventoryOperateLogVerifyDto dto) {
        List inventoryOperateLogVerifyDtos = this.inventoryOperateLogMapper.loadErrorLine();
        LocalDate changeTimeStarter = LocalDate.parse(dto.getChangeTimeStarter());
        LocalDate changeTimeEnd = LocalDate.parse(dto.getChangeTimeEnd());
        long daysDifference = ChronoUnit.DAYS.between(changeTimeStarter, changeTimeEnd);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        inventoryOperateLogVerifyDtos.forEach(record -> {
            LocalDate currentDate = LocalDate.now();
            for (long i = 0L; i < daysDifference; ++i) {
                LocalDate startDate = changeTimeStarter.plusDays(i);
                LocalDate endDate = startDate.plusDays(1L);
                String formattedStartDate = startDate.format(formatter);
                String formattedEndDate = endDate.format(formatter);
                record.setChangeTimeStarter(formattedStartDate);
                record.setChangeTimeEnd(formattedEndDate);
                List receiveResultOrderDetailEos = this.receiveDeliveryResultOrderMapper.loadOrderByVerifyLog(record);
                record.setOrderType("delivery");
                receiveResultOrderDetailEos.addAll(this.receiveDeliveryResultOrderMapper.loadOrderByVerifyLog(record));
                if (CollectionUtils.isEmpty((Collection)receiveResultOrderDetailEos)) continue;
                Map<String, List<ReceiveDeliveryResultOrderDetailDto>> orderMap = receiveResultOrderDetailEos.stream().collect(Collectors.groupingBy(ReceiveDeliveryResultOrderDetailDto::getRelevanceNo));
                List inventoryOperateLogEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInventoryOperateLogDomain)this.domain).filter().in((Object)"source_no", orderMap.keySet())).eq((Object)"sku_code", (Object)record.getSkuCode())).eq((Object)"warehouse_code", (Object)record.getWarehouseCode())).eq((Object)"batch", (Object)record.getBatch())).eq((Object)"inventory_property", (Object)record.getInventoryProperty())).list(Integer.valueOf(1000000));
                Map<String, List<InventoryOperateLogEo>> logMap = inventoryOperateLogEoList.stream().collect(Collectors.groupingBy(InventoryOperateLogEo::getSourceNo));
                orderMap.forEach((v, details) -> {
                    BigDecimal logNum;
                    List inventoryOperateLogEos = logMap.getOrDefault(v, new ArrayList());
                    BigDecimal targetNum = details.stream().map(ReceiveDeliveryResultOrderDetailDto::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal subtract = BigDecimalUtils.subtract((BigDecimal)targetNum, (BigDecimal)(logNum = inventoryOperateLogEos.stream().map(InventoryOperateLogEo::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    if (BigDecimalUtils.eqZero((BigDecimal)subtract).booleanValue()) {
                        return;
                    }
                    ReceiveDeliveryResultOrderDetailDto receiveDeliveryResultOrderDetailDto = (ReceiveDeliveryResultOrderDetailDto)details.get(0);
                    boolean inOut = Objects.equals("delivery", receiveDeliveryResultOrderDetailDto.getOrderType());
                    InventoryOperateLogEo logEo = Optional.ofNullable(inventoryOperateLogEos).filter(CollectionUtils::isNotEmpty).map(r -> {
                        InventoryOperateLogEo inventoryOperateLogEo = (InventoryOperateLogEo)BeanUtil.toBean(r.get(0), InventoryOperateLogEo.class);
                        inventoryOperateLogEo.setChangeInventory(subtract);
                        return inventoryOperateLogEo;
                    }).orElseGet(() -> {
                        InventoryOperateLogEo inventoryOperateLogEo = new InventoryOperateLogEo();
                        inventoryOperateLogEo.setChangeInventory(subtract);
                        inventoryOperateLogEo.setChangeType("balance");
                        inventoryOperateLogEo.setWarehouseCode(inOut ? receiveDeliveryResultOrderDetailDto.getDeliveryLogicWarehouseCode() : receiveDeliveryResultOrderDetailDto.getReceiveLogicWarehouseCode());
                        inventoryOperateLogEo.setInventoryProperty(receiveDeliveryResultOrderDetailDto.getInventoryProperty());
                        inventoryOperateLogEo.setSkuCode(receiveDeliveryResultOrderDetailDto.getSkuCode());
                        inventoryOperateLogEo.setSkuName(receiveDeliveryResultOrderDetailDto.getSkuName());
                        inventoryOperateLogEo.setBatch(receiveDeliveryResultOrderDetailDto.getBatch());
                        inventoryOperateLogEo.setSourceType(receiveDeliveryResultOrderDetailDto.getBusinessType());
                        inventoryOperateLogEo.setBusinessType(receiveDeliveryResultOrderDetailDto.getDisplayBusinessType());
                        inventoryOperateLogEo.setSourceNo(receiveDeliveryResultOrderDetailDto.getRelevanceNo());
                        inventoryOperateLogEo.setExternalOrderNo(receiveDeliveryResultOrderDetailDto.getExternalOrderNo());
                        inventoryOperateLogEo.setChangeInventory(subtract);
                        inventoryOperateLogEo.setExtension(dto.getExtension());
                        return inventoryOperateLogEo;
                    });
                    logEo.setRemark("\u6570\u636e\u4fee\u590d-\u5373\u65f6");
                    logEo.setChangeTime(receiveDeliveryResultOrderDetailDto.getCreateTime());
                    logEo.setCreateTime(receiveDeliveryResultOrderDetailDto.getCreateTime());
                    logEo.setUpdateTime(receiveDeliveryResultOrderDetailDto.getCreateTime());
                });
            }
        });
        return RestResponse.VOID;
    }
}

