/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.ShippingMarkTypeEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.ShippingMarkManagementConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IShippingMarkManagementDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.ShippingMarkManagementDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ShippingMarkManagementPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.ShippingMarkManagementEo;
import com.yunxi.dg.base.center.inventory.service.entity.IShippingMarkManagementService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShippingMarkManagementServiceImpl
extends BaseServiceImpl<ShippingMarkManagementDto, ShippingMarkManagementEo, IShippingMarkManagementDomain>
implements IShippingMarkManagementService {
    private static final Logger log = LoggerFactory.getLogger(ShippingMarkManagementServiceImpl.class);

    public ShippingMarkManagementServiceImpl(IShippingMarkManagementDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ShippingMarkManagementDto, ShippingMarkManagementEo> converter() {
        return ShippingMarkManagementConverter.INSTANCE;
    }

    @Override
    public PageInfo<ShippingMarkManagementDto> page(ShippingMarkManagementPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IShippingMarkManagementDomain)this.domain).list(dto));
    }

    @Override
    public List<ShippingMarkManagementDto> list(ShippingMarkManagementPageReqDto dto) {
        return ((IShippingMarkManagementDomain)this.domain).list(dto);
    }

    @Override
    public Long add(ShippingMarkManagementDto dto) {
        log.info("\u65b0\u589e\u551b\u5934\u7ba1\u7406:{}", (Object)dto);
        this.validParams(dto);
        ShippingMarkManagementEo insertEo = new ShippingMarkManagementEo();
        BeanUtil.copyProperties((Object)dto, (Object)insertEo, (String[])new String[0]);
        insertEo.setId(null);
        ((IShippingMarkManagementDomain)this.domain).insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public RestResponse modify(ShippingMarkManagementDto dto) {
        log.info("\u7f16\u8f91\u551b\u5934\u7ba1\u7406:{}", (Object)dto);
        this.modifyValidParams(dto);
        AssertUtils.isTrue((null != dto.getId() ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ShippingMarkManagementEo updateEo = new ShippingMarkManagementEo();
        BeanUtil.copyProperties((Object)dto, (Object)updateEo, (String[])new String[0]);
        ((IShippingMarkManagementDomain)this.domain).update((BaseEo)updateEo);
        return RestResponse.VOID;
    }

    private void validParams(ShippingMarkManagementDto dto) {
        AssertUtils.isTrue((dto != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((dto.getType() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (dto.getType().equals(ShippingMarkTypeEnum.CUSTOMER.getCode())) {
            AssertUtils.isTrue((dto.getCustomerCode() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getCustomerName() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getRepackagingRequest() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u6539\u5305\u88c5\u8981\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
            ShippingMarkManagementEo shippingMarkManagementEo = (ShippingMarkManagementEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IShippingMarkManagementDomain)this.domain).filter().eq((Object)"type", (Object)dto.getType())).eq((Object)"customer_code", (Object)dto.getCustomerCode())).one();
            AssertUtils.isTrue((boolean)ObjectUtil.isNull((Object)shippingMarkManagementEo), (String)"\u8be5\u5ba2\u6237\u4ee5\u7ef4\u62a4,\u8bf7\u68c0\u67e5");
        } else if (dto.getType().equals(ShippingMarkTypeEnum.ITEM.getCode())) {
            AssertUtils.isTrue((dto.getCustomerCode() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getCustomerName() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getSkuCode() != null ? 1 : 0) != 0, (String)"\u9009\u9879SKU\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getSkuName() != null ? 1 : 0) != 0, (String)"\u9009\u9879SKU\u4e0d\u80fd\u4e3a\u7a7a");
            ShippingMarkManagementEo shippingMarkManagementEo = (ShippingMarkManagementEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IShippingMarkManagementDomain)this.domain).filter().eq((Object)"type", (Object)dto.getType())).eq((Object)"customer_code", (Object)dto.getCustomerCode())).eq((Object)"sku_code", (Object)dto.getSkuCode())).one();
            AssertUtils.isTrue((boolean)ObjectUtil.isNull((Object)shippingMarkManagementEo), (String)"\u8be5SKU\u5df2\u7ef4\u62a4\uff0c\u8bf7\u68c0\u67e5");
        } else {
            throw new RuntimeException("\u4f20\u5165\u7684\u7c7b\u578b\u6709\u8bef!");
        }
    }

    private void modifyValidParams(ShippingMarkManagementDto dto) {
        AssertUtils.isTrue((dto != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((dto.getType() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (dto.getType().equals(ShippingMarkTypeEnum.CUSTOMER.getCode())) {
            AssertUtils.isTrue((dto.getCustomerCode() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getCustomerName() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getRepackagingRequest() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u6539\u5305\u88c5\u8981\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (dto.getType().equals(ShippingMarkTypeEnum.ITEM.getCode())) {
            AssertUtils.isTrue((dto.getCustomerCode() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getCustomerName() != null ? 1 : 0) != 0, (String)"\u9009\u9879\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getSkuCode() != null ? 1 : 0) != 0, (String)"\u9009\u9879SKU\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((dto.getSkuName() != null ? 1 : 0) != 0, (String)"\u9009\u9879SKU\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            throw new RuntimeException("\u4f20\u5165\u7684\u7c7b\u578b\u6709\u8bef!");
        }
    }
}

