/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.holdMerge.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsOutNoticePushStatusEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.HoldStrategyConfigConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IHoldStrategyConfigDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IHoldStrategyConfigDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IHoldStrategyLogDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.HoldMergeStrategyConfigEnumDto;
import com.yunxi.dg.base.center.inventory.dto.entity.HoldStrategyConfigDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.HoldStrategyConfigDto;
import com.yunxi.dg.base.center.inventory.dto.entity.HoldStrategyConfigPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.TimePair;
import com.yunxi.dg.base.center.inventory.eo.HoldStrategyConfigEo;
import com.yunxi.dg.base.center.inventory.eo.HoldStrategyLogEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderDocumentTypeEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.service.holdMerge.IHoldStrategyConfigDetailService;
import com.yunxi.dg.base.center.inventory.service.holdMerge.IHoldStrategyConfigService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HoldStrategyConfigServiceImpl
extends BaseServiceImpl<HoldStrategyConfigDto, HoldStrategyConfigEo, IHoldStrategyConfigDomain>
implements IHoldStrategyConfigService {
    @Resource
    private IHoldStrategyConfigDetailService holdStrategyConfigDetailService;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IBaseOrderAddressDomain baseOrderAddressDomain;
    @Resource
    private IHoldStrategyLogDomain holdStrategyLogDomain;
    @Resource
    private IHoldStrategyConfigDetailDomain iHoldStrategyConfigDetailDomain;
    @Resource
    GenerateCodeUtil generateCodeUtil;

    public HoldStrategyConfigServiceImpl(IHoldStrategyConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<HoldStrategyConfigDto, HoldStrategyConfigEo> converter() {
        return HoldStrategyConfigConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Long addHoldStrategyConfig(HoldStrategyConfigDto dto) {
        this.check(dto);
        dto.setStrategyCode(this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.HOLD_STRATEGY_CONFIG.getCode())));
        HoldStrategyConfigEo eo = (HoldStrategyConfigEo)this.converter().toEo((BaseDto)dto);
        ((IHoldStrategyConfigDomain)this.domain).insert((BaseEo)eo);
        dto.getHoldStrategyConfigDetailDtos().forEach(detaill -> {
            detaill.setStrategyId(eo.getId());
            detaill.setStrategyCode(dto.getStrategyCode());
        });
        this.holdStrategyConfigDetailService.insertBatch(dto.getHoldStrategyConfigDetailDtos());
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Long updateHoldStrategyConfig(HoldStrategyConfigDto dto) {
        this.check(dto);
        HoldStrategyConfigEo eo = (HoldStrategyConfigEo)this.converter().toEo((BaseDto)dto);
        ((IHoldStrategyConfigDomain)this.domain).update((BaseEo)eo);
        this.holdStrategyConfigDetailService.deleteHoldStrategyConfigDetailByStrategyId(eo.getId());
        dto.getHoldStrategyConfigDetailDtos().forEach(detail -> {
            detail.setStrategyId(eo.getId());
            detail.setStrategyCode(dto.getStrategyCode());
        });
        this.holdStrategyConfigDetailService.insertBatch(dto.getHoldStrategyConfigDetailDtos());
        return eo.getId();
    }

    @Override
    public Boolean intercept(String documentNo) {
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByDocumentNo(documentNo);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos), (String)(documentNo + "\u5355\u53f7\u4e0d\u5b58\u5728"));
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        return this.doIntercept(inOutNoticeOrderEo);
    }

    @Override
    public boolean doIntercept(InOutNoticeOrderEo inOutNoticeOrderEo) {
        if ("in".equals(inOutNoticeOrderEo.getOrderType()) || BaseOrderDocumentTypeEnum.MERGE.getCode().equalsIgnoreCase(inOutNoticeOrderEo.getDocumentType())) {
            return Boolean.FALSE;
        }
        HoldMergeStrategyConfigEnumDto holdMergeStrategyConfigEnumDto = new HoldMergeStrategyConfigEnumDto();
        holdMergeStrategyConfigEnumDto.setWarehouse(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        holdMergeStrategyConfigEnumDto.setBusinessType(inOutNoticeOrderEo.getDisplayBusinessType());
        holdMergeStrategyConfigEnumDto.setShopLimit(inOutNoticeOrderEo.getShopCode());
        holdMergeStrategyConfigEnumDto.setCustomerLimit("");
        ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).eq((Object)"contacts_type", (Object)"consignee")).last(" limit 1 ")).oneOpt().ifPresent(c -> holdMergeStrategyConfigEnumDto.setCustomerLimit(c.getCustomerCode()));
        List holdStrategyConfigEos = ((IHoldStrategyConfigDomain)this.domain).queryHoldStrategyConfigByStrategyConfig(holdMergeStrategyConfigEnumDto);
        if (CollectionUtils.isEmpty((Collection)holdStrategyConfigEos)) {
            return Boolean.FALSE;
        }
        long time = DateUtil.parseDate((String)DateUtil.getDateFormat((Date)inOutNoticeOrderEo.getCreateTime(), (String)"HH:mm:ss"), (String)"HH:mm:ss").getTime();
        for (HoldStrategyConfigEo holdStrategyConfigEo : holdStrategyConfigEos) {
            List timePairs = JSONArray.parseArray((String)holdStrategyConfigEo.getStrategyTimeConfig(), TimePair.class);
            for (TimePair timePair : timePairs) {
                if (timePair.getStart() > time || time >= timePair.getEnd()) continue;
                HoldStrategyLogEo holdStrategyLogEo = new HoldStrategyLogEo();
                holdStrategyLogEo.setStrategyId(holdStrategyConfigEo.getId());
                holdStrategyLogEo.setStrategyCode(holdStrategyConfigEo.getStrategyCode());
                holdStrategyLogEo.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
                this.holdStrategyLogDomain.insert((BaseEo)holdStrategyLogEo);
                inOutNoticeOrderEo.setPushStatus(CsOutNoticePushStatusEnum.WAITING.getCode());
                inOutNoticeOrderEo.setPushTime(new Date(inOutNoticeOrderEo.getCreateTime().getTime() + (timePair.getEnd() - time)));
                inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode());
                this.inOutNoticeOrderDomain.updateSelective((BaseEo)inOutNoticeOrderEo);
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void updateHoldStrategyConfigOrderStatus(List<Long> ids, String status) {
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)status), (String)"\u66f4\u65b0\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((null != ValidFlagEnum.getByCode((String)status) ? 1 : 0) != 0, (String)"\u7b56\u7565\u72b6\u6001\u503c\u4e0d\u7b26\u5408\u8981\u6c42");
        ((IHoldStrategyConfigDomain)this.domain).updateHoldStrategyConfigOrderStatus(ids, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void deleteHoldStrategyConfig(List<Long> ids) {
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(arg_0 -> ((IHoldStrategyConfigDomain)((IHoldStrategyConfigDomain)this.domain)).deleteById(arg_0));
    }

    @Override
    public HoldStrategyConfigDto queryId(Long id) {
        HoldStrategyConfigEo holdStrategyConfigEo = (HoldStrategyConfigEo)((IHoldStrategyConfigDomain)this.domain).getMapper().findById(id);
        AssertUtils.notEmpty((Object)holdStrategyConfigEo, (String)"\u67e5\u4e0d\u5230\u8be5id");
        List configDetailEoList = ((ExtQueryChainWrapper)this.iHoldStrategyConfigDetailDomain.filter().eq((Object)"strategy_code", (Object)holdStrategyConfigEo.getStrategyCode())).list();
        HoldStrategyConfigDto holdStrategyConfigDto = (HoldStrategyConfigDto)BeanUtil.copyProperties((Object)holdStrategyConfigEo, HoldStrategyConfigDto.class, (String[])new String[0]);
        List holdStrategyConfigDetailDtos = BeanUtil.copyToList((Collection)configDetailEoList, HoldStrategyConfigDetailDto.class);
        holdStrategyConfigDto.setHoldStrategyConfigDetailDtos(holdStrategyConfigDetailDtos);
        return holdStrategyConfigDto;
    }

    @Override
    public PageInfo<HoldStrategyConfigDto> queryPage(HoldStrategyConfigPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IHoldStrategyConfigDomain)this.domain).queryList(dto));
    }

    private void check(HoldStrategyConfigDto dto) {
        AssertUtil.isTrue((null != dto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getStrategyName()), (String)"\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getStrategyStatus()), (String)"\u7b56\u7565\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getStrategyConfig()), (String)"\u7b56\u7565\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getStrategyTimeConfig()), (String)"\u7b56\u7565\u914d\u7f6e\u65f6\u95f4\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((null != ValidFlagEnum.getByCode((String)dto.getStrategyStatus()) ? 1 : 0) != 0, (String)"\u7b56\u7565\u72b6\u6001\u503c\u4e0d\u7b26\u5408\u8981\u6c42");
        List timePairs = JSONArray.parseArray((String)dto.getStrategyTimeConfig(), TimePair.class);
        AssertUtil.isTrue((!HoldStrategyConfigServiceImpl.isOverlap(timePairs, (boolean)Boolean.FALSE) ? 1 : 0) != 0, (String)"\u6709\u91cd\u53e0\u7684\u65f6\u95f4\u6bb5\uff0c\u8bf7\u4fee\u6539");
    }

    public static boolean isOverlap(TimePair[] timePairs, boolean isStrict) {
        if (timePairs == null || timePairs.length == 0) {
            throw new DateTimeException("\u65f6\u95f4\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Arrays.sort(timePairs, Comparator.comparingLong(TimePair::getStart));
        for (int i = 1; i < timePairs.length; ++i) {
            if (!(isStrict ? timePairs[i - 1].getEnd() >= timePairs[i].getStart() : timePairs[i - 1].getEnd() > timePairs[i].getStart())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverlap(List<TimePair> timePairList, boolean isStrict) {
        if (CollectionUtil.isEmpty(timePairList)) {
            throw new DateTimeException("\u65f6\u95f4\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TimePair[] timePairs = new TimePair[timePairList.size()];
        timePairList.toArray(timePairs);
        return HoldStrategyConfigServiceImpl.isOverlap(timePairs, isStrict);
    }

    public static void main(String[] args) {
        ArrayList<TimePair> timePairList = new ArrayList<TimePair>();
        timePairList.add(new TimePair("09:00:00", "10:00:00"));
        timePairList.add(new TimePair("09:00:00", "10:00:00"));
        timePairList.add(new TimePair("11:44:00", "12:00:00"));
        DateUtil.parseDate((String)DateUtil.getDateFormat((Date)new Date(), (String)"HH:mm:ss"), (String)"HH:mm:ss").getTime();
        System.out.println(HoldStrategyConfigServiceImpl.isOverlap(timePairList, (boolean)Boolean.FALSE));
        System.out.println(DateUtil.getDateFormat((Date)new Date(1687172270471L), (String)"yyyy-MM-dd HH:mm:ss"));
    }
}

