/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.pda.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.constants.OperateLogInfoConstant;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsBaseOrderAddressContactsTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.OutNoticePushStatusEnum;
import com.yunxi.dg.base.center.inventory.api.transform.ITrLogisticsMappingRelationQueryApi;
import com.yunxi.dg.base.center.inventory.constants.AuthStateEnum;
import com.yunxi.dg.base.center.inventory.constants.BizPrintTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.CustomerAccountTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.DefaultConstants;
import com.yunxi.dg.base.center.inventory.constants.LogisticsOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.constants.PrintIsSupportEnum;
import com.yunxi.dg.base.center.inventory.constants.PrintReturnStatusEnum;
import com.yunxi.dg.base.center.inventory.constants.PrintStatusEnum;
import com.yunxi.dg.base.center.inventory.constants.PrintTemplateTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.RetrievalNumberFlagEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.das.IBaseOrderAddressDas;
import com.yunxi.dg.base.center.inventory.dao.das.IInOutNoticeOrderDas;
import com.yunxi.dg.base.center.inventory.dao.das.IInOutNoticeOrderDetailDas;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicWarehouseDas;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsCompanySiteDas;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsKuaidiTemplateDas;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsPlatformShopDas;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsPrintRecordDas;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsPrintTemplateDas;
import com.yunxi.dg.base.center.inventory.dao.das.IWarehouseAddressDas;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdvancedShippingDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPdaSettingDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OutNoticeOrderOperateLogDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OutResultOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.CallBackPrintReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.CancelLogisticsOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.CreateShipOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryCombineDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryInfoDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryInfoQueryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryOrderInfoRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryOrderUpdateReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryPrintFinishMessageDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryPrintFinishMessageInfoDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsDeliveryOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsOrderCancelReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsOrderThirdTemplateReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsPlatformShopRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsPrintTemplateRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsSubscriptionSearchReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsTemplateRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.PrintLogisticsAddressDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.PrintLogisticsConfigurationDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.PrintLogisticsOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.PrintLogisticsOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.ShipOrderPrintReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.ShipOrderPrintRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.WarehouseDeliveryInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.WarehouseDeliveryReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.WarehouseDeliveryRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.WaybillSubscriptionInfoDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutSendBackDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutSendBackReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.LogisticsCompanySiteEo;
import com.yunxi.dg.base.center.inventory.eo.LogisticsKuaidiTemplateEo;
import com.yunxi.dg.base.center.inventory.eo.LogisticsPlatformShopEo;
import com.yunxi.dg.base.center.inventory.eo.LogisticsPrintRecordEo;
import com.yunxi.dg.base.center.inventory.eo.LogisticsPrintTemplateEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.pda.domain.entity.ILogisticsPrintReqTaskDomain;
import com.yunxi.dg.base.center.inventory.pda.eo.LogisticsPrintReqTaskEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeLogisticsGenEvent;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IHistoryLogisticsService;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutNoticeOrderService;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicInventoryService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDetailDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.pda.IDeliveryLogisticsService;
import com.yunxi.dg.base.center.inventory.service.pda.ILogisticsPdaSettingService;
import com.yunxi.dg.base.center.inventory.service.pda.IOutNoticeOrderOperateLogService;
import com.yunxi.dg.base.center.inventory.service.pda.impl.LinkSelectTypeEnum;
import com.yunxi.dg.base.center.inventory.service.pda.impl.LinkSuitTypeEnum;
import com.yunxi.dg.base.center.inventory.service.pda.impl.PdaMatchUtils;
import com.yunxi.dg.base.center.inventory.service.utils.ExtensionUtil;
import com.yunxi.dg.base.center.inventory.service.utils.SendMqHelper;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.logistics.dto.entity.SendOrderStrategyDto;
import com.yunxi.dg.base.center.logistics.dto.entity.SendOrderStrategyPageReqDto;
import com.yunxi.dg.base.center.logistics.proxy.send.ISendOrderStrategyApiProxy;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.StdCancelLogisticsOrderReqDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.StdCancelLogisticsOrderRespDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.StdPrintLogisticsAddressDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.StdPrintLogisticsOrderExtReqDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.StdPrintLogisticsOrderExtRespDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.StdPrintLogisticsOrderReqDto;
import com.yunxi.dg.base.center.openapi.proxy.kuaidi100.IKuaidi100ApiProxy;
import com.yunxi.dg.base.center.pull.waybill.api.IWaybillApi;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillIiAddressDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillIiCancelReqDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillIiCancelRespDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillIiGetPrintDataRespDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillIiGetReqDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillIiGetRespDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillIiItemInfoDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillIiTemplateGetReqDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillIiTemplateGetRespDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillPrintDocRespDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillPrintDocumentReqDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillPrintImgExchangeReqDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillPrintImgExchangeRespDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillPrintReqDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillPrintRespDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillPrintTemplateReqDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillSubscriptionSearchReqDto;
import com.yunxi.dg.base.center.pull.waybill.dto.WaybillSubscriptionSearchRespDto;
import com.yunxi.dg.base.center.source.api.entity.ITrSourceQueryApi;
import com.yunxi.dg.base.center.source.dto.entity.TfSourceRespDto;
import com.yunxi.dg.base.center.trade.api.order.IPerformOrderQueryApi;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.transform.TrLogisticsMappingRelationRespDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IDeliveryLogisticsServiceImpl
implements IDeliveryLogisticsService {
    private static final Logger log = LoggerFactory.getLogger(IDeliveryLogisticsServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(IDeliveryLogisticsServiceImpl.class);
    @Resource
    private ILogicWarehouseDas csLogicWarehouseDas;
    @Resource
    private IInOutNoticeOrderDas outNoticeOrderDas;
    @Resource
    private IInOutNoticeOrderDetailDas outNoticeOrderDetailDas;
    @Resource
    private IKuaidi100ApiProxy kuaidi100ApiProxy;
    @Resource
    private ILogisticsPlatformShopDas logisticsPlatformShopDas;
    @Resource
    private ILogisticsPrintTemplateDas logisticsPrintTemplateDas;
    @Resource
    private IWarehouseAddressDas warehouseAddressDas;
    @Resource
    private ILogisticsPrintRecordDas logisticsPrintRecordDas;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private ItemDetailDataQueryHelperImpl itemDetailDataQueryHelper;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ITrSourceQueryApi trSourceQueryApi;
    @Resource
    private IPerformOrderQueryApi performOrderQueryApi;
    private static final Integer DEFAULT_PRINT_NUM = 0;
    @Resource
    private IOutNoticeOrderOperateLogService outNoticeOrderOperateLogService;
    @Resource
    private IBaseOrderAddressDas baseOrderAddressDas;
    @Value(value="${inventory.delivery.logistics.print.pos.type:1}")
    private Integer printPosType;
    @Value(value="${inventory.delivery.logistics.print.text.size:3}")
    private Integer printTextSize;
    private static final String TABLENAME = "create_ship_order_table";
    @Resource
    private ILogisticsCompanySiteDas logisticsCompanySiteDas;
    @Resource
    private IInOutNoticeOrderService outNoticeOrderService;
    @Resource
    private ILogisticsKuaidiTemplateDas logisticsKuaidiTemplateDas;
    @Resource
    private ILogisticsPdaSettingService logisticsPdaSettingService;
    @Autowired
    private ITrLogisticsMappingRelationQueryApi trLogisticsMappingRelationQueryApi;
    @Autowired
    private ILogicInventoryService logicInventoryService;
    @Value(value="${inventory.logistics.source:suning,jdcs,tmallyoupin,alibaba}")
    private String source;
    @Value(value="${inventory.logistics.oaid.source:tmallyoupin,kaolazhiying}")
    private String oaidSource;
    @Value(value="${inventory.logistics.distribution.source:douyin}")
    private String distributionOrderNoSource;
    @Value(value="${inventory.logistics.distribution.source.system:banniu}")
    private String distributionOrderNoSourceSystem;
    @Autowired
    private IWaybillApi waybillApi;
    @Autowired
    private ILogisticsPrintReqTaskDomain logisticsPrintReqTaskDomain;
    @Autowired
    private SendMqHelper sendMqHelper;
    @Resource
    private ISendOrderStrategyApiProxy sendOrderStrategyApiProxy;
    @Resource
    private IHistoryLogisticsService historyLogisticsService;
    ExecutorService executorService = new ThreadPoolExecutor(6, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void matchAndCreateShipOrder(InOutNoticeOrderContext inOutNoticeOrderContext) {
        if (!CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode().equals(inOutNoticeOrderContext.getInOutNoticeOrderEo().getRelevanceTableName()) || StringUtils.isBlank((CharSequence)inOutNoticeOrderContext.getInOutNoticeOrderEo().getSourcePlatformCode())) {
            log.info("\u975e\u5e73\u53f0\u8ba2\u5355\u65e0\u6cd5\u53d6\u53f7:{},", (Object)JSONUtil.toJsonStr((Object)inOutNoticeOrderContext));
            return;
        }
        RestResponse<LogisticsPdaSettingDto> andInit = this.logisticsPdaSettingService.getAndInit();
        LogisticsPdaSettingDto data = (LogisticsPdaSettingDto)andInit.getData();
        if (!data.isEnable()) {
            log.info("\u672a\u914d\u7f6e\u81ea\u52a8\u83b7\u53d6\u7b56\u7565:{},", (Object)JSONUtil.toJsonStr(andInit));
            return;
        }
        boolean match = data.match(inOutNoticeOrderContext.getLogicWarehouseCode());
        if (!match) {
            log.info("\u672a\u5339\u914d\u5230\u81ea\u52a8\u751f\u6210\u7535\u5b50\u9762\u5355\u7b56\u7565:{},{}", (Object)JSONUtil.toJsonStr(andInit), (Object)JSONUtil.toJsonStr((Object)inOutNoticeOrderContext));
            return;
        }
        log.info("\u5339\u914d\u5230\u81ea\u52a8\u751f\u6210\u7535\u5b50\u9762\u5355\u7b56\u7565:{},{}", (Object)JSONUtil.toJsonStr(andInit), (Object)JSONUtil.toJsonStr((Object)inOutNoticeOrderContext));
        CreateShipOrderReqDto orderReqDto = new CreateShipOrderReqDto();
        orderReqDto.setId(inOutNoticeOrderContext.getInOutNoticeOrderEo().getId());
        orderReqDto.setPlatformOrderNo(inOutNoticeOrderContext.getExternalOrderNo());
        orderReqDto.setSaleOrderNo(inOutNoticeOrderContext.getRelevanceNo());
        Integer count = this.getCount(inOutNoticeOrderContext, data);
        orderReqDto.setCount(count + "");
        orderReqDto.setBuyerRemark(inOutNoticeOrderContext.getInOutNoticeOrderEo().getRemark());
        List addressList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.baseOrderAddressDas.filter().eq((Object)"document_no", (Object)inOutNoticeOrderContext.getRelevanceNo())).eq((Object)"contacts_type", (Object)CsBaseOrderAddressContactsTypeEnum.CONSIGNEE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)addressList)) {
            BaseOrderAddressEo baseOrderAddressEo = (BaseOrderAddressEo)addressList.get(0);
            orderReqDto.setAddress(baseOrderAddressEo.getDetailAddress());
            orderReqDto.setContactPhone(baseOrderAddressEo.getPhone());
            orderReqDto.setContact(baseOrderAddressEo.getContacts());
            orderReqDto.setCity(baseOrderAddressEo.getCity());
            orderReqDto.setCityCode(baseOrderAddressEo.getCityCode());
            orderReqDto.setAreaCode(baseOrderAddressEo.getDistrictCode());
            orderReqDto.setArea(baseOrderAddressEo.getDistrict());
            orderReqDto.setProvince(baseOrderAddressEo.getProvince());
            orderReqDto.setProvinceCode(baseOrderAddressEo.getProvinceCode());
        }
        this.createShipOrder(orderReqDto);
    }

    private Integer getCount(InOutNoticeOrderContext inOutNoticeOrderContext, LogisticsPdaSettingDto data) {
        if ("count".equals(data.getAutoTakeModule())) {
            return inOutNoticeOrderContext.getInOutNoticeOrderDetailEoList().stream().mapToInt(r -> r.getDoneQuantity().intValue()).sum();
        }
        return 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public LogisticsDeliveryOrderRespDto createShipOrder(CreateShipOrderReqDto reqDto) {
        logger.info("\u521b\u5efa\u7535\u5b50\u9762\u5355\u5165\u53c2:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)reqDto));
        DeliveryCombineDto deliveryCombine = this.validDeliveryCombineDto(reqDto);
        LogicWarehouseEo logicWarehouseEo = this.validWarehouseRespDto(deliveryCombine);
        this.outNoticeOrderService.updateRetrievalNumberFlag(reqDto.getId(), RetrievalNumberFlagEnum.RETRIEVAL_NUMBER.getCode());
        PrintLogisticsOrderReqDto printLogisticsOrderReqDto = this.buildPrintLogisticsOrderReqDto(deliveryCombine, logicWarehouseEo, reqDto);
        PrintLogisticsOrderRespDto printLogisticsOrderRespDto = this.syncCreateShipOrder(printLogisticsOrderReqDto);
        this.updateShipping(reqDto.getId(), printLogisticsOrderRespDto);
        LogisticsDeliveryOrderRespDto logisticsDeliveryOrderRespDto = new LogisticsDeliveryOrderRespDto();
        CubeBeanUtils.copyProperties((Object)logisticsDeliveryOrderRespDto, (Object)printLogisticsOrderRespDto, (String[])new String[0]);
        logisticsDeliveryOrderRespDto.setDeliveryId(reqDto.getId());
        logisticsDeliveryOrderRespDto.setDocumentNo(deliveryCombine.getOutNoticeOrderRespDto().getDocumentNo());
        if (StringUtils.isNotBlank((CharSequence)printLogisticsOrderRespDto.getShippingNo())) {
            InventoryConfig.registerSynchronizationAfterCommit(() -> this.noticeAdvancedShipping(logisticsDeliveryOrderRespDto));
        }
        return logisticsDeliveryOrderRespDto;
    }

    @Override
    public List<LogisticsDeliveryOrderRespDto> batchCreateShipOrder(List<CreateShipOrderReqDto> reqDtoList) {
        AssertUtil.assertTrue((boolean)CollectionUtils.isNotEmpty(reqDtoList), (String)"\u8bf7\u9009\u62e9\u8981\u53d6\u53f7\u7684\u53d1\u8d27\u5355", (Object[])new Object[0]);
        ArrayList<LogisticsDeliveryOrderRespDto> logisticsDeliveryOrderRespDtos = new ArrayList<LogisticsDeliveryOrderRespDto>();
        ArrayList<CompletionStage> completableFutureTasks = new ArrayList<CompletionStage>(reqDtoList.size());
        for (CreateShipOrderReqDto order : reqDtoList) {
            completableFutureTasks.add(CompletableFuture.runAsync(() -> {
                LogisticsDeliveryOrderRespDto logisticsDeliveryOrderRespDto = ((IDeliveryLogisticsServiceImpl)SpringBeanUtil.getBean(IDeliveryLogisticsServiceImpl.class)).createShipOrder(order);
                logisticsDeliveryOrderRespDtos.add(logisticsDeliveryOrderRespDto);
            }).handle((unused, throwable) -> {
                if (throwable != null) {
                    LogisticsDeliveryOrderRespDto expRespDto = new LogisticsDeliveryOrderRespDto();
                    expRespDto.setDeliveryId(order.getId());
                    expRespDto.setMessage(this.getExpMessage((Throwable)throwable));
                    expRespDto.setPrintStatus(PrintStatusEnum.GET_NUMBER_FAIL.getCode());
                    logisticsDeliveryOrderRespDtos.add(expRespDto);
                }
                return null;
            }));
        }
        CompletableFuture<Void> allFuture = CompletableFuture.allOf(completableFutureTasks.toArray(new CompletableFuture[0]));
        try {
            allFuture.get();
        }
        catch (Exception e) {
            throw new BizException(String.format("\u6279\u91cf\u53d6\u53f7\u6267\u884c\u5f02\u5e38:%s", e.getMessage()));
        }
        return logisticsDeliveryOrderRespDtos;
    }

    private String getExpMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (StrUtil.isNotBlank((CharSequence)message) && message.split(":").length > 1) {
            message = message.split(":", 2)[1];
        }
        return message;
    }

    @Override
    public CancelLogisticsOrderRespDto saleOrderCancel(String saleOrderNo) {
        logger.info("\u9500\u552e\u5355\u56de\u6536\u5feb\u9012:{}", (Object)saleOrderNo);
        ArrayList<String> orderStatus = new ArrayList<String>();
        orderStatus.add(BaseOrderStatusEnum.ONO_WAIT_OUT.getCode());
        orderStatus.add(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().eq((Object)"relevance_no", (Object)saleOrderNo)).eq((Object)"order_type", (Object)"out")).in((Object)"order_status", orderStatus)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<InOutNoticeOrderEo> eoList;
            if (list.size() > 1) {
                logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u51fa\u5e93\u901a\u77e5\u5355:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)list));
            }
            if (CollectionUtils.isNotEmpty(eoList = list.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getShippingCode()) && StringUtils.isNotBlank((CharSequence)x.getLogisticsOrderLabel())).collect(Collectors.toList()))) {
                eoList.forEach(info -> {
                    TransactionStatus cfr_ignored_0 = (TransactionStatus)InventoryConfig.executorNewTransaction(s -> {
                        LogisticsOrderCancelReqDto logisticsOrderCancelReqDto = new LogisticsOrderCancelReqDto();
                        logisticsOrderCancelReqDto.setBizOrderNo(info.getDocumentNo());
                        logisticsOrderCancelReqDto.setBizPrintType(BizPrintTypeEnum.DELIVERY.getCode());
                        ((IDeliveryLogisticsServiceImpl)SpringBeanUtil.getBean(IDeliveryLogisticsServiceImpl.class)).cancel(logisticsOrderCancelReqDto);
                        return s;
                    });
                });
                return new CancelLogisticsOrderRespDto();
            }
        }
        return new CancelLogisticsOrderRespDto();
    }

    @Override
    public List<LogisticsTemplateRespDto> getTemplateList(LogisticsOrderThirdTemplateReqDto logisticsOrderCancelReqDto) {
        WaybillIiTemplateGetReqDto reqDto = (WaybillIiTemplateGetReqDto)BeanUtil.copyProperties((Object)logisticsOrderCancelReqDto, WaybillIiTemplateGetReqDto.class, (String[])new String[0]);
        WaybillIiTemplateGetRespDto iiTemplateGetRespDto = (WaybillIiTemplateGetRespDto)RestResponseHelper.extractData((RestResponse)this.waybillApi.waybillTemplateGet(reqDto));
        AssertUtil.isTrue((boolean)iiTemplateGetRespDto.isCallResult(), (String)("\u83b7\u53d6\u9762\u5355\u5f02\u5e38:" + iiTemplateGetRespDto.getCallResultMsg()));
        boolean filter = StringUtils.isNotBlank((CharSequence)logisticsOrderCancelReqDto.getLogisticsCode());
        if (CollectionUtils.isEmpty((Collection)iiTemplateGetRespDto.getWaybillIiTemplateDtos())) {
            return new ArrayList<LogisticsTemplateRespDto>();
        }
        return BeanUtil.copyToList((Collection)iiTemplateGetRespDto.getWaybillIiTemplateDtos().stream().filter(r -> !filter || logisticsOrderCancelReqDto.getLogisticsCode().equals(r.getLogisticsCode())).collect(Collectors.toList()), LogisticsTemplateRespDto.class);
    }

    @Override
    public List<WaybillSubscriptionInfoDto> subscriptionSearch(LogisticsSubscriptionSearchReqDto logisticsSubscriptionSearchReqDto) {
        WaybillSubscriptionSearchReqDto reqDto = (WaybillSubscriptionSearchReqDto)BeanUtil.copyProperties((Object)logisticsSubscriptionSearchReqDto, WaybillSubscriptionSearchReqDto.class, (String[])new String[0]);
        WaybillSubscriptionSearchRespDto iiTemplateGetRespDto = (WaybillSubscriptionSearchRespDto)RestResponseHelper.extractData((RestResponse)this.waybillApi.waybillSubscriptionSearch(reqDto));
        AssertUtil.isTrue((boolean)iiTemplateGetRespDto.isCallResult(), (String)("\u83b7\u53d6\u9762\u5355\u5f02\u5e38:" + iiTemplateGetRespDto.getCallResultMsg()));
        return BeanUtil.copyToList((Collection)iiTemplateGetRespDto.getSubscriptionInfoDtoList(), WaybillSubscriptionInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CancelLogisticsOrderRespDto cancel(LogisticsOrderCancelReqDto logisticsOrderCancelReqDto) {
        return this.syncCancel(logisticsOrderCancelReqDto, Boolean.FALSE);
    }

    public CancelLogisticsOrderRespDto syncCancel(LogisticsOrderCancelReqDto logisticsOrderCancelReqDto, boolean isValid) {
        StdCancelLogisticsOrderRespDto cancelLogisticsOrderRespDto;
        logger.info("\u53d6\u6d88\u7535\u5b50\u9762\u5355\u5165\u53c2:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)logisticsOrderCancelReqDto));
        PrintLogisticsOrderReqDto printLogisticsOrderReqDto = new PrintLogisticsOrderReqDto();
        printLogisticsOrderReqDto.setBizOrderNo(logisticsOrderCancelReqDto.getBizOrderNo());
        printLogisticsOrderReqDto.setBizPrintType(logisticsOrderCancelReqDto.getBizPrintType());
        CancelLogisticsOrderRespDto respDto = new CancelLogisticsOrderRespDto();
        InOutNoticeOrderEo outOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().eq((Object)"document_no", (Object)printLogisticsOrderReqDto.getBizOrderNo())).one();
        if (null == outOrderEo) {
            respDto.setResult(Boolean.valueOf(false));
            respDto.setReturnCode("100000");
            respDto.setMessage("\u6ca1\u6709\u5bf9\u5e94\u53ef\u4ee5\u56de\u6536\u7684\u53d6\u53f7\u8bb0\u5f55");
            this.updateFailReason(printLogisticsOrderReqDto.getBizOrderNo(), "\u6ca1\u6709\u5bf9\u5e94\u53ef\u4ee5\u56de\u6536\u7684\u53d6\u53f7\u8bb0\u5f55");
            return respDto;
        }
        LogisticsPrintRecordEo recordEo = this.validLogisticsPrintRecordEo(printLogisticsOrderReqDto, isValid);
        if (recordEo == null) {
            respDto.setResult(Boolean.valueOf(false));
            respDto.setReturnCode("100000");
            respDto.setMessage("\u6ca1\u6709\u5bf9\u5e94\u53ef\u4ee5\u56de\u6536\u7684\u53d6\u53f7\u8bb0\u5f55");
            this.updateFailReason(outOrderEo.getDocumentNo(), "\u6ca1\u6709\u5bf9\u5e94\u53ef\u4ee5\u56de\u6536\u7684\u53d6\u53f7\u8bb0\u5f55");
            return respDto;
        }
        StdCancelLogisticsOrderReqDto cancelLogisticsOrderReqDto = this.buildStdCancelLogisticsOrderReqDto(recordEo);
        Integer customerAccountType = null;
        String extension = recordEo.getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)extension);
            customerAccountType = jsonObject.getInteger("customerAccountType");
        }
        if (customerAccountType == null || CustomerAccountTypeEnum.EXPRESS.getCode().equals(customerAccountType)) {
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsCompanySiteDas.filter().eq((Object)"logistics_company_code", (Object)recordEo.getLogisticsCompanyCode())).eq((Object)"status", (Object)1)).orderByDesc((Object)"id")).list();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                HashMap<String, String> objectHashMap = new HashMap<String, String>();
                if (StringUtils.isNotBlank((CharSequence)((LogisticsCompanySiteEo)list.get(0)).getPlatformAccount())) {
                    objectHashMap.put("printAccount", ((LogisticsCompanySiteEo)list.get(0)).getPlatformAccount());
                }
                if (StringUtils.isNotBlank((CharSequence)((LogisticsCompanySiteEo)list.get(0)).getPlatformPassword())) {
                    objectHashMap.put("printPassword", ((LogisticsCompanySiteEo)list.get(0)).getPlatformPassword());
                }
                if (StringUtils.isNotBlank((CharSequence)((LogisticsCompanySiteEo)list.get(0)).getLogisticsSiteCode())) {
                    objectHashMap.put("logisticsSiteCode", ((LogisticsCompanySiteEo)list.get(0)).getLogisticsSiteCode());
                }
                objectHashMap.put("customerAccountType", "1");
                cancelLogisticsOrderReqDto.setExtFields(objectHashMap);
            }
        } else if (CustomerAccountTypeEnum.THIRD.getCode().equals(customerAccountType)) {
            HashMap<String, String> objectHashMap = new HashMap<String, String>();
            objectHashMap.put("customerAccountType", "2");
            cancelLogisticsOrderReqDto.setExtFields(objectHashMap);
        }
        if (!InventoryConfig.isPadModule(recordEo.getLogisticsPlatformCode())) {
            ArrayList shippingNos = Lists.newArrayList((Object[])new String[]{recordEo.getShippingNo()});
            String subShippingCode = outOrderEo.getSubShippingCode();
            shippingNos.addAll(Optional.ofNullable(subShippingCode).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(r -> r.split(",")).map(Lists::newArrayList).orElse(new ArrayList()));
            cancelLogisticsOrderRespDto = new StdCancelLogisticsOrderRespDto();
            WaybillIiCancelReqDto reqDto = new WaybillIiCancelReqDto();
            reqDto.setPlatformOrderNo(this.transferPlatFormOrderNo(outOrderEo.getExternalOrderNo(), outOrderEo.getSourcePlatformCode(), outOrderEo.getOaidOrderSourceCode(), outOrderEo.getRelevanceNo()));
            reqDto.setWaybillCode((String)shippingNos.get(0));
            reqDto.setAllWaybillCodeList((List)shippingNos);
            reqDto.setChannelCode(cancelLogisticsOrderReqDto.getLogisticsPlatformCode());
            reqDto.setLogisticsCode(cancelLogisticsOrderReqDto.getLogisticsCompanyCode());
            reqDto.setShopCode(cancelLogisticsOrderReqDto.getShopCode());
            reqDto.setOperatorName(ServiceContext.getContext().getRequestUserCode());
            reqDto.setOperatorDate(new Date());
            com.alibaba.fastjson.JSONObject jsonObject = ExtensionUtil.parseJson(recordEo.getExtension());
            reqDto.setParentWaybillCodeList(jsonObject.getJSONArray("parentWaybillNos").toJavaList(String.class));
            reqDto.setParentOrder(jsonObject.getBooleanValue("isParentOrder"));
            logger.info("\u8c03\u7528\u63a5\u53e3\u4e2d\u5fc3\u53d6\u6d88\u7535\u5b50\u9762\u5355\u5165\u53c2:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)reqDto));
            WaybillIiCancelRespDto waybillIiCancelRespDto = (WaybillIiCancelRespDto)RestResponseHelper.extractData((RestResponse)this.waybillApi.waybillCancel(reqDto));
            logger.info("\u8c03\u7528\u63a5\u53e3\u4e2d\u5fc3\u53d6\u6d88\u7535\u5b50\u9762\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)waybillIiCancelRespDto));
            cancelLogisticsOrderRespDto.setResult(Boolean.valueOf(waybillIiCancelRespDto.isCallResult()));
            cancelLogisticsOrderRespDto.setReturnCode(waybillIiCancelRespDto.isCallResult() ? PrintReturnStatusEnum.PRINT_RETURN_SUCCESS.getCode() : PrintReturnStatusEnum.PRINT_RETURN_400.getCode());
            cancelLogisticsOrderRespDto.setMessage(waybillIiCancelRespDto.getCallResultMsg());
        } else {
            logger.info("\u8c03\u7528\u63a5\u53e3\u4e2d\u5fc3\u53d6\u6d88\u7535\u5b50\u9762\u5355\u5165\u53c2:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)cancelLogisticsOrderReqDto));
            RestResponse stdCancelLogisticsOrderRespDtoRestResponse = this.kuaidi100ApiProxy.cancelLogistics(cancelLogisticsOrderReqDto);
            logger.info("\u8c03\u7528\u63a5\u53e3\u4e2d\u5fc3\u53d6\u6d88\u7535\u5b50\u9762\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)stdCancelLogisticsOrderRespDtoRestResponse));
            cancelLogisticsOrderRespDto = (StdCancelLogisticsOrderRespDto)stdCancelLogisticsOrderRespDtoRestResponse.getData();
        }
        this.updatePrintInfoByCancel(recordEo, cancelLogisticsOrderRespDto);
        BeanUtils.copyProperties((Object)cancelLogisticsOrderRespDto, (Object)respDto);
        return respDto;
    }

    private LogisticsPrintRecordEo validLogisticsPrintRecordEo(PrintLogisticsOrderReqDto printLogisticsOrderReqDto, boolean isValid) {
        return this.checkLogisticsPrintRecordEo(printLogisticsOrderReqDto);
    }

    private LogisticsPrintRecordEo checkLogisticsPrintRecordEo(PrintLogisticsOrderReqDto printLogisticsOrderReqDto) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPrintRecordDas.filter().isNotNull((Object)"task_id")).eq((Object)"biz_print_type", (Object)printLogisticsOrderReqDto.getBizPrintType())).eq((Object)"biz_order_no", (Object)printLogisticsOrderReqDto.getBizOrderNo())).notIn((Object)"print_status", Arrays.asList(PrintStatusEnum.PRINT_CANCEL.getCode(), PrintStatusEnum.GET_NUMBER_FAIL.getCode()))).last(" limit 1 ")).oneOpt().orElse(null);
    }

    private StdCancelLogisticsOrderReqDto buildStdCancelLogisticsOrderReqDto(LogisticsPrintRecordEo recordEo) {
        StdCancelLogisticsOrderReqDto cancelLogisticsOrderReqDto = new StdCancelLogisticsOrderReqDto();
        cancelLogisticsOrderReqDto.setChannelCode(recordEo.getChannelCode());
        cancelLogisticsOrderReqDto.setShippingNo(recordEo.getShippingNo());
        cancelLogisticsOrderReqDto.setShopCode(recordEo.getShopCode());
        cancelLogisticsOrderReqDto.setLogisticsCompanyCode(recordEo.getExternalLogisticsCode());
        cancelLogisticsOrderReqDto.setLogisticsPlatformCode(recordEo.getLogisticsPlatformCode());
        String logisticsAttachDataStr = recordEo.getLogisticsAttachData();
        if (StrUtil.isNotBlank((CharSequence)logisticsAttachDataStr)) {
            com.alibaba.fastjson.JSONObject logisticsAttachData = com.alibaba.fastjson.JSONObject.parseObject((String)logisticsAttachDataStr);
            cancelLogisticsOrderReqDto.setOrderNo(logisticsAttachData.getString("logisticsOrderNum"));
        }
        cancelLogisticsOrderReqDto.setReason("\u4e1a\u52a1\u53d6\u6d88\u5feb\u9012\u5355");
        return cancelLogisticsOrderReqDto;
    }

    private void updatePrintInfoByCancel(LogisticsPrintRecordEo logisticsPrintRecordEo, StdCancelLogisticsOrderRespDto printLogisticsRespDto) {
        logger.info("\u53d6\u6d88\u7535\u5b50\u9762\u54cd\u5e94 printLogisticsRespDto" + com.alibaba.fastjson.JSONObject.toJSONString((Object)printLogisticsRespDto));
        if (PrintReturnStatusEnum.PRINT_RETURN_SUCCESS.getCode().equals(printLogisticsRespDto.getReturnCode())) {
            logisticsPrintRecordEo.setPrintStatus(PrintStatusEnum.PRINT_CANCEL.getCode());
            this.logisticsPrintRecordDas.updateSelective((BaseEo)logisticsPrintRecordEo);
            printLogisticsRespDto.setResult(Boolean.valueOf(true));
            this.cancelShipping(logisticsPrintRecordEo);
            this.addOperateLog(logisticsPrintRecordEo.getBizOrderNo(), "\u5feb\u9012\u56de\u6536\u6210\u529f", "");
            logger.info("\u53d1\u8d27\u5355\u56de\u6536\u9762\u5355\u6210\u529f:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)logisticsPrintRecordEo));
        } else {
            logger.info("\u53d1\u8d27\u5355\u56de\u6536\u9762\u5355\u56de\u6536\u5931\u8d25:{},\u5931\u8d25\u539f\u56e0:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)logisticsPrintRecordEo), (Object)printLogisticsRespDto.getMessage());
            this.addOperateLog(logisticsPrintRecordEo.getBizOrderNo(), OperateLogInfoConstant.getExpressDeliveryFail((String)printLogisticsRespDto.getMessage()), "");
            printLogisticsRespDto.setResult(Boolean.valueOf(false));
            printLogisticsRespDto.setMessage(printLogisticsRespDto.getMessage());
            this.updateFailReason(logisticsPrintRecordEo.getBizOrderNo(), printLogisticsRespDto.getMessage());
        }
    }

    private void updateFailReason(String documentNo, String message) {
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)documentNo), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3anull");
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        updateEo.setFailReason(message);
        this.outNoticeOrderDas.getMapper().update((Object)updateEo, (Wrapper)Wrappers.query((Object)new InOutNoticeOrderEo()).eq((Object)"document_no", (Object)documentNo));
    }

    private DeliveryCombineDto validDeliveryCombineDto(CreateShipOrderReqDto reqDto) {
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().eq((Object)"id", (Object)reqDto.getId())).list().get(0);
        logger.info("\u66f4\u65b0\u524d:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)outNoticeOrderEo));
        reqDto.setStreet(ExtensionUtil.parseJson(outNoticeOrderEo.getExtension()).getString("street"));
        AssertUtil.assertTrue((boolean)RetrievalNumberFlagEnum.NOT_RETRIEVAL_NUMBER.getCode().equals(outNoticeOrderEo.getRetrievalNumberFlag()), (String)"\u6b64\u65f6\u6b63\u5728\u53d6\u53f7\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (Object[])new Object[0]);
        List outNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.outNoticeOrderDetailDas.filter().eq((Object)"document_no", (Object)outNoticeOrderEo.getDocumentNo())).list();
        AssertUtil.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)outNoticeOrderDetailEoList), (String)"\u53d1\u8d27\u5355\u8d27\u54c1\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)outNoticeOrderEo.getShopCode()), (String)"\u53d1\u8d27\u5355\u5e97\u94fa\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)outNoticeOrderEo.getShipmentEnterpriseCode()), (String)"\u53d1\u8d27\u5355\u627f\u8fd0\u5546\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertTrue((LogisticsOrderStatusEnum.WAIT_RETRIEVAL_NUMBER.getCode().equals(outNoticeOrderEo.getLogisticsOrderStatus()) || LogisticsOrderStatusEnum.RETRIEVAL_NUMBER_FAIL.getCode().equals(outNoticeOrderEo.getLogisticsOrderStatus()) ? 1 : 0) != 0, (String)"\u53d1\u8d27\u5355\u9700\u4e3a\u5f85\u53d6\u53f7/\u53d6\u53f7\u5931\u8d25\u72b6\u6001\u624d\u53ef\u53d6\u53f7", (Object[])new Object[0]);
        DeliveryCombineDto deliveryCombine = new DeliveryCombineDto();
        InOutNoticeOrderDto outNoticeOrderRespDto = new InOutNoticeOrderDto();
        CubeBeanUtils.copyProperties((Object)outNoticeOrderRespDto, (Object)outNoticeOrderEo, (String[])new String[0]);
        deliveryCombine.setOutNoticeOrderRespDto(outNoticeOrderRespDto);
        List outNoticeOrderDetailRespDtoList = BeanUtil.copyToList((Collection)outNoticeOrderDetailEoList, CsOutNoticeOrderDetailRespDto.class);
        deliveryCombine.setOutNoticeOrderDetailRespDtoList(outNoticeOrderDetailRespDtoList);
        return deliveryCombine;
    }

    private LogicWarehouseEo validWarehouseRespDto(DeliveryCombineDto deliveryCombine) {
        InOutNoticeOrderDto outNoticeOrderRespDto = deliveryCombine.getOutNoticeOrderRespDto();
        if (StringUtils.isNotBlank((CharSequence)outNoticeOrderRespDto.getOutLogicWarehouseCode())) {
            List logicWarehouseEoList = ((ExtQueryChainWrapper)this.csLogicWarehouseDas.filter().eq((Object)"warehouse_code", (Object)outNoticeOrderRespDto.getOutLogicWarehouseCode())).list();
            AssertUtil.assertNotEmpty((Collection)logicWarehouseEoList, (String)"\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f", (Object[])new Object[0]);
            return (LogicWarehouseEo)logicWarehouseEoList.get(0);
        }
        throw new BizException("\u53d1\u8d27\u5355\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a");
    }

    private PrintLogisticsOrderReqDto buildPrintLogisticsOrderReqDto(DeliveryCombineDto deliveryCombine, LogicWarehouseEo logicWarehouseEo, CreateShipOrderReqDto reqDto) {
        PrintLogisticsOrderReqDto printLogisticsOrderReqDto = new PrintLogisticsOrderReqDto();
        InOutNoticeOrderDto outNoticeOrderRespDto = deliveryCombine.getOutNoticeOrderRespDto();
        printLogisticsOrderReqDto.setLogisticsCompanyCode(outNoticeOrderRespDto.getShipmentEnterpriseCode());
        printLogisticsOrderReqDto.setBizOrderNo(outNoticeOrderRespDto.getDocumentNo());
        printLogisticsOrderReqDto.setBizPrintType(BizPrintTypeEnum.DELIVERY.getCode());
        printLogisticsOrderReqDto.setSiCode(outNoticeOrderRespDto.getShipmentEnterpriseCode());
        printLogisticsOrderReqDto.setCount(reqDto.getCount());
        printLogisticsOrderReqDto.setSaleOrderNo(outNoticeOrderRespDto.getRelevanceNo());
        printLogisticsOrderReqDto.setThirdOrderNo(reqDto.getPlatformOrderNo());
        printLogisticsOrderReqDto.setDeliveryItems(deliveryCombine.getOutNoticeOrderDetailRespDtoList());
        printLogisticsOrderReqDto.setOutNoticeOrderRespDto(deliveryCombine.getOutNoticeOrderRespDto());
        if (!InventoryConfig.isPadModule(outNoticeOrderRespDto.getShipmentEnterpriseCode())) {
            List logisticsPlatformShopEos = this.logisticsPlatformShopDas.queryByShopAndWarehouse(PdaMatchUtils.buildMatchKey(LinkSelectTypeEnum.SELECT, outNoticeOrderRespDto.getShopCode(), LinkSuitTypeEnum.SHOP), PdaMatchUtils.buildMatchKey(LinkSelectTypeEnum.SELECT, outNoticeOrderRespDto.getOutPhysicsWarehouseCode(), LinkSuitTypeEnum.WAREHOUSE), 1);
            logisticsPlatformShopEos = logisticsPlatformShopEos.stream().filter(r -> outNoticeOrderRespDto.getShipmentEnterpriseCode().equals(r.getChannelCode())).collect(Collectors.toList());
            AssertUtil.assertNotEmpty(logisticsPlatformShopEos, (String)"\u6682\u65e0\u6b64\u4ed3\u5e93+\u7269\u6d41\u5546\u7684\u7535\u5b50\u9762\u5355,\u8bf7\u524d\u5f80\u914d\u7f6e", (Object[])new Object[0]);
            LogisticsPlatformShopEo logisticsPlatformShopEo = (LogisticsPlatformShopEo)logisticsPlatformShopEos.get(0);
            LogisticsPlatformShopRespDto logisticsPlatformShopRespDto = new LogisticsPlatformShopRespDto();
            CubeBeanUtils.copyProperties((Object)logisticsPlatformShopRespDto, (Object)logisticsPlatformShopEo, (String[])new String[0]);
            printLogisticsOrderReqDto.setLogisticsPlatformCode(logisticsPlatformShopEo.getPlatformCode());
            printLogisticsOrderReqDto.setChannelCode(logisticsPlatformShopEo.getChannelCode());
            printLogisticsOrderReqDto.setShopCode(logisticsPlatformShopEo.getShopCode());
            if (StringUtils.isNotBlank((CharSequence)logisticsPlatformShopEo.getDeliveryAddress())) {
                this.wrapperAddress(logisticsPlatformShopEo, printLogisticsOrderReqDto);
            }
            List templateEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPrintTemplateDas.filter().eq((Object)"logistics_company_code", (Object)outNoticeOrderRespDto.getShipmentEnterpriseCode())).eq((Object)"channel_code", (Object)printLogisticsOrderReqDto.getLogisticsPlatformCode())).orderByDesc((Object)"id")).list();
            AssertUtil.assertNotEmpty((Collection)templateEoList, (String)"\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u7535\u5b50\u9762\u5355\u914d\u7f6e\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
            LogisticsPrintTemplateEo logisticsPrintTemplateEo = (LogisticsPrintTemplateEo)templateEoList.get(0);
            this.setTemplateByTemplateType(logisticsPrintTemplateEo, printLogisticsOrderReqDto);
            printLogisticsOrderReqDto.setThirdTemplateURL(logisticsPrintTemplateEo.getStandardTemplateUrl());
            printLogisticsOrderReqDto.setThirdCustomTemplateUrl(logisticsPrintTemplateEo.getCustomTemplateUrl());
            printLogisticsOrderReqDto.setCustomerAccountType(CustomerAccountTypeEnum.THIRD.getCode());
            Optional<com.alibaba.fastjson.JSONObject> extensionOpt = Optional.ofNullable(outNoticeOrderRespDto.getExtension()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(JSON::parseObject);
            Integer orderSource = extensionOpt.map(r -> r.getInteger("orderSource")).orElse(1);
            Integer addressModified = extensionOpt.map(r -> r.getInteger("addressModified")).orElse(0);
            printLogisticsOrderReqDto.setIsPlatformOrderFlag(Boolean.valueOf(1 != addressModified && !Objects.equals(orderSource, 0)));
            printLogisticsOrderReqDto.setLogisticsSiteCode((String)StringUtils.defaultIfEmpty((CharSequence)logisticsPlatformShopEo.getSiteCode(), (CharSequence)logisticsPlatformShopEo.getStatementNumber()));
        } else {
            String shopCode = outNoticeOrderRespDto.getShopCode();
            String shippingCompany = outNoticeOrderRespDto.getShipmentEnterpriseCode();
            logger.info("\u83b7\u53d6\u7269\u6d41\u7535\u5b50\u9762\u5355\u6a21\u677f\u4fe1\u606f:{}", (Object)shippingCompany);
            LogisticsPrintTemplateRespDto logisticsPrintTemplateRespDto = new LogisticsPrintTemplateRespDto();
            Optional<com.alibaba.fastjson.JSONObject> extensionOpt = Optional.ofNullable(outNoticeOrderRespDto.getExtension()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(JSON::parseObject);
            Integer orderSource = extensionOpt.map(r -> r.getInteger("orderSource")).orElse(1);
            Integer addressModified = extensionOpt.map(r -> r.getInteger("addressModified")).orElse(0);
            String sourcePlatformCode = outNoticeOrderRespDto.getSourcePlatformCode();
            boolean flag = this.isPlatform(sourcePlatformCode, orderSource, addressModified);
            logger.info("\u53d6\u53f7\u6a21\u5f0f:{}, {}", (Object)outNoticeOrderRespDto.getDocumentNo(), (Object)(flag ? "\u5bc6\u6587\u53d6\u53f7" : "\u660e\u6587\u53d6\u53f7"));
            if (flag) {
                logger.info("\u83b7\u53d6\u5e97\u94fa\u7535\u5b50\u9762\u5355\u6388\u6743\u914d\u7f6e\u4fe1\u606f:{}", (Object)shopCode);
                List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPlatformShopDas.filter().eq((Object)"shop_code", (Object)shopCode)).eq((Object)"auth_state", (Object)AuthStateEnum.AUTHORIZED.getCode())).orderByDesc((Object)"id")).list();
                AssertUtil.assertNotEmpty((Collection)list, (String)"\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u7535\u5b50\u9762\u5355\u5df2\u6388\u6743\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
                LogisticsPlatformShopEo logisticsPlatformShopEo = (LogisticsPlatformShopEo)list.get(0);
                LogisticsPlatformShopRespDto logisticsPlatformShopRespDto = new LogisticsPlatformShopRespDto();
                CubeBeanUtils.copyProperties((Object)logisticsPlatformShopRespDto, (Object)logisticsPlatformShopEo, (String[])new String[0]);
                printLogisticsOrderReqDto.setLogisticsPlatformCode(logisticsPlatformShopEo.getPlatformCode());
                printLogisticsOrderReqDto.setChannelCode(logisticsPlatformShopEo.getChannelCode());
                printLogisticsOrderReqDto.setShopCode(logisticsPlatformShopEo.getShopCode());
                if (StringUtils.isNotBlank((CharSequence)logisticsPlatformShopEo.getDeliveryAddress())) {
                    this.wrapperAddress(logisticsPlatformShopEo, printLogisticsOrderReqDto);
                }
                List templateEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPrintTemplateDas.filter().eq((Object)"olp_id", (Object)logisticsPlatformShopEo.getId())).eq((Object)"logistics_company_code", (Object)shippingCompany)).orderByDesc((Object)"id")).list();
                AssertUtil.assertNotEmpty((Collection)templateEoList, (String)"\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u7535\u5b50\u9762\u5355\u914d\u7f6e\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
                LogisticsPrintTemplateEo logisticsPrintTemplateEo = (LogisticsPrintTemplateEo)templateEoList.get(0);
                CubeBeanUtils.copyProperties((Object)logisticsPrintTemplateRespDto, (Object)logisticsPrintTemplateEo, (String[])new String[0]);
                this.setTemplateByTemplateType(logisticsPrintTemplateEo, printLogisticsOrderReqDto);
                printLogisticsOrderReqDto.setCustomerAccountType(CustomerAccountTypeEnum.THIRD.getCode());
                List logisticsCompanySiteEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsCompanySiteDas.filter().eq((Object)"logistics_company_code", (Object)outNoticeOrderRespDto.getShipmentEnterpriseCode())).eq((Object)"status", (Object)1)).orderByDesc((Object)"id")).list();
                if (CollectionUtils.isNotEmpty((Collection)logisticsCompanySiteEoList)) {
                    LogisticsCompanySiteEo logisticsCompanySiteEo = (LogisticsCompanySiteEo)logisticsCompanySiteEoList.get(0);
                    if ("kuaishouxiaodian".equals(sourcePlatformCode)) {
                        printLogisticsOrderReqDto.setLogisticsSiteCode(logisticsCompanySiteEo.getLogisticsSiteCode());
                    } else {
                        printLogisticsOrderReqDto.setLogisticsSiteCode(logisticsCompanySiteEo.getLogisticsSiteCode());
                    }
                }
            } else {
                LogisticsKuaidiTemplateEo templateEo = (LogisticsKuaidiTemplateEo)((ExtQueryChainWrapper)this.logisticsKuaidiTemplateDas.filter().eq((Object)"logistics_company_code", (Object)shippingCompany)).one();
                AssertUtil.assertNotNull((Object)templateEo, (String)"\u672a\u83b7\u53d6\u5230\u7535\u5b50\u9762\u5355\u914d\u7f6e\u5feb\u9012100\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
                CubeBeanUtils.copyProperties((Object)logisticsPrintTemplateRespDto, (Object)templateEo, (String[])new String[0]);
                printLogisticsOrderReqDto.setTempCode(templateEo.getTemplateCode());
                printLogisticsOrderReqDto.setChildTempCode(templateEo.getChildTemplateCode());
                printLogisticsOrderReqDto.setCustomerAccountType(CustomerAccountTypeEnum.EXPRESS.getCode());
                LogisticsCompanySiteEo logisticsCompanySiteEo = this.getLogisticsCompanySiteDto(outNoticeOrderRespDto);
                printLogisticsOrderReqDto.setPrintAccount(logisticsCompanySiteEo.getPlatformAccount());
                printLogisticsOrderReqDto.setPrintPassword(logisticsCompanySiteEo.getPlatformPassword());
                printLogisticsOrderReqDto.setPrintSecret(logisticsCompanySiteEo.getPlatformSecret());
                printLogisticsOrderReqDto.setLogisticsSiteCode(logisticsCompanySiteEo.getLogisticsSiteCode());
                printLogisticsOrderReqDto.setLogisticsSiteName(logisticsCompanySiteEo.getLogisticsSiteName());
            }
        }
        List warehouseAddressEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseAddressDas.filter().eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).list();
        PrintLogisticsAddressDto senderAddressDto = Optional.ofNullable(printLogisticsOrderReqDto.getSendInfo()).orElse(new PrintLogisticsAddressDto());
        if (CollectionUtils.isNotEmpty((Collection)warehouseAddressEoList)) {
            WarehouseAddressEo csWarehouseAddressEo = (WarehouseAddressEo)warehouseAddressEoList.get(0);
            senderAddressDto.setProvince(csWarehouseAddressEo.getProvince());
            senderAddressDto.setCity((String)StringUtils.defaultIfBlank((CharSequence)senderAddressDto.getCity(), (CharSequence)csWarehouseAddressEo.getCity()));
            senderAddressDto.setDistrict((String)StringUtils.defaultIfBlank((CharSequence)senderAddressDto.getDistrict(), (CharSequence)csWarehouseAddressEo.getDistrict()));
            senderAddressDto.setStreet(senderAddressDto.getStreet());
            senderAddressDto.setAddr((String)StringUtils.defaultIfBlank((CharSequence)senderAddressDto.getAddr(), (CharSequence)csWarehouseAddressEo.getDetailAddress()));
            senderAddressDto.setMobile(csWarehouseAddressEo.getPhone());
            senderAddressDto.setName(csWarehouseAddressEo.getContacts());
            senderAddressDto.setPrintAddr((String)StringUtils.defaultIfBlank((CharSequence)senderAddressDto.getAddr(), (CharSequence)csWarehouseAddressEo.getDetailAddress()));
        }
        printLogisticsOrderReqDto.setSendInfo(senderAddressDto);
        PrintLogisticsAddressDto recInfoAddressDto = new PrintLogisticsAddressDto();
        recInfoAddressDto.setProvince(reqDto.getProvince());
        recInfoAddressDto.setCity(reqDto.getCity());
        recInfoAddressDto.setDistrict(reqDto.getArea());
        recInfoAddressDto.setAddr(reqDto.getAddr());
        recInfoAddressDto.setMobile(reqDto.getContactPhone());
        recInfoAddressDto.setName(reqDto.getContact());
        recInfoAddressDto.setStreet(reqDto.getStreet());
        recInfoAddressDto.setPrintAddr(reqDto.getAddress());
        printLogisticsOrderReqDto.setRecInfo(recInfoAddressDto);
        this.setCargoRemark(deliveryCombine, printLogisticsOrderReqDto);
        logger.info("\u521b\u5efa\u7535\u5b50\u9762\u5355\u57fa\u7840\u4fe1\u606f\u83b7\u53d6:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)printLogisticsOrderReqDto));
        return printLogisticsOrderReqDto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPlatform(String sourcePlatformCode, Integer orderSource, Integer addressModified) {
        if (!StringUtils.isBlank((CharSequence)this.source)) {
            if (!CollectionUtils.isEmpty((Collection)Lists.newArrayList((Object[])this.source.split(",")).stream().filter(sourcePlatformCode::contains).collect(Collectors.toList()))) return false;
        }
        if (Objects.equals(orderSource, 0)) return false;
        if (Objects.equals(addressModified, 1)) return false;
        return true;
    }

    private void wrapperAddress(LogisticsPlatformShopEo logisticsPlatformShopEo, PrintLogisticsOrderReqDto printLogisticsOrderReqDto) {
        JSONObject jsonObject = JSONUtil.parseObj((String)logisticsPlatformShopEo.getDeliveryAddress());
        PrintLogisticsAddressDto printLogisticsAddressDto = new PrintLogisticsAddressDto();
        printLogisticsAddressDto.setCity(jsonObject.getStr((Object)"cityName"));
        printLogisticsAddressDto.setProvince(jsonObject.getStr((Object)"provinceName"));
        printLogisticsAddressDto.setDistrict(jsonObject.getStr((Object)"countrysideName"));
        printLogisticsAddressDto.setStreet(jsonObject.getStr((Object)"streetName"));
        printLogisticsAddressDto.setAddr(jsonObject.getStr((Object)"address"));
        printLogisticsOrderReqDto.setSendInfo(printLogisticsAddressDto);
    }

    private String buildMatchKey(LinkSelectTypeEnum linkSelectTypeEnum, String code, LinkSuitTypeEnum linkSuitTypeEnum) {
        return String.join((CharSequence)InventoryConfig.getCommonSeparate(), linkSelectTypeEnum.code, linkSuitTypeEnum.code, code);
    }

    private LogisticsCompanySiteEo getLogisticsCompanySiteDto(InOutNoticeOrderDto outNoticeOrderRespDto) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsCompanySiteDas.filter().eq((Object)"logistics_company_code", (Object)outNoticeOrderRespDto.getShipmentEnterpriseCode())).eq((Object)"status", (Object)1)).orderByDesc((Object)"id")).list();
        AssertUtil.assertNotEmpty((Collection)list, (String)"\u672a\u914d\u7f6e\u7269\u6d41\u7f51\u70b9\u6708\u7ed3\u8d26\u53f7", (Object[])new Object[0]);
        return (LogisticsCompanySiteEo)list.get(0);
    }

    private void noticeAdvancedShipping(LogisticsDeliveryOrderRespDto logisticsDelivery) {
        AdvancedShippingDto shippingDto = new AdvancedShippingDto();
        shippingDto.setOutNoticeOrderNo(logisticsDelivery.getDocumentNo());
        log.info("noticeAdvancedShipping \u53d6\u53f7\u6210\u529f\u9884\u53d1\u8d27\u6570\u636e\u7ec4\u88c5\u53d1\u9001\u6d88\u606f\uff1a{}", (Object)logisticsDelivery.getDocumentNo());
        this.commonsMqService.sendSingleMessage("NOTICE_ADVANCED_SHIPPING_TAG", (Object)JSON.toJSONString((Object)shippingDto));
    }

    @Deprecated
    private void setPrintMark(DeliveryCombineDto deliveryCombine, PrintLogisticsConfigurationDto printLogisticsConfigurationDto, PrintLogisticsOrderReqDto printLogisticsOrderReqDto, LogicWarehouseEo LogicWarehouseEo2, CreateShipOrderReqDto reqDto) {
        HashMap<String, String> varMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)LogicWarehouseEo2.getWarehouseName())) {
            varMap.put("warehouseName", LogicWarehouseEo2.getWarehouseName());
        }
        InOutNoticeOrderDto outNoticeOrderRespDto = deliveryCombine.getOutNoticeOrderRespDto();
        List outNoticeOrderDetailRespDtoList = deliveryCombine.getOutNoticeOrderDetailRespDtoList();
        if (StringUtils.isNotBlank((CharSequence)outNoticeOrderRespDto.getShopName())) {
            varMap.put("shopName", outNoticeOrderRespDto.getShopName());
        }
        LogisticsPrintTemplateRespDto logisticsPrintTemplateRespDto = printLogisticsConfigurationDto.getLogisticsPrintTemplateRespDto();
        if (PrintIsSupportEnum.SUPPORT.getCode().equals(logisticsPrintTemplateRespDto.getPrintItem())) {
            StringBuilder itemMsg = new StringBuilder();
            outNoticeOrderDetailRespDtoList.forEach(deliveryItemDto -> itemMsg.append(deliveryItemDto.getCargoName()).append("*").append(deliveryItemDto.getPlanQuantity().stripTrailingZeros().toPlainString()).append(";"));
            if (StringUtils.isNotBlank((CharSequence)itemMsg.toString())) {
                varMap.put("item", itemMsg.toString());
            }
        }
        printLogisticsOrderReqDto.setCargo(((CsOutNoticeOrderDetailRespDto)outNoticeOrderDetailRespDtoList.get(0)).getSkuName());
        if (PrintIsSupportEnum.SUPPORT.getCode().equals(logisticsPrintTemplateRespDto.getPrintRemark())) {
            if (StringUtils.isNotBlank((CharSequence)reqDto.getBuyerRemark())) {
                varMap.put("buyerRemark", reqDto.getBuyerRemark());
            }
            if (StringUtils.isNotBlank((CharSequence)reqDto.getRemark())) {
                varMap.put("remark", reqDto.getRemark());
            }
        }
        String remark = this.getRemark(varMap);
        printLogisticsOrderReqDto.setRemark(remark);
    }

    private void setCargoRemark(DeliveryCombineDto deliveryCombine, PrintLogisticsOrderReqDto printLogisticsOrderReqDto) {
        ArrayList remark = new ArrayList();
        String skuNameConfig = this.getSkuNameConfig();
        deliveryCombine.getOutNoticeOrderDetailRespDtoList().forEach(outNoticeOrderDetail -> {
            String skuName = this.getSkuName((CsOutNoticeOrderDetailRespDto)outNoticeOrderDetail, skuNameConfig);
            String rn = "\r\n";
            remark.add(rn + "[ " + skuName + " " + outNoticeOrderDetail.getWaitQuantity().intValue() + "]");
        });
        String cargoRemark = String.join((CharSequence)"", remark);
        printLogisticsOrderReqDto.setRemark(cargoRemark.length() > 200 ? StringUtils.substring((String)cargoRemark, (int)0, (int)200) : cargoRemark);
        String cargoName = ((CsOutNoticeOrderDetailRespDto)deliveryCombine.getOutNoticeOrderDetailRespDtoList().get(0)).getSkuName();
        printLogisticsOrderReqDto.setCargo(cargoName.length() > 20 ? StringUtils.substring((String)cargoName, (int)0, (int)20) : cargoName);
    }

    public String getSkuNameConfig() {
        SendOrderStrategyPageReqDto pageReqDto = new SendOrderStrategyPageReqDto();
        pageReqDto.setType("WAREHOUSE_CONFIGURATION");
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sendOrderStrategyApiProxy.page(pageReqDto));
        String extension = null;
        if (pageInfo == null || CollectionUtil.isEmpty((Collection)pageInfo.getList()) || StringUtils.isBlank((CharSequence)(extension = ((SendOrderStrategyDto)pageInfo.getList().get(0)).getExtension()))) {
            return DefaultConstants.NAME.SKU_NAME.name();
        }
        return (String)com.alibaba.fastjson.JSONObject.parseObject((String)extension).getOrDefault((Object)"getSkuNameConfig", (Object)DefaultConstants.NAME.SKU_NAME.name());
    }

    private String getSkuName(CsOutNoticeOrderDetailRespDto respDto, String nameConfig) {
        String skuName = respDto.getSkuName();
        if (DefaultConstants.NAME.SKU_DISPLAY_NAME.name().equals(nameConfig) && StringUtils.isNotBlank((CharSequence)respDto.getSkuDisplayName())) {
            skuName = respDto.getSkuDisplayName();
        }
        return skuName;
    }

    public String getRemark(Map<String, String> varMap) {
        ArrayList<String> remark = new ArrayList<String>();
        if (varMap.containsKey("item")) {
            remark.add("\u3010\u5546\u54c1\u4fe1\u606f\u3011:" + varMap.get("item"));
        }
        if (varMap.containsKey("buyerRemark")) {
            remark.add("\u3010\u4e70\u5bb6\u5907\u6ce8\u3011:" + varMap.get("buyerRemark"));
        }
        if (varMap.containsKey("shopName")) {
            remark.add("\u3010\u5e97\u94fa\u540d\u79f0\u3011:" + varMap.get("shopName"));
        }
        if (varMap.containsKey("warehouseName")) {
            remark.add("\u3010\u4ed3\u5e93\u540d\u79f0\u3011:" + varMap.get("warehouseName"));
        }
        if (varMap.containsKey("remark")) {
            remark.add("\u3010\u5185\u90e8\u5907\u6ce8\u3011:" + varMap.get("remark"));
        }
        if (CollectionUtils.isNotEmpty(remark)) {
            return String.join((CharSequence)" \r ", remark).length() > 200 ? StringUtils.substring((String)String.join((CharSequence)" \r ", remark), (int)0, (int)200) : String.join((CharSequence)" \r ", remark);
        }
        return "";
    }

    @Deprecated
    private PrintLogisticsConfigurationDto getOrderRLogisticsPlatformDto(DeliveryCombineDto deliveryCombine, PrintLogisticsOrderReqDto printLogisticsOrderReqDto) {
        PrintLogisticsConfigurationDto printLogisticsConfigurationDto = new PrintLogisticsConfigurationDto();
        InOutNoticeOrderDto outNoticeOrderRespDto = deliveryCombine.getOutNoticeOrderRespDto();
        String shopCode = outNoticeOrderRespDto.getShopCode();
        String shippingCompany = outNoticeOrderRespDto.getShipmentEnterpriseCode();
        logger.info("\u83b7\u53d6\u7269\u6d41\u7535\u5b50\u9762\u5355\u6a21\u677f\u4fe1\u606f:{}", (Object)shippingCompany);
        LogisticsPrintTemplateRespDto logisticsPrintTemplateRespDto = new LogisticsPrintTemplateRespDto();
        Integer orderSource = Optional.ofNullable(outNoticeOrderRespDto.getExtension()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(JSON::parseObject).map(r -> r.getInteger("orderSource")).orElse(1);
        if (!Objects.equals(orderSource, 0)) {
            logger.info("\u83b7\u53d6\u5e97\u94fa\u7535\u5b50\u9762\u5355\u6388\u6743\u914d\u7f6e\u4fe1\u606f:{}", (Object)shopCode);
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPlatformShopDas.filter().eq((Object)"shop_code", (Object)shopCode)).eq((Object)"auth_state", (Object)AuthStateEnum.AUTHORIZED.getCode())).orderByDesc((Object)"id")).list();
            AssertUtil.assertNotEmpty((Collection)list, (String)"\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u7535\u5b50\u9762\u5355\u5df2\u6388\u6743\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
            LogisticsPlatformShopEo logisticsPlatformShopEo = (LogisticsPlatformShopEo)list.get(0);
            LogisticsPlatformShopRespDto logisticsPlatformShopRespDto = new LogisticsPlatformShopRespDto();
            CubeBeanUtils.copyProperties((Object)logisticsPlatformShopRespDto, (Object)logisticsPlatformShopEo, (String[])new String[0]);
            printLogisticsConfigurationDto.setLogisticsPlatformShopRespDto(logisticsPlatformShopRespDto);
            printLogisticsOrderReqDto.setLogisticsPlatformCode(logisticsPlatformShopEo.getPlatformCode());
            printLogisticsOrderReqDto.setChannelCode(logisticsPlatformShopEo.getChannelCode());
            printLogisticsOrderReqDto.setShopCode(logisticsPlatformShopEo.getShopCode());
            List templateEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPrintTemplateDas.filter().eq((Object)"olp_id", (Object)logisticsPlatformShopEo.getId())).eq((Object)"logistics_company_code", (Object)shippingCompany)).orderByDesc((Object)"id")).list();
            AssertUtil.assertNotEmpty((Collection)templateEoList, (String)"\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u7535\u5b50\u9762\u5355\u914d\u7f6e\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
            LogisticsPrintTemplateEo logisticsPrintTemplateEo = (LogisticsPrintTemplateEo)templateEoList.get(0);
            CubeBeanUtils.copyProperties((Object)logisticsPrintTemplateRespDto, (Object)logisticsPrintTemplateEo, (String[])new String[0]);
            this.setTemplateByTemplateType(logisticsPrintTemplateEo, printLogisticsOrderReqDto);
            printLogisticsOrderReqDto.setCustomerAccountType(CustomerAccountTypeEnum.THIRD.getCode());
        } else {
            LogisticsKuaidiTemplateEo templateEo = (LogisticsKuaidiTemplateEo)((ExtQueryChainWrapper)this.logisticsKuaidiTemplateDas.filter().eq((Object)"logistics_company_code", (Object)shippingCompany)).one();
            AssertUtil.assertNotNull((Object)templateEo, (String)"\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u7535\u5b50\u9762\u5355\u914d\u7f6e\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
            CubeBeanUtils.copyProperties((Object)logisticsPrintTemplateRespDto, (Object)templateEo, (String[])new String[0]);
            printLogisticsOrderReqDto.setTempCode(templateEo.getTemplateCode());
            printLogisticsOrderReqDto.setChildTempCode(templateEo.getChildTemplateCode());
            printLogisticsOrderReqDto.setCustomerAccountType(CustomerAccountTypeEnum.EXPRESS.getCode());
        }
        printLogisticsConfigurationDto.setLogisticsPrintTemplateRespDto(logisticsPrintTemplateRespDto);
        return printLogisticsConfigurationDto;
    }

    private void setTemplateByTemplateType(LogisticsPrintTemplateEo logisticsPrintTemplateEo, PrintLogisticsOrderReqDto printLogisticsOrderReqDto) {
        if (PrintTemplateTypeEnum.EXPRESS_TEMPLATE.getCode().equals(logisticsPrintTemplateEo.getPrintTemplateType())) {
            printLogisticsOrderReqDto.setThirdTemplateURL(logisticsPrintTemplateEo.getPrintTemplateValue());
        } else if (PrintTemplateTypeEnum.PLATFORM_CUSTOMIZATION_TEMPLATE.getCode().equals(logisticsPrintTemplateEo.getPrintTemplateType())) {
            printLogisticsOrderReqDto.setThirdCustomTemplateUrl(logisticsPrintTemplateEo.getPrintTemplateValue());
        } else if (PrintTemplateTypeEnum.PLATFORM_STANDARD_TEMPLATE.getCode().equals(logisticsPrintTemplateEo.getPrintTemplateType())) {
            printLogisticsOrderReqDto.setThirdTemplateURL(logisticsPrintTemplateEo.getPrintTemplateValue());
        }
    }

    public PrintLogisticsOrderRespDto syncCreateShipOrder(PrintLogisticsOrderReqDto printLogisticsOrder) {
        RestResponse<StdPrintLogisticsOrderExtRespDto> printLogisticsRespDto;
        this.validPrintLogistics(printLogisticsOrder);
        StdPrintLogisticsOrderReqDto channelReqDto = this.buildPrintLogisticsReqDto(printLogisticsOrder);
        LogisticsPrintRecordEo logisticsPrintRecordEo = this.saveLogisticsPrintRecordEo(printLogisticsOrder);
        logger.info("\u8c03\u7528\u63a5\u53e3\u4e2d\u5fc3\u521b\u5efa\u7535\u5b50\u9762\u5355\u5165\u53c2:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)channelReqDto));
        if (!InventoryConfig.isPadModule(logisticsPrintRecordEo.getLogisticsPlatformCode())) {
            WaybillIiGetReqDto reqDto = (WaybillIiGetReqDto)BeanUtil.copyProperties((Object)channelReqDto, WaybillIiGetReqDto.class, (String[])new String[0]);
            reqDto.setSaleOrderNo(printLogisticsOrder.getSaleOrderNo());
            reqDto.setIsPlatformOrderFlag(printLogisticsOrder.getIsPlatformOrderFlag());
            reqDto.setPlatformOrderChannelCode(this.getPlatformOrderChannelCode(printLogisticsOrder.getOutNoticeOrderRespDto()));
            reqDto.setLogisticsCode(channelReqDto.getLogisticsCompanyCode());
            reqDto.setSettlementCode(printLogisticsOrder.getLogisticsSiteCode());
            reqDto.setChannelCode(printLogisticsOrder.getLogisticsPlatformCode());
            reqDto.setTemplateUrl(channelReqDto.getThirdTemplateURL());
            reqDto.setWaybillIiCount(Integer.valueOf(channelReqDto.getCount()));
            reqDto.setSenderAddress(this.getWaybillIiAddressDto(channelReqDto.getSendInfo()));
            reqDto.setReceiveAddress(this.getWaybillIiAddressDto(channelReqDto.getRecInfo()));
            reqDto.getReceiveAddress().setOaid(channelReqDto.getOaId());
            if (this.distributionOrderNoSource.contains(printLogisticsOrder.getOutNoticeOrderRespDto().getSourcePlatformCode())) {
                log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u5206\u9500\u5355\u53f7\u67e5\u8be2:{}", (Object)printLogisticsOrder.getOutNoticeOrderRespDto().getRelevanceNo());
                Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.performOrderQueryApi.queryByOrderNo(printLogisticsOrder.getOutNoticeOrderRespDto().getRelevanceNo()))).filter(r -> StringUtils.isNotBlank((CharSequence)r.getOrderSourceSystemCode()) && this.distributionOrderNoSourceSystem.contains(r.getOrderSourceSystemCode())).ifPresent(r -> reqDto.setIsPlatformOrderFlag(Boolean.valueOf(false)));
            }
            reqDto.setPlatformOrderNo(StringUtils.isNotBlank((CharSequence)channelReqDto.getOaId()) ? this.transferPlatFormOrderNo(printLogisticsOrder.getThirdOrderNo(), printLogisticsOrder.getOutNoticeOrderRespDto().getSourcePlatformCode(), printLogisticsOrder.getOutNoticeOrderRespDto().getOaidOrderSourceCode(), printLogisticsOrder.getOutNoticeOrderRespDto().getRelevanceNo()) : printLogisticsOrder.getThirdOrderNo());
            reqDto.setTakeTaskKey(String.valueOf(logisticsPrintRecordEo.getId()));
            boolean splitPackage = reqDto.getWaybillIiCount() > 1;
            HashMap packageMap = new HashMap();
            HashMap packageSortMap = new HashMap();
            if (splitPackage) {
                AtomicInteger atomicInteger = new AtomicInteger(1);
                reqDto.setItemInfoList(printLogisticsOrder.getDeliveryItems().stream().flatMap(r -> {
                    ArrayList<WaybillIiItemInfoDto> waybillIiItemInfoDtos = new ArrayList<WaybillIiItemInfoDto>();
                    BigDecimal planQuti = r.getPlanQuantity();
                    for (int i = 0; i < planQuti.intValue(); ++i) {
                        WaybillIiItemInfoDto waybillIiItemInfoDto = new WaybillIiItemInfoDto();
                        waybillIiItemInfoDto.setPackageCode(System.currentTimeMillis() + "" + atomicInteger.get());
                        packageMap.put(waybillIiItemInfoDto.getPackageCode(), r.getId());
                        packageSortMap.put(atomicInteger.get(), r.getId());
                        waybillIiItemInfoDto.setSkuCode(r.getSkuCode());
                        waybillIiItemInfoDto.setSkuName(r.getSkuName());
                        waybillIiItemInfoDto.setQuantity(Integer.valueOf(1));
                        waybillIiItemInfoDto.setWeight(ExtensionUtil.parseJson(r.getExtension()).getBigDecimal("weight"));
                        waybillIiItemInfoDto.setVolume(ExtensionUtil.parseJson(r.getExtension()).getBigDecimal("volume"));
                        waybillIiItemInfoDtos.add(waybillIiItemInfoDto);
                        atomicInteger.getAndIncrement();
                    }
                    return waybillIiItemInfoDtos.stream();
                }).collect(Collectors.toList()));
            } else {
                reqDto.setItemInfoList(printLogisticsOrder.getDeliveryItems().stream().map(r -> {
                    WaybillIiItemInfoDto waybillIiItemInfoDto = new WaybillIiItemInfoDto();
                    waybillIiItemInfoDto.setPackageCode(System.currentTimeMillis() + "" + 1);
                    waybillIiItemInfoDto.setSkuCode(r.getSkuCode());
                    waybillIiItemInfoDto.setSkuName(r.getSkuName());
                    waybillIiItemInfoDto.setQuantity(Integer.valueOf(r.getPlanQuantity().intValue()));
                    waybillIiItemInfoDto.setWeight(ExtensionUtil.parseJson(r.getExtension()).getBigDecimal("weight"));
                    waybillIiItemInfoDto.setVolume(ExtensionUtil.parseJson(r.getExtension()).getBigDecimal("volume"));
                    return waybillIiItemInfoDto;
                }).collect(Collectors.toList()));
            }
            reqDto.setWaybillIiCount(null);
            log.info("\u8c03\u7528\u63a5\u53e3\u4e2d\u5fc3\u6253\u5370\u7535\u5b50\u9762\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)reqDto));
            List waybillIiGetRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.waybillApi.waybillGet(reqDto));
            log.info("\u8c03\u7528\u63a5\u53e3\u4e2d\u5fc3\u6253\u5370\u7535\u5b50\u9762\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)waybillIiGetRespDtos));
            AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)waybillIiGetRespDtos), (String)"\u53d6\u53f7\u5f02\u5e38");
            printLogisticsRespDto = this.callPrint(waybillIiGetRespDtos, channelReqDto, reqDto, logisticsPrintRecordEo, printLogisticsOrder);
            StdPrintLogisticsOrderExtRespDto data = (StdPrintLogisticsOrderExtRespDto)printLogisticsRespDto.getData();
            if (reqDto.getItemInfoList().size() == 1) {
                data.setSkuShippingMap(printLogisticsOrder.getDeliveryItems().stream().collect(Collectors.toMap(BaseRespDto::getId, r -> Lists.newArrayList((Object[])new String[]{((WaybillIiGetRespDto)waybillIiGetRespDtos.get(0)).getWaybillCode()}))));
            } else {
                AtomicInteger count = new AtomicInteger(1);
                waybillIiGetRespDtos.forEach(r -> {
                    Long l = (Long)packageMap.getOrDefault(r.getObjectId(), packageSortMap.get(count.get()));
                    data.getSkuShippingMap().compute(l, (k, v) -> {
                        if (CollectionUtils.isEmpty((Collection)v)) {
                            return Lists.newArrayList((Object[])new String[]{r.getWaybillCode()});
                        }
                        v.add(r.getWaybillCode());
                        return v;
                    });
                    count.getAndIncrement();
                });
            }
        } else {
            printLogisticsRespDto = this.kuaidi100CreateShipOrderCall(printLogisticsOrder, channelReqDto, logisticsPrintRecordEo);
        }
        this.updatePrintInfo4CreateShipOrder(logisticsPrintRecordEo, (StdPrintLogisticsOrderExtRespDto)printLogisticsRespDto.getData(), printLogisticsRespDto.getResultMsg(), printLogisticsRespDto.getResultCode());
        return this.buildPrintLogisticsRespDto(logisticsPrintRecordEo, (StdPrintLogisticsOrderExtRespDto)printLogisticsRespDto.getData(), printLogisticsOrder.getDeliveryItems());
    }

    private String transferPlatFormOrderNo(String thirdOrderNo, String sourcePlatformCode, String oaidOrderSourceCode, String orderSourceCode) {
        if (this.oaidSource.contains(sourcePlatformCode)) {
            com.alibaba.fastjson.JSONObject filterJson = new com.alibaba.fastjson.JSONObject();
            filterJson.put("platform_order_no", (Object)thirdOrderNo);
            PageInfo sourceRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.trSourceQueryApi.queryByPage(filterJson.toJSONString(), Integer.valueOf(1), Integer.valueOf(1)));
            if (CollectionUtils.isNotEmpty((Collection)sourceRespDtoPageInfo.getList())) {
                TfSourceRespDto tfSourceRespDto = (TfSourceRespDto)sourceRespDtoPageInfo.getList().get(0);
                JSONObject jsonObject = JSONUtil.parseObj((String)tfSourceRespDto.getOrgContent());
                String byPath = (String)jsonObject.getByPath("request.receiverInfo.oaidSourceCode");
                return (String)ObjectUtil.defaultIfBlank((CharSequence)byPath, (CharSequence)Optional.ofNullable(oaidOrderSourceCode).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(thirdOrderNo));
            }
            return Optional.ofNullable(oaidOrderSourceCode).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(thirdOrderNo);
        }
        if (this.distributionOrderNoSource.contains(sourcePlatformCode)) {
            log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u5206\u9500\u5355\u53f7\u8f6c\u6362:{}", (Object)orderSourceCode);
            return Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.performOrderQueryApi.queryByOrderNo(orderSourceCode))).filter(r -> this.distributionOrderNoSourceSystem.contains(r.getOrderSourceSystemCode())).map(DgPerformOrderInfoDto::getDistributionOrderNo).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(thirdOrderNo);
        }
        return thirdOrderNo;
    }

    private String getPlatformOrderChannelCode(InOutNoticeOrderDto outNoticeOrderRespDto) {
        if (StringUtils.isBlank((CharSequence)outNoticeOrderRespDto.getSourcePlatformCode())) {
            return null;
        }
        switch (outNoticeOrderRespDto.getSourcePlatformCode()) {
            case "suningLingShouYun": 
            case "suningchangsong": {
                return "TB";
            }
            case "tmallyoupin": {
                return "TB";
            }
            case "jdcs": 
            case "jingdong": {
                return "JD";
            }
            case "douyinfenxiao": {
                return "douyinfenxiao";
            }
        }
        return "";
    }

    @NotNull
    private RestResponse<StdPrintLogisticsOrderExtRespDto> kuaidi100CreateShipOrderCall(PrintLogisticsOrderReqDto printLogisticsOrder, StdPrintLogisticsOrderReqDto channelReqDto, LogisticsPrintRecordEo logisticsPrintRecordEo) {
        RestResponse printLogisticsDtoResp = this.kuaidi100ApiProxy.getLogistics(channelReqDto);
        RestResponse printLogisticsRespDto = (RestResponse)BeanUtil.copyProperties((Object)printLogisticsDtoResp, RestResponse.class, (String[])new String[]{"data"});
        printLogisticsRespDto.setData(BeanUtil.copyProperties((Object)printLogisticsDtoResp.getData(), StdPrintLogisticsOrderExtRespDto.class, (String[])new String[0]));
        StdPrintLogisticsOrderExtRespDto respDto = (StdPrintLogisticsOrderExtRespDto)printLogisticsRespDto.getData();
        logger.info("\u8c03\u7528\u63a5\u53e3\u4e2d\u5fc3\u521b\u5efa\u7535\u5b50\u9762\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)printLogisticsRespDto));
        HashMap<Object, Object> shippingUrlMap = new HashMap<Object, Object>();
        HashMap itemShippingNoMap = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)respDto.getSubShippingNo())) {
            List subShippingList = Stream.of(respDto.getSubShippingNo().split(",")).collect(Collectors.toList());
            subShippingList.add(respDto.getShippingNo());
            List printList = Stream.of(Optional.ofNullable(respDto.getPrintUrl()).orElse("").split(",")).collect(Collectors.toList());
            for (int i = 0; i < subShippingList.size(); ++i) {
                shippingUrlMap.put(subShippingList.get(i), printList.get(Math.min(printList.size() - 1, i)));
            }
            AtomicInteger integer = new AtomicInteger(0);
            int size = subShippingList.size();
            printLogisticsOrder.getDeliveryItems().forEach(r -> {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < r.getPlanQuantity().intValue(); ++i) {
                    arrayList.add(subShippingList.get(Math.min(integer.getAndIncrement(), size - 1)));
                }
                itemShippingNoMap.put(r.getId(), arrayList);
            });
        } else {
            shippingUrlMap.put(respDto.getShippingNo(), logisticsPrintRecordEo.getPrintImageUrl());
            printLogisticsOrder.getDeliveryItems().forEach(r -> {
                List cfr_ignored_0 = itemShippingNoMap.put(r.getId(), Lists.newArrayList((Object[])new String[]{respDto.getShippingNo()}));
            });
        }
        respDto.setShippingUrlMap(shippingUrlMap);
        respDto.setSkuShippingMap(itemShippingNoMap);
        return printLogisticsRespDto;
    }

    @NotNull
    private RestResponse<StdPrintLogisticsOrderExtRespDto> callPrint(List<WaybillIiGetRespDto> waybillIiGetRespDtos, StdPrintLogisticsOrderReqDto channelReqDto, WaybillIiGetReqDto reqDto, LogisticsPrintRecordEo logisticsPrintRecordEo, PrintLogisticsOrderReqDto printLogisticsOrder) {
        HashMap shippingUrlMap = new HashMap();
        Map<String, List<WaybillIiItemInfoDto>> iiItemInfoDtoMap = reqDto.getItemInfoList().stream().peek(r -> r.setPackageCode((String)ObjectUtil.defaultIfBlank((CharSequence)r.getPackageCode(), (CharSequence)"1"))).collect(Collectors.groupingBy(WaybillIiItemInfoDto::getPackageCode));
        Map<String, DgItemSkuDetailRespDto> skuDetailRespDtoMap = this.itemDetailDataQueryHelper.getByCodes(reqDto.getItemInfoList().stream().map(WaybillIiItemInfoDto::getSkuCode).collect(Collectors.toList())).stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (o, o1) -> o));
        Map<String, ItemSkuDto> skuRespDtoMap = this.itemDataQueryHelper.getByCodes(reqDto.getItemInfoList().stream().map(WaybillIiItemInfoDto::getSkuCode).collect(Collectors.toList())).stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o, o1) -> o));
        HashMap<Long, DirRespDto> dirMap = new HashMap<Long, DirRespDto>();
        if (reqDto.getItemInfoList().size() == 1) {
            WaybillIiGetRespDto waybillIiGetRespDto = waybillIiGetRespDtos.get(0);
            RestResponse printLogisticsRespDto = new RestResponse();
            StdPrintLogisticsOrderExtRespDto respDto = new StdPrintLogisticsOrderExtRespDto();
            respDto.setShippingNo((String)StringUtils.defaultIfEmpty((CharSequence)waybillIiGetRespDto.getParentWaybillCode(), (CharSequence)waybillIiGetRespDto.getWaybillCode()));
            respDto.setPrintData(waybillIiGetRespDto.getPrintData());
            respDto.setChannelCode(channelReqDto.getLogisticsPlatformCode());
            WaybillIiGetPrintDataRespDto printDataRespDto = waybillIiGetRespDto.getWaybillIiGetPrintDataRespDto();
            WaybillPrintReqDto waybillPrintReqDto2 = new WaybillPrintReqDto();
            waybillPrintReqDto2.setChannelCode(reqDto.getChannelCode());
            waybillPrintReqDto2.setShopCode(reqDto.getShopCode());
            waybillPrintReqDto2.setFirstDocumentNumber(Integer.valueOf(1));
            waybillPrintReqDto2.setPreview(false);
            waybillPrintReqDto2.setTotalDocumentCount(Integer.valueOf(1));
            waybillPrintReqDto2.setTaskId(String.valueOf(logisticsPrintRecordEo.getId()));
            WaybillPrintDocumentReqDto waybillPrintDocumentReqDto = new WaybillPrintDocumentReqDto();
            waybillPrintDocumentReqDto.setPrintContents(respDto.getPrintData());
            waybillPrintDocumentReqDto.setTemplateUrl(reqDto.getTemplateUrl());
            waybillPrintDocumentReqDto.setWaybillCode(waybillIiGetRespDto.getWaybillCode());
            if (StringUtils.isNotBlank((CharSequence)channelReqDto.getThirdCustomTemplateUrl())) {
                ArrayList<WaybillPrintTemplateReqDto> waybillPrintTemplateReqDtoList = new ArrayList<WaybillPrintTemplateReqDto>();
                WaybillPrintTemplateReqDto waybillPrintTemplateReqDto = new WaybillPrintTemplateReqDto();
                waybillPrintTemplateReqDto.setTemplateUrl(channelReqDto.getThirdCustomTemplateUrl());
                com.alibaba.fastjson.JSONObject data = new com.alibaba.fastjson.JSONObject();
                data.put("itemList", (Object)reqDto.getItemInfoList());
                InOutNoticeOrderDto outNoticeOrderRespDto = printLogisticsOrder.getOutNoticeOrderRespDto();
                String storeinfo = this.getStoreinfo(outNoticeOrderRespDto);
                data.put("storeinfo", (Object)storeinfo);
                data.put("store", (Object)storeinfo);
                String allotMsg = this.getAllotMsg(reqDto.getItemInfoList(), skuDetailRespDtoMap, dirMap, skuRespDtoMap);
                data.put("allotMsg", (Object)allotMsg);
                data.put("info", (Object)allotMsg);
                waybillPrintTemplateReqDto.setData(data.toJSONString());
                waybillPrintTemplateReqDtoList.add(waybillPrintTemplateReqDto);
                waybillPrintDocumentReqDto.setWaybillPrintTemplateReqDtoList(waybillPrintTemplateReqDtoList);
            }
            waybillPrintReqDto2.setWaybillPrintDocumentReqDtoList((List)Lists.newArrayList((Object[])new WaybillPrintDocumentReqDto[]{waybillPrintDocumentReqDto}));
            log.info("\u8c03\u7528\u63a5\u53e3\u4e2d\u5fc3\u6253\u5370\u7535\u5b50\u9762\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)waybillPrintReqDto2));
            this.addTask(logisticsPrintRecordEo, waybillPrintReqDto2);
            respDto.setReturnCode(PrintReturnStatusEnum.GET_PRINT_RETURN_SUCCESS.getCode());
            respDto.setTaskId(String.valueOf(logisticsPrintRecordEo.getId()));
            respDto.setShippingUrlMap(shippingUrlMap);
            respDto.setChannelCode(channelReqDto.getLogisticsPlatformCode());
            respDto.setMessage(JSONUtil.toJsonStr((Object)printDataRespDto));
            printLogisticsRespDto.setData((Object)respDto);
            return printLogisticsRespDto;
        }
        RestResponse printLogisticsRespDto = new RestResponse();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ArrayList<WaybillPrintReqDto> waybillPrintReqDtoList = new ArrayList<WaybillPrintReqDto>();
        ArrayList<LogisticsPrintReqTaskEo> logisticsPrintReqTaskEos = new ArrayList<LogisticsPrintReqTaskEo>();
        for (WaybillIiGetRespDto waybillIiGetRespDto : waybillIiGetRespDtos) {
            WaybillPrintReqDto waybillPrintReqDto3 = this.buildPrintDto(channelReqDto, reqDto, logisticsPrintRecordEo, printLogisticsOrder, waybillIiGetRespDto, atomicInteger, iiItemInfoDtoMap, skuDetailRespDtoMap, dirMap, skuRespDtoMap);
            atomicInteger.getAndIncrement();
            waybillPrintReqDtoList.add(waybillPrintReqDto3);
            logisticsPrintReqTaskEos.add(this.buildTaskEo(logisticsPrintRecordEo, waybillPrintReqDto3));
        }
        this.logisticsPrintReqTaskDomain.insertBatch(logisticsPrintReqTaskEos);
        InventoryConfig.registerSynchronizationAfterCommit(() -> this.sendMqHelper.sendPublishMq(logisticsPrintReqTaskEos.get(0), "logisticsOrderPrint"));
        ArrayList<StdPrintLogisticsOrderExtRespDto> allPrintRespDtos = new ArrayList<StdPrintLogisticsOrderExtRespDto>();
        waybillPrintReqDtoList.forEach(waybillPrintReqDto -> {
            StdPrintLogisticsOrderExtRespDto respDto = new StdPrintLogisticsOrderExtRespDto();
            respDto.setShippingNo(((WaybillPrintDocumentReqDto)waybillPrintReqDto.getWaybillPrintDocumentReqDtoList().get(0)).getWaybillCode());
            respDto.setChannelCode(channelReqDto.getLogisticsPlatformCode());
            respDto.setTaskId(String.valueOf(logisticsPrintRecordEo.getId()));
            respDto.setReturnCode(PrintReturnStatusEnum.GET_PRINT_RETURN_SUCCESS.getCode());
            allPrintRespDtos.add(respDto);
        });
        StdPrintLogisticsOrderExtRespDto respDto = this.mergePrintResp(allPrintRespDtos);
        List waybillCodes = waybillIiGetRespDtos.stream().map(WaybillIiGetRespDto::getWaybillCode).collect(Collectors.toList());
        String waybillCode = waybillIiGetRespDtos.stream().map(WaybillIiGetRespDto::getParentWaybillCode).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).findFirst().orElse((String)waybillCodes.get(0));
        respDto.setShippingNo(waybillCode);
        respDto.setSubShippingNo(String.join((CharSequence)",", Optional.of(waybillIiGetRespDtos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getParentWaybillCode()) && !r.getParentWaybillCode().equals(waybillCode)).map(WaybillIiGetRespDto::getWaybillCode).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).orElseGet(() -> waybillIiGetRespDtos.stream().map(WaybillIiGetRespDto::getWaybillCode).filter(code -> !StringUtils.equals((CharSequence)waybillCode, (CharSequence)code)).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList()))));
        respDto.setParentWaybillNos(waybillIiGetRespDtos.stream().map(WaybillIiGetRespDto::getParentWaybillCode).filter(StringUtils::isNotBlank).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList()));
        printLogisticsRespDto.setData((Object)respDto);
        return printLogisticsRespDto;
    }

    private void addTask(LogisticsPrintRecordEo logisticsPrintRecordEo, WaybillPrintReqDto waybillPrintReqDto) {
        LogisticsPrintReqTaskEo logisticsPrintReqTaskEo = this.buildTaskEo(logisticsPrintRecordEo, waybillPrintReqDto);
        this.logisticsPrintReqTaskDomain.insert((BaseEo)logisticsPrintReqTaskEo);
        this.sendMqHelper.sendPublishMq(logisticsPrintReqTaskEo, "logisticsOrderPrint");
    }

    @NotNull
    private LogisticsPrintReqTaskEo buildTaskEo(LogisticsPrintRecordEo logisticsPrintRecordEo, WaybillPrintReqDto waybillPrintReqDto) {
        LogisticsPrintReqTaskEo logisticsPrintReqTaskEo = new LogisticsPrintReqTaskEo();
        logisticsPrintReqTaskEo.setPrintReqContent(com.alibaba.fastjson.JSONObject.toJSONString((Object)waybillPrintReqDto));
        logisticsPrintReqTaskEo.setPrintRetryCount(Integer.valueOf(0));
        logisticsPrintReqTaskEo.setShippingNo(((WaybillPrintDocumentReqDto)waybillPrintReqDto.getWaybillPrintDocumentReqDtoList().get(0)).getWaybillCode());
        logisticsPrintReqTaskEo.setRefRecordId(logisticsPrintRecordEo.getId());
        logisticsPrintReqTaskEo.setStatus("waitProcess");
        return logisticsPrintReqTaskEo;
    }

    private StdPrintLogisticsOrderExtRespDto mergePrintResp(List<StdPrintLogisticsOrderExtRespDto> allPrintRespDtos) {
        log.info("\u5355\u636e\u5168\u90e8\u6253\u5370\u54cd\u5e94:{}", (Object)JSONUtil.toJsonStr(allPrintRespDtos));
        StdPrintLogisticsOrderExtRespDto respDto = allPrintRespDtos.get(0);
        for (StdPrintLogisticsOrderExtRespDto allPrintRespDto : allPrintRespDtos) {
            if (PrintReturnStatusEnum.GET_PRINT_RETURN_SUCCESS.getCode().equals(allPrintRespDto.getReturnCode())) continue;
            return allPrintRespDto;
        }
        return respDto;
    }

    @NotNull
    private WaybillPrintReqDto buildPrintDto(StdPrintLogisticsOrderReqDto channelReqDto, WaybillIiGetReqDto reqDto, LogisticsPrintRecordEo logisticsPrintRecordEo, PrintLogisticsOrderReqDto printLogisticsOrder, WaybillIiGetRespDto waybillIiGetRespDto, AtomicInteger atomicInteger, Map<String, List<WaybillIiItemInfoDto>> iiItemInfoDtoMap, Map<String, DgItemSkuDetailRespDto> skuDetailRespDtoMap, Map<Long, DirRespDto> dirMap, Map<String, ItemSkuDto> skuRespDtoMap) {
        WaybillPrintReqDto waybillPrintReqDto = new WaybillPrintReqDto();
        waybillPrintReqDto.setChannelCode(reqDto.getChannelCode());
        waybillPrintReqDto.setShopCode(reqDto.getShopCode());
        waybillPrintReqDto.setFirstDocumentNumber(Integer.valueOf(1));
        waybillPrintReqDto.setPreview(false);
        waybillPrintReqDto.setTotalDocumentCount(Integer.valueOf(1));
        waybillPrintReqDto.setTaskId(logisticsPrintRecordEo.getId() + "_" + atomicInteger.get());
        WaybillPrintDocumentReqDto waybillPrintDocumentReqDto = new WaybillPrintDocumentReqDto();
        waybillPrintDocumentReqDto.setPrintContents(waybillIiGetRespDto.getPrintData());
        waybillPrintDocumentReqDto.setTemplateUrl(reqDto.getTemplateUrl());
        waybillPrintDocumentReqDto.setWaybillCode(waybillIiGetRespDto.getWaybillCode());
        waybillPrintDocumentReqDto.setPrintContents(waybillIiGetRespDto.getPrintData());
        waybillPrintDocumentReqDto.setTemplateUrl(reqDto.getTemplateUrl());
        waybillPrintDocumentReqDto.setWaybillCode(waybillIiGetRespDto.getWaybillCode());
        if (StringUtils.isNotBlank((CharSequence)channelReqDto.getThirdCustomTemplateUrl())) {
            ArrayList<WaybillPrintTemplateReqDto> waybillPrintTemplateReqDtoList = new ArrayList<WaybillPrintTemplateReqDto>();
            WaybillPrintTemplateReqDto waybillPrintTemplateReqDto = new WaybillPrintTemplateReqDto();
            waybillPrintTemplateReqDto.setTemplateUrl(channelReqDto.getThirdCustomTemplateUrl());
            com.alibaba.fastjson.JSONObject data = new com.alibaba.fastjson.JSONObject();
            InOutNoticeOrderDto outNoticeOrderRespDto = printLogisticsOrder.getOutNoticeOrderRespDto();
            String storeinfo = this.getStoreinfo(outNoticeOrderRespDto);
            data.put("storeinfo", (Object)storeinfo);
            data.put("store", (Object)storeinfo);
            List<WaybillIiItemInfoDto> itemInfoDtoMapOrDefault = iiItemInfoDtoMap.getOrDefault(waybillIiGetRespDto.getObjectId(), Lists.newArrayList((Object[])new WaybillIiItemInfoDto[]{(WaybillIiItemInfoDto)reqDto.getItemInfoList().get(Math.min(reqDto.getItemInfoList().size() - 1, atomicInteger.get()))}));
            String allotMsg = this.getAllotMsg(itemInfoDtoMapOrDefault, skuDetailRespDtoMap, dirMap, skuRespDtoMap);
            data.put("allotMsg", (Object)allotMsg);
            data.put("info", (Object)allotMsg);
            data.put("itemList", itemInfoDtoMapOrDefault);
            waybillPrintTemplateReqDto.setData(data.toJSONString());
            waybillPrintTemplateReqDtoList.add(waybillPrintTemplateReqDto);
            waybillPrintDocumentReqDto.setWaybillPrintTemplateReqDtoList(waybillPrintTemplateReqDtoList);
        }
        waybillPrintReqDto.setWaybillPrintDocumentReqDtoList((List)Lists.newArrayList((Object[])new WaybillPrintDocumentReqDto[]{waybillPrintDocumentReqDto}));
        return waybillPrintReqDto;
    }

    @NotNull
    private String getStoreinfo(InOutNoticeOrderDto outNoticeOrderRespDto) {
        return outNoticeOrderRespDto.getShopName() + "\n#" + outNoticeOrderRespDto.getExternalOrderNo() + "\n";
    }

    @NotNull
    private String getAllotMsg(List<WaybillIiItemInfoDto> itemInfoDtoMapOrDefault, Map<String, DgItemSkuDetailRespDto> skuDetailRespDtoMap, Map<Long, DirRespDto> dirMap, Map<String, ItemSkuDto> skuRespDtoMap) {
        StringBuilder allotMsg = new StringBuilder("\u914d\u8d27\u4fe1\u606f:");
        itemInfoDtoMapOrDefault.forEach(r -> {
            allotMsg.append("\u3010");
            allotMsg.append(r.getSkuCode());
            allotMsg.append("\u3011- ");
            DgItemSkuDetailRespDto dgItemSkuDetailRespDto = skuDetailRespDtoMap.getOrDefault(r.getSkuCode(), new DgItemSkuDetailRespDto());
            ItemSkuDto itemSkuDto = skuRespDtoMap.getOrDefault(r.getSkuCode(), new ItemSkuDto());
            allotMsg.append(dgItemSkuDetailRespDto.getSpecModel());
            allotMsg.append(" - ");
            allotMsg.append(Optional.ofNullable(itemSkuDto.getBarCode()).orElse(""));
            allotMsg.append(" - ");
            allotMsg.append(Optional.ofNullable(dgItemSkuDetailRespDto.getDirName()).orElseGet(() -> Optional.ofNullable(dgItemSkuDetailRespDto.getDirId()).map(dirId -> {
                DirRespDto orDefault = (DirRespDto)dirMap.getOrDefault(dirId, (DirRespDto)ObjectUtil.defaultIfNull((Object)this.itemSkuDgQueryApiProxy.queryDirById(dirId), (Object)new DirRespDto()));
                dirMap.put((Long)dirId, orDefault);
                return ((DirRespDto)dirMap.getOrDefault(dirId, (DirRespDto)ObjectUtil.defaultIfNull((Object)this.itemSkuDgQueryApiProxy.queryDirById(dirId), (Object)new DirRespDto()))).getName();
            }).orElse("")));
            allotMsg.append("(");
            allotMsg.append(r.getQuantity());
            allotMsg.append(")");
            allotMsg.append(Optional.ofNullable(dgItemSkuDetailRespDto.getUnit()).orElse("\u4ef6"));
            allotMsg.append("\n");
        });
        return allotMsg.toString();
    }

    @NotNull
    private WaybillIiAddressDto getWaybillIiAddressDto(StdPrintLogisticsAddressDto sendInfo) {
        WaybillIiAddressDto waybillIiAddressDto = (WaybillIiAddressDto)BeanUtil.copyProperties((Object)sendInfo, WaybillIiAddressDto.class, (String[])new String[0]);
        waybillIiAddressDto.setDetail(StringUtils.defaultString((String)sendInfo.getDetailAddrEnc(), (String)sendInfo.getAddr()));
        waybillIiAddressDto.setCounty(sendInfo.getDistrict());
        waybillIiAddressDto.setContactName(sendInfo.getName());
        waybillIiAddressDto.setContactPhone(StringUtils.defaultString((String)sendInfo.getTel(), (String)sendInfo.getMobile()));
        return waybillIiAddressDto;
    }

    public void validPrintLogistics(PrintLogisticsOrderReqDto printLogisticsReqDto) {
        AssertUtil.assertTrue((printLogisticsReqDto.getBizOrderNo() != null ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertTrue((printLogisticsReqDto.getLogisticsCompanyCode() != null ? 1 : 0) != 0, (String)"\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertTrue((printLogisticsReqDto.getBizPrintType() != null ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
    }

    private StdPrintLogisticsOrderReqDto buildPrintLogisticsReqDto(PrintLogisticsOrderReqDto printLogisticsRespDto) {
        TrLogisticsMappingRelationRespDto trLogisticsMappingRelationRespDto;
        StdPrintLogisticsOrderExtReqDto stdPrintLogisticsOrderReqDto = new StdPrintLogisticsOrderExtReqDto();
        BeanUtils.copyProperties((Object)printLogisticsRespDto, (Object)stdPrintLogisticsOrderReqDto);
        if (!InventoryConfig.isPadModule(printLogisticsRespDto.getLogisticsPlatformCode())) {
            trLogisticsMappingRelationRespDto = (TrLogisticsMappingRelationRespDto)RestResponseHelper.extractData((RestResponse)this.trLogisticsMappingRelationQueryApi.queryByLogisticsCodeAndSystematicCode("PDA", printLogisticsRespDto.getLogisticsCompanyCode(), printLogisticsRespDto.getLogisticsPlatformCode(), null));
            AssertUtils.notNull((Object)trLogisticsMappingRelationRespDto, (String)"{}\u7269\u6d41\u5546\u6620\u5c04\u5173\u7cfb\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u5e73\u53f0\u7269\u6d41\u5546, {}", (Object[])new Object[]{printLogisticsRespDto.getChannelCode(), printLogisticsRespDto.getLogisticsCompanyCode()});
        } else {
            trLogisticsMappingRelationRespDto = (TrLogisticsMappingRelationRespDto)RestResponseHelper.extractData((RestResponse)this.trLogisticsMappingRelationQueryApi.queryByLogisticsCodeAndSystematicCode(null, printLogisticsRespDto.getLogisticsCompanyCode(), "kuaidi100", null));
            AssertUtils.notNull((Object)trLogisticsMappingRelationRespDto, (String)"\u5feb\u9012100\u7269\u6d41\u5546\u6620\u5c04\u5173\u7cfb\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u5e73\u53f0\u7269\u6d41\u5546, {}", (Object[])new Object[]{printLogisticsRespDto.getLogisticsCompanyCode()});
        }
        printLogisticsRespDto.setExternalLogisticsCode(trLogisticsMappingRelationRespDto.getExternalLogisticsCode());
        stdPrintLogisticsOrderReqDto.setLogisticsCompanyCode(trLogisticsMappingRelationRespDto.getExternalLogisticsCode());
        stdPrintLogisticsOrderReqDto.setLogisticsCompanyName(trLogisticsMappingRelationRespDto.getExternalLogisticsName());
        stdPrintLogisticsOrderReqDto.setThirdTemplateURL(printLogisticsRespDto.getThirdTemplateURL());
        stdPrintLogisticsOrderReqDto.setTempCode(printLogisticsRespDto.getTempCode());
        stdPrintLogisticsOrderReqDto.setChildTempCode(printLogisticsRespDto.getChildTempCode());
        stdPrintLogisticsOrderReqDto.setThirdCustomTemplateUrl(printLogisticsRespDto.getThirdCustomTemplateUrl());
        stdPrintLogisticsOrderReqDto.setOrderNo(printLogisticsRespDto.getThirdOrderNo());
        PrintLogisticsAddressDto recInfo = printLogisticsRespDto.getRecInfo();
        StdPrintLogisticsAddressDto stdRecInfo = new StdPrintLogisticsAddressDto();
        BeanUtils.copyProperties((Object)recInfo, (Object)stdRecInfo);
        PrintLogisticsAddressDto sendInfo = printLogisticsRespDto.getSendInfo();
        StdPrintLogisticsAddressDto stdSendInfo = new StdPrintLogisticsAddressDto();
        BeanUtils.copyProperties((Object)sendInfo, (Object)stdSendInfo);
        stdPrintLogisticsOrderReqDto.setRecInfo(stdRecInfo);
        stdPrintLogisticsOrderReqDto.setSendInfo(stdSendInfo);
        stdPrintLogisticsOrderReqDto.setOaId(this.getOaId(printLogisticsRespDto.getSaleOrderNo()));
        stdPrintLogisticsOrderReqDto.setRemark(printLogisticsRespDto.getRemark());
        return stdPrintLogisticsOrderReqDto;
    }

    public String getOaId(String documentNo) {
        List addressList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.baseOrderAddressDas.filter().eq((Object)"document_no", (Object)documentNo)).eq((Object)"contacts_type", (Object)CsBaseOrderAddressContactsTypeEnum.CONSIGNEE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)addressList)) {
            return ((BaseOrderAddressEo)addressList.get(0)).getOaid();
        }
        return "";
    }

    public LogisticsPrintRecordEo saveLogisticsPrintRecordEo(PrintLogisticsOrderReqDto printLogisticsOrderReqDto) {
        logger.info("\u4fdd\u5b58\u9762\u5355\u6253\u5370\u4fe1\u606f:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)printLogisticsOrderReqDto));
        LogisticsPrintRecordEo updateInfo = new LogisticsPrintRecordEo();
        updateInfo.setPrintStatus(PrintStatusEnum.PRINT_CANCEL.getCode());
        ArrayList<SqlFilter> updateSqlFilters = new ArrayList<SqlFilter>();
        updateSqlFilters.add(SqlFilter.eq((String)"biz_print_type", (Object)printLogisticsOrderReqDto.getBizPrintType()));
        updateSqlFilters.add(SqlFilter.eq((String)"biz_order_no", (Object)printLogisticsOrderReqDto.getBizOrderNo()));
        updateSqlFilters.add(SqlFilter.ne((String)"print_status", (Object)PrintStatusEnum.PRINT_CANCEL.getCode()));
        updateInfo.setSqlFilters(updateSqlFilters);
        this.logisticsPrintRecordDas.updateSelectiveSqlFilter((BaseEo)updateInfo);
        LogisticsPrintRecordEo logisticsPrintRecordEo = this.buildLogisticsPrintRecordEo(printLogisticsOrderReqDto);
        this.logisticsPrintRecordDas.insert((BaseEo)logisticsPrintRecordEo);
        return logisticsPrintRecordEo;
    }

    private LogisticsPrintRecordEo buildLogisticsPrintRecordEo(PrintLogisticsOrderReqDto printLogisticsReqDto) {
        LogisticsPrintRecordEo logisticsPrintRecordEo = new LogisticsPrintRecordEo();
        logisticsPrintRecordEo.setChannelCode(printLogisticsReqDto.getChannelCode());
        logisticsPrintRecordEo.setLogisticsCompanyCode(printLogisticsReqDto.getLogisticsCompanyCode());
        logisticsPrintRecordEo.setLogisticsPlatformCode(printLogisticsReqDto.getLogisticsPlatformCode());
        logisticsPrintRecordEo.setShopCode(printLogisticsReqDto.getShopCode());
        logisticsPrintRecordEo.setBizOrderNo(printLogisticsReqDto.getBizOrderNo());
        logisticsPrintRecordEo.setPrintStatus(PrintStatusEnum.GET_NUMBER_WAIT.getCode());
        logisticsPrintRecordEo.setBizPrintType(printLogisticsReqDto.getBizPrintType());
        logisticsPrintRecordEo.setPrintNum(DEFAULT_PRINT_NUM);
        logisticsPrintRecordEo.setExternalLogisticsCode(printLogisticsReqDto.getExternalLogisticsCode());
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        jsonObject.put("customerAccountType", (Object)printLogisticsReqDto.getCustomerAccountType());
        logisticsPrintRecordEo.setExtension(jsonObject.toJSONString());
        return logisticsPrintRecordEo;
    }

    private void updatePrintInfo4CreateShipOrder(LogisticsPrintRecordEo logisticsPrintRecordEo, StdPrintLogisticsOrderExtRespDto printLogisticsRespDto, String resultMsg, String resultCode) {
        if (Objects.nonNull(printLogisticsRespDto) && PrintReturnStatusEnum.GET_PRINT_RETURN_SUCCESS.getCode().equals(printLogisticsRespDto.getReturnCode())) {
            logisticsPrintRecordEo.setShippingNo(printLogisticsRespDto.getShippingNo());
            logisticsPrintRecordEo.setPrintStatus(PrintStatusEnum.PRINT_WAIT.getCode());
            logisticsPrintRecordEo.setTaskId(printLogisticsRespDto.getTaskId());
            logisticsPrintRecordEo.setPrintMsg(printLogisticsRespDto.getMessage());
            logisticsPrintRecordEo.setLogisticsAttachData(printLogisticsRespDto.getLogisticsAttachData());
            logisticsPrintRecordEo.setPrintImageUrl(printLogisticsRespDto.getPrintUrl());
            logisticsPrintRecordEo.setCreateShipOrderTime(new Date());
            com.alibaba.fastjson.JSONObject jsonObject = ExtensionUtil.parseJson(logisticsPrintRecordEo.getExtension());
            Map shippingUrlMap = printLogisticsRespDto.getShippingUrlMap();
            jsonObject.put("shippingUrlMap", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)shippingUrlMap));
            jsonObject.put("parentWaybillNos", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)printLogisticsRespDto.getParentWaybillNos()));
            jsonObject.put("isParentOrder", (Object)CollectionUtils.isNotEmpty((Collection)printLogisticsRespDto.getParentWaybillNos()));
            logisticsPrintRecordEo.setExtension(jsonObject.toJSONString());
            this.addOperateLog(logisticsPrintRecordEo.getBizOrderNo(), OperateLogInfoConstant.getRetrievalNumber((String)printLogisticsRespDto.getShippingNo()), printLogisticsRespDto.getShippingNo());
            logger.info("\u53d1\u8d27\u5355\u53d6\u53f7\u6210\u529f:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)logisticsPrintRecordEo));
            InventoryConfig.pushEvent(new BaseOrderOutNoticeLogisticsGenEvent(logisticsPrintRecordEo.getBizOrderNo()));
        } else {
            String msg = Objects.isNull(printLogisticsRespDto) ? resultMsg : printLogisticsRespDto.getMessage();
            logisticsPrintRecordEo.setPrintStatus(PrintStatusEnum.GET_NUMBER_FAIL.getCode());
            logisticsPrintRecordEo.setPrintMsg(msg);
            logger.info("\u53d1\u8d27\u5355\u53d6\u53f7\u5931\u8d25:{}", (Object)logisticsPrintRecordEo.getBizOrderNo());
            this.addOperateLog(logisticsPrintRecordEo.getBizOrderNo(), OperateLogInfoConstant.getRetrievalNumberFail((String)msg), "");
        }
        this.logisticsPrintRecordDas.updateSelective((BaseEo)logisticsPrintRecordEo);
    }

    private PrintLogisticsOrderRespDto buildPrintLogisticsRespDto(LogisticsPrintRecordEo logisticsPrintRecordEo, StdPrintLogisticsOrderExtRespDto respDto, List<CsOutNoticeOrderDetailRespDto> deliveryItems) {
        PrintLogisticsOrderRespDto printLogisticsOrderRespDto = new PrintLogisticsOrderRespDto();
        printLogisticsOrderRespDto.setShippingNo(logisticsPrintRecordEo.getShippingNo());
        printLogisticsOrderRespDto.setMessage(logisticsPrintRecordEo.getPrintMsg());
        printLogisticsOrderRespDto.setLogisticsCompanyCode(logisticsPrintRecordEo.getLogisticsCompanyCode());
        printLogisticsOrderRespDto.setChannelCode(logisticsPrintRecordEo.getChannelCode());
        printLogisticsOrderRespDto.setPrintStatus(logisticsPrintRecordEo.getPrintStatus());
        printLogisticsOrderRespDto.setLogisticsPlatformCode(logisticsPrintRecordEo.getLogisticsPlatformCode());
        printLogisticsOrderRespDto.setPrintImageUrl(logisticsPrintRecordEo.getPrintImageUrl());
        printLogisticsOrderRespDto.setLogisticsPrintId(logisticsPrintRecordEo.getId());
        printLogisticsOrderRespDto.setReturnCode(respDto.getReturnCode());
        printLogisticsOrderRespDto.setSubShippingNo(respDto.getSubShippingNo());
        printLogisticsOrderRespDto.setShippingUrlMap(respDto.getShippingUrlMap());
        printLogisticsOrderRespDto.setSkuShippingMap(respDto.getSkuShippingMap());
        return printLogisticsOrderRespDto;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void updateShipping(Long deliveryId, PrintLogisticsOrderRespDto printLogisticsOrderRespDto) {
        InOutNoticeOrderEo outNoticeOrderEo = new InOutNoticeOrderEo();
        outNoticeOrderEo.setId(deliveryId);
        if (PrintStatusEnum.PRINT_WAIT.getCode().equals(printLogisticsOrderRespDto.getPrintStatus())) {
            this.convertLogisticsOrderStatus(outNoticeOrderEo, printLogisticsOrderRespDto.getPrintStatus());
            outNoticeOrderEo.setLogisticsOrderLabel(printLogisticsOrderRespDto.getPrintImageUrl());
            outNoticeOrderEo.setShippingCode(printLogisticsOrderRespDto.getShippingNo());
            outNoticeOrderEo.setSubShippingCode(printLogisticsOrderRespDto.getSubShippingNo());
            outNoticeOrderEo.setLogisticsPrintId(printLogisticsOrderRespDto.getLogisticsPrintId());
            outNoticeOrderEo.setFailReason("");
        } else {
            this.convertLogisticsOrderStatus(outNoticeOrderEo, printLogisticsOrderRespDto.getPrintStatus());
            outNoticeOrderEo.setLogisticsPrintId(printLogisticsOrderRespDto.getLogisticsPrintId());
            outNoticeOrderEo.setFailReason(printLogisticsOrderRespDto.getMessage());
        }
        outNoticeOrderEo.setRetrievalNumberFlag(RetrievalNumberFlagEnum.NOT_RETRIEVAL_NUMBER.getCode());
        this.outNoticeOrderDas.updateSelective((BaseEo)outNoticeOrderEo);
        if (StringUtils.isBlank((CharSequence)outNoticeOrderEo.getFailReason()) && CollectionUtil.isNotEmpty((Map)printLogisticsOrderRespDto.getSkuShippingMap())) {
            printLogisticsOrderRespDto.getSkuShippingMap().forEach((id, keys) -> {
                if (Objects.isNull(id)) {
                    return;
                }
                InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo = new InOutNoticeOrderDetailEo();
                inOutNoticeOrderDetailEo.setId(id);
                inOutNoticeOrderDetailEo.setSubShippingNo(String.join((CharSequence)",", keys));
                this.outNoticeOrderDetailDas.updateSelective((BaseEo)inOutNoticeOrderDetailEo);
            });
        }
    }

    private void cancelShipping(LogisticsPrintRecordEo recordEo) {
        InOutNoticeOrderEo outOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().eq((Object)"document_no", (Object)recordEo.getBizOrderNo())).one();
        InOutNoticeOrderEo outNoticeOrderEo = new InOutNoticeOrderEo();
        outNoticeOrderEo.setId(outOrderEo.getId());
        this.historyLogisticsService.convertByOutNotice(outOrderEo);
        outNoticeOrderEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.WAIT_RETRIEVAL_NUMBER.getCode());
        outNoticeOrderEo.setLogisticsOrderLabel("");
        outNoticeOrderEo.setShippingCode("");
        outNoticeOrderEo.setSubShippingCode("");
        this.outNoticeOrderDas.updateSelective((BaseEo)outNoticeOrderEo);
    }

    public void addOperateLog(String outNoticeOrderNo, String operateInfo, String ShippingNo) {
        OutNoticeOrderOperateLogDto OutNoticeOrderOperateLogDto2 = new OutNoticeOrderOperateLogDto();
        OutNoticeOrderOperateLogDto2.setOutNoticeOrderNo(outNoticeOrderNo);
        OutNoticeOrderOperateLogDto2.setOperateInfo(operateInfo);
        OutNoticeOrderOperateLogDto2.setShippingCode(ShippingNo);
        this.outNoticeOrderOperateLogService.addOutNoticeOrderOperateLog(OutNoticeOrderOperateLogDto2);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void printCallback(List<CallBackPrintReqDto> callBackPrintReqDtoList) {
        logger.info("\u6253\u5370\u56de\u8c03:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString(callBackPrintReqDtoList));
        this.callBackHandle(callBackPrintReqDtoList);
    }

    public void callBackHandle(List<CallBackPrintReqDto> callBackPrintReqDtoList) {
        List printTaskIdList = callBackPrintReqDtoList.stream().map(info -> Long.valueOf(info.getPrintTaskId())).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(printTaskIdList)) {
            logger.info("\u6253\u5370\u56de\u8c03\u5931\u8d25,\u6253\u5370id\u4e3a\u7a7a");
        }
        List recordEoList = ((ExtQueryChainWrapper)this.logisticsPrintRecordDas.filter().in((Object)"id", printTaskIdList)).list();
        Map recordEoMap = ((List)Optional.ofNullable(recordEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
        List documentNoList = ((List)Optional.ofNullable(recordEoList).orElse(new ArrayList())).stream().map(LogisticsPrintRecordEo::getBizOrderNo).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(documentNoList)) {
            logger.info("\u6253\u5370\u56de\u8c03\u5931\u8d25,\u53d1\u8d27\u5355\u53f7\u4e3a\u7a7a");
        }
        List orderEoList = ((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().in((Object)"document_no", documentNoList)).list();
        List outNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.outNoticeOrderDetailDas.filter().in((Object)"document_no", documentNoList)).list();
        Map orderEoMap = ((List)Optional.ofNullable(orderEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(InOutNoticeOrderEo::getDocumentNo, Function.identity(), (v1, v2) -> v1));
        Map<String, List<InOutNoticeOrderDetailEo>> orderInfoEoMap = ((List)Optional.ofNullable(outNoticeOrderDetailEoList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getDocumentNo));
        callBackPrintReqDtoList.forEach(callBack -> this.updateCallBackPrint(recordEoMap, orderEoMap, orderInfoEoMap, (CallBackPrintReqDto)callBack));
    }

    public void updateCallBackPrint(Map<Long, LogisticsPrintRecordEo> recordEoMap, Map<String, InOutNoticeOrderEo> orderEoMap, Map<String, List<InOutNoticeOrderDetailEo>> orderInfoEoMap, CallBackPrintReqDto callBack) {
        if (recordEoMap.containsKey(Long.valueOf(callBack.getPrintTaskId()))) {
            LogisticsPrintRecordEo logisticsPrintRecordEo = recordEoMap.get(Long.valueOf(callBack.getPrintTaskId()));
            if (orderEoMap.containsKey(logisticsPrintRecordEo.getBizOrderNo())) {
                InOutNoticeOrderEo outNoticeOrderEo = orderEoMap.get(logisticsPrintRecordEo.getBizOrderNo());
                this.updateDeliveryOrderPrint(outNoticeOrderEo, callBack);
                this.sendOutPrintFinishMessage(outNoticeOrderEo, orderInfoEoMap);
            }
            this.updatePrintRecordEo(logisticsPrintRecordEo, callBack);
            this.addOperateLog(logisticsPrintRecordEo.getBizOrderNo(), "\u9762\u5355\u6253\u5370", "");
        } else {
            logger.info("\u6ca1\u6709\u8be5\u6253\u5370id\u8bb0\u5f55:{}", (Object)callBack.getPrintTaskId());
        }
    }

    public void updateDeliveryOrderPrint(InOutNoticeOrderEo outNoticeOrderEo, CallBackPrintReqDto callBack) {
        InOutNoticeOrderEo InOutNoticeOrderEo2 = new InOutNoticeOrderEo();
        InOutNoticeOrderEo2.setId(outNoticeOrderEo.getId());
        this.convertLogisticsOrderStatus(InOutNoticeOrderEo2, callBack.getPrintStatus());
        InOutNoticeOrderEo2.setLogisticsPrintNum(Integer.valueOf(null != outNoticeOrderEo.getLogisticsPrintNum() ? outNoticeOrderEo.getLogisticsPrintNum() + 1 : 1));
        InOutNoticeOrderEo2.setLogisticsPrintTime(new Date());
        this.outNoticeOrderDas.updateSelective((BaseEo)InOutNoticeOrderEo2);
    }

    public void sendOutPrintFinishMessage(InOutNoticeOrderEo outNoticeOrderEo, Map<String, List<InOutNoticeOrderDetailEo>> orderInfoEoMap) {
        DeliveryPrintFinishMessageDto deliveryPrintFinishMessageDto = new DeliveryPrintFinishMessageDto();
        deliveryPrintFinishMessageDto.setDeliveryNo(outNoticeOrderEo.getDocumentNo());
        deliveryPrintFinishMessageDto.setShopId(outNoticeOrderEo.getShopId());
        deliveryPrintFinishMessageDto.setShopName(outNoticeOrderEo.getShopName());
        deliveryPrintFinishMessageDto.setShopCode(outNoticeOrderEo.getShopCode());
        deliveryPrintFinishMessageDto.setSaleOrderNo(outNoticeOrderEo.getRelevanceNo());
        deliveryPrintFinishMessageDto.setShipmentEnterpriseName(outNoticeOrderEo.getShipmentEnterpriseName());
        deliveryPrintFinishMessageDto.setShipmentEnterpriseCode(outNoticeOrderEo.getShipmentEnterpriseCode());
        deliveryPrintFinishMessageDto.setShippingCode(outNoticeOrderEo.getShippingCode());
        ArrayList infoDtoList = new ArrayList();
        List<InOutNoticeOrderDetailEo> outNoticeOrderDetailEoList = orderInfoEoMap.get(outNoticeOrderEo.getDocumentNo());
        if (CollectionUtils.isNotEmpty(outNoticeOrderDetailEoList)) {
            outNoticeOrderDetailEoList.forEach(info -> {
                DeliveryPrintFinishMessageInfoDto infoDto = new DeliveryPrintFinishMessageInfoDto();
                infoDto.setItemCode(info.getSkuCode());
                infoDto.setItemName(info.getSkuName());
                infoDto.setItemNum(info.getPlanQuantity());
                infoDto.setTradeOrderItemId(info.getPreOrderItemId());
                infoDtoList.add(infoDto);
            });
            deliveryPrintFinishMessageDto.setInfoDtoList(infoDtoList);
        }
        String message = JSON.toJSONString((Object)deliveryPrintFinishMessageDto);
        logger.info("\u51fa\u5e93\u901a\u77e5\u5355\u6253\u5370\u5b8c\u6210\u53d1\u9001MQ:{}", (Object)message);
        this.commonsMqService.publishMessage("SINGLE_TOPIC", "OUT_PRINT_FINISH_TAG", (Object)message);
        logger.info("\u51fa\u5e93\u901a\u77e5\u5355\u6253\u5370\u5b8c\u6210\u53d1\u9001MQ\u5b8c\u6210");
    }

    public void updatePrintRecordEo(LogisticsPrintRecordEo logisticsPrintRecordEo, CallBackPrintReqDto callBack) {
        LogisticsPrintRecordEo printRecordEo = new LogisticsPrintRecordEo();
        printRecordEo.setId(logisticsPrintRecordEo.getId());
        printRecordEo.setPrintStatus(callBack.getPrintStatus());
        printRecordEo.setPrintData(callBack.getMessage());
        printRecordEo.setPrintNum(Integer.valueOf(null != logisticsPrintRecordEo.getPrintNum() ? logisticsPrintRecordEo.getPrintNum() + 1 : 1));
        this.logisticsPrintRecordDas.updateSelective((BaseEo)printRecordEo);
    }

    public void convertLogisticsOrderStatus(InOutNoticeOrderEo outNoticeOrderEo, Integer printStatus) {
        switch (printStatus) {
            case 1: 
            case 5: {
                outNoticeOrderEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.WAIT_RETRIEVAL_NUMBER.getCode());
                break;
            }
            case 2: 
            case 7: {
                outNoticeOrderEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.WAIT_PRINT.getCode());
                break;
            }
            case 3: {
                outNoticeOrderEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.PRINTED.getCode());
                break;
            }
            case 6: {
                outNoticeOrderEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.RETRIEVAL_NUMBER_FAIL.getCode());
                break;
            }
            case 4: {
                outNoticeOrderEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.PRINT_FAIL.getCode());
                break;
            }
        }
    }

    @Override
    public List<WarehouseDeliveryRespDto> warehouseDelivery(WarehouseDeliveryReqDto warehouseDeliveryReqDto) {
        logger.info("\u53d1\u8d27\u5355\u53d1\u8d27:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)warehouseDeliveryReqDto));
        if (null == warehouseDeliveryReqDto.getPda()) {
            warehouseDeliveryReqDto.setPda(Boolean.valueOf(false));
        }
        AssertUtil.assertNotEmpty((Collection)warehouseDeliveryReqDto.getDeliveryInfoReqDtoList(), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d1\u8d27\u7684\u53d1\u8d27\u5355", (Object[])new Object[0]);
        List<WarehouseDeliveryRespDto> warehouseDeliveryRespDtoList = this.handleDeliveryParam(warehouseDeliveryReqDto);
        this.addDeliveryLog(warehouseDeliveryReqDto, warehouseDeliveryRespDtoList);
        return warehouseDeliveryRespDtoList;
    }

    public void addDeliveryLog(WarehouseDeliveryReqDto warehouseDeliveryReqDto, List<WarehouseDeliveryRespDto> warehouseDeliveryRespDtoList) {
        if (CollectionUtils.isNotEmpty(warehouseDeliveryRespDtoList)) {
            ArrayList<OutNoticeOrderOperateLogDto> addReqDtoList = new ArrayList<OutNoticeOrderOperateLogDto>();
            warehouseDeliveryRespDtoList.forEach(info -> {
                if (warehouseDeliveryReqDto.getPda().booleanValue()) {
                    OutNoticeOrderOperateLogDto outNoticeOrderOperateLogDto = new OutNoticeOrderOperateLogDto();
                    outNoticeOrderOperateLogDto.setOutNoticeOrderNo(info.getDeliveryNo());
                    outNoticeOrderOperateLogDto.setOperateInfo(OperateLogInfoConstant.getPdaDeliveryFail((String)info.getMessage()));
                    addReqDtoList.add(outNoticeOrderOperateLogDto);
                } else {
                    OutNoticeOrderOperateLogDto outNoticeOrderOperateLogDto = new OutNoticeOrderOperateLogDto();
                    outNoticeOrderOperateLogDto.setOutNoticeOrderNo(info.getDeliveryNo());
                    outNoticeOrderOperateLogDto.setOperateInfo(OperateLogInfoConstant.getHandDeliveryFail((String)info.getMessage()));
                    addReqDtoList.add(outNoticeOrderOperateLogDto);
                }
            });
            if (CollectionUtils.isNotEmpty(addReqDtoList)) {
                this.outNoticeOrderOperateLogService.batchAddOutNoticeOrderOperateLog(addReqDtoList);
            }
        }
    }

    public List<WarehouseDeliveryRespDto> handleDeliveryParam(WarehouseDeliveryReqDto warehouseDeliveryReqDto) {
        ArrayList<WarehouseDeliveryRespDto> warehouseDeliveryRespDtoList = new ArrayList<WarehouseDeliveryRespDto>();
        List deliveryNoList = warehouseDeliveryReqDto.getDeliveryInfoReqDtoList().stream().map(WarehouseDeliveryInfoReqDto::getDeliveryNo).distinct().collect(Collectors.toList());
        List orderEoList = ((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().in((Object)"document_no", deliveryNoList)).list();
        if (CollectionUtils.isNotEmpty((Collection)orderEoList)) {
            List documentNoList = orderEoList.stream().map(InOutNoticeOrderEo::getDocumentNo).distinct().collect(Collectors.toList());
            List orderDetailList = ((ExtQueryChainWrapper)this.outNoticeOrderDetailDas.filter().in((Object)"document_no", documentNoList)).list();
            Map orderEoMap = orderEoList.stream().collect(Collectors.toMap(InOutNoticeOrderEo::getDocumentNo, Function.identity(), (v1, v2) -> v1));
            Map<String, List<InOutNoticeOrderDetailEo>> detailEoMap = ((List)Optional.ofNullable(orderDetailList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getDocumentNo));
            warehouseDeliveryReqDto.getDeliveryInfoReqDtoList().forEach(delivery -> {
                block7: {
                    WarehouseDeliveryRespDto warehouseDeliveryRespDto = new WarehouseDeliveryRespDto();
                    if (orderEoMap.containsKey(delivery.getDeliveryNo())) {
                        InOutNoticeOrderEo InOutNoticeOrderEo2 = (InOutNoticeOrderEo)orderEoMap.get(delivery.getDeliveryNo());
                        if (detailEoMap.containsKey(delivery.getDeliveryNo())) {
                            List outNoticeOrderDetailEoList = (List)detailEoMap.get(delivery.getDeliveryNo());
                            try {
                                this.getWmsOutSendBack(InOutNoticeOrderEo2, outNoticeOrderDetailEoList, (WarehouseDeliveryInfoReqDto)delivery);
                                if (warehouseDeliveryReqDto.getPda().booleanValue()) {
                                    this.addOperateLog(delivery.getDeliveryNo(), "PDA\u626b\u63cf\u53d1\u8d27", "");
                                    break block7;
                                }
                                this.addOperateLog(delivery.getDeliveryNo(), "\u53d1\u8d27\u5355\u624b\u52a8\u53d1\u8d27", "");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                logger.error("\u53d1\u8d27\u5355\u51fa\u5e93\u56de\u4f20\u5931\u8d25:{}", (Object)e.getMessage());
                                warehouseDeliveryRespDto.setDeliveryNo(delivery.getDeliveryNo());
                                warehouseDeliveryRespDto.setMessage(e.getMessage());
                                warehouseDeliveryRespDtoList.add(warehouseDeliveryRespDto);
                            }
                        } else {
                            warehouseDeliveryRespDto.setDeliveryNo(delivery.getDeliveryNo());
                            warehouseDeliveryRespDto.setMessage(String.format("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f:%s", delivery));
                            warehouseDeliveryRespDtoList.add(warehouseDeliveryRespDto);
                        }
                    } else {
                        warehouseDeliveryRespDto.setDeliveryNo(delivery.getDeliveryNo());
                        warehouseDeliveryRespDto.setMessage(String.format("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u53d1\u8d27\u5355\u4fe1\u606f:%s", delivery));
                        warehouseDeliveryRespDtoList.add(warehouseDeliveryRespDto);
                    }
                }
            });
        }
        return warehouseDeliveryRespDtoList;
    }

    public void getWmsOutSendBack(InOutNoticeOrderEo InOutNoticeOrderEo2, List<InOutNoticeOrderDetailEo> outNoticeOrderDetailEoList, WarehouseDeliveryInfoReqDto warehouseDeliveryInfoReqDto) {
        OutSendBackReqDto outSendBackReqDto = new OutSendBackReqDto();
        outSendBackReqDto.setWmsOrderNo(InOutNoticeOrderEo2.getId().toString());
        outSendBackReqDto.setOutNoticeOrderNo(InOutNoticeOrderEo2.getDocumentNo());
        outSendBackReqDto.setOutTime(new Date());
        ArrayList detailReqDtoList = new ArrayList();
        Map<String, WarehouseDeliveryInfoReqDto.SkuInfo> skuInfoMap = ((List)Optional.ofNullable(warehouseDeliveryInfoReqDto.getInfos()).orElse(new ArrayList())).stream().collect(Collectors.toMap(WarehouseDeliveryInfoReqDto.SkuInfo::getSkuCode, Function.identity(), (v1, v2) -> v2));
        outNoticeOrderDetailEoList.forEach(detail -> {
            WarehouseDeliveryInfoReqDto.SkuInfo skuInfo = skuInfoMap.getOrDefault(detail.getSkuCode(), new WarehouseDeliveryInfoReqDto.SkuInfo());
            OutSendBackDetailReqDto csWmsOutSendBackDetailReqDto = new OutSendBackDetailReqDto();
            csWmsOutSendBackDetailReqDto.setSkuCode(detail.getSkuCode());
            csWmsOutSendBackDetailReqDto.setQuantity(detail.getWaitQuantity());
            csWmsOutSendBackDetailReqDto.setWarehouseCode(InOutNoticeOrderEo2.getOutLogicWarehouseCode());
            csWmsOutSendBackDetailReqDto.setInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
            csWmsOutSendBackDetailReqDto.setTradeOrderItemId(detail.getPreOrderItemId());
            csWmsOutSendBackDetailReqDto.setSnCodes(skuInfo.getSnCodeList());
            csWmsOutSendBackDetailReqDto.setBarCodeList(skuInfo.getBarCodeList());
            detailReqDtoList.add(csWmsOutSendBackDetailReqDto);
        });
        outSendBackReqDto.setDetailReqDtoList(detailReqDtoList);
        outSendBackReqDto.setWarehouseCode(InOutNoticeOrderEo2.getOutLogicWarehouseCode());
        ArrayList shippingInfoReqDtoList = new ArrayList();
        ArrayList<String> shippingList = new ArrayList<String>();
        shippingList.add(InOutNoticeOrderEo2.getShippingCode());
        if (StringUtils.isNotBlank((CharSequence)InOutNoticeOrderEo2.getSubShippingCode())) {
            shippingList.addAll(Arrays.stream(InOutNoticeOrderEo2.getSubShippingCode().split(",")).collect(Collectors.toList()));
        }
        shippingList.forEach(r -> {
            CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
            csWmsShippingInfoReqDto.setWmsOrderNo(InOutNoticeOrderEo2.getId().toString());
            csWmsShippingInfoReqDto.setOutNoticeOrderNo(InOutNoticeOrderEo2.getDocumentNo());
            csWmsShippingInfoReqDto.setShippingCompanyCode(InOutNoticeOrderEo2.getShipmentEnterpriseCode());
            csWmsShippingInfoReqDto.setShippingCompanyName(InOutNoticeOrderEo2.getShipmentEnterpriseName());
            csWmsShippingInfoReqDto.setShippingNo(r);
            csWmsShippingInfoReqDto.setConsignNo(r);
            csWmsShippingInfoReqDto.setDeliveryTime(new Date());
            shippingInfoReqDtoList.add(csWmsShippingInfoReqDto);
        });
        outSendBackReqDto.setShippingInfoReqDtoList(shippingInfoReqDtoList);
        this.outNoticeOrderService.outSendBack(outSendBackReqDto);
        this.updateNoticeOrderDetailSnCode(outNoticeOrderDetailEoList, skuInfoMap);
    }

    public void updateNoticeOrderDetailSnCode(List<InOutNoticeOrderDetailEo> outNoticeOrderDetailEoList, Map<String, WarehouseDeliveryInfoReqDto.SkuInfo> skuInfoMap) {
        if (MapUtils.isNotEmpty(skuInfoMap)) {
            logger.info("\u901a\u77e5\u5355\u66f4\u65b0\u5546\u54c1\u6761\u7801\u548c69\u7801");
            outNoticeOrderDetailEoList.forEach(info -> {
                WarehouseDeliveryInfoReqDto.SkuInfo skuInfo = (WarehouseDeliveryInfoReqDto.SkuInfo)skuInfoMap.get(info.getSkuCode());
                if (skuInfo == null) {
                    return;
                }
                InOutNoticeOrderDetailEo outNoticeOrderDetailEo = new InOutNoticeOrderDetailEo();
                outNoticeOrderDetailEo.setId(info.getId());
                if (CollectionUtils.isNotEmpty((Collection)skuInfo.getSnCodeList())) {
                    outNoticeOrderDetailEo.setSnCode(String.join((CharSequence)",", skuInfo.getSnCodeList()));
                }
                if (CollectionUtils.isNotEmpty((Collection)skuInfo.getBarCodeList())) {
                    outNoticeOrderDetailEo.setBarCode(String.join((CharSequence)",", skuInfo.getBarCodeList()));
                }
                this.outNoticeOrderDetailDas.updateSelective((BaseEo)outNoticeOrderDetailEo);
            });
        }
    }

    @Override
    public List<DeliveryOrderInfoRespDto> queryDeliveryByParam(DeliveryInfoQueryDto deliveryInfoQueryDto) {
        logger.info("\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)deliveryInfoQueryDto));
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)this.outNoticeOrderDas.filter().orderByDesc((Object)"id");
        if (StringUtils.isNotBlank((CharSequence)deliveryInfoQueryDto.getShippingCode())) {
            filter.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"shipping_code", (Object)deliveryInfoQueryDto.getShippingCode())).or()).apply(String.format(" FIND_IN_SET('%s',sub_shipping_code) ", deliveryInfoQueryDto.getShippingCode()), new Object[0]);
            });
        }
        List list = filter.list();
        ArrayList<DeliveryOrderInfoRespDto> deliveryOrderInfoRespDtoList = new ArrayList<DeliveryOrderInfoRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List documentNoList = list.stream().map(InOutNoticeOrderEo::getDocumentNo).distinct().collect(Collectors.toList());
            List detailEoList = ((ExtQueryChainWrapper)this.outNoticeOrderDetailDas.filter().in((Object)"document_no", documentNoList)).list();
            if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
                this.getItemInfoByCode(detailEoList);
            }
            Map<String, List<InOutNoticeOrderDetailEo>> map = ((List)Optional.ofNullable(detailEoList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getDocumentNo));
            list.forEach(info -> {
                DeliveryOrderInfoRespDto respDto = new DeliveryOrderInfoRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)info, (String[])new String[0]);
                if (map.containsKey(info.getDocumentNo())) {
                    List InOutNoticeOrderDetailEos = (List)map.get(info.getDocumentNo());
                    ArrayList outNoticeOrderDetailRespDtoList = new ArrayList();
                    CubeBeanUtils.copyCollection(outNoticeOrderDetailRespDtoList, (Collection)InOutNoticeOrderDetailEos, CsOutNoticeOrderDetailRespDto.class);
                    respDto.setOutNoticeOrderDetailRespDtoList(outNoticeOrderDetailRespDtoList);
                }
                deliveryOrderInfoRespDtoList.add(respDto);
            });
        }
        return deliveryOrderInfoRespDtoList;
    }

    public void getItemInfoByCode(List<InOutNoticeOrderDetailEo> detailEoList) {
        List<String> skuCodeList = detailEoList.stream().map(InOutNoticeOrderDetailEo::getSkuCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        logger.info("\u51fa\u5e93\u901a\u77e5\u5355\u83b7\u53d6\u5546\u54c169\u7801:{}", (Object)JSON.toJSONString(skuCodeList));
        if (CollectionUtils.isNotEmpty(skuCodeList)) {
            List itemSkuRespDtoList = this.itemDataQueryHelper.getByCodes(skuCodeList);
            Map map = ((List)Optional.ofNullable(itemSkuRespDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (v1, v2) -> v2));
            detailEoList.forEach(info -> {
                if (map.containsKey(info.getSkuCode())) {
                    info.setBarCode(((ItemSkuDto)map.get(info.getSkuCode())).getBarCode());
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeliveryInfo(DeliveryInfoDto deliveryInfoDto) {
        logger.info("\u66f4\u65b0\u53d1\u8d27\u5355\u4fe1\u606f\u5165\u53c2:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)deliveryInfoDto));
        AssertUtil.assertNotBlank((String)deliveryInfoDto.getDeliveryNo(), (String)"\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InOutNoticeOrderEo outOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().eq((Object)"document_no", (Object)deliveryInfoDto.getDeliveryNo())).one();
        if (null == outOrderEo || null == outOrderEo.getId()) {
            throw new BizException("\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\uff1a{}", deliveryInfoDto.getDeliveryNo());
        }
        AssertUtil.assertTrue((BaseOrderStatusEnum.ONO_WAIT_OUT.getCode().equals(outOrderEo.getOrderStatus()) || BaseOrderStatusEnum.ONO_PORTION_OUT.getCode().equals(outOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u5f85\u51fa\u5e93\u72b6\u6001\u624d\u5141\u8bb8\u586b\u5199\u5feb\u9012\u5355\u53f7", (Object[])new Object[0]);
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        updateEo.setId(outOrderEo.getId());
        updateEo.setShippingCode(deliveryInfoDto.getShippingCode());
        this.outNoticeOrderDas.updateSelective((BaseEo)updateEo);
        this.addOperateLog(outOrderEo.getDocumentNo(), OperateLogInfoConstant.getManualUpdateShippingCode((String)deliveryInfoDto.getShippingCode()), deliveryInfoDto.getShippingCode());
    }

    @Override
    public BatchOrderOperationMsgDto updateLogisticsOrderStatus(DeliveryOrderUpdateReqDto reqDto) {
        AssertUtil.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)reqDto.getIds()), (String)"id\u96c6\u5408\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertTrue((!LogisticsOrderStatusEnum.PRINTED.equals((Object)reqDto.getLogisticsOrderStatus()) ? 1 : 0) != 0, (String)"\u5feb\u9012\u5355\u72b6\u6001\u4e0d\u4e3a\u5df2\u6253\u5370", (Object[])new Object[0]);
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)reqDto.getIds()));
        updateEo.setSqlFilters((List)sqlFilterList);
        updateEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.WAIT_PRINT.getCode());
        int successNum = this.outNoticeOrderDas.updateSelectiveSqlFilter((BaseEo)updateEo);
        BatchOrderOperationMsgDto respDto = new BatchOrderOperationMsgDto();
        respDto.setSuccCount(Integer.valueOf(successNum));
        respDto.setFailCount(Integer.valueOf(reqDto.getIds().size() - successNum));
        return respDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void printPickingOrderCallback(List<CallBackPrintReqDto> callBackPrintReqDtoList) {
        logger.info("\u6253\u5370\u62e3\u8d27\u5355\u56de\u8c03:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString(callBackPrintReqDtoList));
        List documentNoList = callBackPrintReqDtoList.stream().map(CallBackPrintReqDto::getBizId).collect(Collectors.toList());
        List orderEoList = ((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().in((Object)"document_no", documentNoList)).list();
        Map orderEoMap = ((List)Optional.ofNullable(orderEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(InOutNoticeOrderEo::getDocumentNo, Function.identity(), (v1, v2) -> v1));
        callBackPrintReqDtoList.forEach(callBack -> {
            if (orderEoMap.containsKey(callBack.getBizId())) {
                InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)orderEoMap.get(callBack.getBizId());
                InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
                updateEo.setId(outNoticeOrderEo.getId());
                updateEo.setPickingPrintNum(Integer.valueOf(null != outNoticeOrderEo.getPickingPrintNum() ? outNoticeOrderEo.getPickingPrintNum() + 1 : 1));
                updateEo.setPickingOrderNo(callBack.getPickingOrderNo());
                this.outNoticeOrderDas.updateSelective((BaseEo)updateEo);
            }
        });
    }

    @Override
    public void batchUpdateDeliveryInfo(List<DeliveryInfoDto> reqDtos) {
        Date now = new Date();
        Map attachments = ServiceContext.getContext().getAttachments();
        String requestId = ServiceContext.getContext().getRequestId();
        ArrayList completableFutures = new ArrayList();
        reqDtos.forEach(reqDto -> completableFutures.add(CompletableFuture.supplyAsync(() -> {
            attachments.forEach((arg_0, arg_1) -> ((ServiceContext)ServiceContext.getContext()).set(arg_0, arg_1));
            MDC.put((String)"yes.req.requestId", (String)requestId);
            try {
                InventoryConfig.executorNewTransaction(s -> {
                    this.updateDeliveryInfo((DeliveryInfoDto)reqDto, now);
                    return s;
                });
                return 1;
            }
            catch (Exception e) {
                log.info("\u5bfc\u5165\u5916\u90e8\u5355\u53f7\u53d1\u8d27\u5931\u8d25:{}", (Object)JSONUtil.toJsonStr((Object)reqDto), (Object)e);
                throw new BizException(e.getMessage());
            }
        }, this.executorService)));
        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0]));
    }

    private void updateDeliveryInfo(DeliveryInfoDto reqDto, Date now) {
        boolean needPushWms;
        boolean isPushedWms;
        AssertUtil.assertNotBlank((String)reqDto.getDeliveryNo(), (String)"\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InOutNoticeOrderEo outOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().eq((Object)"document_no", (Object)reqDto.getDeliveryNo())).one();
        if (null == outOrderEo || null == outOrderEo.getId()) {
            throw new BizException("\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\uff1a{}", reqDto.getDeliveryNo());
        }
        HashSet allowStatus = Sets.newHashSet((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode()});
        if (!allowStatus.contains(outOrderEo.getOrderStatus())) {
            throw new BizException("\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u51fa\u5e93/\u5f85\u4e0b\u53d1\uff1a{}", reqDto.getDeliveryNo());
        }
        boolean bl = isPushedWms = Objects.equals(reqDto.getImportType(), 2) && (OutNoticePushStatusEnum.PUSHING.getCode().equals(outOrderEo.getPushStatus()) || OutNoticePushStatusEnum.SUCCESS.getCode().equals(outOrderEo.getPushStatus()));
        if (isPushedWms) {
            throw new BizException("\u53d1\u8d27\u5355\u4e0d\u5141\u8bb8\u91cd\u590d\u4e0b\u53d1WMS\uff1a{}", reqDto.getDeliveryNo());
        }
        if (reqDto.getImportType() == null || reqDto.getImportType().equals(1)) {
            OutResultOrderReqDto outResultOrderReqDto = new OutResultOrderReqDto();
            outResultOrderReqDto.setId(outOrderEo.getId());
            outResultOrderReqDto.setShippingCode(reqDto.getShippingCode());
            outResultOrderReqDto.setShippingCompanyCode(reqDto.getShippingCompany());
            outResultOrderReqDto.setShippingCompanyName(reqDto.getShippingCompanyName());
            outResultOrderReqDto.setBizDate(now);
            this.outNoticeOrderService.productOutbound(outResultOrderReqDto);
        }
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        updateEo.setId(outOrderEo.getId());
        updateEo.setSubShippingCode(reqDto.getSubShippingCode());
        updateEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.PRINTED.getCode());
        updateEo.setShippingCode(reqDto.getShippingCode());
        updateEo.setShippingCompany(reqDto.getShippingCompany());
        updateEo.setShippingCompanyName(reqDto.getShippingCompanyName());
        if (reqDto.getImportType() != null) {
            updateEo.setLogisticsOrderLabel("\u5bfc\u5165,\u4e2d\u53f0\u4e0d\u652f\u6301\u6253\u5370");
        }
        this.outNoticeOrderDas.updateSelective((BaseEo)updateEo);
        List subShippingNos = Lists.newArrayList((Object[])new String[]{reqDto.getShippingCode(), reqDto.getSubShippingCode()}).stream().filter(StringUtils::isNotBlank).flatMap(s -> Arrays.stream(s.split("[,\uff0c]"))).distinct().collect(Collectors.toList());
        List details = this.outNoticeOrderDetailDas.queryByDocumentNo(outOrderEo.getDocumentNo());
        details.forEach(detail -> {
            int len = Math.min(detail.getPlanQuantity().intValue(), subShippingNos.size());
            if (len <= 0) {
                return;
            }
            InOutNoticeOrderDetailEo updateDetailEo = new InOutNoticeOrderDetailEo();
            updateDetailEo.setId(detail.getId());
            ArrayList subList = new ArrayList(subShippingNos.subList(0, len));
            subShippingNos.removeAll(subList);
            updateDetailEo.setSubShippingNo(String.join((CharSequence)",", subList));
            this.outNoticeOrderDetailDas.updateSelective((BaseEo)updateDetailEo);
        });
        if (reqDto.getImportType() == null || reqDto.getImportType().equals(1)) {
            InventoryConfig.getPushWmsAble().afterOnoTotalOut(Lists.newArrayList((Object[])new String[]{outOrderEo.getDocumentNo()}));
        }
        boolean bl2 = needPushWms = Objects.equals(reqDto.getImportType(), 2) && (OutNoticePushStatusEnum.WAITING.getCode().equals(outOrderEo.getPushStatus()) || OutNoticePushStatusEnum.FAIL.getCode().equals(outOrderEo.getPushStatus()));
        if (needPushWms) {
            this.outNoticeOrderService.pushWms(reqDto.getDeliveryNo());
        }
        this.addOperateLog(outOrderEo.getDocumentNo(), OperateLogInfoConstant.getManualUpdateShippingCode((String)reqDto.getShippingCode()), reqDto.getShippingCode());
    }

    @Override
    public String generatePickingOrderNo() {
        return InventoryConfig.getGenerateCodeUtil().generateCode(CodeGenEnum.PICKING_ORDER);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BatchOrderOperationMsgDto batchUpdateShippingCompany(List<DeliveryInfoDto> reqDtos) {
        BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        reqDtos.forEach(reqDto -> {
            try {
                AssertUtil.assertNotBlank((String)reqDto.getDeliveryNo(), (String)"\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                InOutNoticeOrderEo outOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().eq((Object)"document_no", (Object)reqDto.getDeliveryNo())).one();
                if (null == outOrderEo || null == outOrderEo.getId()) {
                    throw new BizException("\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\uff1a{}", reqDto.getDeliveryNo());
                }
                InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
                updateEo.setId(outOrderEo.getId());
                updateEo.setShipmentEnterpriseCode(reqDto.getShippingCompany());
                updateEo.setShipmentEnterpriseName(reqDto.getShippingCompanyName());
                if (LogisticsOrderStatusEnum.WAIT_PRINT.getCode().equals(outOrderEo.getLogisticsOrderStatus()) || LogisticsOrderStatusEnum.PRINTED.getCode().equals(outOrderEo.getLogisticsOrderStatus()) || LogisticsOrderStatusEnum.PRINT_FAIL.getCode().equals(outOrderEo.getLogisticsOrderStatus())) {
                    LogisticsOrderCancelReqDto cancelReqDto = LogisticsOrderCancelReqDto.builder().bizOrderNo(outOrderEo.getDocumentNo()).bizPrintType(BizPrintTypeEnum.DELIVERY.getCode()).build();
                    try {
                        CancelLogisticsOrderRespDto respDto = this.cancel(cancelReqDto);
                        if (respDto.getResult().booleanValue()) {
                            updateEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.WAIT_RETRIEVAL_NUMBER.getCode());
                        } else {
                            logger.error("\u81ea\u52a8\u56de\u6536\u5931\u8d25,\u5931\u8d25\u539f\u56e0: {}", (Object)respDto.getMessage());
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u81ea\u52a8\u56de\u6536\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0: {}", (Object)e.getMessage());
                    }
                }
                this.outNoticeOrderDas.updateSelective((BaseEo)updateEo);
                this.addOperateLog(outOrderEo.getDocumentNo(), OperateLogInfoConstant.getManualUpdateShippingCode((String)reqDto.getShippingCode()), reqDto.getShippingCode());
                resMsg.setMsg(reqDto.getDeliveryNo());
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                resMsg.setReqStatus(Integer.valueOf(0));
                resMsg.setMsg(e.getMessage());
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(reqDtos.size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return msgDto;
    }

    @Override
    public List<ShipOrderPrintRespDto> shipOrderPrint(List<ShipOrderPrintReqDto> shipOrderPrintReqDtoList) {
        if (CollectionUtils.isEmpty(shipOrderPrintReqDtoList)) {
            return new ArrayList<ShipOrderPrintRespDto>();
        }
        Set documentNoSet = shipOrderPrintReqDtoList.stream().map(ShipOrderPrintReqDto::getDocumentNo).collect(Collectors.toSet());
        Map printRecordEoMap = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPrintRecordDas.filter().in((Object)"biz_order_no", documentNoSet)).in((Object)"print_status", (Collection)Lists.newArrayList((Object[])new Integer[]{3, 7}))).list().stream().collect(Collectors.toMap(LogisticsPrintRecordEo::getBizOrderNo, Function.identity(), (o, o1) -> o));
        List printRespDtos = shipOrderPrintReqDtoList.stream().map(r -> {
            LogisticsPrintRecordEo printRecordEo = (LogisticsPrintRecordEo)printRecordEoMap.get(r.getDocumentNo());
            if (Objects.isNull(printRecordEo)) {
                return null;
            }
            ShipOrderPrintRespDto shipOrderPrintRespDto = (ShipOrderPrintRespDto)BeanUtil.copyProperties((Object)printRecordEo, ShipOrderPrintRespDto.class, (String[])new String[0]);
            shipOrderPrintRespDto.setPrintTaskId(printRecordEo.getId() + "");
            shipOrderPrintRespDto.setBizId(printRecordEo.getBizOrderNo());
            shipOrderPrintRespDto.setPosType((Integer)ObjectUtil.defaultIfNull((Object)r.getPosType(), (Object)this.printPosType));
            shipOrderPrintRespDto.setTextSize((Integer)ObjectUtil.defaultIfNull((Object)r.getTextSize(), (Object)this.printTextSize));
            shipOrderPrintRespDto.setSortNo(r.getSortNo());
            shipOrderPrintRespDto.setPickOrderNo(r.getPickOrderNo());
            if (StringUtils.isNotEmpty((CharSequence)printRecordEo.getExtension())) {
                com.alibaba.fastjson.JSONObject jsonObject = ExtensionUtil.parseJson(printRecordEo.getExtension());
                com.alibaba.fastjson.JSONObject shippingUrlMap = jsonObject.getJSONObject("shippingUrlMap");
                Optional.ofNullable(shippingUrlMap).filter(CollUtil::isNotEmpty).ifPresent(dip -> shipOrderPrintRespDto.setPrintImageUrl(shippingUrlMap.getString(r.getShippingNo())));
            }
            return shipOrderPrintRespDto;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        WaybillPrintImgExchangeReqDto reqDto = new WaybillPrintImgExchangeReqDto();
        reqDto.setPrintImgExchangeSubReqDtos(printRespDtos.stream().map(r -> {
            WaybillPrintImgExchangeReqDto.WaybillPrintImgExchangeSubReqDto subReqDto = new WaybillPrintImgExchangeReqDto.WaybillPrintImgExchangeSubReqDto();
            subReqDto.setAddText(r.getSortNo() + "#" + Optional.ofNullable(r.getPickOrderNo()).orElse(""));
            subReqDto.setImgKey(r.getPrintImageUrl());
            subReqDto.setPrinterImgUrl(r.getPrintImageUrl());
            subReqDto.setPosType(r.getPosType());
            subReqDto.setTextSize(r.getPosType());
            return subReqDto;
        }).collect(Collectors.toList()));
        List exchangeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.waybillApi.exchangeImgUrl(reqDto));
        Map respDtoMap = exchangeRespDtos.stream().collect(Collectors.toMap(WaybillPrintImgExchangeRespDto::getImgKey, Function.identity()));
        return printRespDtos.stream().peek(r -> r.setPrintImageUrl((String)StringUtils.defaultIfBlank((CharSequence)respDtoMap.getOrDefault(r.getPrintImageUrl(), new WaybillPrintImgExchangeRespDto()).getNewPinterImgUrl(), (CharSequence)r.getPrintImageUrl()))).sorted(Comparator.comparing(ShipOrderPrintRespDto::getSortNo)).collect(Collectors.toList());
    }

    @Override
    public void executePrintAndWriteBack(Long refRecordId, boolean force) {
        List printReqTaskEos = ((ExtQueryChainWrapper)this.logisticsPrintReqTaskDomain.filter().eq((Object)"ref_record_id", (Object)refRecordId)).list();
        LogisticsPrintReqTaskEo logisticsPrintReqTaskEo = (LogisticsPrintReqTaskEo)printReqTaskEos.get(0);
        if (logisticsPrintReqTaskEo.getPrintRetryCount() > 20 && !force) {
            printReqTaskEos.forEach(r -> {
                r.setStatus("fail");
                r.setRemark("\u6253\u5370\u91cd\u8bd5\u5927\u4e8e20\u6b21,\u5224\u5b9a\u5931\u8d25");
            });
            this.logisticsPrintReqTaskDomain.getMapper().updateBatchByIds(printReqTaskEos);
            return;
        }
        HashMap shippingUrlMap = new HashMap();
        printReqTaskEos.forEach(r -> {
            WaybillPrintReqDto printReqDto = (WaybillPrintReqDto)JSONUtil.parseObj((String)r.getPrintReqContent()).toBean(WaybillPrintReqDto.class);
            printReqDto.setTaskId(String.valueOf(r.getId()));
            WaybillPrintRespDto waybillPrintRespDto = (WaybillPrintRespDto)RestResponseHelper.extractData((RestResponse)this.waybillApi.waybillPrint(printReqDto));
            r.setPrintRespContent(JSONUtil.toJsonStr((Object)waybillPrintRespDto));
            if (!waybillPrintRespDto.isPrintStatus() || StringUtils.isBlank((CharSequence)((WaybillPrintDocRespDto)waybillPrintRespDto.getWaybillPrintDocumentReqDtoList().get(0)).getWaybillPrintImgUrl())) {
                InventoryConfig.executorNewTransaction(s -> {
                    printReqTaskEos.forEach(taskEo -> {
                        taskEo.setStatus("waitRetry");
                        taskEo.setPrintRespContent(JSONUtil.toJsonStr((Object)waybillPrintRespDto));
                        taskEo.setRemark(waybillPrintRespDto.getFailMessage());
                        taskEo.setPrintRetryCount(Integer.valueOf(Optional.ofNullable(taskEo.getPrintRetryCount()).orElse(1) + 1));
                    });
                    this.logisticsPrintReqTaskDomain.getMapper().updateBatchByIds(printReqTaskEos);
                    return s;
                });
                throw new BizException("\u8bf7\u6c42\u6253\u5370\u5931\u8d25,\u7b49\u5f85\u91cd\u8bd5");
            }
            WaybillPrintDocRespDto waybillPrintDocRespDto = (WaybillPrintDocRespDto)waybillPrintRespDto.getWaybillPrintDocumentReqDtoList().get(0);
            r.setStatus("success");
            r.setPrintUrl(waybillPrintDocRespDto.getWaybillPrintImgUrl());
            r.setPrintRespContent(JSONUtil.toJsonStr((Object)waybillPrintRespDto));
            shippingUrlMap.put(r.getShippingNo(), waybillPrintDocRespDto.getWaybillPrintImgUrl());
        });
        this.logisticsPrintReqTaskDomain.getMapper().updateBatchByIds(printReqTaskEos);
        String fileUrl = String.join((CharSequence)",", shippingUrlMap.values());
        LogisticsPrintRecordEo printRecordEo = (LogisticsPrintRecordEo)this.logisticsPrintRecordDas.selectByPrimaryKey(refRecordId);
        com.alibaba.fastjson.JSONObject parsed = ExtensionUtil.parseJson(printRecordEo.getExtension());
        parsed.put("shippingUrlMap", (Object)com.alibaba.fastjson.JSONObject.toJSONString(shippingUrlMap));
        printRecordEo.setExtension(parsed.toJSONString());
        printRecordEo.setPrintImageUrl(fileUrl);
        this.logisticsPrintRecordDas.updateSelective((BaseEo)printRecordEo);
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().eq((Object)"document_no", (Object)printRecordEo.getBizOrderNo())).one();
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        updateEo.setId(outNoticeOrderEo.getId());
        updateEo.setLogisticsOrderLabel(fileUrl);
        this.outNoticeOrderDas.updateSelective((BaseEo)updateEo);
        try {
            if (InventoryConfig.getPushWms().canPushWms(PushWmsAble.CanPushWmsBo.builder().logicWarehouseCode(outNoticeOrderEo.getOutLogicWarehouseCode()).businessType(outNoticeOrderEo.getDisplayBusinessType()).relevanceTableNameEnum(CsRelevanceTableNameEnum.getStatusByCode((String)outNoticeOrderEo.getRelevanceTableName())).orderType(outNoticeOrderEo.getJumpDocumentType()).inOut(outNoticeOrderEo.getOrderType()).relevanceNo(outNoticeOrderEo.getRelevanceNo()).build())) {
                this.outNoticeOrderService.pushWms(outNoticeOrderEo.getDocumentNo());
            }
        }
        catch (Exception e) {
            log.info("\u63a8\u9001wms\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @Override
    public void retryPrintByDocuments(List<String> documentNos) {
        List printRecordEos = ((ExtQueryChainWrapper)this.logisticsPrintRecordDas.filter().in((Object)"biz_order_no", documentNos)).list();
        printRecordEos.forEach(printRecordEo -> {
            try {
                this.executePrintAndWriteBack(printRecordEo.getId(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u91cd\u8bd5\u6253\u5370\u5931\u8d25:{}", (Object)e.getMessage());
            }
        });
    }
}

