/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.third;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IAdjustmentOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPlanOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.service.third.PushShareDispatchAble;
import com.yunxi.dg.base.center.share.dto.entity.SeparateRuleOrderRecordDto;
import com.yunxi.dg.base.center.share.proxy.entity.ISeparateRuleOrderRecordApiProxy;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DefaultPushShareDispatchAble<T extends BaseOrderBaseContext>
implements PushShareDispatchAble<T> {
    @Resource
    private ISeparateRuleOrderRecordApiProxy iSeparateRuleOrderRecordApiProxy;
    @Resource
    private ITransferOrderDomain transferOrderDomain;
    @Resource
    private IInOtherStorageOrderDomain inOtherStorageOrderDomain;
    @Resource
    private IAdjustmentOrderDomain adjustmentOrderDomain;
    @Resource
    private IPlanOrderDomain planOrderDomain;

    @Override
    public String getType() {
        return "default";
    }

    @Override
    public boolean canPush(PushAble.CanPushBo canPushBo) {
        return InventoryConfig.isCanSupplyInventory();
    }

    @Override
    public boolean push(T context) {
        SeparateRuleOrderRecordDto separateRuleOrderRecordDto = new SeparateRuleOrderRecordDto();
        BeanUtil.copyProperties(context, (Object)separateRuleOrderRecordDto, (String[])new String[0]);
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)((BaseOrderBaseContext)context).getRelevanceTableName())) {
            Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)((BaseOrderBaseContext)context).getRelevanceNo())).last("limit 1")).one()).ifPresent(transferOrderEo -> separateRuleOrderRecordDto.setAssignWarehouseCode(BaseOrderOperateTypeEnum.OUT.equals((Object)context.getOperateTypeEnum()) ? transferOrderEo.getOutSubWarehouseCode() : transferOrderEo.getInSubWarehouseCode()));
        } else if (CsRelevanceTableNameEnum.IN_OTHER_STORAGE_ORDER.equals((Object)((BaseOrderBaseContext)context).getRelevanceTableName())) {
            Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOtherStorageOrderDomain.filter().eq((Object)"storage_order_no", (Object)((BaseOrderBaseContext)context).getRelevanceNo())).last("limit 1")).one()).ifPresent(inOtherStorageOrderEo -> separateRuleOrderRecordDto.setAssignWarehouseCode(inOtherStorageOrderEo.getSubWarehouseCode()));
        } else if (CsRelevanceTableNameEnum.IN_ADJUSTMENT_ORDER.equals((Object)((BaseOrderBaseContext)context).getRelevanceTableName())) {
            Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.adjustmentOrderDomain.filter().eq((Object)"adjustment_no", (Object)((BaseOrderBaseContext)context).getRelevanceNo())).last("limit 1")).one()).ifPresent(adjustmentOrderEo -> separateRuleOrderRecordDto.setAssignWarehouseCode(adjustmentOrderEo.getSubWarehouseCode()));
        } else {
            separateRuleOrderRecordDto.setAssignWarehouseCode(((BaseOrderBaseContext)context).getSubWarehouseCode());
        }
        if (BaseOrderOperateTypeEnum.OUT.equals((Object)((BaseOrderBaseContext)context).getOperateTypeEnum())) {
            separateRuleOrderRecordDto.setOrderType(BaseOrderTypeEnum.OUT_RESULT.getCode());
        } else if (BaseOrderOperateTypeEnum.IN.equals((Object)((BaseOrderBaseContext)context).getOperateTypeEnum())) {
            separateRuleOrderRecordDto.setOrderType(BaseOrderTypeEnum.IN_NOTICE.getCode());
        } else if (BaseOrderOperateTypeEnum.IN_OUT.equals((Object)((BaseOrderBaseContext)context).getOperateTypeEnum())) {
            separateRuleOrderRecordDto.setOrderType(BaseOrderTypeEnum.ADJUST_RESULT.getCode());
        }
        separateRuleOrderRecordDto.setRelevanceTableName(((BaseOrderBaseContext)context).getRelevanceTableName().getCode());
        separateRuleOrderRecordDto.setStatus("unProcess");
        this.iSeparateRuleOrderRecordApiProxy.insert(separateRuleOrderRecordDto);
        return true;
    }

    @Override
    public boolean cancel(T context) {
        return false;
    }
}

