/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderPushThirdSettingDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.OrderPushThirdSettingEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.message.OrderCancelQimenMessageReqDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractPushWmsAble
implements PushWmsAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractPushWmsAble.class);
    @Resource
    private IPhysicsWarehouseDomain iPhysicsWarehouseDomain;
    @Resource
    private ILogicWarehouseDomain iLogicWarehouseDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderPushThirdSettingDomain orderPushThirdSettingDomain;
    @Resource
    private Environment environment;

    @Override
    public boolean canPushWms(PushWmsAble.CanPushWmsBo canPushWmsBo) {
        log.info("\u662f\u5426\u63a8\u9001wms\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)canPushWmsBo));
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)canPushWmsBo.getLogicWarehouseCode())).last("limit 1")).one();
        AssertUtils.isFalse((boolean)Objects.isNull(logicWarehouseEo), (String)("\u903b\u8f91\u4ed3" + canPushWmsBo.getLogicWarehouseCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iPhysicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).last("limit 1")).one();
        if (Objects.isNull(physicsWarehouseEo)) {
            return false;
        }
        return ObjectUtil.equals((Object)physicsWarehouseEo.getInterconnectionFlag(), (Object)1) && this.checkBySetting(canPushWmsBo, physicsWarehouseEo);
    }

    @Override
    public boolean pushWms(InOutNoticeOrderContext inOutNoticeOrderContext) {
        log.info("\u63a8\u9001wms\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderContext));
        MessageVo messageVo = new MessageVo();
        this.settingMappingType(inOutNoticeOrderContext);
        messageVo.setData((Object)JSON.toJSONString((Object)inOutNoticeOrderContext));
        this.commonsMqService.publishMessage(this.environment.resolvePlaceholders("${inventory.process.mq:PUBLISH_TOPIC}"), "PUSH_WMS", (Object)messageVo);
        return true;
    }

    @Override
    public boolean sendOrderCancel(OrderCancelQimenMessageReqDto orderCancelQimenMessageReqDto) {
        log.info("\u63a8\u9001wms\u53d6\u6d88\u5355\u636e");
        return true;
    }

    @Override
    public boolean sendOrderClose(OrderCancelQimenMessageReqDto orderCancelQimenMessageReqDto) {
        log.info("\u63a8\u9001wms\u5b8c\u7ed3\u5355\u636e");
        return true;
    }

    protected boolean checkBySetting(PushWmsAble.CanPushWmsBo canPushWmsBo, PhysicsWarehouseEo physicsWarehouseEo) {
        List orderPushThirdSettingEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderPushThirdSettingDomain.filter().eq((Object)"business_type", (Object)canPushWmsBo.getBusinessType())).eq((Object)"order_type", (Object)canPushWmsBo.getOrderType())).eq((Object)"system_code", (Object)"wms")).list();
        List<OrderPushThirdSettingEo> settingEos = AbstractPushWmsAble.getOrderPushThirdSettingEos(physicsWarehouseEo, orderPushThirdSettingEos);
        if ("adjust".equals(canPushWmsBo.getInOut()) && CollectionUtils.isNotEmpty(settingEos)) {
            return true;
        }
        return settingEos.stream().anyMatch(s -> canPushWmsBo.getInOut().equalsIgnoreCase(s.getInOut()));
    }

    @NotNull
    protected static List<OrderPushThirdSettingEo> getOrderPushThirdSettingEos(PhysicsWarehouseEo physicsWarehouseEo, List<OrderPushThirdSettingEo> orderPushThirdSettingEos) {
        return Optional.of(orderPushThirdSettingEos.stream().filter(r -> Objects.equals(physicsWarehouseEo.getWarehouseCode(), r.getPhysicsWarehouseCode())).collect(Collectors.toList())).filter(CollUtil::isNotEmpty).orElseGet(() -> orderPushThirdSettingEos.stream().filter(r -> Objects.equals(physicsWarehouseEo.getEntitySystemCode(), r.getThirdFlagCode())).collect(Collectors.toList()));
    }

    protected void settingMappingType(InOutNoticeOrderContext inOutNoticeOrderContext) {
        List orderPushThirdSettingEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderPushThirdSettingDomain.filter().eq((Object)"business_type", (Object)inOutNoticeOrderContext.getInOutNoticeOrderEo().getDisplayBusinessType())).eq((Object)"order_type", (Object)inOutNoticeOrderContext.getInOutNoticeOrderEo().getJumpDocumentType())).eq((Object)"system_code", (Object)"wms")).list();
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iPhysicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inOutNoticeOrderContext.getPhysicsWarehouseCode())).last("limit 1")).one();
        List<OrderPushThirdSettingEo> settingEos = AbstractPushWmsAble.getOrderPushThirdSettingEos(physicsWarehouseEo, orderPushThirdSettingEos);
        settingEos.stream().filter(s -> ObjectUtil.equals((Object)s.getInOut(), (Object)inOutNoticeOrderContext.getInOutNoticeOrderEo().getOrderType())).findFirst().ifPresent(orderPushThirdSettingEo -> inOutNoticeOrderContext.setThirdBusinessType(orderPushThirdSettingEo.getMappingOrderType()));
    }
}

