/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.FormOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractInOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.calc.IReleasePreemptAble;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OutResultOrderAbleImpl
extends AbstractInOutResultOrderAble {
    private static final Logger log = LoggerFactory.getLogger(OutResultOrderAbleImpl.class);
    @Resource
    private ICalcInventoryService calcInventoryService;
    @Resource
    private IReleasePreemptAble releasePreemptAble;

    @Override
    protected void wrapperGenerateAfter(InOutResultOrderContext context) {
        if (!context.getUpdateInventory().booleanValue()) {
            return;
        }
        if (this.isProcessInTransit(context)) {
            TransferOutDto transferInDto = new TransferOutDto();
            this.wrapper(context, (CalcDto)transferInDto);
            if (CollectionUtils.isEmpty((Collection)transferInDto.getDetails())) {
                return;
            }
            if (context.isAppendRecord()) {
                transferInDto.setNoneLineNo(Boolean.valueOf(true));
                transferInDto.setIgnorePreempt(Boolean.valueOf(true));
                transferInDto.setValidNegative(Boolean.valueOf(false));
            } else {
                transferInDto.setIgnorePreempt(Boolean.valueOf(context.isIgnorePreempt()));
            }
            if (context.getOrderBasicsDetailReqDtoList().stream().anyMatch(BaseOrderDetailReqDto::isOnlyRecord)) {
                transferInDto.setNoneLineNo(Boolean.valueOf(true));
            }
            if (context.isNoticeEnd() && !transferInDto.getIgnorePreempt().booleanValue()) {
                ReleasePreemptDto releasePreemptDto = (ReleasePreemptDto)BeanUtil.copyProperties((Object)transferInDto, ReleasePreemptDto.class, (String[])new String[0]);
                releasePreemptDto.setAllRelease(Boolean.valueOf(true));
                this.releasePreemptAble.releasePreempt(releasePreemptDto);
                transferInDto.setIgnorePreempt(Boolean.valueOf(true));
            }
            transferInDto.setInLogicWarehouseCode(context.getTransferInLogicWarehouseCode());
            this.calcInventoryService.transferOut(transferInDto);
            this.backfill(context, transferInDto);
        } else {
            FormOutDto formOutDto = new FormOutDto();
            this.wrapper(context, (CalcDto)formOutDto);
            if (CollectionUtils.isEmpty((Collection)formOutDto.getDetails())) {
                return;
            }
            if (context.getOrderBasicsDetailReqDtoList().stream().anyMatch(BaseOrderDetailReqDto::isOnlyRecord)) {
                formOutDto.setNoneLineNo(Boolean.valueOf(true));
            }
            if (context.isMainRelevanceNoPreempt()) {
                String mainRelevanceNo = context.getMainRelevanceNo();
                ReleasePreemptDto releasePreemptDto = (ReleasePreemptDto)BeanUtil.copyProperties((Object)formOutDto, ReleasePreemptDto.class, (String[])new String[0]);
                releasePreemptDto.setSourceNo(mainRelevanceNo);
                releasePreemptDto.setAllRelease(Boolean.valueOf(false));
                this.releasePreemptAble.releasePreempt(releasePreemptDto);
                formOutDto.setIgnorePreempt(Boolean.valueOf(true));
            } else if (context.isAppendRecord() || !this.canNoticeInventoryProcess(context)) {
                formOutDto.setNoneLineNo(Boolean.valueOf(true));
                formOutDto.setIgnorePreempt(Boolean.valueOf(true));
                formOutDto.setValidNegative(Boolean.valueOf(false));
                if (context.isOnlyGenResult()) {
                    formOutDto.setValidNegative(context.getValidNegative());
                }
            } else {
                formOutDto.setIgnorePreempt(Boolean.valueOf(context.isIgnorePreempt()));
            }
            if (context.isNoticeEnd() && !formOutDto.getIgnorePreempt().booleanValue()) {
                ReleasePreemptDto releasePreemptDto = (ReleasePreemptDto)BeanUtil.copyProperties((Object)formOutDto, ReleasePreemptDto.class, (String[])new String[0]);
                releasePreemptDto.setAllRelease(Boolean.valueOf(true));
                this.releasePreemptAble.releasePreempt(releasePreemptDto);
                formOutDto.setIgnorePreempt(Boolean.valueOf(true));
            }
            this.calcInventoryService.formOut(formOutDto);
            this.backfill(context, formOutDto);
        }
    }

    private <T extends CalcDto> void backfill(InOutResultOrderContext context, T transferInDto) {
        boolean flag;
        boolean bl = flag = InventoryConfig.isPreemptHiddenBatch() && context.getOrderBasicsDetailReqDtoList().stream().anyMatch(r -> "99999999-hidden".equals(r.getBatch()) || StringUtils.isBlank((CharSequence)r.getBatch()));
        if (flag) {
            List details = transferInDto.getDetails();
            List<BaseOrderDetailReqDto> origDetails = context.getOrderBasicsDetailReqDtoList();
            List orderBasicsDetailReqDtoList = context.getOrderBasicsDetailReqDtoList().stream().filter(r -> r.getLineNo() != null).collect(Collectors.toList());
            Map<String, BaseOrderDetailReqDto> skuOptMap = orderBasicsDetailReqDtoList.stream().collect(Collectors.toMap(b -> b.getPreOrderItemId() + b.getSkuCode(), o -> o, (o1, o2) -> o1));
            Map<String, BaseOrderDetailReqDto> skuOptBatchMap = orderBasicsDetailReqDtoList.stream().collect(Collectors.toMap(b -> b.getPreOrderItemId() + b.getSkuCode() + b.getBatch(), o -> o, (o1, o2) -> o1));
            context.setOrderBasicsDetailReqDtoList(details.stream().filter(r -> r.getLineNo() != null).map(in -> {
                BaseOrderDetailReqDto reqDto = (BaseOrderDetailReqDto)((Object)((Object)BeanUtil.copyProperties(skuOptBatchMap.getOrDefault(in.getPreOrderItemId() + in.getSkuCode() + in.getBatch(), (BaseOrderDetailReqDto)((Object)skuOptMap.get(in.getPreOrderItemId() + in.getSkuCode()))), BaseOrderDetailReqDto.class, (String[])new String[]{"id"})));
                reqDto.setBatch(in.getBatch());
                reqDto.setPreOrderItemId(in.getPreOrderItemId());
                reqDto.setQuantity(in.getNum());
                reqDto.setLineNo(in.getLineNo());
                reqDto.setInventoryProperty(in.getInventoryProperty());
                return reqDto;
            }).collect(Collectors.toList()));
            context.getOrderBasicsDetailReqDtoList().addAll(origDetails.stream().filter(r -> r.getLineNo() == null).collect(Collectors.toList()));
            if (context.isFullBatchInOutResult()) {
                List ids = context.getInOutResultOrderDetailEoList().stream().map(BaseEo::getId).collect(Collectors.toList());
                Optional.ofNullable(ids).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((IInOutResultOrderDetailDomain)this.inOutResultOrderDetailDomain).logicDeleteByIds(arg_0));
                context.setInOutResultOrderDetailEoList(this.getInOutResultOrderDetailEos(context, context.getInOutResultOrderEo()));
                this.inOutResultOrderDetailDomain.insertBatch(context.getInOutResultOrderDetailEoList());
            }
        }
    }

    private boolean isProcessInTransit(InOutResultOrderContext context) {
        return CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)context.getRelevanceTableName()) && context.getCanProcessTransit() != false && !context.isOnlyProcessResult() && !context.isAppendRecord() && this.canNoticeInventoryProcess(context);
    }

    @Override
    protected String getHangUpStatus() {
        return BaseOrderStatusEnum.ORO_HANG_UP.getCode();
    }

    @Override
    protected String getWaitConfirmStatus() {
        return BaseOrderStatusEnum.ORO_WAIT_CONFIRM.getCode();
    }

    @Override
    protected void wrapperGenerate(InOutResultOrderContext context) {
        context.getInOutResultOrderEo().setOutLogicWarehouseCode(context.getLogicWarehouseCode());
        context.getInOutResultOrderEo().setOutLogicWarehouseName(context.getLogicWarehouseName());
        context.getInOutResultOrderEo().setOutPhysicsWarehouseCode(context.getPhysicsWarehouseCode());
        context.getInOutResultOrderEo().setOutPhysicsWarehouseName(context.getPhysicsWarehouseName());
    }

    @Override
    public boolean validClose(InOutResultOrderContext context) {
        return false;
    }

    @Override
    public void doClose(InOutResultOrderContext context) {
    }

    @Override
    public boolean validCancel(InOutResultOrderContext context) {
        return super.validCancel(context);
    }

    @Override
    public void doCancel(InOutResultOrderContext context) {
        InOutResultOrderEo inOutResultOrderEo = context.getInOutResultOrderEo();
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        updateEo.setId(inOutResultOrderEo.getId());
        updateEo.setOrderStatus(BaseOrderStatusEnum.ORO_CANCEL.getCode());
        this.inOutResultOrderDomain.getMapper().updateById((BaseEo)inOutResultOrderEo);
    }

    @Override
    protected String getCompleteStatus() {
        return BaseOrderStatusEnum.ORO_DONE_OUT.getCode();
    }

    @Override
    protected void setUnhookWarehouse(InOutResultOrderContext context) {
        context.setLogicWarehouseCode(context.getInOutResultOrderEo().getOutLogicWarehouseCode());
        context.setLogicWarehouseName(context.getInOutResultOrderEo().getOutLogicWarehouseName());
        context.setPhysicsWarehouseCode(context.getInOutResultOrderEo().getOutPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(context.getInOutResultOrderEo().getOutPhysicsWarehouseName());
    }

    @Override
    protected final void unhookAfter(InOutResultOrderContext context) {
        this.wrapperGenerateAfter(context);
    }

    @Override
    protected void confirmAfter(InOutResultOrderContext context) {
        this.wrapperGenerateAfter(context);
    }
}

