/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.adjust.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.AdjustmentOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IAdjustmentOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderUpdateDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.AbstractAdjustmentOrder;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="inventoryAdjustmentOrderServiceImpl")
public class InventoryAdjustmentOrderServiceImpl
extends AbstractAdjustmentOrder<AdjustmentOrderDto, AdjustmentOrderEo, IAdjustmentOrderDomain> {
    private static final Logger log = LoggerFactory.getLogger(InventoryAdjustmentOrderServiceImpl.class);

    public InventoryAdjustmentOrderServiceImpl(IAdjustmentOrderDomain domain) {
        super(domain);
    }

    public IConverter<AdjustmentOrderDto, AdjustmentOrderEo> converter() {
        return AdjustmentOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Integer addAdjustmentOrderBatch(List<AdjustmentOrderDto> adjustmentOrderDtos) {
        adjustmentOrderDtos.forEach(adjustmentOrderDto -> {
            adjustmentOrderDto.setEvent(null);
            super.addAdjustmentOrder((AdjustmentOrderDto)adjustmentOrderDto);
        });
        return adjustmentOrderDtos.size();
    }

    @Override
    public AdjustmentOrderDto queryById(Long id) {
        return super.queryById(id);
    }

    @Override
    public void submit(AdjustmentOrderUpdateDto adjustmentOrderUpdateDto) {
        super.submit(adjustmentOrderUpdateDto);
    }

    @Override
    public void audit(AdjustmentOrderUpdateDto adjustmentOrderUpdateDto) {
        super.audit(adjustmentOrderUpdateDto);
    }

    @Override
    public AdjustmentOrderDto queryByAdjustmentNo(String adjustmentNo) {
        return super.queryByAdjustmentNo(adjustmentNo);
    }

    @Override
    public List<AdjustmentOrderDetailDto> queryDetailByAdjustmentNo(String adjustmentNo) {
        return super.queryDetailByAdjustmentNo(adjustmentNo);
    }

    @Override
    public void paramCheck(AdjustmentOrderDto adjustmentOrderDto) {
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)adjustmentOrderDto.getBusinessType()), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)adjustmentOrderDto.getAdjustmentOrderDetailDtos()), (String)"\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        adjustmentOrderDto.getAdjustmentOrderDetailDtos().forEach(adjustmentOrderDetailDto -> {
            AssertUtil.isFalse((boolean)Objects.isNull(adjustmentOrderDetailDto.getChangeQuantity()), (String)"\u8c03\u6574\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)adjustmentOrderDetailDto.getUnit()), (String)"\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        });
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)adjustmentOrderDto.getWarehouseCode()), (String)"\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)BeanUtil.isEmpty((Object)adjustmentOrderDto.getBizDate(), (String[])new String[0]), (String)"\u4e1a\u52a1\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)adjustmentOrderDto.getOrderType()), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        super.paramCheck(adjustmentOrderDto);
    }

    @Override
    protected String genAdjustmentOrderNo() {
        return InventoryConfig.getGenerateCodeUtil().generateCode(CodeGenEnum.INVENTORY_ADJUSTMENT);
    }

    @Override
    public List<AdjustmentOrderDto> queryByExternalOrderNos(List<String> externalOrderNos) {
        return super.queryByExternalOrderNos(externalOrderNos);
    }

    @Override
    public BatchOrderOperationMsgDto batchCancel(List<AdjustmentOrderUpdateDto> adjustmentOrderUpdateDtoList) {
        return super.batchCancel(adjustmentOrderUpdateDtoList);
    }

    @Override
    public BatchOrderOperationMsgDto batchWithdraw(List<String> adjustmentNoList) {
        return super.batchWithdraw(adjustmentNoList);
    }

    @Override
    public AdjustmentOrderDto queryByPreOrderNo(String preOrderNo) {
        return super.queryByPreOrderNo(preOrderNo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Integer addAdjustmentOrderBatchV2(List<AdjustmentOrderDto> adjustmentOrderDtos) {
        adjustmentOrderDtos.forEach(x$0 -> super.addAdjustmentOrder((AdjustmentOrderDto)x$0));
        return adjustmentOrderDtos.size();
    }

    @Override
    public AdjustmentOrderDto queryByAdjustmentId(Long id) {
        AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)((IAdjustmentOrderDomain)this.domain).selectByPrimaryKey(id);
        AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
        BeanUtil.copyProperties((Object)adjustmentOrderEo, (Object)adjustmentOrderDto, (String[])new String[0]);
        return adjustmentOrderDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public List<AdjustmentOrderDto> addAdjustmentOrderBatchV3(List<AdjustmentOrderDto> adjustmentOrderDtos) {
        return adjustmentOrderDtos.stream().map(k -> {
            Long id = this.addAdjustmentOrder((AdjustmentOrderDto)k);
            return this.queryByAdjustmentId(id);
        }).collect(Collectors.toList());
    }
}

