/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.action;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IAdjustmentOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentChangeTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentInventoryContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class AdjustmentInventoryOrderPreemptAction
extends AbstractAction<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentInventoryOrderPreemptAction.class);
    @Resource
    private ICalcInventoryService calcInventoryService;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private IAdjustmentOrderDetailDomain adjustmentOrderDetailDomain;

    @Override
    public void doExecute(StateContext<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> context) {
        log.info("\u8fdb\u5165\u8c03\u6574\u5355\u9884\u5360\u5e93\u5b58\u52a8\u4f5c");
        StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        AdjustmentOrderEo eo = (AdjustmentOrderEo)executorBo.getEo();
        List adjustmentOrderDetailEos = (List)executorBo.getVariables().get(AdjustmentInventoryContextEnum.ADJUSTMENT_INVENTORY_ORDER_DETAIL.getCode());
        Map<Object, OrderUnitConversionRecordDto> unitConversionRecordDtoMap = this.unitProcess(eo.getAdjustmentNo(), adjustmentOrderDetailEos);
        PreemptDto preemptDto = new PreemptDto();
        preemptDto.setSourceType(eo.getOrderType());
        preemptDto.setSourceNo(eo.getAdjustmentNo());
        preemptDto.setBusinessType(eo.getBusinessType());
        preemptDto.setExternalOrderNo(eo.getExternalOrderNo());
        preemptDto.setPreOrderNo(eo.getPreOrderNo());
        preemptDto.setNoneLineNo(Boolean.valueOf(true));
        preemptDto.setValidNegative(Boolean.valueOf(InventoryConfig.isCheckInventory()));
        preemptDto.setRemark("\u5907\u6ce8");
        ArrayList calcDetailDtoList = new ArrayList();
        adjustmentOrderDetailEos.forEach(orderDetailEo -> {
            OrderUnitConversionRecordDto orderUnitConversionRecordDto = (OrderUnitConversionRecordDto)unitConversionRecordDtoMap.get(this.getKey(orderDetailEo.getSkuCode(), orderDetailEo.getChangeQuantity(), orderDetailEo.getUnit()));
            HashMap<String, BigDecimal> extMap = new HashMap<String, BigDecimal>();
            extMap.put("grossWeightUnit", Objects.nonNull(orderUnitConversionRecordDto) ? orderUnitConversionRecordDto.getGrossWeight() : null);
            extMap.put("volume", Objects.nonNull(orderUnitConversionRecordDto) ? orderUnitConversionRecordDto.getVolume() : null);
            orderDetailEo.setExtension(JSONObject.toJSONString(extMap));
            this.adjustmentOrderDetailDomain.updateSelective((BaseEo)orderDetailEo);
            if (AdjustmentChangeTypeEnum.DECREASE.getCode().equals(orderDetailEo.getChangeType())) {
                CalcDetailDto calcDetailDto = new CalcDetailDto();
                calcDetailDto.setLogicWarehouseCode(eo.getWarehouseCode());
                calcDetailDto.setBatch(this.getPreemptBatch(eo.getOrderType(), (AdjustmentOrderDetailEo)orderDetailEo));
                calcDetailDto.setNum(BeanUtil.isNotEmpty((Object)orderUnitConversionRecordDto, (String[])new String[0]) ? orderUnitConversionRecordDto.getToNum() : BigDecimal.ZERO);
                calcDetailDto.setSkuCode(orderDetailEo.getSkuCode());
                calcDetailDto.setInventoryProperty(orderDetailEo.getInventoryProperty());
                calcDetailDto.setProduceDate(orderDetailEo.getProduceTime());
                calcDetailDto.setExpireDate(orderDetailEo.getExpireTime());
                calcDetailDtoList.add(calcDetailDto);
            }
        });
        preemptDto.setDetails(calcDetailDtoList);
        if (CollectionUtils.isNotEmpty(calcDetailDtoList)) {
            this.calcInventoryService.updatePreempt(preemptDto);
            if (InventoryConfig.isCanSupplyInventory() && InventoryConfig.getPushShareDispatchAble().canPush(PushAble.CanPushBo.builder().logicWarehouseCode(eo.getWarehouseCode()).build())) {
                BaseOrderBaseContext baseOrderBaseContext = new BaseOrderBaseContext();
                baseOrderBaseContext.setRelevanceNo(eo.getAdjustmentNo());
                baseOrderBaseContext.setRelevanceTableName(CsRelevanceTableNameEnum.IN_ADJUSTMENT_ORDER);
                baseOrderBaseContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
                baseOrderBaseContext.setBusinessType(eo.getBusinessType());
                baseOrderBaseContext.setExternalOrderNo(eo.getExternalOrderNo());
                InventoryConfig.getPushShareDispatchAble().push(baseOrderBaseContext);
            }
        }
    }

    private Map<Object, OrderUnitConversionRecordDto> unitProcess(String adjustmentOrderNo, List<AdjustmentOrderDetailEo> adjustmentOrderDetailEos) {
        ArrayList unitConversionDetails = new ArrayList();
        adjustmentOrderDetailEos.forEach(detailEo -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(detailEo.getUnit());
            unitConversionDetail.setSkuCode(detailEo.getSkuCode());
            unitConversionDetail.setCurNum(detailEo.getChangeQuantity());
            unitConversionDetails.add(unitConversionDetail);
        });
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(adjustmentOrderNo);
        orderUnitConversionReqDto.setType("adjustment");
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
        return orderUnitConversionRecordDtos.stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getNum(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
    }

    private String getPreemptBatch(String orderType, AdjustmentOrderDetailEo detailEo) {
        return (String)DataExtractUtils.ifNullElse((Object)detailEo.getOrigBatch(), (Object)detailEo.getBatch());
    }

    private Object getKey(String skuCode, BigDecimal num, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + num.setScale(6) + InventoryConfig.getCommonSeparate() + currentUnit;
    }
}

