/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.order.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdvancedShippingDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.AdvancedShippingOrderDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutDeliveryMessageDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.order.AdvancedShippingOrderService;
import com.yunxi.dg.base.center.source.dto.entity.AdvancedStrategyDto;
import com.yunxi.dg.base.center.source.proxy.entity.IAdvancedStrategyApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdvancedShippingOrderServiceImpl
implements AdvancedShippingOrderService {
    private static final Logger log = LoggerFactory.getLogger(AdvancedShippingOrderServiceImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IAdvancedStrategyApiProxy advancedStrategyApiProxy;

    @Override
    public void orderSaleAdvancedShipping(AdvancedShippingDto shippingDto) {
        String outNoticeOrderNo = shippingDto.getOutNoticeOrderNo();
        InOutNoticeOrderEo noticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)outNoticeOrderNo)).one();
        if (Objects.isNull(noticeOrderEo)) {
            log.info("\u51fa\u5e93\u901a\u77e5\u5355\uff1a{} \u4e0d\u5b58\u5728", (Object)outNoticeOrderNo);
            return;
        }
        String shippingCode = noticeOrderEo.getShippingCode();
        if (StrUtil.isBlank((CharSequence)shippingCode)) {
            log.info("\u51fa\u5e93\u901a\u77e5\u5355\u7269\u6d41\u5355\u53f7\uff1a{} \u4e0d\u5b58\u5728", (Object)outNoticeOrderNo);
            return;
        }
        String shopCode = noticeOrderEo.getShopCode();
        AdvancedStrategyDto waybillAdvanced = (AdvancedStrategyDto)RestResponseHelper.extractData((RestResponse)this.advancedStrategyApiProxy.getEnableWaybill(shopCode));
        if (Objects.isNull(waybillAdvanced)) {
            log.info("\u51fa\u5e93\u901a\u77e5\u5355\uff1a{} \u5173\u8054\u5e97\u94fa\uff1a{} {} \u672a\u547d\u4e2d\u9884\u53d1\u8d27\u7b56\u7565", new Object[]{outNoticeOrderNo, shopCode, noticeOrderEo.getShopName()});
            return;
        }
        String shipmentEnterpriseCode = noticeOrderEo.getShipmentEnterpriseCode();
        String shipmentEnterpriseName = noticeOrderEo.getShipmentEnterpriseName();
        OutDeliveryMessageDto outDeliveryMessageDto = new OutDeliveryMessageDto();
        outDeliveryMessageDto.setDeliveryTime(new Date());
        outDeliveryMessageDto.setOrderNo(noticeOrderEo.getRelevanceNo());
        outDeliveryMessageDto.setOutNoticeOrderNo(outNoticeOrderNo);
        outDeliveryMessageDto.setShippingNo(shippingCode);
        outDeliveryMessageDto.setShipmentEnterpriseCode(shipmentEnterpriseCode);
        outDeliveryMessageDto.setShipmentEnterpriseName(shipmentEnterpriseName);
        this.sendAdvancedShippingMsg(outNoticeOrderNo, outDeliveryMessageDto);
    }

    private void sendAdvancedShippingMsg(String outNoticeOrderNo, OutDeliveryMessageDto outDeliveryMessageDto) {
        String outDeliveryMsg = JSONObject.toJSONString((Object)outDeliveryMessageDto);
        log.info("\u9884\u53d1\u8d27\u901a\u77e5\u4ea4\u6613\uff1a{}", (Object)outDeliveryMsg);
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("NOTICE_ADVANCED_SHIPPING_ORDER_SALE_TAG", (Object)outDeliveryMsg);
        log.info("\u51fa\u5e93\u901a\u77e5\u5355\uff1a{} \u9884\u53d1\u8d27msgId\uff1a{}", (Object)outNoticeOrderNo, messageResponse.getData());
    }

    @Override
    public void orderSaleAdvancedShippingByWms(AdvancedShippingOrderDto shippingDto) {
        String outNoticeOrderNo = shippingDto.getOutNoticeOrderNo();
        String shopCode = shippingDto.getShopCode();
        AdvancedStrategyDto waybillAdvanced = (AdvancedStrategyDto)RestResponseHelper.extractData((RestResponse)this.advancedStrategyApiProxy.getEnableWsm(shopCode));
        if (Objects.isNull(waybillAdvanced)) {
            log.info("\u51fa\u5e93\u901a\u77e5\u5355\uff1a{} \u5173\u8054\u5e97\u94fa\uff1a{} {} \u672a\u547d\u4e2d\u9884\u53d1\u8d27\u7b56\u7565", new Object[]{outNoticeOrderNo, shopCode, shippingDto.getShopName()});
            return;
        }
        OutDeliveryMessageDto outDeliveryMessageDto = (OutDeliveryMessageDto)BeanUtil.copyProperties((Object)shippingDto, OutDeliveryMessageDto.class, (String[])new String[0]);
        this.sendAdvancedShippingMsg(outNoticeOrderNo, outDeliveryMessageDto);
    }
}

