/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.other.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CommitEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.enums.OtherStorageOrderReceiveStatusEnum;
import com.yunxi.dg.base.center.enums.PcpBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.InOtherStorageOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IAutomaticAuditPolicyDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageBusinessTypeDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseRelationDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageOrderUpdateDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageBusinessTypeEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseRelationEo;
import com.yunxi.dg.base.center.inventory.service.annotatin.OptLogContext;
import com.yunxi.dg.base.center.inventory.service.business.other.IInOtherStorageOrderService;
import com.yunxi.dg.base.center.inventory.service.business.other.impl.OtherStorageOrderContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherStorageOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineMap;
import com.yunxi.dg.base.center.inventory.statemachine.executor.OtherInOutStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DateUtils;
import com.yunxi.dg.base.center.openapi.dto.erp.ErpMaterialCarryLineRequestDto;
import com.yunxi.dg.base.center.openapi.dto.erp.ErpMaterialCarryRequestDto;
import com.yunxi.dg.base.center.openapi.proxy.erp.IExternalInventoryErpApiProxy;
import com.yunxi.dg.base.center.trade.proxy.order.IOrderConfigQueryApiProxy;
import com.yunxi.dg.base.center.user.dto.OrgRespDto;
import com.yunxi.dg.base.center.user.proxy.IDgOrganizationApiProxy;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InOtherStorageOrderServiceImpl
extends BaseServiceImpl<InOtherStorageOrderDto, InOtherStorageOrderEo, IInOtherStorageOrderDomain>
implements IInOtherStorageOrderService {
    private static final Logger log = LoggerFactory.getLogger(InOtherStorageOrderServiceImpl.class);
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private IInOtherStorageOrderDetailDomain inOtherStorageOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordService iOrderUnitConversionRecordService;
    @Resource
    private OtherInOutStatemachineExecutor otherInOutStatemachineExecutor;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    protected ICalcInventoryService calcInventoryService;
    @Resource
    private IContext iContext;
    @Resource
    protected IAutomaticAuditPolicyDomain automaticAuditPolicyDomain;
    @Resource
    protected IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    private IExternalInventoryErpApiProxy iExternalInventoryErpApiProxy;
    @Resource
    private IWarehouseRelationDomain iWarehouseRelationDomain;
    @Resource
    private IInOtherStorageBusinessTypeDomain inOtherStorageBusinessTypeDomain;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private IDgOrganizationApiProxy dgOrganizationApiProxy;
    @Resource
    private IOrderConfigQueryApiProxy orderConfigQueryApiProxy;

    public InOtherStorageOrderServiceImpl(IInOtherStorageOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InOtherStorageOrderDto, InOtherStorageOrderEo> converter() {
        return InOtherStorageOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Long addOtherStorageOrder(InOtherStorageOrderDto inOtherStorageOrderDto) {
        log.info("\u6dfb\u52a0\u5176\u4ed6\u51fa\u5165\u5e93\u5355,\u53c2\u6570{}", (Object)JSON.toJSONString((Object)inOtherStorageOrderDto));
        String organizationCode = null;
        AssertUtils.isTrue(("SAVE".equals(inOtherStorageOrderDto.getCommitType()) || "COMMIT".equals(inOtherStorageOrderDto.getCommitType()) || "autoComplete".equals(inOtherStorageOrderDto.getCommitType()) ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u7c7b\u578b\u4e0d\u6b63\u786e");
        boolean isEdit = Objects.nonNull(inOtherStorageOrderDto.getId());
        if (Objects.nonNull(inOtherStorageOrderDto.getId())) {
            InOtherStorageOrderEo orderEo = (InOtherStorageOrderEo)((IInOtherStorageOrderDomain)this.domain).selectByPrimaryKey(inOtherStorageOrderDto.getId());
            AssertUtil.isTrue((boolean)Objects.nonNull(orderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728");
            inOtherStorageOrderDto.setStorageOrderNo(orderEo.getStorageOrderNo());
            inOtherStorageOrderDto.setOrderSrc(orderEo.getOrderSrc());
            inOtherStorageOrderDto.setSourceSystem(orderEo.getSourceSystem());
            inOtherStorageOrderDto.setOrderStatus(orderEo.getOrderStatus());
            organizationCode = orderEo.getOrganizationCode();
            if (StringUtils.isEmpty((CharSequence)orderEo.getExternalOrderNo())) {
                organizationCode = null;
            }
        }
        if (!this.checkDeptLabels(inOtherStorageOrderDto)) {
            throw new BizException("\u9009\u62e9\u90e8\u95e8\u4fe1\u606f\u6709\u8bef");
        }
        this.reSetBizDate(inOtherStorageOrderDto);
        LogicWarehouseEo logicWarehouseEo = this.checkLogicWarehouse(inOtherStorageOrderDto.getWarehouseCode());
        List inOtherStorageOrderDetailDtos = inOtherStorageOrderDto.getInOtherStorageOrderDetailDtos();
        this.checkSku(inOtherStorageOrderDetailDtos);
        this.checkProject(inOtherStorageOrderDto.getBusinessType(), inOtherStorageOrderDetailDtos);
        InOtherStorageOrderEo insertEo = new InOtherStorageOrderEo();
        BeanUtils.copyProperties((Object)inOtherStorageOrderDto, (Object)insertEo);
        String inventoryProperty = Optional.ofNullable(inOtherStorageOrderDto.getInventoryProperty()).orElse(LogicWarehouseQualityEnum.QUALIFIED.getCode());
        insertEo.setInventoryProperty(inventoryProperty);
        if (CollectionUtils.isNotEmpty((Collection)inOtherStorageOrderDto.getDocumentUrlList())) {
            if (inOtherStorageOrderDto.getDocumentUrlList().size() > 50) {
                throw new RuntimeException("\u63d0\u4ea4\u7684\u6587\u4ef6\u4fe1\u606f\u5df2\u8d85\u8fc7\u4e94\u5341\u6761");
            }
            insertEo.setDocumentUrl(StringUtils.join((Iterable)inOtherStorageOrderDto.getDocumentUrlList(), (String)","));
        } else {
            insertEo.setDocumentUrl("");
        }
        String code = insertEo.getStorageOrderNo();
        if (StringUtils.isEmpty((CharSequence)code)) {
            if (DgOtherStorageOrderTypeEnum.OUT.getCode().equals(inOtherStorageOrderDto.getType())) {
                code = InventoryConfig.getGenerateCodeUtil().generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.OTHER_STORAGE_ORDER_OUT.getCode()));
            } else if (DgOtherStorageOrderTypeEnum.IN.getCode().equals(inOtherStorageOrderDto.getType())) {
                code = InventoryConfig.getGenerateCodeUtil().generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.OTHER_STORAGE_ORDER_IN.getCode()));
            } else if (DgOtherStorageOrderTypeEnum.PARTS_REQUISITION.getCode().equals(inOtherStorageOrderDto.getType())) {
                code = InventoryConfig.getGenerateCodeUtil().generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.PARTS_REQUISITION.getCode()));
            } else if (DgOtherStorageOrderTypeEnum.SCRAP_OUT.getCode().equals(inOtherStorageOrderDto.getType())) {
                code = InventoryConfig.getGenerateCodeUtil().generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.SCRAP_OUT.getCode()));
            } else {
                throw new BizException(String.format("\u5355\u636e\u7c7b\u578b\u4e0d\u6b63\u786e,%s", inOtherStorageOrderDto.getType()));
            }
            insertEo.setStorageOrderNo(code);
        }
        if (!isEdit) {
            insertEo.setOrderStatus(DgOtherOrderStatusEnum.INIT.getKey());
        }
        DgOtherStorageOrderTypeEnum orderTypeEnum = DgOtherStorageOrderTypeEnum.getByCode(inOtherStorageOrderDto.getType());
        boolean inOut = StrUtil.equals((CharSequence)"in", (CharSequence)orderTypeEnum.getFlag());
        insertEo.setOrganizationCode(Optional.ofNullable(logicWarehouseEo.getCargoEscheatageName()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(logicWarehouseEo.getOrganizationCode()));
        insertEo.setOrganizationName(Optional.ofNullable(logicWarehouseEo.getCargoEscheatageName()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(logicWarehouseEo.getOrganizationName()));
        insertEo.setWarehouseName(logicWarehouseEo.getWarehouseName());
        insertEo.setPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
        insertEo.setPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
        if (StringUtils.isEmpty((CharSequence)insertEo.getCargoOrganizationCode())) {
            insertEo.setCargoOrganizationCode(logicWarehouseEo.getOrganizationCode());
            insertEo.setCargoOrganizationName(logicWarehouseEo.getOrganizationName());
        }
        if (StringUtils.isBlank((CharSequence)inOtherStorageOrderDto.getAddress())) {
            ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseAddressDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).eq((Object)"warehouse_classify", (Object)"physics")).last(" limit 1 ")).oneOpt().ifPresent(address -> {
                insertEo.setProvinceCode(address.getProvinceCode());
                insertEo.setProvinceName(address.getProvince());
                insertEo.setCityCode(address.getCityCode());
                insertEo.setCityName(address.getCity());
                insertEo.setAreaCode(address.getDistrictCode());
                insertEo.setAreaName(address.getDistrict());
                insertEo.setAddress(address.getDetailAddress());
                insertEo.setConsignee(address.getContacts());
                insertEo.setPhone(address.getPhone());
            });
        }
        ArrayList eoList = new ArrayList(inOtherStorageOrderDetailDtos.size());
        inOtherStorageOrderDetailDtos.forEach(detail -> {
            InOtherStorageOrderDetailEo detailEo = new InOtherStorageOrderDetailEo();
            BeanUtils.copyProperties((Object)detail, (Object)detailEo);
            detailEo.setStorageOrderNo(insertEo.getStorageOrderNo());
            detailEo.setInventoryProperty(inventoryProperty);
            if (InventoryConfig.isNoneBatch() && inOut) {
                detailEo.setBatch((String)ObjectUtils.defaultIfNull((Object)detailEo.getBatch(), (Object)InventoryConfig.getDefaultBatch()));
            }
            eoList.add(detailEo);
        });
        this.computerVolumeAndQuantity(inOtherStorageOrderDetailDtos, insertEo, code);
        if (StringUtils.isEmpty((CharSequence)organizationCode)) {
            insertEo.setOrganizationCode(logicWarehouseEo.getOrganizationCode());
        }
        insertEo.setCreatePerson(this.iContext.userName());
        insertEo.setUpdatePerson(this.iContext.userName());
        StatemachineMap storageOrderDetailListMap = new StatemachineMap();
        storageOrderDetailListMap.put(OtherStorageOrderContextEnum.OTHER_STORAGE_ORDER_DETAIL.getCode(), eoList);
        storageOrderDetailListMap.put(OtherStorageOrderContextEnum.UPDATE_OTHER_STORAGE.getCode(), inOtherStorageOrderDto);
        if ("autoComplete".equals(inOtherStorageOrderDto.getCommitType())) {
            storageOrderDetailListMap.put("autoComplete", "1");
            if (InventoryConfig.isEnableInOutAutoComplete() && this.canAutoComplete(insertEo.getBusinessType(), insertEo.getType(), insertEo.getWarehouseCode())) {
                storageOrderDetailListMap.put("noPushWms", "1");
            }
        }
        StatemachineExecutorBo<InOtherStorageOrderEo> inOtherStorageOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<InOtherStorageOrderEo>();
        inOtherStorageOrderEoStatemachineExecutorBo.setEo(insertEo);
        inOtherStorageOrderEoStatemachineExecutorBo.setVariables(storageOrderDetailListMap);
        boolean execute = this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.SAVE, inOtherStorageOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u4fdd\u5b58\u5931\u8d25:{},{}", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25");
        }
        if (CommitEnum.COMMIT.code().equals(inOtherStorageOrderDto.getCommitType())) {
            InventoryConfig.registerSynchronizationAfterCommit(() -> {
                int auditLevel = this.automaticAuditPolicyDomain.getAuditLevel(insertEo.getType(), insertEo.getBusinessType());
                if (auditLevel <= 1 || CommitEnum.AUTOCOMPLETE.code().equals(inOtherStorageOrderDto.getCommitType())) {
                    InOtherStorageOrderUpdateDto inOtherStorageOrderUpdateDto = new InOtherStorageOrderUpdateDto();
                    inOtherStorageOrderUpdateDto.setStorageOrderNo(insertEo.getStorageOrderNo());
                    inOtherStorageOrderUpdateDto.setAuditResult("1");
                    inOtherStorageOrderUpdateDto.setRemark("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
                    InventoryConfig.executorNewTransaction(s -> {
                        this.audit(inOtherStorageOrderUpdateDto);
                        if (InventoryConfig.isCanSecondLevel() && (auditLevel == 0 || auditLevel == 2)) {
                            this.audit(inOtherStorageOrderUpdateDto);
                        }
                        return s;
                    });
                }
            });
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.getEditType((boolean)isEdit), (String)"EMPTY", (String)insertEo.getStorageOrderNo(), (String)insertEo.getType());
        return insertEo.getId();
    }

    private void reSetBizDate(InOtherStorageOrderDto inOtherStorageOrderDto) {
        if (DgOtherStorageOrderTypeEnum.WUTOUJIANTUIHUORUKU.getCode().equals(inOtherStorageOrderDto.getBusinessType()) || DgOtherStorageOrderTypeEnum.WUTOUJIANTUIHUOCHUKU.getCode().equals(inOtherStorageOrderDto.getBusinessType())) {
            log.info("\u65e0\u5934\u4ef6\u9000\u8d27:{},\u8fdb\u884c\u4e1a\u52a1\u65f6\u95f4\u68c0\u67e5", (Object)inOtherStorageOrderDto.getStorageOrderNo());
            Date bizDate = inOtherStorageOrderDto.getBizDate();
            int courtMonth = DateUtils.getMonth((Date)bizDate);
            int courtDay = DateUtils.getDate((Date)bizDate);
            Boolean verifyWarning = (Boolean)RestResponseHelper.extractData((RestResponse)this.orderConfigQueryApiProxy.verifyHqU9CheckoutWarning(Integer.valueOf(courtMonth), Integer.valueOf(courtDay)));
            if (verifyWarning.booleanValue()) {
                log.info("\u65e0\u5934\u4ef6\u9000\u8d27:{}\u7684\u4e1a\u52a1\u65e5\u671f\u5728\u9884\u8b66\u8303\u56f4\u5185,\u4e1a\u52a1\u65f6\u95f4\u8bbe\u7f6e\u6210\u4e0b\u4e2a\u6708", (Object)inOtherStorageOrderDto.getStorageOrderNo());
                inOtherStorageOrderDto.setBizDate(DateUtils.getMonthStart((Date)DateUtils.addMonth((Date)bizDate, (int)1)));
            }
        }
    }

    private boolean checkDeptLabels(InOtherStorageOrderDto inOtherStorageOrderDto) {
        String whDepartmentCode;
        OrgRespDto orgRespDto;
        JSONObject jsonObject;
        InOtherStorageBusinessTypeEo inOtherStorageBusinessTypeEo = this.getInOtherStorageBusinessTypeEo(inOtherStorageOrderDto.getBusinessType(), inOtherStorageOrderDto.getType());
        if (inOtherStorageBusinessTypeEo == null || StringUtils.isEmpty((CharSequence)inOtherStorageBusinessTypeEo.getDeptLabels())) {
            log.info("\u5176\u4ed6\u51fa\u5165\u5355\u4e1a\u52a1\u7c7b\u578b\u8868\u65e0\u6570\u636e,type:{},businessType:{},", (Object)inOtherStorageOrderDto.getType(), (Object)inOtherStorageOrderDto.getBusinessType());
            return true;
        }
        List deptLabels = Arrays.stream(inOtherStorageBusinessTypeEo.getDeptLabels().split(",")).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((CharSequence)inOtherStorageOrderDto.getExtension()) && (jsonObject = JSONObject.parseObject((String)inOtherStorageOrderDto.getExtension())).get((Object)"whDepartmentCode") != null && (orgRespDto = (OrgRespDto)this.dgOrganizationApiProxy.queryByCode(whDepartmentCode = jsonObject.get((Object)"whDepartmentCode").toString()).getData()) != null) {
            String deptLabel = orgRespDto.getDeptLabel();
            log.info("deptLabel:{},deptLabels:{}", (Object)deptLabel, deptLabels);
            return deptLabels.contains(deptLabel);
        }
        return true;
    }

    @Override
    public void submitById(Long id) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void submit(InOtherStorageOrderUpdateDto inOtherStorageOrderUpdateDto) {
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)inOtherStorageOrderUpdateDto.getStorageOrderNo()), (String)"\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        InOtherStorageOrderEo orderEo = this.getInOtherStorageOrderEo(inOtherStorageOrderUpdateDto);
        List storageOrderDetailList = ((ExtQueryChainWrapper)this.inOtherStorageOrderDetailDomain.filter().eq((Object)"storage_order_no", (Object)inOtherStorageOrderUpdateDto.getStorageOrderNo())).list();
        StatemachineMap storageOrderDetailListMap = new StatemachineMap();
        storageOrderDetailListMap.put(OtherStorageOrderContextEnum.OTHER_STORAGE_ORDER_DETAIL.getCode(), storageOrderDetailList);
        StatemachineExecutorBo<InOtherStorageOrderEo> inOtherStorageOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<InOtherStorageOrderEo>();
        inOtherStorageOrderEoStatemachineExecutorBo.setEo(orderEo);
        inOtherStorageOrderEoStatemachineExecutorBo.setVariables(storageOrderDetailListMap);
        boolean execute = this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.SUBMIT, inOtherStorageOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u63d0\u4ea4\u5931\u8d25:{},{}", (Object)Thread.currentThread().getName(), (Object)orderEo.getStorageOrderNo());
            throw new RuntimeException("\u63d0\u4ea4\u5931\u8d25");
        }
        boolean isAutoAudit = this.automaticAuditPolicyDomain.isAutoAudit(orderEo.getType(), orderEo.getBusinessType());
        if (isAutoAudit) {
            InOtherStorageOrderUpdateDto storageOrderUpdateDto = new InOtherStorageOrderUpdateDto();
            storageOrderUpdateDto.setStorageOrderNo(orderEo.getStorageOrderNo());
            storageOrderUpdateDto.setAuditResult("1");
            storageOrderUpdateDto.setRemark("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
            this.audit(storageOrderUpdateDto);
            if (InventoryConfig.isCanSecondLevel()) {
                this.audit(storageOrderUpdateDto);
            }
        }
        boolean isEdit = Objects.nonNull(orderEo.getId());
        OptUtil.addOptLog((String)OperationLogTypeEnum.getEditType((boolean)isEdit), (String)"EMPTY", (String)orderEo.getStorageOrderNo(), (String)orderEo.getType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    @OptLogContext(logType=OperationLogTypeEnum.WITHDRAW, orderCodeSpel="#inOtherStorageOrderUpdateDto.storageOrderNo", typeSpel="#inOtherStorageOrderUpdateDto.orderType")
    public void withdraw(InOtherStorageOrderUpdateDto inOtherStorageOrderUpdateDto) {
        InOtherStorageOrderEo orderEo = this.getInOtherStorageOrderEo(inOtherStorageOrderUpdateDto);
        inOtherStorageOrderUpdateDto.setOrderType(orderEo.getType());
        List receiveDeliveryNoticeOrderList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)inOtherStorageOrderUpdateDto.getStorageOrderNo())).eq((Object)"dr", (Object)YesNoEnum.NO)).list();
        StatemachineMap storageOrderDetailListMap = new StatemachineMap();
        storageOrderDetailListMap.put(OtherStorageOrderContextEnum.RECEIVE_DELIVERY_NOTICE_ORDER.getCode(), receiveDeliveryNoticeOrderList);
        StatemachineExecutorBo<InOtherStorageOrderEo> inOtherStorageOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<InOtherStorageOrderEo>();
        inOtherStorageOrderEoStatemachineExecutorBo.setEo(orderEo);
        inOtherStorageOrderEoStatemachineExecutorBo.setVariables(storageOrderDetailListMap);
        boolean execute = this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.WITHDRAW, inOtherStorageOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u64a4\u56de\u5931\u8d25:{}", (Object)Thread.currentThread().getName(), (Object)orderEo.getStorageOrderNo());
            throw new RuntimeException("\u64a4\u56de\u5931\u8d25");
        }
    }

    @Override
    public BatchOrderOperationMsgDto batchWithdraw(List<InOtherStorageOrderUpdateDto> inOtherStorageOrderUpdateDtoList) {
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        inOtherStorageOrderUpdateDtoList.forEach(dto -> {
            BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
            try {
                this.withdraw((InOtherStorageOrderUpdateDto)dto);
                resMsg.setMsg(dto.getStorageOrderNo());
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                resMsg.setMsg(String.format("%s\u64a4\u56de\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", dto.getStorageOrderNo(), e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(inOtherStorageOrderUpdateDtoList.size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return msgDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void audit(InOtherStorageOrderUpdateDto inOtherStorageOrderUpdateDto) {
        boolean execute;
        JSONObject jsonObject;
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)inOtherStorageOrderUpdateDto.getStorageOrderNo()), (String)"\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)inOtherStorageOrderUpdateDto.getAuditResult()), (String)"\u5ba1\u6838\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        InOtherStorageOrderEo orderEo = this.getInOtherStorageOrderEo(inOtherStorageOrderUpdateDto);
        String extension = orderEo.getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            jsonObject = JSONObject.parseObject((String)extension);
            jsonObject.put("auditRemark", (Object)inOtherStorageOrderUpdateDto.getRemark());
            extension = jsonObject.toJSONString();
        } else {
            jsonObject = new JSONObject();
            jsonObject.put("auditRemark", (Object)inOtherStorageOrderUpdateDto.getRemark());
            extension = jsonObject.toJSONString();
        }
        orderEo.setExtension(extension);
        if (inOtherStorageOrderUpdateDto.getBizDate() != null) {
            orderEo.setBizDate(inOtherStorageOrderUpdateDto.getBizDate());
        }
        List storageOrderDetailList = ((ExtQueryChainWrapper)this.inOtherStorageOrderDetailDomain.filter().eq((Object)"storage_order_no", (Object)inOtherStorageOrderUpdateDto.getStorageOrderNo())).list();
        AssertUtils.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)storageOrderDetailList), (String)(orderEo.getStorageOrderNo() + "\u5355\u636e\u660e\u7ec6\u4e3a\u7a7a"));
        StatemachineMap storageOrderDetailListMap = new StatemachineMap();
        storageOrderDetailListMap.put(OtherStorageOrderContextEnum.OTHER_STORAGE_ORDER_DETAIL.getCode(), storageOrderDetailList);
        if (InventoryConfig.isEnableInOutAutoComplete() && this.canAutoComplete(orderEo.getBusinessType(), orderEo.getType())) {
            storageOrderDetailListMap.put("autoComplete", "1");
            storageOrderDetailListMap.put("noPushWms", "1");
        }
        StatemachineExecutorBo<InOtherStorageOrderEo> inOtherStorageOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<InOtherStorageOrderEo>();
        inOtherStorageOrderEoStatemachineExecutorBo.setEo(orderEo);
        inOtherStorageOrderEoStatemachineExecutorBo.setVariables(storageOrderDetailListMap);
        boolean isApproved = true;
        if (YesNoEnum.YES.getValue().toString().equals(inOtherStorageOrderUpdateDto.getAuditResult())) {
            execute = InventoryConfig.isCanSecondLevel() ? this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.AUDIT, inOtherStorageOrderEoStatemachineExecutorBo) : this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.TWO_AUDIT, inOtherStorageOrderEoStatemachineExecutorBo);
        } else {
            isApproved = false;
            execute = this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.AUDITFAILED, inOtherStorageOrderEoStatemachineExecutorBo);
        }
        if (!execute) {
            log.error("\u5ba1\u6838\u5931\u8d25:{},{}", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u5ba1\u6838\u5931\u8d25\u8be5\u5355\u636e" + orderEo.getStorageOrderNo() + "\u72b6\u6001\u4e3a" + orderEo.getOrderStatus());
        }
        if (StringUtils.equals((CharSequence)PcpBusinessTypeEnum.PARTS_REQUISITION_OUT.getCode(), (CharSequence)orderEo.getBusinessType()) && StringUtils.equals((CharSequence)DgOtherOrderStatusEnum.WAIT_TWO_AUDIT.getKey(), (CharSequence)orderEo.getOrderStatus()) && StringUtils.equals((CharSequence)inOtherStorageOrderUpdateDto.getAuditResult(), (CharSequence)YesNoHelper.YES.toString())) {
            log.info("\u8fdb\u5165\u5230\u540c\u6b65\u642c\u8fd0\u5355");
            this.syncMaterialCarryOrder(orderEo, storageOrderDetailList);
        }
        String remark = StrUtil.emptyToDefault((CharSequence)inOtherStorageOrderUpdateDto.getRemark(), (String)"EMPTY");
        OptUtil.addOptLog((String)OperationLogTypeEnum.getAuditType((boolean)isApproved), (String)remark, (String)orderEo.getStorageOrderNo(), (String)orderEo.getType());
    }

    private void syncMaterialCarryOrder(InOtherStorageOrderEo orderEo, List<InOtherStorageOrderDetailEo> storageOrderDetailList) {
        ErpMaterialCarryRequestDto carryRequestDto = this.getErpMaterialCarryRequestDto(orderEo, storageOrderDetailList);
        InOtherStorageOrderDto orderDto = new InOtherStorageOrderDto();
        orderDto.setStorageOrderNo(orderEo.getStorageOrderNo());
        String externalOrderNo = null;
        try {
            externalOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.iExternalInventoryErpApiProxy.materialCarryOrder(carryRequestDto));
            log.info("\u540c\u6b65\u642c\u8fd0\u5355\u8fd4\u56de\u7684\u5916\u90e8\u5355\u53f7:{}", (Object)externalOrderNo);
        }
        catch (Exception e) {
            log.info("ERP\u540c\u6b65\u642c\u8fd0\u5355\u5931\u8d25:{}", (Object)e.getMessage());
            orderDto.setReceiveFailReason(e.getMessage());
            this.modifyStatus(orderDto);
            throw new BizException("ERP\u540c\u6b65\u642c\u8fd0\u5355\u5931\u8d25:{}", e.getMessage());
        }
        orderDto.setExternalOrderNo(externalOrderNo);
        orderDto.setReceiveStatus(OtherStorageOrderReceiveStatusEnum.ALREADY_CREATE_IN_NOTICE.getType());
        this.modifyStatus(orderDto);
    }

    private ErpMaterialCarryRequestDto getErpMaterialCarryRequestDto(InOtherStorageOrderEo orderEo, List<InOtherStorageOrderDetailEo> storageOrderDetailList) {
        ErpMaterialCarryRequestDto carryRequestDto = new ErpMaterialCarryRequestDto();
        List relationEoList = ((ExtQueryChainWrapper)this.iWarehouseRelationDomain.filter().eq((Object)"logic_warehouse_code", (Object)orderEo.getWarehouseCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)relationEoList)) {
            carryRequestDto.setSubinventoryCode(((WarehouseRelationEo)relationEoList.get(0)).getErpId());
        }
        carryRequestDto.setTransactionType(orderEo.getType());
        carryRequestDto.setDealDate(DateUtil.formatDate((Date)orderEo.getBizDate()));
        carryRequestDto.setCompanyCode(orderEo.getSaleOrganizationCode());
        carryRequestDto.setSourceNumber(orderEo.getStorageOrderNo());
        ArrayList dtoList = Lists.newArrayList();
        storageOrderDetailList.forEach(orderDetailDto -> {
            ErpMaterialCarryLineRequestDto lineRequestDto = new ErpMaterialCarryLineRequestDto();
            lineRequestDto.setItemCode(orderDetailDto.getSkuCode());
            lineRequestDto.setItemDescription(orderDetailDto.getSkuName());
            lineRequestDto.setTransactionQuantity(BigDecimalUtils.toStr((BigDecimal)orderDetailDto.getQuantity()));
            dtoList.add(lineRequestDto);
        });
        carryRequestDto.setLines((List)dtoList);
        return carryRequestDto;
    }

    public boolean canAutoComplete(String businessType, String orderType) {
        InOtherStorageBusinessTypeEo businessTypeEo = this.getInOtherStorageBusinessTypeEo(businessType, orderType);
        String noPushWms = "";
        JSONObject json = null;
        if (businessTypeEo != null && StringUtils.isNotEmpty((CharSequence)businessTypeEo.getExtension()) && Objects.nonNull(json = JSONObject.parseObject((String)businessTypeEo.getExtension()))) {
            noPushWms = json.getString("noPushWms");
        }
        return StringUtils.isNotBlank((CharSequence)noPushWms) && "1".equals(noPushWms);
    }

    private InOtherStorageBusinessTypeEo getInOtherStorageBusinessTypeEo(String businessType, String orderType) {
        return (InOtherStorageBusinessTypeEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOtherStorageBusinessTypeDomain.filter().eq((Object)"type", (Object)orderType)).eq((Object)"business_type_code", (Object)businessType)).last("limit 1")).one();
    }

    public boolean canAutoComplete(String businessType, String orderType, String warehouseCode) {
        boolean flag;
        InOtherStorageBusinessTypeEo businessTypeEo = this.getInOtherStorageBusinessTypeEo(businessType, orderType);
        String noPushWms = "";
        JSONObject json = null;
        if (businessTypeEo != null && StringUtils.isNotEmpty((CharSequence)businessTypeEo.getExtension()) && Objects.nonNull(json = JSONObject.parseObject((String)businessTypeEo.getExtension()))) {
            noPushWms = json.getString("noPushWms");
        }
        boolean bl = flag = StringUtils.isNotBlank((CharSequence)noPushWms) && "1".equals(noPushWms);
        if (!flag) {
            LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)warehouseCode)).one();
            PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).one();
            AssertUtil.assertNotNull((Object)physicsWarehouseEo, (String)"\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            flag |= 1 != physicsWarehouseEo.getInterconnectionFlag();
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    @OptLogContext(logType=OperationLogTypeEnum.CANCELED, orderCodeSpel="#inOtherStorageOrderUpdateDto.storageOrderNo", typeSpel="#inOtherStorageOrderUpdateDto.orderType")
    public void cancel(InOtherStorageOrderUpdateDto inOtherStorageOrderUpdateDto) {
        JSONObject jsonObject;
        InOtherStorageOrderEo orderEo = this.getInOtherStorageOrderEo(inOtherStorageOrderUpdateDto);
        String extension = orderEo.getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            jsonObject = JSONObject.parseObject((String)extension);
            jsonObject.put("cancelReason", (Object)inOtherStorageOrderUpdateDto.getRemark());
            extension = jsonObject.toJSONString();
        } else {
            jsonObject = new JSONObject();
            jsonObject.put("cancelReason", (Object)inOtherStorageOrderUpdateDto.getRemark());
            extension = jsonObject.toJSONString();
        }
        orderEo.setExtension(extension);
        inOtherStorageOrderUpdateDto.setOrderType(orderEo.getType());
        StatemachineExecutorBo<InOtherStorageOrderEo> inOtherStorageOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<InOtherStorageOrderEo>();
        inOtherStorageOrderEoStatemachineExecutorBo.setEo(orderEo);
        boolean execute = this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.CANCEL, inOtherStorageOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u53d6\u6d88\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u53d6\u6d88\u5931\u8d25\u8be5\u5355\u636e" + orderEo.getStorageOrderNo() + "\u72b6\u6001\u4e3a" + orderEo.getOrderStatus());
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.CANCELED.name(), (String)"EMPTY", (String)orderEo.getStorageOrderNo(), (String)orderEo.getType());
    }

    @Override
    public BatchOrderOperationMsgDto batchCancel(List<InOtherStorageOrderUpdateDto> inOtherStorageOrderUpdateDtoList) {
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        inOtherStorageOrderUpdateDtoList.forEach(dto -> {
            BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
            try {
                this.cancel((InOtherStorageOrderUpdateDto)dto);
                resMsg.setMsg(dto.getStorageOrderNo());
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                resMsg.setMsg(String.format("%s\u53d6\u6d88\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", dto.getStorageOrderNo(), e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(inOtherStorageOrderUpdateDtoList.size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return msgDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    @OptLogContext(logType=OperationLogTypeEnum.CLOSE, orderCodeSpel="#inOtherStorageOrderUpdateDto.storageOrderNo", typeSpel="#inOtherStorageOrderUpdateDto.orderType")
    public void close(InOtherStorageOrderUpdateDto inOtherStorageOrderUpdateDto) {
        InOtherStorageOrderEo orderEo = this.getInOtherStorageOrderEo(inOtherStorageOrderUpdateDto);
        inOtherStorageOrderUpdateDto.setOrderType(orderEo.getType());
        StatemachineExecutorBo<InOtherStorageOrderEo> inOtherStorageOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<InOtherStorageOrderEo>();
        inOtherStorageOrderEoStatemachineExecutorBo.setEo(orderEo);
        boolean execute = false;
        execute = DgOtherStorageOrderTypeEnum.IN.getCode().equals(orderEo.getType()) ? this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.FINISHIN, inOtherStorageOrderEoStatemachineExecutorBo) : this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.FINISHOUT, inOtherStorageOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u53d6\u6d88\u5931\u8d25\u8be5\u5355\u636e" + orderEo.getStorageOrderNo() + "\u72b6\u6001\u4e3a" + orderEo.getOrderStatus());
        }
        if (StringUtils.equals((CharSequence)orderEo.getBusinessType(), (CharSequence)PcpBusinessTypeEnum.PARTS_REQUISITION_OUT.getCode()) && StringUtils.isNotEmpty((CharSequence)orderEo.getExternalOrderNo())) {
            try {
                this.iExternalInventoryErpApiProxy.closeMaterialCarryOrder((List)Lists.newArrayList((Object[])new String[]{orderEo.getExternalOrderNo()}));
            }
            catch (Exception e) {
                log.info("\u5173\u95ederp\u642c\u8fd0\u5355\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public BatchOrderOperationMsgDto batchClose(List<InOtherStorageOrderUpdateDto> inOtherStorageOrderUpdateDtoList) {
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        inOtherStorageOrderUpdateDtoList.forEach(dto -> {
            BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
            try {
                this.close((InOtherStorageOrderUpdateDto)dto);
                resMsg.setMsg(dto.getStorageOrderNo());
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                resMsg.setMsg(String.format("%s\u5173\u95ed\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", dto.getStorageOrderNo(), e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(inOtherStorageOrderUpdateDtoList.size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return msgDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    @OptLogContext(logType=OperationLogTypeEnum.COMPLETED, orderCodeSpel="#inOtherStorageOrderUpdateDto.storageOrderNo", typeSpel="#inOtherStorageOrderUpdateDto.orderType")
    public void complete(InOtherStorageOrderUpdateDto inOtherStorageOrderUpdateDto) {
        InOtherStorageOrderEo orderEo = this.getInOtherStorageOrderEo(inOtherStorageOrderUpdateDto);
        inOtherStorageOrderUpdateDto.setOrderType(orderEo.getType());
        StatemachineExecutorBo<InOtherStorageOrderEo> inOtherStorageOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<InOtherStorageOrderEo>();
        inOtherStorageOrderEoStatemachineExecutorBo.setEo(orderEo);
        boolean execute = false;
        execute = DgOtherStorageOrderTypeEnum.IN.getCode().equals(orderEo.getType()) ? this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.FINISHIN, inOtherStorageOrderEoStatemachineExecutorBo) : this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.FINISHOUT, inOtherStorageOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u5b8c\u7ed3\u5931\u8d25\u8be5\u5355\u636e" + orderEo.getStorageOrderNo() + "\u72b6\u6001\u4e3a" + orderEo.getOrderStatus());
        }
    }

    @Override
    public void modifyStatus(InOtherStorageOrderDto inOtherStorageOrderDto) {
        AssertUtils.notNull((Object)inOtherStorageOrderDto.getStorageOrderNo(), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInOtherStorageOrderDomain)this.domain).filter().eq((Object)"storage_order_no", (Object)inOtherStorageOrderDto.getStorageOrderNo())).last("limit 1")).one();
        inOtherStorageOrderEo.setReceiveStatus(inOtherStorageOrderDto.getOrderStatus());
        if (StringUtils.isNotBlank((CharSequence)inOtherStorageOrderDto.getReceiveFailReason())) {
            inOtherStorageOrderEo.setReceiveFailReason(inOtherStorageOrderDto.getReceiveFailReason());
        }
        if (StringUtils.isNotBlank((CharSequence)inOtherStorageOrderDto.getExternalOrderNo())) {
            inOtherStorageOrderEo.setExternalOrderNo(inOtherStorageOrderDto.getExternalOrderNo());
        }
        ((IInOtherStorageOrderDomain)this.domain).updateSelective((BaseEo)inOtherStorageOrderEo);
    }

    private InOtherStorageOrderUpdateDto getInOtherStorageOrderUpdateDto(InOtherStorageOrderEo inOtherStorageOrderEo) {
        InOtherStorageOrderUpdateDto inOtherStorageOrderUpdateDto = new InOtherStorageOrderUpdateDto();
        inOtherStorageOrderUpdateDto.setStorageOrderNo(inOtherStorageOrderEo.getStorageOrderNo());
        inOtherStorageOrderUpdateDto.setAuditResult(YesNoHelper.YES.toString());
        return inOtherStorageOrderUpdateDto;
    }

    @Override
    public InOtherStorageOrderDto queryByStorageOrderNo(String storageOrderNo) {
        InOtherStorageOrderEo otherStorageOrderEo = (InOtherStorageOrderEo)((ExtQueryChainWrapper)((IInOtherStorageOrderDomain)this.domain).filter().eq((Object)"storage_order_no", (Object)storageOrderNo)).one();
        AssertUtils.notNull((Object)otherStorageOrderEo, (String)String.format("\u6839\u636e\u5176\u5b83\u51fa\u5165\u5e93\u5355\u53f7\u3010{}\u3011, \u67e5\u8be2\u4e0d\u5230\u5355\u636e", storageOrderNo));
        return (InOtherStorageOrderDto)this.converter().toDto((BaseEo)otherStorageOrderEo);
    }

    private LogicWarehouseEo checkLogicWarehouse(String warehouseCode) {
        LogicWarehouseEo logicWarehouseEo = this.logicWarehouseDomain.queryByCode(warehouseCode);
        AssertUtil.isTrue((boolean)Objects.nonNull(logicWarehouseEo), (String)(warehouseCode + ",\u4ed3\u5e93\u4e0d\u5b58\u5728"));
        return logicWarehouseEo;
    }

    private void checkSku(List<InOtherStorageOrderDetailDto> inOtherStorageOrderDetailDtos) {
        AssertUtil.isTrue((boolean)CollectionUtil.isNotEmpty(inOtherStorageOrderDetailDtos), (String)"\u53c2\u6570\u9519\u8bef,\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        inOtherStorageOrderDetailDtos.forEach(d -> AssertUtil.isTrue((d.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
    }

    private void checkProject(String businessType, List<InOtherStorageOrderDetailDto> inOtherStorageOrderDetailDtos) {
        AssertUtil.isTrue((boolean)CollectionUtil.isNotEmpty(inOtherStorageOrderDetailDtos), (String)"\u53c2\u6570\u9519\u8bef,\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void computerVolumeAndQuantity(List<InOtherStorageOrderDetailDto> detailList, InOtherStorageOrderEo updateEo, String code) {
        BigDecimal totalQuantity = new BigDecimal(0);
        BigDecimal totalVolume = new BigDecimal(0);
        for (InOtherStorageOrderDetailDto dto : detailList) {
            dto.setStorageOrderNo(code);
            totalQuantity = totalQuantity.add(dto.getQuantity());
            if (null == dto.getVolume()) continue;
            totalVolume = totalVolume.add(dto.getQuantity().multiply(dto.getVolume()));
        }
        updateEo.setTotalQuantity(totalQuantity);
        updateEo.setTotalVolume(totalVolume);
    }

    @NotNull
    private InOtherStorageOrderEo getInOtherStorageOrderEo(InOtherStorageOrderUpdateDto inOtherStorageOrderUpdateDto) {
        InOtherStorageOrderEo inOtherStorageOrderEo = new InOtherStorageOrderEo();
        inOtherStorageOrderEo.setStorageOrderNo(inOtherStorageOrderUpdateDto.getStorageOrderNo());
        InOtherStorageOrderEo orderEo = (InOtherStorageOrderEo)((IInOtherStorageOrderDomain)this.domain).selectOne((BaseEo)inOtherStorageOrderEo);
        AssertUtil.isTrue((boolean)Objects.nonNull(orderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728");
        return orderEo;
    }

    private boolean checkDepartment(String extension) {
        if (StringUtils.isNotEmpty((CharSequence)extension)) {
            Map map = JacksonUtil.toMap((String)extension);
            Object whDepartmentCode = map.get("whDepartmentCode");
            Object whDepartmentName = map.get("whDepartmentName");
            return Objects.nonNull(whDepartmentCode) && Objects.nonNull(whDepartmentName);
        }
        return false;
    }

    private void setOutItemUnitData(List<InOtherStorageOrderDetailDto> inOtherStorageOrderDetailDtos, String code, String orderType) {
        OrderUnitConversionReqDto record = new OrderUnitConversionReqDto();
        record.setDocumentCode(code);
        record.setType(orderType);
        record.setOrderUnitConversionDetailList(inOtherStorageOrderDetailDtos.stream().map(itemReqDto -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitDto = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitDto.setSkuCode(itemReqDto.getSkuCode());
            unitDto.setCurUnit(itemReqDto.getUnit());
            unitDto.setCurNum(itemReqDto.getQuantity());
            return unitDto;
        }).collect(Collectors.toList()));
        this.iOrderUnitConversionRecordService.queryAndSaveUnitConversion(record);
    }
}

