/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsInventoryStrategyEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsValidFlagEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderInventoryExe;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.utils.ExtensionUtil;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TransferOrderDeliveryExe {
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderDeliveryExe.class);
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private TransferOrderInventoryExe transferOrderInventoryExe;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private IWarehouseAddressDomain iWarehouseAddressDomain;

    public void generateDeliveryNoticeOrder(CsTransferOrderRespDto respDto, List<TransferOrderDetailEo> detailList, boolean isUpdateFinishStatus) {
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = this.getReceiveDeliveryNoticeOrderFacadeBo(respDto, detailList, isUpdateFinishStatus);
        facadeBo.setLogicWarehouseCode(respDto.getOutLogicWarehouseCode());
        facadeBo.setLogicWarehouseName(respDto.getOutLogicWarehouseName());
        facadeBo.setPhysicsWarehouseCode(respDto.getOutPhysicsWarehouseCode());
        facadeBo.setPhysicsWarehouseName(respDto.getOutPhysicsWarehouseName());
        facadeBo.setTransferInLogicWarehouseCode(respDto.getInLogicWarehouseCode());
        facadeBo.setExternalOrderNo(respDto.getExternalOrderNo());
        facadeBo.setShipmentEnterpriseCode(respDto.getShipmentEnterpriseCode());
        facadeBo.setShipmentEnterpriseName(respDto.getShipmentEnterpriseName());
        this.baseOrderFacade.deliveryNoticeOrderGen(facadeBo);
    }

    @NotNull
    public ReceiveDeliveryNoticeOrderFacadeBo getReceiveDeliveryNoticeOrderFacadeBo(final CsTransferOrderRespDto respDto, List<TransferOrderDetailEo> detailList, final boolean isUpdateFinishStatus) {
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        CubeBeanUtils.copyProperties((Object)facadeBo, (Object)respDto, (String[])new String[0]);
        facadeBo.setPreOrderNo(respDto.getPreOrderNo());
        String externalOrderNo = respDto.getPreOrderNo();
        facadeBo.setExternalOrderNo(externalOrderNo);
        facadeBo.setRelevanceNo(respDto.getTransferOrderNo());
        facadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT.getCode());
        facadeBo.setPreemptReleaseType(CsInventorySourceTypeEnum.TRANSFER_OTHER_PREEMPT.getCode());
        facadeBo.setDisplayBusinessType(respDto.getType());
        facadeBo.setBusinessType(respDto.getType());
        facadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        facadeBo.setRemark(respDto.getRemark());
        facadeBo.setExternalOrderNo(respDto.getExternalOrderNo());
        facadeBo.setTransportTypeCode(ExtensionUtil.parseJson(respDto.getExtension()).getString("transportTypeCode"));
        if (isUpdateFinishStatus) {
            facadeBo.setAutoComplete(true);
        }
        if (StringUtils.equals((CharSequence)respDto.getType(), (CharSequence)TransferOrderTypeEnum.REPAIR_RETURN_WAREHOUSE.getCode()) || StringUtils.equals((CharSequence)respDto.getType(), (CharSequence)TransferOrderTypeEnum.EXTERNAL_WAREHOUSE_C_B.getCode())) {
            facadeBo.setAutoComplete(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)respDto.getSourceSystem()) && "WMS".equalsIgnoreCase(respDto.getSourceSystem())) {
            facadeBo.setSendWms(false);
        }
        if (StringUtils.isNotEmpty((CharSequence)respDto.getSourceSystem()) && "WMS".equalsIgnoreCase(respDto.getSourceSystem())) {
            facadeBo.setSendWms(false);
        }
        Map<Object, OrderUnitConversionRecordDto> unitConversionRecordDtoMap = this.unitProcess(respDto, detailList);
        List<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(detailList.size());
        for (TransferOrderDetailEo detail : detailList) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            OrderUnitConversionRecordDto orderUnitConversionRecordDto = unitConversionRecordDtoMap.get(this.getKey(detail.getSkuCode(), detail.getQuantity(), detail.getUnit()));
            CubeBeanUtils.copyProperties((Object)((Object)basic), (Object)detail, (String[])new String[0]);
            basic.setSkuCode(detail.getSkuCode());
            basic.setSkuName(detail.getSkuName());
            basic.setQuantity(BeanUtil.isNotEmpty((Object)orderUnitConversionRecordDto, (String[])new String[0]) ? orderUnitConversionRecordDto.getToNum() : BigDecimal.ZERO);
            basic.setBatch(detail.getBatch());
            basic.setVolume(detail.getVolume());
            basic.setPreOrderItemId(detail.getId());
            basic.setExpireTime(detail.getExpireTime());
            basic.setProduceTime(detail.getProduceTime());
            basic.setInventoryProperty(detail.getInventoryProperty());
            deliveryDetailList.add(basic);
        }
        if (!InventoryConfig.isPreemptHiddenBatch() && !InventoryConfig.isNoneBatch() && detailList.stream().anyMatch(r -> StringUtils.isBlank((CharSequence)r.getBatch()))) {
            deliveryDetailList = this.getCsBasicsOrderDetailList(facadeBo.getRelevanceNo(), deliveryDetailList);
            facadeBo.setShoutBatch(true);
        }
        facadeBo.setBaseOrderAddressEoList(Optional.of(this.getBaseOrderAddress(respDto)).map(Lists::newArrayList).orElse(null));
        facadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList.stream().filter(e -> BigDecimalUtils.gtZero((BigDecimal)e.getQuantity())).collect(Collectors.toList()));
        facadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                    ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                    ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context1.getReceiveDeliveryNoticeOrderEo();
                    receiveDeliveryNoticeOrderEo.setTotalQuantity(respDto.getTotalQuantity());
                    receiveDeliveryNoticeOrderEo.setSourceSystem(respDto.getSourceSystem());
                    receiveDeliveryNoticeOrderEo.setShippingType(ExtensionUtil.parseJson(respDto.getExtension()).getString("transportTypeCode"));
                    if (StringUtils.isEmpty((CharSequence)receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode())) {
                        receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseCode(respDto.getInLogicWarehouseCode());
                        receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseName(respDto.getInLogicWarehouseName());
                        receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseCode(respDto.getInPhysicsWarehouseCode());
                        receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseName(respDto.getInPhysicsWarehouseName());
                    }
                    if (StringUtils.isEmpty((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode())) {
                        receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(respDto.getOutLogicWarehouseCode());
                        receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseName(respDto.getOutLogicWarehouseName());
                        receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(respDto.getOutPhysicsWarehouseCode());
                        receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(respDto.getOutPhysicsWarehouseName());
                    }
                    TransferOrderDeliveryExe.this.wrapperTransferOrderDelivery(receiveDeliveryNoticeOrderEo, (TransferOrderEo)BeanUtil.copyProperties((Object)respDto, TransferOrderEo.class, (String[])new String[0]));
                    TransferOrderDeliveryExe.this.copyDeliveryToContext(context1, receiveDeliveryNoticeOrderEo);
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
                boolean flag;
                TransferOrderTypeEnum transferOrderTypeEnum = TransferOrderTypeEnum.getEnumByCode((String)respDto.getType());
                boolean bl = flag = transferOrderTypeEnum != null && CsInventoryStrategyEnum.VIRTUAL.getCode().equalsIgnoreCase(transferOrderTypeEnum.getVirtualTag()) || isUpdateFinishStatus;
                if (flag) {
                    context.setTransparentCallback(true);
                }
            }
        });
        return facadeBo;
    }

    private List<BaseOrderDetailReqDto> getCsBasicsOrderDetailList(String relevanceNo, List<BaseOrderDetailReqDto> buildList) {
        List<InventoryUsageRecordEo> inventoryUsageRecordEos = this.transferOrderInventoryExe.queryPreemptTypeBySourceNo(relevanceNo, CsValidFlagEnum.ENABLE.getCode(), CsWarehouseClassifyEnum.LOGIC.getCode());
        if (CollectionUtils.isNotEmpty(inventoryUsageRecordEos)) {
            Map tradeOrderItemMap = buildList.stream().collect(HashMap::new, (m, v) -> m.put(v.getSkuCode(), v), HashMap::putAll);
            ArrayList<BaseOrderDetailReqDto> detailReqDtoList = new ArrayList<BaseOrderDetailReqDto>();
            for (InventoryUsageRecordEo in : inventoryUsageRecordEos) {
                BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
                basic.setSkuCode(in.getSkuCode());
                basic.setSkuName(in.getSkuName());
                basic.setInventoryProperty(in.getInventoryProperty());
                basic.setQuantity(in.getPreemptNum());
                basic.setBatch(in.getBatch());
                BaseOrderDetailReqDto csBasicsOrderDetailReqDto = (BaseOrderDetailReqDto)((Object)tradeOrderItemMap.get(in.getSkuCode()));
                basic.setPreOrderItemId(csBasicsOrderDetailReqDto.getPreOrderItemId());
                basic.setExtension(csBasicsOrderDetailReqDto.getExtension());
                basic.setExpireTime(csBasicsOrderDetailReqDto.getExpireTime());
                basic.setProduceTime(csBasicsOrderDetailReqDto.getProduceTime());
                basic.setInventoryProperty(csBasicsOrderDetailReqDto.getInventoryProperty());
                detailReqDtoList.add(basic);
            }
            return detailReqDtoList;
        }
        return buildList;
    }

    private List<BaseOrderAddressEo> getBaseOrderAddress(CsTransferOrderRespDto respDto) {
        BaseOrderAddressEo baseOrderAddressEo = new BaseOrderAddressEo();
        BeanUtil.copyProperties((Object)respDto, (Object)baseOrderAddressEo, (String[])new String[0]);
        baseOrderAddressEo.setId(null);
        baseOrderAddressEo.setDocumentNo(respDto.getTransferOrderNo());
        baseOrderAddressEo.setContactsType("consignee");
        baseOrderAddressEo.setProvince(respDto.getProvince());
        baseOrderAddressEo.setCity(respDto.getCity());
        baseOrderAddressEo.setDistrict(respDto.getArea());
        baseOrderAddressEo.setDetailAddress(respDto.getAddress());
        baseOrderAddressEo.setEncryptProvince(respDto.getProvince());
        baseOrderAddressEo.setEncryptCity(respDto.getCity());
        baseOrderAddressEo.setEncryptDistrict(respDto.getAddress());
        baseOrderAddressEo.setEncryptDetailAddress(respDto.getAddress());
        baseOrderAddressEo.setContacts(respDto.getContact());
        baseOrderAddressEo.setEncryptContacts(respDto.getContact());
        baseOrderAddressEo.setPhone(respDto.getContactPhone());
        baseOrderAddressEo.setCustomerCode(respDto.getCustomerCode());
        baseOrderAddressEo.setCustomerName(respDto.getCustomerName());
        ArrayList<BaseOrderAddressEo> baseOrderAddressEos = new ArrayList<BaseOrderAddressEo>();
        baseOrderAddressEos.add(baseOrderAddressEo);
        BaseOrderAddressEo baseOrderAddressEo1 = new BaseOrderAddressEo();
        WarehouseAddressEo warehouseCodeEo = (WarehouseAddressEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iWarehouseAddressDomain.filter().eq((Object)"warehouse_code", (Object)respDto.getOutPhysicsWarehouseCode())).last("limit 1")).one();
        Optional.ofNullable(warehouseCodeEo).ifPresent(r -> {
            baseOrderAddressEo1.setContactsType("consignor");
            baseOrderAddressEo1.setProvince(warehouseCodeEo.getProvince());
            baseOrderAddressEo1.setCity(warehouseCodeEo.getCity());
            baseOrderAddressEo1.setDistrict(warehouseCodeEo.getDistrict());
            baseOrderAddressEo1.setDetailAddress(warehouseCodeEo.getDetailAddress());
            baseOrderAddressEo1.setEncryptProvince(warehouseCodeEo.getProvince());
            baseOrderAddressEo1.setEncryptCity(warehouseCodeEo.getCity());
            baseOrderAddressEo1.setEncryptDistrict(warehouseCodeEo.getDistrict());
            baseOrderAddressEo1.setEncryptDetailAddress(warehouseCodeEo.getDetailAddress());
            baseOrderAddressEo1.setContacts(warehouseCodeEo.getContacts());
            baseOrderAddressEo1.setEncryptContacts(warehouseCodeEo.getContacts());
            baseOrderAddressEo1.setPhone(warehouseCodeEo.getPhone());
            baseOrderAddressEo1.setEncryptPhone(warehouseCodeEo.getPhone());
            baseOrderAddressEos.add(baseOrderAddressEo1);
        });
        return baseOrderAddressEos;
    }

    public void wrapperTransferOrderDelivery(ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo, TransferOrderEo transferOrderEo) {
        receiveDeliveryNoticeOrderEo.setShipmentEnterpriseCode(transferOrderEo.getShipmentEnterpriseCode());
        receiveDeliveryNoticeOrderEo.setShipmentEnterpriseName(transferOrderEo.getShipmentEnterpriseName());
        ArrayList<CsWmsShippingInfoReqDto> shippingInfoReqDtoList = new ArrayList<CsWmsShippingInfoReqDto>();
        CsWmsShippingInfoReqDto wmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
        wmsShippingInfoReqDto.setShippingCompanyCode(transferOrderEo.getShipmentEnterpriseCode());
        wmsShippingInfoReqDto.setShippingCompanyName(transferOrderEo.getShipmentEnterpriseName());
        wmsShippingInfoReqDto.setPlatformOrderNo(transferOrderEo.getExternalOrderNo());
        wmsShippingInfoReqDto.setDeliveryTime(new Date());
        shippingInfoReqDtoList.add(wmsShippingInfoReqDto);
        receiveDeliveryNoticeOrderEo.setShippingJson(JSON.toJSONString(shippingInfoReqDtoList));
        receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(transferOrderEo.getOutLogicWarehouseCode());
        receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseName(transferOrderEo.getOutLogicWarehouseName());
        receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(transferOrderEo.getOutPhysicsWarehouseCode());
        receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(transferOrderEo.getOutPhysicsWarehouseName());
        receiveDeliveryNoticeOrderEo.setShopCode(transferOrderEo.getShopCode());
        receiveDeliveryNoticeOrderEo.setShopName(transferOrderEo.getShopName());
        receiveDeliveryNoticeOrderEo.setPayTime(transferOrderEo.getCreateTime());
        receiveDeliveryNoticeOrderEo.setOaidOrderSourceCode(transferOrderEo.getPreOrderNo());
        receiveDeliveryNoticeOrderEo.setTradeOrderCreateTime(transferOrderEo.getCreateTime());
        receiveDeliveryNoticeOrderEo.setSourcePlatformCode(transferOrderEo.getOrderSrc());
        receiveDeliveryNoticeOrderEo.setRepairOrderNo(transferOrderEo.getTransferOrderNo());
    }

    public void copyDeliveryToContext(ReceiveDeliveryNoticeOrderContext deliveryNoticeOrderContext, ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo) {
        deliveryNoticeOrderContext.setShipmentEnterpriseCode(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode());
        deliveryNoticeOrderContext.setShipmentEnterpriseName(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName());
        deliveryNoticeOrderContext.setYfRepairOrderNo(receiveDeliveryNoticeOrderEo.getYfRepairOrderNo());
        deliveryNoticeOrderContext.setSourcePlatformCode(receiveDeliveryNoticeOrderEo.getSourcePlatformCode());
        deliveryNoticeOrderContext.setOaidOrderSourceCode(receiveDeliveryNoticeOrderEo.getOaidOrderSourceCode());
        deliveryNoticeOrderContext.setPayTime(receiveDeliveryNoticeOrderEo.getPayTime());
        deliveryNoticeOrderContext.setTradeOrderCreateTime(receiveDeliveryNoticeOrderEo.getTradeOrderCreateTime());
        deliveryNoticeOrderContext.setExchangePlatformAfterSaleOrderNo(receiveDeliveryNoticeOrderEo.getExchangePlatformAfterSaleOrderNo());
        deliveryNoticeOrderContext.setShopId(receiveDeliveryNoticeOrderEo.getShopId());
        deliveryNoticeOrderContext.setShopCode(receiveDeliveryNoticeOrderEo.getShopCode());
        deliveryNoticeOrderContext.setShopName(receiveDeliveryNoticeOrderEo.getShopName());
        deliveryNoticeOrderContext.setShipmentEnterpriseCode(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode());
        deliveryNoticeOrderContext.setShipmentEnterpriseName(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName());
        deliveryNoticeOrderContext.setYfRepairOrderNo(receiveDeliveryNoticeOrderEo.getYfRepairOrderNo());
        deliveryNoticeOrderContext.setRepairOrderNo(receiveDeliveryNoticeOrderEo.getRepairOrderNo());
    }

    private Map<Object, OrderUnitConversionRecordDto> unitProcess(CsTransferOrderRespDto respDto, List<TransferOrderDetailEo> detailList) {
        ArrayList unitConversionDetails = new ArrayList();
        detailList.forEach(detailEo -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(detailEo.getUnit());
            unitConversionDetail.setSkuCode(detailEo.getSkuCode());
            unitConversionDetail.setCurNum(detailEo.getQuantity());
            unitConversionDetails.add(unitConversionDetail);
        });
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(respDto.getTransferOrderNo());
        orderUnitConversionReqDto.setType(respDto.getType());
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
        return orderUnitConversionRecordDtos.stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getNum(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
    }

    private Object getKey(String skuCode, BigDecimal num, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + num.setScale(6) + InventoryConfig.getCommonSeparate() + currentUnit;
    }
}

