/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.action;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.transform.ITrLogisticsMappingRelationQueryApiProxy;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.transform.LogisticsMappingType;
import com.yunxi.dg.base.center.transform.TrLogisticsMappingRelationReqDto;
import com.yunxi.dg.base.center.transform.TrLogisticsMappingRelationRespDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TransferOrderLogisticsMappingAction {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderLogisticsMappingAction.class);
    @Resource
    private ITrLogisticsMappingRelationQueryApiProxy trLogisticsMappingRelationQueryApiProxy;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;

    public void verify(String outLogicWarehouseCode, String shipmentEnterpriseCode) {
        log.info("checkShipmentEnterpriseCode-->outLogicWarehouseCode:{}, shipmentEnterpriseCode:{}, logisticsMapping:{}", new Object[]{outLogicWarehouseCode, shipmentEnterpriseCode, InventoryConfig.isLogisticsMapping()});
        if (!InventoryConfig.isLogisticsMapping()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)outLogicWarehouseCode) || StringUtils.isEmpty((CharSequence)shipmentEnterpriseCode)) {
            return;
        }
        LogicWarehouseEo logicWarehouseEo = this.queryByCodeAndFlag(outLogicWarehouseCode);
        log.info("auditTransferOrder-->logicWarehouseEo:{}", (Object)JSONObject.toJSONString((Object)logicWarehouseEo));
        if (ObjectUtils.isEmpty((Object)logicWarehouseEo)) {
            return;
        }
        TrLogisticsMappingRelationReqDto trLogisticsMappingRelationReqDto = new TrLogisticsMappingRelationReqDto();
        trLogisticsMappingRelationReqDto.setMappingType(LogisticsMappingType.WMS.getCode());
        trLogisticsMappingRelationReqDto.setLogisticsCode(shipmentEnterpriseCode);
        trLogisticsMappingRelationReqDto.setSystematicCode(logicWarehouseEo.getWarehouseCorrespondingSystem());
        trLogisticsMappingRelationReqDto.setOrderType(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode());
        log.info("logisticsMapping-->trLogisticsMappingRelationReqDto:{}", (Object)JSONObject.toJSONString((Object)trLogisticsMappingRelationReqDto));
        TrLogisticsMappingRelationRespDto trLogisticsMappingRelationRespDto = this.trLogisticsMappingRelationQueryApiProxy.queryByRelationReqDtoSiteMatching(trLogisticsMappingRelationReqDto);
        log.info("logisticsMapping-->trLogisticsMappingRelationRespDto:{}", (Object)JSONObject.toJSONString((Object)trLogisticsMappingRelationRespDto));
        if (ObjectUtils.isEmpty((Object)trLogisticsMappingRelationRespDto)) {
            throw new BizException("WMS\u7269\u6d41" + shipmentEnterpriseCode + "\u6620\u5c04\u4e0d\u5230\u7269\u6d41\u7f16\u7801\u3002\u8bf7\u53bb\"\u7269\u6d41\u6620\u5c04\u6863\u6848\"\u4fee\u6539WMS\u7cfb\u7edf\u6620\u5c04\u3002");
        }
    }

    private LogicWarehouseEo queryByCodeAndFlag(String logicWarehouseCode) {
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)logicWarehouseCode), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseCode)).last("limit 1")).one();
        AssertUtils.isFalse((boolean)Objects.isNull(logicWarehouseEo), (String)("\u903b\u8f91\u4ed3 " + logicWarehouseCode + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
        PhysicsWarehouseEo warehouseCode = (PhysicsWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).last("limit 1")).one();
        AssertUtils.isFalse((boolean)Objects.isNull(warehouseCode), (String)("\u7269\u7406\u4ed3" + logicWarehouseEo.getPhysicsWarehouseCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
        if (ObjectUtil.equals((Object)warehouseCode.getInterconnectionFlag(), (Object)1)) {
            return logicWarehouseEo;
        }
        return null;
    }
}

