/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.customer.dto.DgEnterpriseInventoryOrgRelationQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsShipmentEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgInventoryOrgRelationRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsShipmentEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.IDgInventoryOrgQueryApiProxy;
import com.yunxi.dg.base.center.enums.CommitEnum;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.LogicWarehousePropertyEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.enums.TransferGoodsStatusEnum;
import com.yunxi.dg.base.center.enums.TransferOrderEnum;
import com.yunxi.dg.base.center.enums.TypeOfDocumentEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.TransferOrderConverter;
import com.yunxi.dg.base.center.inventory.dao.das.IStorageAuditRecordDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IAutomaticAuditPolicyDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryOperateLogDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.InResultOrderInsertItemsReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InResultOrderInsertReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OutResultOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.transfer.order.TransferOrderDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.BatchModificationQuantityDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.CsTransferOrderDeliveryReceiveConfirmReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderAuditReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderSearchDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.SimpleAuditRecordDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderItemPageDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderLabelValueRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderPageDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderTypeListRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryOperateLogEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.StorageAuditRecordEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferPositionConfigurationEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.annotatin.OptLogContext;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderService;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderWarehouseExe;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderLogisticsMappingAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.helper.TransferOrderApprovalHelper;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.helper.TransferOrderDeliveryHelper;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.helper.TransferOrderReceiveHelper;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutNoticeOrderService;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.service.third.TransferOrderPushBo;
import com.yunxi.dg.base.center.inventory.service.utils.ExtensionUtil;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.item.UnitDgRespDto;
import com.yunxi.dg.base.center.item.dto.old.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.message.TransferGoodsOrderDto;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalEvent;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveEvent;
import com.yunxi.dg.base.center.user.dto.OrganizationDto;
import com.yunxi.dg.base.center.user.proxy.IDgOrganizationApiProxy;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransferOrderServiceImpl
extends BaseServiceImpl<TransferOrderDto, TransferOrderEo, ITransferOrderDomain>
implements ITransferOrderService {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderServiceImpl.class);
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Resource
    private TransferOrderWarehouseExe transferOrderWarehouseExe;
    @Resource
    private GenerateCodeUtil generateCodeUtil;
    @Resource
    private TransferOrderApprovalHelper approvalStateMachineHelper;
    @Resource
    private TransferOrderDeliveryHelper deliveryStateMachineHelper;
    @Resource
    private IContext context;
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    private IStorageAuditRecordDas storageAuditRecordDas;
    @Resource
    private TransferOrderReceiveHelper transferOrderReceiveHelper;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgCsShipmentEnterpriseQueryApiProxy shipmentEnterpriseQueryApiProxy;
    @Autowired
    protected IAutomaticAuditPolicyDomain automaticAuditPolicyDomain;
    @Resource
    private TransferOrderLogisticsMappingAction logisticsMappingAction;
    @Resource
    private IInventoryOperateLogDomain inventoryOperateLogDomain;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    protected IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuProxy;
    @Resource
    private ILogicWarehouseDomain iLogicWarehouseDomain;
    @Autowired
    private IInOutNoticeOrderDomain iInOutNoticeOrderDomain;
    @Autowired
    private IInOutNoticeOrderService iInOutNoticeOrderService;
    @Autowired
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDgOrganizationApiProxy dgOrganizationApiProxy;
    @Resource
    private IDgInventoryOrgQueryApiProxy dgInventoryOrgQueryApiProxy;
    @Resource
    private ILockService lockService;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;

    public TransferOrderServiceImpl(ITransferOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<TransferOrderDto, TransferOrderEo> converter() {
        return TransferOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Long> add(TransferOrderComboReqDto dto) {
        log.info("\u8c03\u62e8\u5355\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)dto));
        if (dto.getTransferOrderReqDto() != null) {
            dto.getTransferOrderReqDto().setId(null);
            dto.getTransferOrderReqDto().setTransferOrderNo(dto.getTransferOrderReqDto().getSettledTransferOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getDetailList())) {
            dto.getDetailList().forEach(item -> {
                item.setTransferOrderNo(null);
                item.setId(null);
            });
        }
        TransferOrderReqDto transferOrderReqDto = dto.getTransferOrderReqDto();
        this.addTransferPositionOrder(dto);
        ((ITransferOrderDomain)this.domain).checkSelfParam(dto);
        this.transferOrderWarehouseExe.checkWarehouse(dto.getTransferOrderReqDto());
        this.transferOrderDetailDomain.checkSelfParam(dto.getDetailList());
        String transferNo = dto.getTransferOrderReqDto().getTransferOrderNo();
        if (StringUtils.isBlank((CharSequence)transferNo)) {
            if (TransferOrderEnum.TRANSFER_POSITION_ORDER.getCode().equals(dto.getTransferOrderReqDto().getOrderType())) {
                transferNo = this.generateCodeUtil.generateCode(CodeGenEnum.TRANSFER_POSITION_ORDER);
            } else if (TransferOrderEnum.INTER_ORGANIZATION_TRANSACTION_ORDER.getCode().equals(dto.getTransferOrderReqDto().getOrderType())) {
                transferNo = this.generateCodeUtil.generateCode(CodeGenEnum.INTER_ORGANIZATION_TRANSACTION_ORDER);
                transferOrderReqDto.setSourceSystem("manual_creation");
            } else if (TransferOrderEnum.MODIFICATION_TRANSFER_ORDER.getCode().equals(dto.getTransferOrderReqDto().getOrderType())) {
                transferNo = this.generateCodeUtil.generateCode(CodeGenEnum.MODIFICATION_TRANSFER_ORDER);
                transferOrderReqDto.setSourceSystem(TransferOrderEnum.MODIFICATION_TRANSFER_ORDER.getCode());
            } else if (TransferOrderEnum.CW_TRANSFER_ORDER.getCode().equals(dto.getTransferOrderReqDto().getOrderType())) {
                transferNo = this.generateCodeUtil.generateCode(CodeGenEnum.CW_TRANSFER_ORDER);
                transferOrderReqDto.setSourceSystem(TransferOrderEnum.CW_TRANSFER_ORDER.getCode());
            } else if (TransferOrderEnum.OVERSEAS_MODIFICATION_TRANSFER_ORDER.getCode().equals(dto.getTransferOrderReqDto().getOrderType())) {
                transferNo = this.generateCodeUtil.generateCode(CodeGenEnum.OVERSEAS_MODIFICATION_TRANSFER_ORDER);
                transferOrderReqDto.setSourceSystem(TransferOrderEnum.OVERSEAS_MODIFICATION_TRANSFER_ORDER.getCode());
            } else if (TransferOrderEnum.OVERSEAS_TRANSFER_ORDER.getCode().equals(dto.getTransferOrderReqDto().getOrderType())) {
                transferNo = this.generateCodeUtil.generateCode(CodeGenEnum.OVERSEAS_TRANSFER_ORDER);
                transferOrderReqDto.setSourceSystem(TransferOrderEnum.OVERSEAS_TRANSFER_ORDER.getCode());
            } else if (TransferOrderEnum.RESTORAGE_TRANSFER_ORDER.getCode().equals(dto.getTransferOrderReqDto().getOrderType())) {
                transferNo = this.generateCodeUtil.generateCode(CodeGenEnum.RESTORAGE_TRANSFER_ORDER);
                transferOrderReqDto.setSourceSystem(TransferOrderEnum.RESTORAGE_TRANSFER_ORDER.getCode());
            } else if (TransferOrderEnum.OVERSEAS_RESTORAGE_TRANSFER_ORDER.getCode().equals(dto.getTransferOrderReqDto().getOrderType())) {
                transferNo = this.generateCodeUtil.generateCode(CodeGenEnum.OVERSEAS_RESTORAGE_TRANSFER_ORDER);
                transferOrderReqDto.setSourceSystem(TransferOrderEnum.OVERSEAS_RESTORAGE_TRANSFER_ORDER.getCode());
            } else {
                transferNo = this.generateCodeUtil.generateCode(CodeGenEnum.TRANSFER_ORDER);
                transferOrderReqDto.setOrderType("transfer_order");
            }
        }
        List<TransferOrderDetailReqDto> detailList = this.supplementItemInfo(dto.getDetailList(), transferNo);
        this.setSaleAccountingCompany(dto.getTransferOrderReqDto());
        BigDecimal totalQuantity = detailList.stream().map(TransferOrderDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outboundTotalQuantity = BigDecimal.ZERO;
        BigDecimal inboundTotalQuantity = BigDecimal.ZERO;
        BigDecimal totalVolume = BigDecimal.ZERO;
        BigDecimal totalWeight = BigDecimal.ZERO;
        this.unitProcess(transferNo, detailList);
        for (TransferOrderDetailReqDto d : detailList) {
            d.setInventoryProperty(Optional.ofNullable(transferOrderReqDto.getInventoryProperty()).orElse(LogicWarehouseQualityEnum.QUALIFIED.getCode()));
            d.setTransferOrderNo(transferNo);
            if (d.getVolume() != null) {
                totalVolume = totalVolume.add(d.getVolume());
            }
            if (d.getWeight() == null) continue;
            totalWeight = totalWeight.add(d.getWeight());
        }
        ArrayList detailEoList = new ArrayList(detailList.size());
        DtoHelper.dtoList2EoList(detailList, detailEoList, TransferOrderDetailEo.class);
        this.transferOrderDetailDomain.insertBatch(detailEoList);
        transferOrderReqDto.setTransferOrderNo(transferNo);
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)transferOrderReqDto, (BaseEo)transferOrderEo, (String[])new String[]{"id", "create_time", "create_person"});
        transferOrderEo.setTotalQuantity(totalQuantity);
        transferOrderEo.setTotalVolume(totalVolume);
        transferOrderEo.setTotalWeight(totalWeight);
        transferOrderEo.setInboundTotalQuantity(inboundTotalQuantity);
        transferOrderEo.setOutboundTotalQuantity(outboundTotalQuantity);
        transferOrderEo.setInventoryProperty(Optional.ofNullable(transferOrderReqDto.getInventoryProperty()).orElse(LogicWarehouseQualityEnum.QUALIFIED.getCode()));
        transferOrderEo.setOrderStatus(TransferOrderStatus.PENDING.code());
        transferOrderEo.setApprovalStatus(TransferOrderApprovalState.PENDING_SUBMISSION.getCode());
        transferOrderEo.setIsVirtual(transferOrderReqDto.getIsVirtual());
        transferOrderEo.setNoBatch(Integer.valueOf(Objects.nonNull(transferOrderReqDto.getHasBatch()) && transferOrderReqDto.getHasBatch() == 0 ? 1 : 0));
        transferOrderEo.setCreatePerson(this.context.userName());
        transferOrderEo.setUpdatePerson(this.context.userName());
        JSONObject extension = ExtensionUtil.parseJson(transferOrderReqDto.getExtension());
        if (null != transferOrderReqDto.getRefundType()) {
            extension.put("refundType", (Object)transferOrderReqDto.getRefundType());
        }
        if (StringUtils.isNotEmpty((CharSequence)transferOrderReqDto.getBusinessUnitCode())) {
            extension.put("businessUnitCode", (Object)transferOrderReqDto.getBusinessUnitCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)transferOrderReqDto.getBusinessUnitName())) {
            extension.put("businessUnitName", (Object)transferOrderReqDto.getBusinessUnitName());
        }
        if (StringUtils.isNotEmpty((CharSequence)transferOrderReqDto.getChannelCode())) {
            extension.put("channelCode", (Object)transferOrderReqDto.getChannelCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)transferOrderReqDto.getChannelName())) {
            extension.put("channelName", (Object)transferOrderReqDto.getChannelName());
        }
        transferOrderEo.setExtension(extension.toJSONString());
        if (CollectionUtils.isNotEmpty((Collection)transferOrderReqDto.getDocumentUrlList())) {
            if (transferOrderReqDto.getDocumentUrlList().size() > 50) {
                throw new RuntimeException("\u63d0\u4ea4\u7684\u6587\u4ef6\u4fe1\u606f\u5df2\u8d85\u8fc7\u4e94\u5341\u6761");
            }
            transferOrderEo.setDocumentUrl(StringUtils.join((Iterable)transferOrderReqDto.getDocumentUrlList(), (String)","));
        }
        if (CollectionUtils.isNotEmpty((Collection)transferOrderReqDto.getReturnTransferOrderNoList())) {
            transferOrderEo.setReturnTransferOrderNo(String.join((CharSequence)",", transferOrderReqDto.getReturnTransferOrderNoList()));
        }
        ((ITransferOrderDomain)this.domain).insert((BaseEo)transferOrderEo);
        OptUtil.addOptLog((String)OperationLogTypeEnum.CREATED.name(), (String)"EMPTY", (String)transferOrderEo.getTransferOrderNo(), (String)CodeGenEnum.TRANSFER_ORDER.getCode());
        if (CommitEnum.COMMIT.code().equals(dto.getCommitType()) || CommitEnum.AUDIT.code().equals(dto.getCommitType())) {
            TransferOrderKeyDto keyDto = new TransferOrderKeyDto();
            keyDto.setTransferOrderNo(dto.getTransferOrderReqDto().getTransferOrderNo());
            keyDto.setReleaseDocumentNo(dto.getReleaseDocumentNo());
            keyDto.setIsSupplyInventory(dto.getTransferOrderReqDto().getIsSupplyInventory());
            keyDto.setIsBorrowGoods(dto.getTransferOrderReqDto().getIsBorrowGoods());
            keyDto.setReleaseDocumentNo(dto.getReleaseDocumentNo());
            keyDto.setAutoAudit(Boolean.valueOf(false));
            keyDto.setValidNegative(transferOrderReqDto.getValidNegative());
            keyDto.setAutoComplete(dto.getAutoComplete());
            this.commit(keyDto);
            if (!dto.getAutoComplete().booleanValue()) {
                InventoryConfig.registerSynchronizationAfterCommit(() -> {
                    int auditLevel = this.automaticAuditPolicyDomain.getAuditLevel(transferOrderReqDto.getOrderType(), transferOrderEo.getType());
                    boolean isAutoAudit = CommitEnum.AUDIT.code().equals(dto.getCommitType());
                    if (auditLevel < 1 || isAutoAudit) {
                        InventoryConfig.executorNewTransaction(s -> {
                            this.audit(transferOrderEo, auditLevel, false);
                            if (StringUtils.equals((CharSequence)transferOrderReqDto.getType(), (CharSequence)TransferOrderTypeEnum.EXTERNAL_WAREHOUSE_C_B.getCode())) {
                                this.productOutbound(transferOrderEo.getTransferOrderNo());
                            }
                            return s;
                        });
                    }
                });
            }
        }
        return new RestResponse((Object)transferOrderEo.getId());
    }

    private void setSaleAccountingCompany(TransferOrderReqDto reqDto) {
        List organizations = (List)RestResponseHelper.extractData((RestResponse)this.dgOrganizationApiProxy.queryOrgListByCode(Collections.singletonList(reqDto.getOutOrganizationCode())));
        if (CollectionUtils.isEmpty((Collection)organizations)) {
            return;
        }
        OrganizationDto organizationDto = (OrganizationDto)organizations.get(0);
        DgEnterpriseInventoryOrgRelationQueryReqDto relationQueryReqDto = new DgEnterpriseInventoryOrgRelationQueryReqDto();
        relationQueryReqDto.setInventoryOrgIdList(Collections.singletonList(organizationDto.getId()));
        List dgInventoryOrgRelationRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgInventoryOrgQueryApiProxy.queryList(relationQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)dgInventoryOrgRelationRespDtos)) {
            return;
        }
        reqDto.setSaleOrganizationCode(((DgInventoryOrgRelationRespDto)dgInventoryOrgRelationRespDtos.get(0)).getEnterpriseCode());
        reqDto.setSaleOrganizationName(((DgInventoryOrgRelationRespDto)dgInventoryOrgRelationRespDtos.get(0)).getEnterpriseName());
    }

    private void productOutbound(String transferNo) {
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iInOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferNo)).eq((Object)"order_type", (Object)"out")).list();
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderEos)) {
            log.info("\u6c92\u6709\u67e5\u8be2\u5230\u51fa\u5e93\u901a\u77e5\u5355");
            return;
        }
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        OutResultOrderReqDto outResultOrderReqDto = new OutResultOrderReqDto();
        outResultOrderReqDto.setId(inOutNoticeOrderEo.getId());
        outResultOrderReqDto.setBizDate(new Date());
        this.iInOutNoticeOrderService.productOutbound(outResultOrderReqDto);
    }

    private void addTransferPositionOrder(TransferOrderComboReqDto dto) {
        if (ObjectUtil.equals((Object)YesNoEnum.YES.getValue(), (Object)dto.getTransferPositionOrder())) {
            TransferOrderReqDto transferOrderReqDto = dto.getTransferOrderReqDto();
            TransferPositionConfigurationEo transferPositionConfigurationEo = new TransferPositionConfigurationEo();
            LogicWarehouseEo goodProductLogicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogicWarehouseDomain.filter().eq((Object)"warehouse_property", (Object)LogicWarehousePropertyEnum.GOOD_PRODUCT.getCode())).last("limit 1")).one();
            AssertUtils.notNull((Object)goodProductLogicWarehouseEo, (String)"\u6ca1\u6709\u826f\u54c1\u4ed3,\u8bf7\u53bb\u903b\u8f91\u4ed3\u6863\u6848\u589e\u52a0\u826f\u54c1\u4ed3");
            LogicWarehouseEo rejectLogicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogicWarehouseDomain.filter().eq((Object)"warehouse_property", (Object)LogicWarehousePropertyEnum.REJECT.getCode())).last("limit 1")).one();
            AssertUtils.notNull((Object)rejectLogicWarehouseEo, (String)"\u6ca1\u6709\u6b21\u54c1\u4ed3,\u8bf7\u53bb\u903b\u8f91\u4ed3\u6863\u6848\u589e\u52a0\u6b21\u54c1\u4ed3");
            if (TransferOrderTypeEnum.DEFECTIVE_TO_QUALIFIED.getCode().equals(transferOrderReqDto.getType())) {
                transferOrderReqDto.setOutLogicWarehouseCode(rejectLogicWarehouseEo.getWarehouseCode());
                transferOrderReqDto.setOutLogicWarehouseName(rejectLogicWarehouseEo.getWarehouseName());
                transferOrderReqDto.setInLogicWarehouseCode(goodProductLogicWarehouseEo.getWarehouseCode());
                transferOrderReqDto.setInLogicWarehouseName(goodProductLogicWarehouseEo.getWarehouseName());
            } else if (TransferOrderTypeEnum.QUALIFIED_TO_DEFECTIVE.getCode().equals(transferOrderReqDto.getType())) {
                transferOrderReqDto.setOutLogicWarehouseCode(goodProductLogicWarehouseEo.getWarehouseCode());
                transferOrderReqDto.setOutLogicWarehouseName(goodProductLogicWarehouseEo.getWarehouseName());
                transferOrderReqDto.setInLogicWarehouseCode(rejectLogicWarehouseEo.getWarehouseCode());
                transferOrderReqDto.setInLogicWarehouseName(rejectLogicWarehouseEo.getWarehouseName());
            } else {
                throw new BizException(String.format("\u79fb\u4ed3\u5355\u6ca1\u6709\u8be5\u4e1a\u52a1\u7c7b\u578b%s", transferOrderReqDto.getType()));
            }
            transferOrderReqDto.setOrderType(TransferOrderEnum.TRANSFER_POSITION_ORDER.getCode());
            Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)transferOrderReqDto.getOutLogicWarehouseCode())).last("limit 1")).one()).ifPresent(logicWarehouseEo -> {
                transferOrderReqDto.setOutOrganizationCode(logicWarehouseEo.getOrganizationCode());
                transferOrderReqDto.setOutOrganization(logicWarehouseEo.getOrganizationName());
                transferOrderReqDto.setOutPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
                transferOrderReqDto.setOutPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
            });
            Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)transferOrderReqDto.getInLogicWarehouseCode())).last("limit 1")).one()).ifPresent(logicWarehouseEo -> {
                transferOrderReqDto.setInOrganizationCode(logicWarehouseEo.getOrganizationCode());
                transferOrderReqDto.setInOrganization(logicWarehouseEo.getOrganizationName());
                transferOrderReqDto.setInPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
                transferOrderReqDto.setInPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
                transferOrderReqDto.setCustomerCode(transferPositionConfigurationEo.getInLogicWarehouseCode());
                transferOrderReqDto.setCustomerName(transferPositionConfigurationEo.getInLogicWarehouseName());
                Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseAddressDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).last("limit 1")).one()).ifPresent(warehouseAddressEo -> {
                    transferOrderReqDto.setProvinceCode(warehouseAddressEo.getProvinceCode());
                    transferOrderReqDto.setProvince(warehouseAddressEo.getProvince());
                    transferOrderReqDto.setCityCode(warehouseAddressEo.getCityCode());
                    transferOrderReqDto.setCity(warehouseAddressEo.getCity());
                    transferOrderReqDto.setAreaCode(warehouseAddressEo.getDistrictCode());
                    transferOrderReqDto.setArea(warehouseAddressEo.getDistrict());
                    transferOrderReqDto.setContactPhone(warehouseAddressEo.getPhone());
                    transferOrderReqDto.setAddress(warehouseAddressEo.getDetailAddress());
                });
            });
            List<String> skuCodeList = dto.getDetailList().stream().map(TransferOrderDetailReqDto::getSkuCode).collect(Collectors.toList());
            Map itemSkuDgRespDtoMap = this.itemDataQueryHelper.getByCodes(skuCodeList).stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o, o1) -> o));
            dto.getDetailList().forEach(r -> {
                ItemSkuDto itemSkuDgRespDto = (ItemSkuDto)itemSkuDgRespDtoMap.get(r.getSkuCode());
                if (itemSkuDgRespDtoMap.containsKey(r.getSkuCode())) {
                    r.setUnit(itemSkuDgRespDto.getUnit());
                    r.setSkuName(itemSkuDgRespDto.getSkuName());
                    r.setSpecification(StringUtils.isNotEmpty((CharSequence)itemSkuDgRespDto.getSpecOne()) ? itemSkuDgRespDto.getSpecOne() : itemSkuDgRespDto.getSpecTwo());
                    if (StringUtils.isEmpty((CharSequence)r.getBatch())) {
                        r.setBatch(InventoryConfig.getDefaultBatch());
                    }
                }
            });
        }
    }

    private void unitProcess(String transferNo, List<TransferOrderDetailReqDto> detailList) {
        ArrayList<OrderUnitConversionReqDto.OrderUnitConversionDetail> unitConversionDetails = new ArrayList<OrderUnitConversionReqDto.OrderUnitConversionDetail>();
        for (TransferOrderDetailReqDto detail : detailList) {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(detail.getUnit());
            unitConversionDetail.setSkuCode(detail.getSkuCode());
            unitConversionDetail.setCurNum(BigDecimalUtils.abs((BigDecimal)detail.getQuantity()));
            unitConversionDetails.add(unitConversionDetail);
        }
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(transferNo);
        orderUnitConversionReqDto.setType("transfer");
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        List<OrderUnitConversionRecordDto> conversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
    }

    private String getKey(String skuCode, BigDecimal num) {
        return skuCode + num;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Boolean> edit(TransferOrderComboReqDto dto) {
        RestResponse shipmentEnterpriseResponse;
        DgCsShipmentEnterpriseRespDto shipmentEnterpriseRespDto;
        TransferOrderKeyDto keyDto = (TransferOrderKeyDto)BeanUtil.copyProperties((Object)dto.getTransferOrderReqDto(), TransferOrderKeyDto.class, (String[])new String[0]);
        TransferOrderEo params = ((ITransferOrderDomain)this.domain).selectByBizKey(keyDto);
        AssertUtil.isTrue((params.getOrderStatus().equals(TransferOrderStatus.PENDING.code()) || params.getOrderStatus().equals(TransferOrderStatus.APPROVAL_REJECT.code()) ? 1 : 0) != 0, (String)("\u8c03\u62e8\u5355[" + TransferOrderStatus.getByCode((String)params.getOrderStatus()).getDesc() + "]\u72b6\u6001\u4e0d\u53ef\u7f16\u8f91"));
        ((ITransferOrderDomain)this.domain).checkSelfParam(dto);
        this.transferOrderWarehouseExe.checkWarehouse(dto.getTransferOrderReqDto());
        this.transferOrderDetailDomain.checkSelfParam(dto.getDetailList());
        this.transferOrderDetailDomain.deleteByTransferOrderNo(params.getTransferOrderNo());
        List<TransferOrderDetailReqDto> detailList = this.supplementItemInfo(dto.getDetailList(), params.getTransferOrderNo());
        BigDecimal totalQuantity = detailList.stream().map(TransferOrderDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList detailEoList = new ArrayList(detailList.size());
        DtoHelper.dtoList2EoList(detailList, detailEoList, TransferOrderDetailEo.class);
        detailEoList.forEach(item -> {
            item.setId(null);
            item.setTransferOrderNo(params.getTransferOrderNo());
        });
        this.transferOrderDetailDomain.insertBatch(detailEoList);
        TransferOrderReqDto transferOrderReqDto = dto.getTransferOrderReqDto();
        if (StringUtils.isNotBlank((CharSequence)transferOrderReqDto.getShipmentEnterpriseCode()) && StringUtils.isBlank((CharSequence)transferOrderReqDto.getShipmentEnterpriseName()) && (shipmentEnterpriseRespDto = (DgCsShipmentEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)(shipmentEnterpriseResponse = this.shipmentEnterpriseQueryApiProxy.getDataByCode(transferOrderReqDto.getShipmentEnterpriseCode())))) != null) {
            transferOrderReqDto.setInPhysicsWarehouseName(shipmentEnterpriseRespDto.getName());
        }
        this.setSaleAccountingCompany(dto.getTransferOrderReqDto());
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)transferOrderReqDto, (BaseEo)transferOrderEo);
        transferOrderEo.setTotalQuantity(totalQuantity);
        if (transferOrderEo.getId() == null) {
            throw new RuntimeException("\u63d0\u4ea4\u6570\u636e\u9519\u8bef\uff0c\u65e0id");
        }
        if (CollectionUtils.isNotEmpty((Collection)transferOrderReqDto.getDocumentUrlList())) {
            if (transferOrderReqDto.getDocumentUrlList().size() > 50) {
                throw new RuntimeException("\u63d0\u4ea4\u7684\u6587\u4ef6\u4fe1\u606f\u5df2\u8d85\u8fc7\u4e94\u5341\u6761");
            }
            transferOrderEo.setDocumentUrl(StringUtils.join((Iterable)transferOrderReqDto.getDocumentUrlList(), (String)","));
        } else {
            transferOrderEo.setDocumentUrl("");
        }
        if (CollectionUtils.isNotEmpty((Collection)transferOrderReqDto.getReturnTransferOrderNoList())) {
            transferOrderEo.setReturnTransferOrderNo(String.join((CharSequence)",", transferOrderReqDto.getReturnTransferOrderNoList()));
        }
        JSONObject extension = ExtensionUtil.parseJson(transferOrderEo.getExtension());
        extension.put("refundType", (Object)transferOrderReqDto.getRefundType());
        transferOrderEo.setExtension(extension.toJSONString());
        ((ITransferOrderDomain)this.domain).updateSelective((BaseEo)transferOrderEo);
        if (CommitEnum.COMMIT.code().equals(dto.getCommitType())) {
            this.commit(keyDto);
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.EDITED.name(), (String)"EMPTY", (String)params.getTransferOrderNo(), (String)CodeGenEnum.TRANSFER_ORDER.getCode());
        return new RestResponse((Object)Boolean.TRUE);
    }

    public List<TransferOrderDetailReqDto> supplementItemInfo(List<TransferOrderDetailReqDto> detailList, String transferNo) {
        if (CollectionUtils.isEmpty(detailList)) {
            return detailList;
        }
        log.info("\u65b0\u589e\u7f16\u8f91\u8c03\u62e8\u5355\u662f\u5426\u5f00\u542f\u5546\u54c1\u5355\u4f4d\u6362\u7b97\uff1a{}", (Object)InventoryConfig.isEnableUnit());
        HashMap<String, BasicOrderDtoExtension> weightAndVolumeMap = new HashMap<String, BasicOrderDtoExtension>();
        if (InventoryConfig.isEnableUnit()) {
            ArrayList<IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo> volumeDetailBos = new ArrayList<IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo>();
            detailList.forEach(adjustmentOrderDetailDto -> {
                IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo detail = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
                detail.setUnit(adjustmentOrderDetailDto.getUnit());
                detail.setSkuCode(adjustmentOrderDetailDto.getSkuCode());
                detail.setQuantity(adjustmentOrderDetailDto.getQuantity());
                volumeDetailBos.add(detail);
            });
            IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo reqDto = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
            reqDto.setDocumentCode(transferNo);
            reqDto.setVolumeDetailBos(volumeDetailBos);
            weightAndVolumeMap.putAll(this.orderUnitConversionRecordService.calculateWeightAndVolume(reqDto));
        }
        List skuCodes = detailList.stream().map(TransferOrderDetailReqDto::getSkuCode).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        HashMap existCodes = new HashMap();
        List itemSkus = null;
        if (CollectionUtils.isNotEmpty(skuCodes) && CollectionUtil.isNotEmpty((Collection)(itemSkus = this.itemSkuProxy.queryBySkuCode(skuCodes)))) {
            existCodes.putAll(itemSkus.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (k1, k2) -> k1)));
        }
        detailList.forEach(item -> {
            UnitDgRespDto unitDgRespDto;
            ItemSkuDgRespDto itemSkuDgRespDto;
            BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)weightAndVolumeMap.get(item.getSkuCode() + InventoryConfig.getCommonSeparate() + item.getQuantity());
            if (basicOrderDtoExtension != null) {
                item.setWeight(basicOrderDtoExtension.getWeight());
                item.setVolume(basicOrderDtoExtension.getVolume());
            }
            if ((itemSkuDgRespDto = (ItemSkuDgRespDto)existCodes.get(item.getSkuCode())) != null && StringUtils.isBlank((CharSequence)item.getSkuName())) {
                item.setSkuName(itemSkuDgRespDto.getName());
                if (item.getWeight() == null || item.getWeight().compareTo(BigDecimal.ZERO) == 0) {
                    item.setWeight(null != itemSkuDgRespDto.getNetWeight() ? item.getQuantity().multiply(itemSkuDgRespDto.getNetWeight()) : BigDecimal.ZERO);
                }
                if (item.getVolume() == null || item.getVolume().compareTo(BigDecimal.ZERO) == 0) {
                    item.setVolume(null != itemSkuDgRespDto.getVolume() ? item.getQuantity().multiply(itemSkuDgRespDto.getVolume()) : BigDecimal.ZERO);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)item.getStorageCondition()) && StringUtils.isBlank((CharSequence)item.getStorageConditionName())) {
                switch (item.getStorageCondition()) {
                    case "0": {
                        item.setStorageConditionName("\u5e38\u6e29");
                        break;
                    }
                    case "1": {
                        item.setStorageConditionName("\u4f4e\u6e29");
                        break;
                    }
                    case "2": {
                        item.setStorageConditionName("\u51b7\u85cf");
                        break;
                    }
                    case "3": {
                        item.setStorageConditionName("\u51b7\u51bb");
                        break;
                    }
                    default: {
                        item.setStorageConditionName("\u5e38\u6e29");
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)item.getUnit()) && StringUtils.isBlank((CharSequence)item.getUnitName()) && (unitDgRespDto = this.itemSkuDgQueryApiProxy.queryUnitByCode(item.getUnit())) != null) {
                item.setUnitName(unitDgRespDto.getName());
            }
        });
        return detailList;
    }

    @Override
    public RestResponse<List<TransferOrderTypeListRespDto>> queryTypeList() {
        ArrayList<TransferOrderTypeListRespDto> respDtoList = new ArrayList<TransferOrderTypeListRespDto>();
        for (TransferOrderTypeEnum type : TransferOrderTypeEnum.values()) {
            TransferOrderTypeListRespDto respDto = new TransferOrderTypeListRespDto();
            respDto.setLabel(type.getLabel());
            respDto.setValue(type.getCode());
            respDto.setVirtualTag(type.getVirtualTag());
            respDto.setEntity(type.getEntity());
            respDtoList.add(respDto);
        }
        return new RestResponse(respDtoList);
    }

    @Override
    public RestResponse<List<TransferOrderLabelValueRespDto>> queryStatusList() {
        ArrayList<TransferOrderLabelValueRespDto> respDtoList = new ArrayList<TransferOrderLabelValueRespDto>();
        for (TransferOrderStatus status : TransferOrderStatus.values()) {
            TransferOrderLabelValueRespDto respDto = new TransferOrderLabelValueRespDto();
            respDto.setLabel(status.getDesc());
            respDto.setValue(status.code());
            respDtoList.add(respDto);
        }
        return new RestResponse(respDtoList);
    }

    @Override
    public RestResponse<Void> testDelete(TransferOrderKeyDto keyDto) {
        TransferOrderEo transferOrderEo = ((ITransferOrderDomain)this.domain).selectByBizKey(keyDto);
        if (transferOrderEo != null) {
            ((ITransferOrderDomain)this.domain).deleteById(transferOrderEo.getId());
            this.transferOrderDetailDomain.deleteByTransferOrderNo(transferOrderEo.getTransferOrderNo());
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> statistics(TransferOrderKeyDto keyDto) {
        this.transferOrderDetailDomain.statisticsDispatcherByTransferOrderNo(keyDto.getTransferOrderNo(), true, InventoryConfig.isDispatchOrderBatch());
        return new RestResponse((Object)Boolean.TRUE);
    }

    @Override
    public RestResponse<Void> batchModificationQuantity(List<BatchModificationQuantityDto> batchModificationQuantityDtoList) {
        log.info("\u8c03\u62e8\u5355\u6279\u91cf\u66f4\u65b0\u8ba1\u5212\u6570\u91cf:{}", (Object)JSON.toJSONString(batchModificationQuantityDtoList));
        List transferNoList = batchModificationQuantityDtoList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getTransferOrderNo())).map(BatchModificationQuantityDto::getTransferOrderNo).collect(Collectors.toList());
        List transferOrderEoList = ((ExtQueryChainWrapper)((ITransferOrderDomain)this.domain).filter().in(CollectionUtil.isNotEmpty(transferNoList), (Object)"transfer_order_no", transferNoList)).list();
        for (TransferOrderEo transferOrderEo : transferOrderEoList) {
            AssertUtils.isTrue((boolean)TransferOrderApprovalState.PENDING_SUBMISSION.getCode().equals(transferOrderEo.getApprovalStatus()), (String)("\u5355\u636e" + transferOrderEo.getTransferOrderNo() + "\u72b6\u6001\u4e0d\u4e3a\u5f85\u63d0\u4ea4\u72b6\u6001"));
        }
        List skuCodeList = batchModificationQuantityDtoList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSkuCode())).map(BatchModificationQuantityDto::getSkuCode).collect(Collectors.toList());
        List batchList = batchModificationQuantityDtoList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getBatch())).map(BatchModificationQuantityDto::getBatch).collect(Collectors.toList());
        Map<String, BigDecimal> newQuantityMap = batchModificationQuantityDtoList.stream().collect(Collectors.toMap(r -> r.getTransferOrderNo() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch(), BatchModificationQuantityDto::getNewQuantity, (o, o1) -> o));
        List transferOrderDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.transferOrderDetailDomain.filter().in(CollectionUtil.isNotEmpty(transferNoList), (Object)"transfer_order_no", transferNoList)).in(CollectionUtil.isNotEmpty(skuCodeList), (Object)"sku_code", skuCodeList)).in(CollectionUtil.isNotEmpty(batchList), (Object)"batch", batchList)).list();
        transferOrderDetailEoList.forEach(r -> {
            if (newQuantityMap.containsKey(r.getTransferOrderNo() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch())) {
                r.setQuantity((BigDecimal)newQuantityMap.get(r.getTransferOrderNo() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch()));
            }
            this.transferOrderDetailDomain.updateSelective((BaseEo)r);
        });
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void batchAdd(List<TransferOrderComboReqDto> dtos) {
        AssertUtil.isTrue((boolean)CollectionUtil.isNotEmpty(dtos), (String)"\u6279\u91cf\u65b0\u589e\u8c03\u62e8\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        dtos.forEach(e -> this.add((TransferOrderComboReqDto)e));
    }

    @Override
    public RestResponse<Void> modifyErpStatus(TransferOrderReqDto transferOrderReqDto) {
        AssertUtils.notEmpty((String)transferOrderReqDto.getTransferOrderNo(), (String)"\u8c03\u62e8\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ITransferOrderDomain)this.domain).filter().eq((Object)"transfer_order_no", (Object)transferOrderReqDto.getTransferOrderNo())).last("limit 1")).one();
        AssertUtils.notEmpty((Object)transferOrderEo, (String)"\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
        TransferOrderEo updateTransferOrderEo = new TransferOrderEo();
        updateTransferOrderEo.setId(transferOrderEo.getId());
        if (StringUtils.isNotBlank((CharSequence)transferOrderReqDto.getExternalOrderNo())) {
            updateTransferOrderEo.setExternalOrderNo(transferOrderReqDto.getExternalOrderNo());
        }
        updateTransferOrderEo.setPushE3Status(transferOrderReqDto.getPushE3Status());
        updateTransferOrderEo.setE3FailReason(transferOrderReqDto.getE3FailReason());
        ((ITransferOrderDomain)this.domain).updateSelective((BaseEo)updateTransferOrderEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyPostReferenceStatus(TransferOrderReqDto transferOrderReqDto) {
        AssertUtils.notEmpty((String)transferOrderReqDto.getTransferOrderNo(), (String)"\u8c03\u62e8\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ITransferOrderDomain)this.domain).filter().eq((Object)"transfer_order_no", (Object)transferOrderReqDto.getTransferOrderNo())).last("limit 1")).one();
        if (StringUtils.isNotBlank((CharSequence)transferOrderReqDto.getExternalOrderNo())) {
            transferOrderEo.setExternalOrderNo(transferOrderReqDto.getExternalOrderNo());
        }
        transferOrderEo.setPostReferenceStatus(transferOrderReqDto.getPostReferenceStatus());
        ((ITransferOrderDomain)this.domain).update((BaseEo)transferOrderEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> deleteTransferOrder(TransferOrderKeyDto transferOrderKeyDto) {
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ITransferOrderDomain)this.domain).filter().eq((Object)"transfer_order_no", (Object)transferOrderKeyDto.getTransferOrderNo())).last("limit 1")).one();
        AssertUtils.isTrue((boolean)TransferOrderStatus.PENDING.code().equals(transferOrderEo.getOrderStatus()), (String)"\u8be5\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
        TransferOrderEo deleteTransferOrderEo = new TransferOrderEo();
        deleteTransferOrderEo.setTransferOrderNo(transferOrderEo.getTransferOrderNo());
        ((ITransferOrderDomain)this.domain).delete((BaseEo)deleteTransferOrderEo);
        TransferOrderDetailEo transferOrderDetailEo = new TransferOrderDetailEo();
        transferOrderDetailEo.setTransferOrderNo(transferOrderEo.getTransferOrderNo());
        this.transferOrderDetailDomain.delete((BaseEo)transferOrderDetailEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> automationInTask() {
        List transferOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ITransferOrderDomain)this.domain).filter().eq((Object)"order_status", (Object)TransferOrderStatus.ALL_DELIVERED_WAITING_FOR_DELIVERY.code())).eq((Object)"type", (Object)TransferOrderTypeEnum.EXTERNAL_WAREHOUSE_B_C.getCode())).list();
        if (CollectionUtil.isEmpty((Collection)transferOrderEos)) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u672a\u5165\u5e93\u7684\u5916\u4ed3BC\u8c03\u62e8");
            return null;
        }
        List transferOrderList = transferOrderEos.stream().map(TransferOrderEo::getTransferOrderNo).collect(Collectors.toList());
        List transferOrderDetailEoList = ((ExtQueryChainWrapper)this.transferOrderDetailDomain.filter().in((Object)"transfer_order_no", transferOrderList)).list();
        AssertUtils.notEmpty((Collection)transferOrderDetailEoList, (String)"\u8c03\u62e8\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iInOutNoticeOrderDomain.filter().in((Object)"relevance_no", transferOrderList)).eq((Object)"order_type", (Object)"in")).list();
        AssertUtils.notEmpty((Collection)inOutNoticeOrderEos, (String)"\u5165\u5e93\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        List documentNoList = inOutNoticeOrderEos.stream().map(InOutNoticeOrderEo::getDocumentNo).collect(Collectors.toList());
        List noticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().in((Object)"document_no", documentNoList)).list();
        AssertUtils.notEmpty((Collection)noticeOrderDetailEoList, (String)"\u5165\u5e93\u901a\u77e5\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        Map<String, String> skuCodeUnitMap = transferOrderDetailEoList.stream().collect(Collectors.toMap(TransferOrderDetailEo::getSkuCode, TransferOrderDetailEo::getUnit, (k1, k2) -> k1));
        Map<String, Long> outNoticeOrderIdMap = inOutNoticeOrderEos.stream().collect(Collectors.toMap(InOutNoticeOrderEo::getRelevanceNo, BaseEo::getId, (k1, k2) -> k1));
        Map<String, List<InOutNoticeOrderDetailEo>> noticeOrderDetailMap = noticeOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getRelevanceNo));
        for (TransferOrderEo transferOrderEo : transferOrderEos) {
            try {
                InResultOrderInsertReqDto inResultOrderInsertReqDto = this.getInResultOrderInsertReqDto(skuCodeUnitMap, outNoticeOrderIdMap, noticeOrderDetailMap, transferOrderEo);
                this.iInOutNoticeOrderService.productInbound(inResultOrderInsertReqDto);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u5916\u4ed3BC\u8c03\u62e8\u5165\u5e93\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
        return RestResponse.VOID;
    }

    private InResultOrderInsertReqDto getInResultOrderInsertReqDto(Map<String, String> skuCodeUnitMap, Map<String, Long> outNoticeOrderIdMap, Map<String, List<InOutNoticeOrderDetailEo>> noticeOrderDetailMap, TransferOrderEo transferOrderEo) {
        List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEos = noticeOrderDetailMap.get(transferOrderEo.getTransferOrderNo());
        Long id = outNoticeOrderIdMap.get(transferOrderEo.getTransferOrderNo());
        InResultOrderInsertReqDto inResultOrderInsertReqDto = new InResultOrderInsertReqDto();
        inResultOrderInsertReqDto.setId(id);
        inResultOrderInsertReqDto.setBizDate(new Date());
        ArrayList itemsReqDtoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo : inOutNoticeOrderDetailEos) {
            InResultOrderInsertItemsReqDto itemsReqDto = new InResultOrderInsertItemsReqDto();
            itemsReqDto.setQuantity(inOutNoticeOrderDetailEo.getWaitQuantity());
            itemsReqDto.setInventoryProperty(inOutNoticeOrderDetailEo.getInventoryProperty());
            itemsReqDto.setSkuCode(inOutNoticeOrderDetailEo.getSkuCode());
            itemsReqDto.setSkuName(inOutNoticeOrderDetailEo.getSkuName());
            itemsReqDto.setPreOrderItemId(inOutNoticeOrderDetailEo.getPreOrderItemId());
            itemsReqDto.setUnit(skuCodeUnitMap.get(inOutNoticeOrderDetailEo.getSkuCode()));
            itemsReqDtoList.add(itemsReqDto);
        }
        inResultOrderInsertReqDto.setItemsReqDtoList((List)itemsReqDtoList);
        return inResultOrderInsertReqDto;
    }

    @Override
    public RestResponse<PageInfo<TransferOrderPageDto>> queryPage(TransferOrderSearchDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        ((ITransferOrderDomain)this.domain).param(dto);
        List pageDtoList = ((ITransferOrderDomain)this.domain).selectPageList(dto);
        ArrayList transferOrderNos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageDtoList)) {
            pageDtoList.forEach(item -> {
                this.settingButton((TransferOrderPageDto)item);
                transferOrderNos.add(item.getTransferOrderNo());
            });
        }
        if (CollectionUtils.isNotEmpty(transferOrderNos)) {
            List inventoryOperateLogEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryOperateLogDomain.filter().in((Object)"source_no", transferOrderNos)).eq((Object)"change_type", (Object)"intransit")).isNotNull(!InventoryConfig.isNoneBatch(), (Object)"batch")).list();
            Map<String, List<InventoryOperateLogEo>> ransferOrderMap = inventoryOperateLogEoList.stream().collect(Collectors.groupingBy(InventoryOperateLogEo::getSourceNo));
            pageDtoList.forEach(item -> {
                List inventoryOperateLogEos = (List)ransferOrderMap.get(item.getTransferOrderNo());
                if (CollectionUtils.isNotEmpty((Collection)inventoryOperateLogEos)) {
                    BigDecimal inTransitQuantity = inventoryOperateLogEos.stream().map(InventoryOperateLogEo::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
                    item.setInTransitQuantity(inTransitQuantity);
                }
            });
            List auditRecordDtoList = this.storageAuditRecordDas.selectLastRemarkByOrderNos(transferOrderNos);
            if (CollectionUtils.isNotEmpty((Collection)auditRecordDtoList)) {
                Map<String, String> auditRemarkMap = auditRecordDtoList.stream().collect(Collectors.toMap(SimpleAuditRecordDto::getOrderSrcNo, sat -> sat.getRemark() != null ? sat.getRemark() : "", (existingValue, newValue) -> existingValue));
                pageDtoList.forEach(item -> {
                    String remark = (String)auditRemarkMap.get(item.getTransferOrderNo());
                    item.setAuditRemark(remark);
                });
            }
        }
        return new RestResponse((Object)new PageInfo(pageDtoList));
    }

    @Override
    public RestResponse<List<TransferOrderPageDto>> queryTransferOrderList(TransferOrderSearchDto dto) {
        List pageDtoList = ((ITransferOrderDomain)this.domain).selectPageList(dto);
        return new RestResponse((Object)pageDtoList);
    }

    private void settingButton(TransferOrderPageDto item) {
        if (TransferOrderStatus.PARTIALLY_DELIVERED_WAITING_FOR_DELIVERY.code().equals(item.getOrderStatus()) || TransferOrderStatus.PARTIALLY_DELIVERED_PARTIALLY_RECEIVED.code().equals(item.getOrderStatus())) {
            item.setButtonFlag(Integer.valueOf(item.getDeliveryStatus().equals(TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED.getCode()) ? 2 : 1));
        } else if (TransferOrderStatus.ALL_DELIVERED_WAITING_FOR_DELIVERY.code().equals(item.getOrderStatus()) || TransferOrderStatus.ALL_DELIVERED_PARTIALLY_RECEIVED.code().equals(item.getOrderStatus())) {
            item.setButtonFlag(Integer.valueOf(2));
        } else {
            item.setButtonFlag(Integer.valueOf(3));
        }
    }

    private void settingButton(TransferOrderItemPageDto item) {
        if (TransferOrderStatus.PARTIALLY_DELIVERED_WAITING_FOR_DELIVERY.code().equals(item.getOrderStatus()) || TransferOrderStatus.PARTIALLY_DELIVERED_PARTIALLY_RECEIVED.code().equals(item.getOrderStatus())) {
            item.setButtonFlag(Integer.valueOf(item.getDeliveryStatus().equals(TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED.getCode()) ? 2 : 1));
        } else if (TransferOrderStatus.ALL_DELIVERED_WAITING_FOR_DELIVERY.code().equals(item.getOrderStatus()) || TransferOrderStatus.ALL_DELIVERED_PARTIALLY_RECEIVED.code().equals(item.getOrderStatus())) {
            item.setButtonFlag(Integer.valueOf(2));
        } else {
            item.setButtonFlag(Integer.valueOf(3));
        }
    }

    @Override
    public RestResponse<PageInfo<TransferOrderItemPageDto>> pageByItem(TransferOrderSearchDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List itemPageDtoList = this.transferOrderDetailDomain.selectPageList(dto);
        if (CollectionUtils.isNotEmpty((Collection)itemPageDtoList)) {
            List dtoList;
            List<String> skuCodeList = itemPageDtoList.stream().map(TransferOrderItemPageDto::getSkuCode).distinct().collect(Collectors.toList());
            HashMap skuMap = new HashMap(skuCodeList.size());
            if (CollectionUtil.isNotEmpty(skuCodeList) && CollectionUtil.isNotEmpty(dtoList = this.itemDataQueryHelper.getByCodes(skuCodeList))) {
                Map skuDgRespDtoMap = dtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o, o1) -> o));
                skuMap.putAll(skuDgRespDtoMap);
            }
            List outPhysicsWarehouseCodeList = itemPageDtoList.stream().map(TransferOrderItemPageDto::getOutPhysicsWarehouseCode).collect(Collectors.toList());
            List inPhysicsWarehouseCodeList = itemPageDtoList.stream().map(TransferOrderItemPageDto::getInPhysicsWarehouseCode).collect(Collectors.toList());
            List outPhysicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(outPhysicsWarehouseCodeList, "physics");
            Map<String, WarehouseAddressEo> outWarehouseEoMap = outPhysicsWarehouseEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, warehouseEo -> warehouseEo, (existing, replacement) -> existing));
            List inPhysicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(inPhysicsWarehouseCodeList, "physics");
            Map<String, WarehouseAddressEo> inWarehouseEoMap = inPhysicsWarehouseEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, warehouseEo -> warehouseEo, (existing, replacement) -> existing));
            itemPageDtoList.forEach(item -> {
                StorageAuditRecordEo auditRecordEo;
                WarehouseAddressEo in;
                item.setPreOrderNoType(this.getPreOrderNoType(item.getPreOrderNo()));
                this.settingButton((TransferOrderItemPageDto)item);
                WarehouseAddressEo out = (WarehouseAddressEo)outWarehouseEoMap.get(item.getOutPhysicsWarehouseCode());
                if (out != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(out.getProvince());
                    sb.append(out.getCity());
                    sb.append(out.getDistrict());
                    sb.append(out.getDetailAddress());
                    item.setOutPhysicsWarehouseDetailAddress(sb.toString());
                }
                if ((in = (WarehouseAddressEo)inWarehouseEoMap.get(item.getInPhysicsWarehouseCode())) != null) {
                    String sb = in.getProvince() + in.getCity() + in.getDistrict() + in.getDetailAddress();
                    item.setInPhysicsWarehouseDetailAddress(sb);
                }
                if ((auditRecordEo = this.storageAuditRecordDas.selectLastOne(item.getTransferOrderNo(), item.getType())) != null) {
                    item.setAuditRemark(auditRecordEo.getRemark());
                }
                if (skuMap.containsKey(item.getSkuCode())) {
                    ItemSkuDto itemSkuDgRespDto = (ItemSkuDto)skuMap.get(item.getSkuCode());
                    item.setSpuCode(itemSkuDgRespDto.getSpuCode());
                    item.setSpuName(itemSkuDgRespDto.getSpuName());
                    item.setSpecModel(itemSkuDgRespDto.getSpecModel());
                    item.setVolume(itemSkuDgRespDto.getVolume());
                    item.setVolumeUnit(itemSkuDgRespDto.getVolumeUnit());
                    item.setSkuDisplayName(itemSkuDgRespDto.getSkuDisplayName());
                }
            });
        }
        List transferOrderNoList = itemPageDtoList.stream().map(TransferOrderItemPageDto::getTransferOrderNo).collect(Collectors.toList());
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtil.isNotEmpty(transferOrderNoList), (Object)"document_code", transferOrderNoList)).list();
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode() + o.getUnit(), Function.identity(), (o2, o1) -> o2));
        itemPageDtoList.forEach(o -> {
            if (unitConversionMap.containsKey(o.getTransferOrderNo() + o.getSkuCode() + o.getUnit())) {
                this.unitConversion((TransferOrderItemPageDto)o, (OrderUnitConversionRecordEo)unitConversionMap.get(o.getTransferOrderNo() + o.getSkuCode() + o.getUnit()));
            }
            BigDecimal inTransitQuantity = BigDecimalUtils.subtract((BigDecimal)o.getDoneOutQuantity(), (BigDecimal)o.getDoneInQuantity());
            o.setInTransitQuantity(inTransitQuantity);
        });
        itemPageDtoList.forEach(item -> {
            if (item.getDispatcherLessQuantity() != null && item.getDispatcherLessQuantity().compareTo(BigDecimal.ZERO) == 0) {
                item.setDispatcherLessQuantity(null);
            }
            if (item.getReceiveDeliveryDifferenceQuantity() != null && item.getReceiveDeliveryDifferenceQuantity().compareTo(BigDecimal.ZERO) == 0) {
                item.setReceiveDeliveryDifferenceQuantity(null);
            }
        });
        return new RestResponse((Object)new PageInfo(itemPageDtoList));
    }

    @Nullable
    private String getPreOrderNoType(String preOrderNo) {
        return StringUtils.isNotBlank((CharSequence)preOrderNo) && preOrderNo.contains(CodeGenEnum.DISPATCHER_ORDER.getPrefix()) ? TypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode() : null;
    }

    private void unitConversion(TransferOrderItemPageDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        BigDecimal rate = unitConversionEo.getNum().divide(unitConversionEo.getToNum(), 6, RoundingMode.HALF_UP);
        BigDecimal doneOutQuantity = null != dto.getDoneOutQuantity() ? dto.getDoneOutQuantity().multiply(rate) : null;
        BigDecimal doneInQuantity = null != dto.getDoneInQuantity() ? dto.getDoneInQuantity().multiply(rate) : null;
        dto.setDoneOutQuantity(doneOutQuantity);
        dto.setDoneInQuantity(doneInQuantity);
    }

    @Override
    public RestResponse<TransferOrderRespDto> detail(TransferOrderKeyDto keyDto) {
        LogicWarehouseEo logicWarehouseEo;
        StorageAuditRecordEo auditRecordEo;
        WarehouseAddressEo out;
        TransferOrderEo transferOrderEo = ((ITransferOrderDomain)this.domain).selectByBizKey(keyDto);
        if (transferOrderEo == null) {
            log.error("\u8c03\u62e8\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002");
            return new RestResponse();
        }
        AssertUtils.notNull((Object)transferOrderEo, (String)"\u8c03\u62e8\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002");
        TransferOrderRespDto respDto = new TransferOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)transferOrderEo, (BaseVo)respDto);
        ArrayList<String> warehouseCodes = new ArrayList<String>(Arrays.asList(respDto.getInLogicWarehouseCode(), respDto.getOutLogicWarehouseCode()));
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEo(warehouseCodes);
        Map<Object, Object> logicWarehouseEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(logicWarehouseEos)) {
            logicWarehouseEoMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<String> physicsWarehouseCodeList = new ArrayList<String>();
        physicsWarehouseCodeList.add(respDto.getInPhysicsWarehouseCode());
        physicsWarehouseCodeList.add(respDto.getOutPhysicsWarehouseCode());
        List inPhysicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(physicsWarehouseCodeList, "physics");
        Map<String, WarehouseAddressEo> warehouseEoMap = inPhysicsWarehouseEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, warehouseEo -> warehouseEo, (existing, replacement) -> existing));
        WarehouseAddressEo in = warehouseEoMap.get(respDto.getInPhysicsWarehouseCode());
        if (in != null) {
            String sb = in.getProvince() + in.getCity() + in.getDistrict() + in.getDetailAddress();
            respDto.setInPhysicsWarehouseDetailAddress(sb);
        }
        if ((out = warehouseEoMap.get(respDto.getOutPhysicsWarehouseCode())) != null) {
            String sb = out.getProvince() + out.getCity() + out.getDistrict() + out.getDetailAddress();
            respDto.setOutPhysicsWarehouseDetailAddress(sb);
        }
        if ((auditRecordEo = this.storageAuditRecordDas.selectLastOne(respDto.getTransferOrderNo(), respDto.getType())) != null) {
            respDto.setAuditRemark(auditRecordEo.getRemark());
        }
        if (transferOrderEo.getTotalVolume() != null) {
            respDto.setTotalVolume(transferOrderEo.getTotalVolume());
        }
        if (transferOrderEo.getTotalWeight() != null) {
            respDto.setTotalWeight(transferOrderEo.getTotalWeight());
        }
        if (StringUtils.isNotEmpty((CharSequence)transferOrderEo.getDocumentUrl())) {
            respDto.setDocumentUrlList(Arrays.asList(transferOrderEo.getDocumentUrl().split(",")));
        }
        if (logicWarehouseEoMap.containsKey(respDto.getOutLogicWarehouseCode())) {
            logicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(respDto.getOutLogicWarehouseCode());
            respDto.setOutOrganizationCode(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getOrganizationCode() : null);
            respDto.setOutOrganizationName(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getOrganizationName() : null);
            respDto.setOutOrganization(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getOrganizationName() : null);
        }
        if (logicWarehouseEoMap.containsKey(respDto.getInLogicWarehouseCode())) {
            logicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(respDto.getInLogicWarehouseCode());
            respDto.setInOrganizationCode(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getOrganizationCode() : null);
            respDto.setInOrganizationName(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getOrganizationName() : null);
            respDto.setInOrganization(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getOrganizationName() : null);
        }
        List csOutResultOrderEoList = ((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)respDto.getTransferOrderNo())).list();
        List outDocumentNoList = csOutResultOrderEoList.stream().filter(o -> StringUtils.equals((CharSequence)"out", (CharSequence)o.getOrderType())).map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList());
        List inDocumentNoList = csOutResultOrderEoList.stream().filter(o -> StringUtils.equals((CharSequence)"in", (CharSequence)o.getOrderType())).map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList());
        List unitConversionRecordEos = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)respDto.getTransferOrderNo())).list();
        Map<String, BigDecimal> ratioMap = unitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
        Map<String, BigDecimal> toRatioMap = unitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getNum(), (BigDecimal)r.getToNum(), (int)6), (o, o1) -> o));
        if (CollectionUtils.isNotEmpty((Collection)csOutResultOrderEoList)) {
            if (CollectionUtil.isNotEmpty(outDocumentNoList)) {
                List outResultOrderDetailEos = Optional.ofNullable(((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", outDocumentNoList)).list()).orElse(Lists.newArrayList());
                BigDecimal outboundTotalQuantity = outResultOrderDetailEos.stream().map(detail -> UnitTransferUtils.pareSaleNum((BigDecimal)detail.getDoneQuantity(), (BigDecimal)((BigDecimal)ratioMap.get(detail.getSkuCode())), (BigDecimal)((BigDecimal)toRatioMap.get(detail.getSkuCode())))).reduce(BigDecimal.ZERO, BigDecimal::add);
                respDto.setOutboundTotalQuantity(outboundTotalQuantity);
            }
            if (CollectionUtil.isNotEmpty(inDocumentNoList)) {
                List inOutResultOrderDetailEos = Optional.ofNullable(((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", inDocumentNoList)).list()).orElse(Lists.newArrayList());
                BigDecimal inboundTotalQuantity = inOutResultOrderDetailEos.stream().map(detail -> UnitTransferUtils.pareSaleNum((BigDecimal)detail.getDoneQuantity(), (BigDecimal)((BigDecimal)ratioMap.get(detail.getSkuCode())), (BigDecimal)((BigDecimal)toRatioMap.get(detail.getSkuCode())))).reduce(BigDecimal.ZERO, BigDecimal::add);
                respDto.setInboundTotalQuantity(inboundTotalQuantity);
            }
        }
        List transferOrderDetailEos = Optional.ofNullable(((ExtQueryChainWrapper)this.transferOrderDetailDomain.filter().eq(StringUtils.isNotBlank((CharSequence)respDto.getTransferOrderNo()), (Object)"transfer_order_no", (Object)respDto.getTransferOrderNo())).list()).orElse(new ArrayList());
        respDto.setDispatcherTotalQuantity(transferOrderDetailEos.stream().filter(o -> Objects.nonNull(o.getDispatcherQuantity())).map(TransferOrderDetailEo::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        respDto.setDispatcherLessTotalQuantity(transferOrderDetailEos.stream().filter(o -> Objects.nonNull(o.getDispatcherLessQuantity())).map(TransferOrderDetailEo::getDispatcherLessQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        respDto.setInboundTotalQuantity(transferOrderDetailEos.stream().filter(o -> Objects.nonNull(o.getDoneInQuantity())).map(TransferOrderDetailEo::getDoneInQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        respDto.setOutboundTotalQuantity(transferOrderDetailEos.stream().filter(o -> Objects.nonNull(o.getDoneOutQuantity())).map(TransferOrderDetailEo::getDoneOutQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        JSONObject jsonObject = JSONObject.parseObject((String)Optional.ofNullable(transferOrderEo.getExtension()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse("{}"));
        respDto.setPlatformId(Long.valueOf(jsonObject.getLongValue("platformId")));
        respDto.setPlatformName(jsonObject.getString("platformName"));
        respDto.setRefundType(jsonObject.getInteger("refundType"));
        if (StringUtils.isNotBlank((CharSequence)transferOrderEo.getReturnTransferOrderNo())) {
            respDto.setReturnTransferOrderNoList((List)Lists.newArrayList((Object[])transferOrderEo.getReturnTransferOrderNo().split(",")));
        }
        return new RestResponse((Object)respDto);
    }

    @Override
    public RestResponse<TransferOrderRespDto> detailByOrderNo(String orderNo) {
        TransferOrderRespDto transferOrderRespDto = ((ITransferOrderDomain)this.domain).queryByTransferOrderNo(orderNo);
        if (transferOrderRespDto == null) {
            log.error("\u8c03\u62e8\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002");
            return new RestResponse();
        }
        List detailEoList = Optional.ofNullable(((ExtQueryChainWrapper)this.transferOrderDetailDomain.filter().eq(StringUtils.isNotBlank((CharSequence)orderNo), (Object)"transfer_order_no", (Object)orderNo)).list()).orElse(new ArrayList());
        ArrayList detailList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)detailEoList, detailList, TransferOrderDetailReqDto.class);
        transferOrderRespDto.setDetailList(detailList);
        return new RestResponse((Object)transferOrderRespDto);
    }

    @Override
    public Boolean updateRemarkById(Long id, String remark) {
        AssertUtils.isTrue((id != null ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        transferOrderEo.setId(id);
        transferOrderEo.setRemark(remark);
        return ((ITransferOrderDomain)this.domain).updateSelective((BaseEo)transferOrderEo) > 0;
    }

    @Override
    public RestResponse<TransferOrderRespDto> queryByTransferOrderNo(String transferOrderNo) {
        TransferOrderKeyDto keyDto = new TransferOrderKeyDto();
        keyDto.setTransferOrderNo(transferOrderNo);
        return this.detail(keyDto);
    }

    private List<LogicWarehouseEo> getLogicWarehouseEo(List<String> warehouseCodes) {
        List logicWarehouseEoList;
        int length;
        ArrayList logicWarehouseEos = Lists.newArrayList();
        int i = 0;
        for (length = warehouseCodes.size(); length > 1000; length -= 1000) {
            logicWarehouseEoList = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes.subList(i, i + 1000))).list();
            logicWarehouseEos.addAll(logicWarehouseEoList);
            i += 1000;
        }
        if (length > 0) {
            logicWarehouseEoList = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes.subList(i, i + length))).list();
            logicWarehouseEos.addAll(logicWarehouseEoList);
        }
        return logicWarehouseEos;
    }

    private void checkParams(CsTransferOrderDeliveryReceiveConfirmReqDto deliveryReceiveConfirmReqDto) {
        AssertUtil.isTrue((null != deliveryReceiveConfirmReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String transferOrderNo = deliveryReceiveConfirmReqDto.getTransferOrderNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)transferOrderNo), (String)"\u8c03\u62e8\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String triggerFlag = deliveryReceiveConfirmReqDto.getTriggerFlag();
        AssertUtil.isTrue((StringUtils.isNotBlank((CharSequence)triggerFlag) && ("delivery".equals(triggerFlag) || "receive".equals(triggerFlag)) ? 1 : 0) != 0, (String)"\u89e6\u53d1\u6807\u8bc6\u53c2\u6570\u6709\u8bef");
        List detailReqDtoList = deliveryReceiveConfirmReqDto.getDetailReqDtoList();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)detailReqDtoList), (String)"\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        detailReqDtoList.forEach(item -> AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getSkuCode()), (String)"\u5546\u54c1sku\u7f16\u7801\u53c2\u6570\u6709\u8bef"));
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> audit(TransferOrderAuditReqDto dto) {
        BatchOrderOperationMsgDto.ResMsg resMsg = null;
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        for (String transferOrderNo : dto.getTransferOrderNos()) {
            resMsg = new BatchOrderOperationMsgDto.ResMsg();
            try {
                ((TransferOrderServiceImpl)SpringBeanUtil.getBean(this.getClass())).auditTransferOrder(dto, transferOrderNo);
                resMsg.setMsg(transferOrderNo);
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                log.error("\u8c03\u62e8\u5355{}\u5ba1\u6838\u5931\u8d25\uff1a", (Object)transferOrderNo, (Object)e);
                resMsg.setMsg(String.format("%s\u5ba1\u6838\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", transferOrderNo, e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        }
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(dto.getTransferOrderNos().size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return new RestResponse((Object)msgDto);
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void auditTransferOrder(TransferOrderAuditReqDto dto, String transferOrderNo) {
        int auditLevel;
        this.doAuditTransferOrder(dto, transferOrderNo);
        if (InventoryConfig.isCanSecondLevel() && "audit_pass".equals(dto.getAuditResult()) && (auditLevel = this.automaticAuditPolicyDomain.getAuditLevel(dto.getOrderType(), dto.getType())) == 2) {
            dto.setRemark("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
            this.doAuditTransferOrder(dto, transferOrderNo);
        }
    }

    private void doAuditTransferOrder(TransferOrderAuditReqDto dto, String transferOrderNo) {
        TransferOrderKeyDto keyDto = new TransferOrderKeyDto();
        keyDto.setTransferOrderNo(transferOrderNo);
        TransferOrderEo transferOrderEo = ((ITransferOrderDomain)this.domain).selectByBizKey(keyDto);
        AssertUtil.isTrue((boolean)TransferOrderStatus.isAuditStatus((String)transferOrderEo.getOrderStatus()), (String)"\u975e\u5f85\u5ba1\u6838\u72b6\u6001\uff01");
        if ("1".equals(dto.getAuditResult())) {
            dto.setAuditResult("audit_pass");
        }
        if ("2".equals(dto.getAuditResult())) {
            dto.setAuditResult("audit_failed");
        }
        if (dto.getBizDate() != null) {
            transferOrderEo.setBizDate(dto.getBizDate());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getExtension())) {
            if (StringUtils.isNotBlank((CharSequence)transferOrderEo.getExtension())) {
                JSONObject nowJsonObject = JSONObject.parseObject((String)dto.getExtension());
                JSONObject jsonObject = JSONObject.parseObject((String)transferOrderEo.getExtension());
                if (jsonObject.containsKey((Object)"platformName")) {
                    nowJsonObject.put("platformName", jsonObject.get((Object)"platformName"));
                }
                if (jsonObject.containsKey((Object)"platformId")) {
                    nowJsonObject.put("platformId", jsonObject.get((Object)"platformId"));
                }
                transferOrderEo.setExtension(nowJsonObject.toJSONString());
            } else {
                transferOrderEo.setExtension(dto.getExtension());
            }
        }
        if (StringUtils.isBlank((CharSequence)transferOrderEo.getPreOrderNo()) || !transferOrderEo.getPreOrderNo().contains(CodeGenEnum.DISPATCHER_ORDER.getPrefix())) {
            boolean isCanAudit = ((ITransferOrderDomain)this.domain).isCanAudit(transferOrderEo);
            AssertUtil.isTrue((boolean)isCanAudit, (String)"\u9009\u9879\u4e2d\u542b\u975e\u5f85\u5ba1\u6838\u8c03\u62e8\u5355,\u8bf7\u68c0\u67e5\u540e\u91cd\u9009\u3002");
        }
        if (StringUtils.isBlank((CharSequence)transferOrderEo.getPreOrderNo()) || !transferOrderEo.getPreOrderNo().contains(CodeGenEnum.DISPATCHER_ORDER.getPrefix())) {
            boolean isCanAudit = ((ITransferOrderDomain)this.domain).isCanAudit(transferOrderEo);
            AssertUtil.isTrue((boolean)isCanAudit, (String)"\u9009\u9879\u4e2d\u542b\u975e\u5f85\u5ba1\u6838\u8c03\u62e8\u5355,\u8bf7\u68c0\u67e5\u540e\u91cd\u9009\u3002");
        }
        dto.setOrderType(transferOrderEo.getOrderType());
        dto.setType(transferOrderEo.getType());
        if (dto.getVirtualOrderAutoComplete() == null) {
            dto.setVirtualOrderAutoComplete(Boolean.valueOf(false));
        }
        boolean accord = StringUtils.isNotBlank((CharSequence)dto.getRemark()) && StringUtils.length((CharSequence)dto.getRemark()) > 200;
        AssertUtil.isFalse((boolean)accord, (String)"\u5907\u6ce8\u957f\u5ea6\u5927\u4e8e200\u5b57\uff0c\u8fc7\u957f\u3002");
        boolean isApproved = true;
        boolean isAutoComplete = this.canAutoComplete(transferOrderEo.getInLogicWarehouseCode(), transferOrderEo.getOutLogicWarehouseCode());
        boolean isInterOrganizationTransactionOrder = TransferOrderEnum.INTER_ORGANIZATION_TRANSACTION_ORDER.getCode().equals(transferOrderEo.getOrderType());
        dto.setVirtualOrderAutoComplete(Boolean.valueOf(dto.getVirtualOrderAutoComplete() != false || isAutoComplete || isInterOrganizationTransactionOrder));
        isInterOrganizationTransactionOrder |= TransferOrderEnum.OVERSEAS_RESTORAGE_TRANSFER_ORDER.getCode().equals(transferOrderEo.getOrderType());
        switch (dto.getAuditResult()) {
            case "audit_failed": {
                isApproved = false;
                if (TransferOrderApprovalState.PRIMARY_PENDING.getCode().equals(transferOrderEo.getApprovalStatus())) {
                    this.approvalStateMachineHelper.sendAuditEvent(TransferOrderApprovalEvent.REJECT_PRIMARY, transferOrderEo, dto.getRemark(), dto.getVirtualOrderAutoComplete());
                    break;
                }
                if (!TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY.getCode().equals(transferOrderEo.getApprovalStatus())) break;
                this.approvalStateMachineHelper.sendAuditEvent(TransferOrderApprovalEvent.REJECT_SECONDARY, transferOrderEo, dto.getRemark(), dto.getVirtualOrderAutoComplete());
                break;
            }
            case "audit_pass": {
                if (TransferOrderApprovalState.PRIMARY_PENDING.getCode().equals(transferOrderEo.getApprovalStatus())) {
                    if (InventoryConfig.isCanSecondLevel() && !isInterOrganizationTransactionOrder) {
                        this.approvalStateMachineHelper.sendAuditEvent(TransferOrderApprovalEvent.PASS_PRIMARY, transferOrderEo, dto.getRemark(), dto.getVirtualOrderAutoComplete());
                        break;
                    }
                    this.approvalStateMachineHelper.sendAuditEvent(TransferOrderApprovalEvent.PASS_SECONDARY, transferOrderEo, dto.getRemark(), dto.getVirtualOrderAutoComplete());
                    break;
                }
                if (!TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY.getCode().equals(transferOrderEo.getApprovalStatus()) && !TransferOrderApprovalState.PENDING_SUBMISSION.getCode().equals(transferOrderEo.getApprovalStatus())) break;
                this.approvalStateMachineHelper.sendAuditEvent(TransferOrderApprovalEvent.PASS_SECONDARY, transferOrderEo, dto.getRemark(), dto.getVirtualOrderAutoComplete());
                break;
            }
            default: {
                throw new BizException("\u5ba1\u6838\u72b6\u6001\u6709\u8bef");
            }
        }
        String remark = StrUtil.emptyToDefault((CharSequence)dto.getRemark(), (String)"EMPTY");
        OptUtil.addOptLog((String)OperationLogTypeEnum.getAuditType((boolean)isApproved), (String)remark, (String)transferOrderEo.getTransferOrderNo(), (String)CodeGenEnum.TRANSFER_ORDER.getCode());
    }

    public boolean canAutoComplete(String inWarehouseCode, String outWarehouseCode) {
        if (!InventoryConfig.isTransferInnerAutoCompulete()) {
            return false;
        }
        List warehouses = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", Arrays.asList(inWarehouseCode, outWarehouseCode))).list();
        return (double)warehouses.stream().map(LogicWarehouseEo::getPhysicsWarehouseCode).distinct().count() == 1.0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Boolean> commit(TransferOrderKeyDto keyDto) {
        int auditLevel;
        TransferOrderEo transferOrderEo = ((ITransferOrderDomain)this.domain).selectByBizKey(keyDto);
        AssertUtils.notNull((Object)transferOrderEo, (String)"\u8c03\u62e8\u5355\u53c2\u6570\u5f02\u5e38");
        ((ITransferOrderDomain)this.domain).isOrderCanCommit(transferOrderEo);
        String transferOrderNo = transferOrderEo.getTransferOrderNo();
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        DtoHelper.eo2Dto((BaseEo)transferOrderEo, (BaseVo)transferOrderReqDto);
        ArrayList<TransferOrderDetailReqDto> detailList = new ArrayList<TransferOrderDetailReqDto>();
        List detailEoList = ((ExtQueryChainWrapper)this.transferOrderDetailDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).list();
        DtoHelper.eoList2DtoList((Collection)detailEoList, detailList, TransferOrderDetailReqDto.class);
        this.checkVolume(detailList);
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(transferOrderReqDto.getTransferOrderNo());
        preemptParam.setExternalOrderNo(transferOrderReqDto.getPreOrderNo());
        preemptParam.setSourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER_PREEMPT.getCode());
        preemptParam.setBusinessType(transferOrderReqDto.getType());
        preemptParam.setValidNegative(keyDto.getValidNegative());
        preemptParam.setNoneLineNo(Boolean.valueOf(true));
        preemptParam.setReleaseDocumentNo(keyDto.getReleaseDocumentNo());
        if (transferOrderEo.getNoBatch() != null && transferOrderEo.getNoBatch() == 1) {
            preemptParam.setNoneBatch(Boolean.valueOf(true));
            preemptParam.setShoutBatch(Boolean.valueOf(false));
        }
        if (StringUtils.isNotBlank((CharSequence)transferOrderEo.getShipmentEnterpriseCode())) {
            this.logisticsMappingAction.verify(transferOrderEo.getOutLogicWarehouseCode(), transferOrderEo.getShipmentEnterpriseCode());
        }
        this.approvalStateMachineHelper.submitPrimary(preemptParam, detailList, transferOrderReqDto, transferOrderEo, detailEoList);
        if (keyDto.getAutoAudit() == null) {
            keyDto.setAutoAudit(Boolean.valueOf(true));
        }
        int n = auditLevel = keyDto.getAutoAudit() == false ? Integer.MAX_VALUE : this.automaticAuditPolicyDomain.getAuditLevel(transferOrderEo.getOrderType(), transferOrderEo.getType());
        if (keyDto.getAutoComplete().booleanValue() || auditLevel <= 1) {
            this.audit(transferOrderEo, keyDto.getAutoComplete() != false ? 0 : auditLevel, keyDto.getAutoComplete());
        }
        if (InventoryConfig.getTransferOrderPushErpAble().canPush(PushAble.CanPushBo.builder().businessType(transferOrderReqDto.getType()).logicWarehouseCode(transferOrderReqDto.getOutLogicWarehouseCode()).relevanceTableNameEnum(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER).build())) {
            InventoryConfig.getTransferOrderPushErpAble().push(new TransferOrderPushBo(transferOrderReqDto, transferOrderNo, detailList));
        }
        return new RestResponse((Object)Boolean.TRUE);
    }

    private void audit(TransferOrderEo transferOrderEo, int auditLevel, boolean autoComplete) {
        TransferOrderAuditReqDto auditReqDto = new TransferOrderAuditReqDto();
        ArrayList<String> transferOrderNos = new ArrayList<String>();
        transferOrderNos.add(transferOrderEo.getTransferOrderNo());
        auditReqDto.setTransferOrderNos(transferOrderNos);
        auditReqDto.setVirtualOrderAutoComplete(Boolean.valueOf(autoComplete));
        auditReqDto.setAuditResult("audit_pass");
        auditReqDto.setRemark("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
        this.audit(auditReqDto);
        if (InventoryConfig.isCanSecondLevel() && (auditLevel == 0 || auditLevel == 2)) {
            this.audit(auditReqDto);
        }
    }

    private void checkVolume(List<TransferOrderDetailReqDto> detailList) {
        List dtoList;
        List<String> skuCodeList = detailList.stream().map(TransferOrderDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        HashMap skuMap = new HashMap(skuCodeList.size());
        if (CollectionUtil.isNotEmpty(skuCodeList) && CollectionUtil.isNotEmpty(dtoList = this.itemDataQueryHelper.getByCodes(skuCodeList))) {
            Map skuDgRespDtoMap = dtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o, o1) -> o));
            skuMap.putAll(skuDgRespDtoMap);
        }
        detailList.forEach(detailDto -> {
            ItemSkuDto itemSkuDgRespDto;
            if (!skuMap.containsKey(detailDto.getSkuCode()) || BigDecimalUtils.eqZero((BigDecimal)(itemSkuDgRespDto = (ItemSkuDto)skuMap.get(detailDto.getSkuCode())).getVolume()).booleanValue()) {
                // empty if block
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Boolean> withdraw(TransferOrderKeyDto keyDto) {
        TransferOrderEo transferOrderEo = ((ITransferOrderDomain)this.domain).selectByBizKey(keyDto);
        AssertUtils.notNull((Object)transferOrderEo, (String)"\u8c03\u62e8\u5355\u53c2\u6570\u5f02\u5e38");
        ((ITransferOrderDomain)this.domain).isOrderCancelable(transferOrderEo);
        String approvalStatus = transferOrderEo.getApprovalStatus();
        String shipmentStatus = transferOrderEo.getShipmentStatus();
        if (TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY.getCode().equals(approvalStatus)) {
            this.approvalStateMachineHelper.sendEvent(TransferOrderApprovalEvent.WAITING_SECONDARY_WITHDRAW, transferOrderEo.getTransferOrderNo());
        } else if (TransferOrderStatus.WAITING_FOR_DELIVERY.code().equals(shipmentStatus)) {
            this.deliveryStateMachineHelper.waitingForShipmentWithdraw(transferOrderEo.getTransferOrderNo());
        } else if (TransferOrderStatus.WAIT_THIRD_TWO_AUDIT.code().equals(approvalStatus)) {
            this.approvalStateMachineHelper.sendEvent(TransferOrderApprovalEvent.WAITING_SECONDARY_WITHDRAW, transferOrderEo.getTransferOrderNo());
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.WITHDRAW.name(), (String)"EMPTY", (String)transferOrderEo.getTransferOrderNo(), (String)CodeGenEnum.TRANSFER_ORDER.getCode());
        return new RestResponse((Object)Boolean.TRUE);
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> batchWithdraw(List<TransferOrderKeyDto> keyDtoList) {
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        keyDtoList.forEach(dto -> {
            BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
            try {
                this.withdraw((TransferOrderKeyDto)dto);
                resMsg.setMsg(dto.getTransferOrderNo());
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                resMsg.setMsg(String.format("%s\u64a4\u56de\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", dto.getTransferOrderNo(), e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(keyDtoList.size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return new RestResponse((Object)msgDto);
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.CANCELED, orderCodeSpel="#keyDto.transferOrderNo", value="TRANSFER_ORDER")
    public RestResponse<Boolean> cancel(TransferOrderKeyDto keyDto) {
        boolean directlyCancellable;
        JSONObject jsonObject;
        TransferOrderEo transferOrderEo = ((ITransferOrderDomain)this.domain).selectByBizKey(keyDto);
        AssertUtils.notNull((Object)transferOrderEo, (String)"\u8c03\u62e8\u5355\u53c2\u6570\u5f02\u5e38");
        String extension = transferOrderEo.getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            jsonObject = JSONObject.parseObject((String)extension);
            jsonObject.put("cancelReason", (Object)keyDto.getExtension());
            extension = jsonObject.toJSONString();
        } else {
            jsonObject = new JSONObject();
            jsonObject.put("cancelReason", (Object)keyDto.getExtension());
            extension = jsonObject.toJSONString();
        }
        transferOrderEo.setExtension(extension);
        ((ITransferOrderDomain)this.domain).canOrderBeCanceled(transferOrderEo);
        boolean bl = directlyCancellable = TransferOrderStatus.PENDING.code().equals(transferOrderEo.getOrderStatus()) || TransferOrderApprovalState.PRIMARY_REJECTED.getCode().equals(transferOrderEo.getApprovalStatus()) || TransferOrderApprovalState.SECONDARY_REJECTED.getCode().equals(transferOrderEo.getApprovalStatus());
        if (directlyCancellable) {
            transferOrderEo.setOrderStatus(TransferOrderStatus.CANCELLED.code());
            ((ITransferOrderDomain)this.domain).updateSelective((BaseEo)transferOrderEo);
            return new RestResponse((Object)Boolean.TRUE);
        }
        List<String> TransferOrderApprovalStateList = Arrays.asList(TransferOrderApprovalState.PRIMARY_PENDING.getCode(), TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY.getCode(), TransferOrderApprovalState.WAIT_THIRD_AUDIT.getCode(), TransferOrderApprovalState.WAIT_THIRD_TWO_AUDIT.getCode());
        if (TransferOrderApprovalStateList.contains(transferOrderEo.getApprovalStatus())) {
            this.approvalStateMachineHelper.sendEvent(TransferOrderApprovalEvent.CANCEL, transferOrderEo.getTransferOrderNo());
            return new RestResponse((Object)Boolean.TRUE);
        }
        if (TransferOrderDeliveryState.WAITING_FOR_DELIVERY.getCode().equals(transferOrderEo.getShipmentStatus())) {
            this.deliveryStateMachineHelper.sendEvent(TransferOrderDeliveryEvent.CANCEL, transferOrderEo.getTransferOrderNo());
        }
        return new RestResponse((Object)Boolean.TRUE);
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> batchCancel(List<TransferOrderKeyDto> keyDtoList) {
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        keyDtoList.forEach(dto -> {
            BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
            try {
                this.cancel((TransferOrderKeyDto)dto);
                resMsg.setMsg(dto.getTransferOrderNo());
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                resMsg.setMsg(String.format("%s\u64a4\u56de\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", dto.getTransferOrderNo(), e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(keyDtoList.size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return new RestResponse((Object)msgDto);
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.CLOSE, orderCodeSpel="#keyDto.transferOrderNo", value="TRANSFER_ORDER")
    public RestResponse<Boolean> close(TransferOrderKeyDto keyDto) {
        TransferOrderEo transferOrderEo = ((ITransferOrderDomain)this.domain).selectByBizKey(keyDto);
        AssertUtils.notNull((Object)transferOrderEo, (String)"\u8c03\u62e8\u5355\u53c2\u6570\u5f02\u5e38");
        ((ITransferOrderDomain)this.domain).canOrderBeClosed(transferOrderEo);
        this.deliveryStateMachineHelper.sendEvent(TransferOrderDeliveryEvent.CLOSE, transferOrderEo.getTransferOrderNo());
        return new RestResponse((Object)Boolean.TRUE);
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> batchClose(List<TransferOrderKeyDto> dtoList) {
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        dtoList.forEach(dto -> {
            BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
            try {
                this.close((TransferOrderKeyDto)dto);
                resMsg.setMsg(dto.getTransferOrderNo());
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                resMsg.setMsg(String.format("%s\u64a4\u56de\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", dto, e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(dtoList.size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return new RestResponse((Object)msgDto);
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.COMPLETED, orderCodeSpel="#keyDto.transferOrderNo", value="TRANSFER_ORDER")
    public RestResponse<Boolean> complete(TransferOrderKeyDto keyDto) {
        TransferOrderEo transferOrderEo = ((ITransferOrderDomain)this.domain).selectByBizKey(keyDto);
        AssertUtils.notNull((Object)transferOrderEo, (String)"\u8c03\u62e8\u5355\u53c2\u6570\u5f02\u5e38");
        ((ITransferOrderDomain)this.domain).canOrderBeCompleted(transferOrderEo);
        this.transferOrderReceiveHelper.sendEvent(TransferOrderReceiveEvent.COMPLETE, transferOrderEo);
        return new RestResponse((Object)Boolean.TRUE);
    }

    @Override
    public RestResponse<Void> modifyExternalOrderNo(TransferOrderReqDto transferOrderReqDto) {
        AssertUtils.notEmpty((String)transferOrderReqDto.getTransferOrderNo(), (String)"\u8c03\u62e8\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ITransferOrderDomain)this.domain).filter().eq((Object)"transfer_order_no", (Object)transferOrderReqDto.getTransferOrderNo())).last("limit 1")).one();
        if (StringUtils.isNotBlank((CharSequence)transferOrderReqDto.getExternalSaleOrderNo())) {
            transferOrderEo.setExternalSaleOrderNo(transferOrderReqDto.getExternalSaleOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)transferOrderReqDto.getExternalPurchaseOrderNo())) {
            transferOrderEo.setExternalPurchaseOrderNo(transferOrderReqDto.getExternalPurchaseOrderNo());
        }
        ((ITransferOrderDomain)this.domain).update((BaseEo)transferOrderEo);
        return RestResponse.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void processBorrowGoods(TransferGoodsOrderDto transferGoodsOrderDto) {
        int i;
        String transferNo = transferGoodsOrderDto.getPreOrderNo();
        String key = "processBorrowGoods-" + transferNo;
        if (!this.cacheService.setIfAbsent(key, "1", i = 60).booleanValue()) {
            throw new BizException("\u5f53\u524d\u5355\u636e\u5df2\u5728\u53d8\u66f4\u5904\u7406\u4e2d");
        }
        try {
            TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ITransferOrderDomain)this.domain).filter().eq((Object)"transfer_order_no", (Object)transferNo)).last("limit 1")).one();
            if (Objects.isNull(transferOrderEo)) {
                log.info("\u4f9b\u8d27\u56de\u4f20\u8c03\u62e8\u5355{}\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406\uff01", (Object)transferNo);
                return;
            }
            AssertUtils.isTrue((boolean)StringUtils.containsAny((CharSequence)transferOrderEo.getOrderStatus(), (CharSequence[])new CharSequence[]{TransferOrderStatus.WAITING_APPROVAL.code(), TransferOrderStatus.TRANSFER_HANG_UP.code()}), (String)("\u5355\u636e" + transferOrderEo.getTransferOrderNo() + "\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6838\u3001\u6302\u8d77\u72b6\u6001"));
            if (TransferGoodsStatusEnum.LEND_LESS.name().equals(transferGoodsOrderDto.getOrderStatus())) {
                this.approvalStateMachineHelper.sendEvent(TransferOrderApprovalEvent.HANG_UP, transferOrderEo.getTransferOrderNo());
                return;
            }
            this.approvalStateMachineHelper.sendUnHangUpEvent(TransferOrderApprovalEvent.UN_HANG_UP, transferOrderEo.getTransferOrderNo(), transferGoodsOrderDto);
            InventoryConfig.registerSynchronizationAfterCommit(() -> {
                boolean isUnLend = TransferGoodsStatusEnum.UN_LEND_LESS.name().equals(transferGoodsOrderDto.getOrderStatus());
                int auditLevel = this.automaticAuditPolicyDomain.getAuditLevel(transferGoodsOrderDto.getPreOrderNo(), transferOrderEo.getType());
                if (auditLevel < 1 && !isUnLend) {
                    InventoryConfig.executorNewTransaction(s -> {
                        this.audit(transferOrderEo, auditLevel, false);
                        return s;
                    });
                }
            });
        }
        finally {
            this.cacheService.delCache(key);
        }
    }

    @Override
    public RestResponse<String> generateTransferOrderNo() {
        return new RestResponse((Object)this.generateCodeUtil.generateCode(CodeGenEnum.TRANSFER_ORDER));
    }
}

