/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.dao.mapper.StateMachineMapper;
import com.yunxi.dg.base.center.inventory.eo.StateMachineEo;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalEvent;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import javax.annotation.Resource;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.stereotype.Component;

@Component
public class ApprovalStateMachinePersist
implements StateMachinePersist<TransferOrderApprovalState, TransferOrderApprovalEvent, String> {
    @Resource
    private StateMachineMapper stateMachineMapper;

    private String convertToJson(StateMachineContext<TransferOrderApprovalState, TransferOrderApprovalEvent> ctx) {
        return JSON.toJSONString(ctx);
    }

    public void write(StateMachineContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context, String transferOrderNo) throws Exception {
        StateMachineEo db = this.stateMachineMapper.selectByTypeAndMachineKey("APPROVAL", transferOrderNo);
        if (db == null) {
            StateMachineEo entity = new StateMachineEo();
            entity.setMachineKey(transferOrderNo);
            entity.setStatus(((TransferOrderApprovalState)context.getState()).getCode());
            entity.setType("APPROVAL");
            this.stateMachineMapper.insert((Object)entity);
        } else {
            StateMachineEo entity = new StateMachineEo();
            entity.setId(db.getId());
            entity.setMachineKey(transferOrderNo);
            entity.setStatus(((TransferOrderApprovalState)context.getState()).getCode());
            entity.setType("APPROVAL");
            this.stateMachineMapper.updateById((BaseEo)entity);
        }
    }

    public StateMachineContext<TransferOrderApprovalState, TransferOrderApprovalEvent> read(String transferOrderNo) {
        StateMachineEo entity = this.stateMachineMapper.selectByTypeAndMachineKey("APPROVAL", transferOrderNo);
        if (entity != null) {
            TransferOrderApprovalState approvalState = TransferOrderApprovalState.getByCode((String)entity.getStatus());
            return new DefaultStateMachineContext((Object)approvalState, null, null, null, null, entity.getMachineKey());
        }
        return new DefaultStateMachineContext((Object)TransferOrderApprovalState.PENDING_SUBMISSION, null, null, null, null, transferOrderNo);
    }
}

