/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.data.DataDictDto;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.constants.InventoryRecordUsageTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryDueInDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryLogDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryOperateLogDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.ReleaseBaseDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryDueInEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryOperateLogEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.FindDetailInventoyBo;
import com.yunxi.dg.base.center.inventory.service.calc.FindInventoryBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcAble;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcExecuteManager;
import com.yunxi.dg.base.center.inventory.service.calc.LogSaveBo;
import com.yunxi.dg.base.center.inventory.service.helper.data.DictDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.helper.data.LogicWarehouseDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BaseAble {
    private static final Logger log = LoggerFactory.getLogger(BaseAble.class);
    public static final String HIDDEN_BATCH = "99999999-hidden";
    @Value(value="${mq.inventory.topic.change:SINGLE_TOPIC}")
    protected String mqInventoryChangeTopic;
    @Value(value="${mq.inventory.tag.change:INVENTORY_CHANGE_TAG}")
    protected String mqInventoryChangeTag;
    @Value(value="${mq.inventory.change.push.mode:multiple}")
    protected String mqInventoryChangePushMode;
    @Value(value="${inventory.update.mode:delegation}")
    protected String inventoryUpdateMode;
    @Value(value="${yunxi.dg.base.project}")
    protected String projectCode;
    @Autowired
    ICacheService cacheService;
    @Autowired
    protected ICommonsMqService commonsMqService;
    @Autowired
    protected IContext context;
    @Autowired
    protected TransactionCallBackService transactionCallBackService;
    @Autowired
    protected ItemDataQueryHelperImpl itemDataQueryHelper;
    @Autowired
    protected IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    protected ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    protected ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    protected ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Autowired
    protected IInventoryOperateLogDomain inventoryOperateLogDomain;
    @Autowired
    protected IInventoryLogDomain inventoryLogDomain;
    @Autowired
    protected ICalcAble calcAble;
    @Autowired
    protected DictDataQueryHelperImpl dictDataQueryHelper;
    @Autowired
    protected ICalcExecuteManager calcExecuteManager;
    @Resource
    protected LogicWarehouseDataQueryHelperImpl logicWarehouseDataQueryHelper;
    @Resource
    protected IInventoryDueInDomain inventoryDueInDomain;

    protected void check(CalcDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getSourceNo(), (String)"\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getSourceType(), (String)"\u539f\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        dto.setNoneBatch((Boolean)ObjectUtil.defaultIfNull((Object)dto.getNoneBatch(), (Object)false));
        dto.setValidNegative((Boolean)ObjectUtil.defaultIfNull((Object)dto.getValidNegative(), (Object)true));
        dto.setNoneLineNo((Boolean)ObjectUtil.defaultIfNull((Object)dto.getNoneLineNo(), (Object)false));
        dto.setShoutBatch((Boolean)ObjectUtil.defaultIfNull((Object)dto.getShoutBatch(), (Object)true));
    }

    protected void checkDetails(CalcDto dto) {
        List details = dto.getDetails();
        AssertUtils.notEmpty((Collection)details, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        boolean projectNoneBatch = InventoryConfig.isNoneBatch();
        for (CalcDetailDto d : details) {
            if (StringUtils.isBlank((CharSequence)d.getBatch())) {
                if (projectNoneBatch) {
                    log.info("\u8bbe\u7f6e\u9ed8\u8ba4\u6279\u6b21\uff1a{},{}", (Object)InventoryConfig.getDefaultBatch(), (Object)dto.getSourceNo());
                    d.setBatch(InventoryConfig.getDefaultBatch());
                }
                if (InventoryConfig.isPreemptHiddenBatch()) {
                    if (dto instanceof FormInDto | dto instanceof TransferInDto) {
                        d.setBatch(InventoryConfig.getDefaultBatch());
                    } else {
                        d.setBatch(HIDDEN_BATCH);
                        dto.setNoneBatch(Boolean.valueOf(false));
                    }
                }
            }
            AssertUtils.notBlank((String)d.getSkuCode(), (String)"\u660e\u7ec6\u5546\u54c1\u7f16\u7801\u5b58\u5728\u7a7a\u503c");
            AssertUtils.notBlank((String)d.getLogicWarehouseCode(), (String)"\u660e\u7ec6\u903b\u8f91\u4ed3\u7f16\u7801\u5b58\u5728\u7a7a\u503c");
            if (!dto.getNoneBatch().booleanValue()) {
                AssertUtils.notBlank((String)d.getBatch(), (String)"\u6279\u6b21\u53f7\u5b58\u5728\u7a7a\u503c");
            }
            if (!dto.getNoneLineNo().booleanValue()) {
                AssertUtils.notNull((Object)d.getLineNo(), (String)"\u884c\u53f7\u5b58\u5728\u7a7a\u503c");
            }
            AssertUtils.notNull((Object)d.getNum(), (String)"\u5e93\u5b58\u53d8\u5316\u91cf\u4e3a\u7a7a");
            if (!BigDecimalUtils.eqZero((BigDecimal)d.getNum()).booleanValue()) continue;
            throw new BizException(String.format("warehouseCode: %s, cargoCode: %s, \u4ed3\u5e93\u53d8\u5316\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u4e3a0", d.getLogicWarehouseCode(), d.getSkuCode()));
        }
    }

    protected void checkDetails(List<CalcDetailDto> details) {
        AssertUtils.notEmpty(details, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        boolean projectNoneBatch = InventoryConfig.isNoneBatch();
        for (CalcDetailDto d : details) {
            if (StringUtils.isBlank((CharSequence)d.getBatch())) {
                if (projectNoneBatch) {
                    d.setBatch(InventoryConfig.getDefaultBatch());
                }
                if (InventoryConfig.isPreemptHiddenBatch()) {
                    d.setBatch(HIDDEN_BATCH);
                }
            }
            AssertUtils.notBlank((String)d.getSkuCode(), (String)"\u660e\u7ec6\u5546\u54c1\u7f16\u7801\u5b58\u5728\u7a7a\u503c");
            AssertUtils.notBlank((String)d.getLogicWarehouseCode(), (String)"\u660e\u7ec6\u903b\u8f91\u4ed3\u7f16\u7801\u5b58\u5728\u7a7a\u503c");
            if (!BigDecimalUtils.eqZero((BigDecimal)d.getNum()).booleanValue()) continue;
            throw new BizException(String.format("warehouseCode: %s, cargoCode: %s, \u4ed3\u5e93\u53d8\u5316\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u4e3a0", d.getLogicWarehouseCode(), d.getSkuCode()));
        }
    }

    protected List<LogicWarehouseEo> queryEnableLogicWarehouseByCodes(List<String> logicWarehouseCodes) {
        ArrayList warehouseCodes = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)warehouseCodes, logicWarehouseCodes, String.class);
        return this.logicWarehouseDataQueryHelper.getByCodes(warehouseCodes);
    }

    protected List<ItemSkuDto> queryItemSkuListByCodes(List<String> skuCodes) {
        if (CollectionUtil.isEmpty(skuCodes)) {
            return Lists.newArrayList();
        }
        return this.itemDataQueryHelper.getByCodes(skuCodes);
    }

    protected List<LogicInventoryEo> queryLogicInventoryEos(FindDetailInventoyBo findDetailInventoyBo) {
        List skuCodes = findDetailInventoyBo.getItemSkuDtoList().stream().map(ItemSkuDto::getSkuCode).distinct().collect(Collectors.toList());
        List logicWarehouseCodes = findDetailInventoyBo.getLogicWarehouseEos().stream().map(LogicWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List logicInventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).in(CollectionUtils.isNotEmpty(findDetailInventoyBo.getBatches()), (Object)"batch", findDetailInventoyBo.getBatches())).in(CollectionUtils.isNotEmpty(findDetailInventoyBo.getInventoryPropertyList()), (Object)"inventory_property", findDetailInventoyBo.getInventoryPropertyList())).list();
        findDetailInventoyBo.getBatches().removeIf(StringUtils::isEmpty);
        if (CollectionUtil.isEmpty(findDetailInventoyBo.getItemSkuDtoList()) || CollectionUtil.isEmpty(findDetailInventoyBo.getBatches())) {
            return logicInventoryEos;
        }
        ArrayList insertLogicInventoryEos = Lists.newArrayList();
        Map inventoryEoMap = logicInventoryEos.stream().collect(Collectors.toMap(o -> this.getKey(o.getWarehouseCode(), o.getSkuCode(), o.getBatch(), o.getInventoryProperty()), Function.identity(), (o, o1) -> o));
        Map logicWarehouseEoMap = findDetailInventoyBo.getLogicWarehouseEos().stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (o, o1) -> o));
        Map skuDtoMap = findDetailInventoyBo.getItemSkuDtoList().stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o, o1) -> o));
        for (String hasKey : findDetailInventoyBo.getHasKeys()) {
            if (inventoryEoMap.containsKey(hasKey)) continue;
            String[] strings = hasKey.split(InventoryConfig.getCommonSeparate());
            LogicInventoryEo insertLogicInventoryEo = this.initLogicInventory((LogicWarehouseEo)logicWarehouseEoMap.get(strings[0]), (ItemSkuDto)skuDtoMap.get(strings[1]), strings[2], strings[3]);
            insertLogicInventoryEos.add(insertLogicInventoryEo);
        }
        List logicInventoryEoList = this.logicInventoryDomain.batchIgnoreInsertNew((List)insertLogicInventoryEos);
        if (ObjectUtil.equals((Object)logicInventoryEoList.size(), (Object)insertLogicInventoryEos.size())) {
            logicInventoryEos.addAll(insertLogicInventoryEos);
        } else {
            logicInventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).in((Object)"batch", findDetailInventoyBo.getBatches())).in((Object)"inventory_property", findDetailInventoyBo.getInventoryPropertyList())).list();
            for (int retryCount = 5; findDetailInventoyBo.getHasKeys().size() > logicInventoryEos.size() && retryCount > 0; --retryCount) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    throw new BizException(e.getMessage());
                }
                logicInventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).in((Object)"batch", findDetailInventoyBo.getBatches())).in((Object)"inventory_property", findDetailInventoyBo.getInventoryPropertyList())).list();
            }
        }
        return logicInventoryEos;
    }

    protected List<LogicInventoryTotalEo> queryLogicInventoryTotalEos(FindInventoryBo findInventoryBo) {
        List skuCodes = findInventoryBo.getItemSkuDtoList().stream().map(ItemSkuDto::getSkuCode).distinct().collect(Collectors.toList());
        List logicWarehouseCodes = findInventoryBo.getLogicWarehouseEos().stream().map(LogicWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List logicInventoryTotalEos = this.logicInventoryTotalDomain.queryByWarehouseCodesAndSkuCodes(logicWarehouseCodes, skuCodes, findInventoryBo.getInventoryPropertyList());
        if (CollectionUtil.isEmpty(findInventoryBo.getItemSkuDtoList())) {
            log.info(Thread.currentThread().getName() + "\u903b\u8f91\u5e93\u5b58:{}", (Object)JSONObject.toJSONString((Object)logicInventoryTotalEos));
            return logicInventoryTotalEos;
        }
        ArrayList insertLogicInventoryTotalEos = Lists.newArrayList();
        for (LogicWarehouseEo logicWarehouseEo : findInventoryBo.getLogicWarehouseEos()) {
            for (ItemSkuDto itemSkuDto : findInventoryBo.getItemSkuDtoList()) {
                for (String inventory : findInventoryBo.getInventoryPropertyList()) {
                    LogicInventoryTotalEo logicInventoryTotalEo = logicInventoryTotalEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)logicWarehouseEo.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)itemSkuDto.getSkuCode()) && StringUtils.equals((CharSequence)o.getInventoryProperty(), (CharSequence)inventory)).findFirst().orElse(null);
                    if (null != logicInventoryTotalEo) continue;
                    LogicInventoryTotalEo insertLogicInventoryTotalEo = this.initLogicInventoryTotal(logicWarehouseEo, itemSkuDto, inventory);
                    insertLogicInventoryTotalEos.add(insertLogicInventoryTotalEo);
                }
            }
        }
        int planCount = insertLogicInventoryTotalEos.size() + logicInventoryTotalEos.size();
        List doInsertLogicInventoryTotalEos = this.logicInventoryTotalDomain.batchIgnoreInsertNew((List)insertLogicInventoryTotalEos);
        if (doInsertLogicInventoryTotalEos.size() >= insertLogicInventoryTotalEos.size()) {
            logicInventoryTotalEos.addAll(insertLogicInventoryTotalEos);
        } else {
            logicInventoryTotalEos = this.logicInventoryTotalDomain.queryByWarehouseCodesAndSkuCodes(logicWarehouseCodes, skuCodes, findInventoryBo.getInventoryPropertyList());
            log.info("\u8fdb\u5165\u521d\u59cb\u5316\u4fdd\u5b58\u67e5\u8be21:{}", (Object)JSONObject.toJSONString((Object)logicInventoryTotalEos));
            for (int retryCount = 5; planCount > logicInventoryTotalEos.size() && retryCount > 0; --retryCount) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    throw new BizException(e.getMessage());
                }
                logicInventoryTotalEos = this.logicInventoryTotalDomain.queryByWarehouseCodesAndSkuCodes(logicWarehouseCodes, skuCodes, findInventoryBo.getInventoryPropertyList());
            }
        }
        return logicInventoryTotalEos;
    }

    private LogicInventoryEo initLogicInventory(LogicWarehouseEo warehouseEo, ItemSkuDto skuDto, String batch, String property) {
        String nil = "null";
        if (StringUtils.isBlank((CharSequence)batch) || StringUtils.equals((CharSequence)batch, (CharSequence)nil)) {
            throw new BizException("\u63d2\u5165\u5e93\u5b58\u660e\u7ec6\u6570\u636e\uff0c\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String currentUserName = StrUtil.isBlank((CharSequence)this.context.userName()) ? "system" : this.context.userName();
        LogicInventoryEo logicInventoryEo = new LogicInventoryEo();
        logicInventoryEo.setId(Long.valueOf(IdWorker.getId()));
        logicInventoryEo.setWarehouseId(warehouseEo.getId());
        logicInventoryEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        logicInventoryEo.setWarehouseName(warehouseEo.getWarehouseName());
        logicInventoryEo.setSkuCode(skuDto.getSkuCode());
        logicInventoryEo.setSkuName(skuDto.getSkuName());
        logicInventoryEo.setInventoryProperty(property);
        logicInventoryEo.setBatch(batch);
        logicInventoryEo.setIntransit(BigDecimal.ZERO);
        logicInventoryEo.setBalance(BigDecimal.ZERO);
        logicInventoryEo.setAvailable(BigDecimal.ZERO);
        logicInventoryEo.setPreempt(BigDecimal.ZERO);
        logicInventoryEo.setActivityAllocate(BigDecimal.ZERO);
        logicInventoryEo.setAllocate(BigDecimal.ZERO);
        logicInventoryEo.setCompleted(BigDecimal.ZERO);
        logicInventoryEo.setFutureIn(BigDecimal.ZERO);
        logicInventoryEo.setFutureRetreat(BigDecimal.ZERO);
        logicInventoryEo.setTransfer(BigDecimal.ZERO);
        logicInventoryEo.setLockInventory(BigDecimal.ZERO);
        logicInventoryEo.setDr(YesNoHelper.NO);
        logicInventoryEo.setCreatePerson(currentUserName);
        logicInventoryEo.setUpdatePerson(currentUserName);
        return logicInventoryEo;
    }

    private LogicInventoryTotalEo initLogicInventoryTotal(LogicWarehouseEo warehouseEo, ItemSkuDto skuDto, String property) {
        String currentUserName = StrUtil.isBlank((CharSequence)this.context.userName()) ? "system" : this.context.userName();
        LogicInventoryTotalEo logicInventoryTotalEo = new LogicInventoryTotalEo();
        logicInventoryTotalEo.setId(Long.valueOf(IdWorker.getId()));
        logicInventoryTotalEo.setWarehouseId(warehouseEo.getId());
        logicInventoryTotalEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        logicInventoryTotalEo.setWarehouseName(warehouseEo.getWarehouseName());
        logicInventoryTotalEo.setSkuCode(skuDto.getSkuCode());
        logicInventoryTotalEo.setSkuName(skuDto.getSkuName());
        logicInventoryTotalEo.setInventoryProperty(property);
        logicInventoryTotalEo.setIntransit(BigDecimal.ZERO);
        logicInventoryTotalEo.setBalance(BigDecimal.ZERO);
        logicInventoryTotalEo.setAvailable(BigDecimal.ZERO);
        logicInventoryTotalEo.setPreempt(BigDecimal.ZERO);
        logicInventoryTotalEo.setActivityAllocate(BigDecimal.ZERO);
        logicInventoryTotalEo.setAllocate(BigDecimal.ZERO);
        logicInventoryTotalEo.setCompleted(BigDecimal.ZERO);
        logicInventoryTotalEo.setFutureIn(BigDecimal.ZERO);
        logicInventoryTotalEo.setFutureRetreat(BigDecimal.ZERO);
        logicInventoryTotalEo.setTransfer(BigDecimal.ZERO);
        logicInventoryTotalEo.setLockInventory(BigDecimal.ZERO);
        logicInventoryTotalEo.setDr(YesNoHelper.NO);
        logicInventoryTotalEo.setCreatePerson(currentUserName);
        logicInventoryTotalEo.setUpdatePerson(currentUserName);
        return logicInventoryTotalEo;
    }

    protected String getKey(String warehouseCode, String skuCode, String batch, String inventoryProperty) {
        return String.join((CharSequence)InventoryConfig.getCommonSeparate(), warehouseCode, skuCode, Optional.ofNullable(batch).orElse(InventoryConfig.getDefaultBatch()).toUpperCase(), Optional.ofNullable(inventoryProperty).orElse(LogicWarehouseQualityEnum.QUALIFIED.getCode()));
    }

    protected String getTotalKey(String warehouseCode, String skuCode, String property) {
        return String.join((CharSequence)InventoryConfig.getCommonSeparate(), warehouseCode, skuCode, property);
    }

    protected String getTotalKey(String warehouseCode, String skuCode, String property, String sourceNo) {
        return String.join((CharSequence)InventoryConfig.getCommonSeparate(), warehouseCode, skuCode, property, sourceNo);
    }

    protected void doCalc(CalcInventoryDto logicCalcDto, CalcInventoryDto logicTotalCalcDto, List<LogicWarehouseEo> logicWarehouseEos, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        boolean noneBatch = InventoryConfig.isNoneBatch();
        if (!noneBatch) {
            this.calcAble.calcLogic(logicCalcDto, logicWarehouseEos, logicInventoryEos);
        }
        this.calcAble.calcLogicTotal(logicTotalCalcDto, logicWarehouseEos, logicInventoryTotalEos);
        ArrayList operateLogEos = Lists.newArrayList();
        ArrayList logEos = Lists.newArrayList();
        if (!noneBatch) {
            this.calcAble.createLogicLogs(logicCalcDto, logicWarehouseEos, logicInventoryEos, operateLogEos, logEos);
        }
        this.calcAble.createLogicTotalLogs(logicTotalCalcDto, logicWarehouseEos, logicInventoryTotalEos, operateLogEos, logEos);
        this.saveLog(new LogSaveBo(operateLogEos, logEos));
    }

    private void setOperateLogDocument(List<InventoryOperateLogEo> operateLogEos) {
        List dictDtoList;
        if (CollUtil.isEmpty(operateLogEos)) {
            return;
        }
        Set businessTypeSet = operateLogEos.stream().map(InventoryOperateLogEo::getBusinessType).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        if (CollUtil.isEmpty(businessTypeSet)) {
            return;
        }
        try {
            dictDtoList = this.dictDataQueryHelper.getByCodes(Lists.newArrayList(businessTypeSet));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u914d\u7f6e\u5f02\u5e38:{}", (Object)e.getMessage());
            return;
        }
        if (CollUtil.isEmpty(dictDtoList)) {
            return;
        }
        Map dictDtoMap = dictDtoList.stream().collect(Collectors.toMap(DataDictDto::getSubValue, Function.identity(), (o, o1) -> o));
        for (InventoryOperateLogEo operateLogEo : operateLogEos) {
            String businessType;
            String documentCode = operateLogEo.getDocumentCode();
            if (StrUtil.isNotBlank((CharSequence)documentCode) || StrUtil.isBlank((CharSequence)(businessType = operateLogEo.getBusinessType()))) continue;
            Optional.ofNullable(dictDtoMap.get(businessType)).ifPresent(dictDto -> {
                operateLogEo.setDocumentCode(dictDto.getGroupCode());
                operateLogEo.setDocumentName(dictDto.getDef1());
            });
        }
    }

    protected LogSaveBo doBatchCalc(List<CalcInventoryDto> logicCalcDtoList, List<CalcInventoryDto> logicTotalCalcDtoList, List<LogicWarehouseEo> logicWarehouseEos, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        this.calcAble.calcBatchLogic(logicCalcDtoList, logicWarehouseEos, logicInventoryEos);
        this.calcAble.calcBatchLogicTotal(logicTotalCalcDtoList, logicWarehouseEos, logicInventoryTotalEos);
        ArrayList operateLogEos = Lists.newArrayList();
        ArrayList logEos = Lists.newArrayList();
        for (CalcInventoryDto calcInventoryDto : logicCalcDtoList) {
            this.calcAble.createLogicLogs(calcInventoryDto, logicWarehouseEos, logicInventoryEos, operateLogEos, logEos);
        }
        for (CalcInventoryDto calcInventoryDto : logicTotalCalcDtoList) {
            this.calcAble.createLogicTotalLogs(calcInventoryDto, logicWarehouseEos, logicInventoryTotalEos, operateLogEos, logEos);
        }
        return new LogSaveBo(operateLogEos, logEos);
    }

    protected void saveLog(LogSaveBo logSaveBo) {
        if (CollectionUtil.isNotEmpty(logSaveBo.getOperateLogEos())) {
            InventoryConfig.registerSynchronizationAfterCommit(() -> {
                log.info("inventoryOperateLogInsertBatch \u4e1a\u52a1\u5355\u53f7\uff1a{} \u751f\u6210\u6d41\u6c34", (Object)logSaveBo.getOperateLogEos().get(0).getSourceNo());
                this.setOperateLogDocument(logSaveBo.getOperateLogEos());
                if (CollectionUtil.isNotEmpty(logSaveBo.getOperateLogEos())) {
                    logSaveBo.getLogEos().forEach(r -> r.setSourceType(r.getBusinessType()));
                    this.calcAble.sendInventoryLogs(logSaveBo.getLogEos());
                }
                log.info("\u8fdb\u5165\u4fdd\u5b58,\u4e1a\u52a1\u5355\u53f7\uff1a{} \u751f\u6210\u6d41\u6c34", (Object)logSaveBo.getOperateLogEos().get(0).getSourceNo());
                List<InventoryOperateLogEo> inventoryOperateLogEos = logSaveBo.getOperateLogEos();
                if (CollectionUtil.isNotEmpty(inventoryOperateLogEos)) {
                    this.inventoryOperateLogDomain.insertBatch(inventoryOperateLogEos.stream().peek(r -> {
                        if (r.getSourceNo().contains(",")) {
                            r.setSourceNo(r.getSourceNo().split(",")[0]);
                        }
                    }).collect(Collectors.toList()));
                }
            }, 2);
        }
    }

    public List<InventoryOperateLogEo> mergeLog(List<InventoryOperateLogEo> operateLogEos) {
        log.info("\u5f85\u5408\u5e76\u6d41\u6c34:{}", (Object)JSONObject.toJSONString(operateLogEos));
        Map<String, BigDecimal> inventoryMap = operateLogEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getBatch())).collect(Collectors.toMap(BaseAble::getInventoryKey, InventoryOperateLogEo::getBeforeInventory, (o, o1) -> o));
        return operateLogEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getBatch())).collect(Collectors.toMap(r -> String.join((CharSequence)InventoryConfig.getCommonSeparate(), r.getSourceNo(), r.getWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty(), r.getChangeType()), Function.identity(), (o, o1) -> {
            String inventoryKey = BaseAble.getInventoryKey(o);
            BigDecimal before = (BigDecimal)inventoryMap.get(inventoryKey);
            o.setChangeInventory(BigDecimalUtils.add((BigDecimal)o.getChangeInventory(), (BigDecimal)o1.getChangeInventory()));
            BigDecimal after = BigDecimalUtils.add((BigDecimal)before, (BigDecimal)o1.getChangeInventory());
            o.setAfterInventory(after);
            inventoryMap.put(inventoryKey, after);
            return o;
        })).values().stream().filter(r -> BigDecimalUtils.eqZero((BigDecimal)r.getChangeInventory()) == false).collect(Collectors.toList());
    }

    @NotNull
    private static String getInventoryKey(InventoryOperateLogEo r) {
        return String.join((CharSequence)InventoryConfig.getCommonSeparate(), r.getWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty(), r.getChangeType());
    }

    protected CalcInventoryDto createCalcLogicTotalDtoByLogicDto(CalcInventoryDto logicCalcDto) {
        log.info("createCalcLogicTotalDtoByLogicDto-\u300b{}", (Object)JSONObject.toJSONString((Object)logicCalcDto));
        CalcInventoryDto logicTotalCalcDto = new CalcInventoryDto();
        BeanUtils.copyProperties((Object)logicCalcDto, (Object)logicTotalCalcDto, (String[])new String[]{"details"});
        HashMap map = Maps.newHashMap();
        for (CalcInventoryDetailDto logicDetail : logicCalcDto.getDetails()) {
            String totalKey = this.getTotalKey(logicDetail.getWarehouseCode(), logicDetail.getSkuCode(), logicDetail.getInventoryProperty(), logicDetail.getSourceNo());
            CalcInventoryDetailDto logicTotalDetail = map.getOrDefault(totalKey, new CalcInventoryDetailDto());
            logicTotalDetail.setSourceNo(logicDetail.getSourceNo());
            logicTotalDetail.setSourceType(logicDetail.getSourceType());
            logicTotalDetail.setBusinessType(logicDetail.getBusinessType());
            logicTotalDetail.setOperate(logicDetail.getOperate());
            logicTotalDetail.setChangeBalance(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeBalance(), (BigDecimal)logicDetail.getChangeBalance()));
            logicTotalDetail.setChangeAvailable(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeAvailable(), (BigDecimal)logicDetail.getChangeAvailable()));
            logicTotalDetail.setChangePreempt(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangePreempt(), (BigDecimal)logicDetail.getChangePreempt()));
            logicTotalDetail.setChangeAllocate(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeAllocate(), (BigDecimal)logicDetail.getChangeAllocate()));
            logicTotalDetail.setChangeIntransit(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeIntransit(), (BigDecimal)logicDetail.getChangeIntransit()));
            logicTotalDetail.setChangeFutureIn(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeFutureIn(), (BigDecimal)logicDetail.getChangeFutureIn()));
            logicTotalDetail.setChangeLockInventory(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeLockInventory(), (BigDecimal)logicDetail.getChangeLockInventory()));
            logicTotalDetail.setWarehouseCode(logicDetail.getWarehouseCode());
            logicTotalDetail.setSkuCode(logicDetail.getSkuCode());
            logicTotalDetail.setValidNegative(Boolean.valueOf(logicCalcDto.getValidNegative() != false || logicDetail.getValidNegative() != false));
            logicTotalDetail.setLendInventory(BigDecimalUtils.add((BigDecimal)logicDetail.getLendInventory(), (BigDecimal)logicTotalDetail.getLendInventory()));
            logicTotalDetail.setInventoryProperty(logicDetail.getInventoryProperty());
            logicTotalDetail.setPreemptId(logicDetail.getPreemptId());
            logicTotalDetail.setBeforePreemptNum(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getBeforePreemptNum(), (BigDecimal)logicDetail.getBeforePreemptNum()));
            logicTotalDetail.setAfterPreemptNum(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getAfterPreemptNum(), (BigDecimal)logicDetail.getAfterPreemptNum()));
            map.put(totalKey, logicTotalDetail);
        }
        log.info("createCalcLogicTotalDtoByLogicDto\u65e0\u6279\u6b21\uff1a{}", (Object)JSONObject.toJSONString((Object)map));
        logicTotalCalcDto.setDetails((List)Lists.newArrayList(map.values()));
        return logicTotalCalcDto;
    }

    protected List<CalcDetailDto> updatePreempt(List<CalcDetailDto> details, List<InventoryUsageRecordEo> inventoryUsageRecordEos) {
        if (CollectionUtil.isEmpty(inventoryUsageRecordEos)) {
            return Lists.newArrayList();
        }
        Map calcDetailDtoMap = BeanUtil.copyToList(details, CalcDetailDto.class).stream().filter(r -> r.getLineNo() != null).collect(Collectors.toMap(CalcDetailDto::getLineNo, Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        }));
        ArrayList updatePreemptionEoList = Lists.newArrayList();
        ArrayList releaseDetails = Lists.newArrayList();
        for (InventoryUsageRecordEo preemptionEo : inventoryUsageRecordEos) {
            CalcDetailDto detailDto = (CalcDetailDto)calcDetailDtoMap.get(preemptionEo.getLineNo());
            if (null == detailDto) continue;
            BigDecimal avaliableReleaseNum = BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum());
            if (BigDecimalUtils.leZero((BigDecimal)avaliableReleaseNum).booleanValue()) {
                throw new BizException("\u5df2\u8d85\u9884\u5360\u91ca\u653e, \u5df2\u65e0\u53ef\u91ca\u653e\u5e93\u5b58");
            }
            preemptionEo.setReleaseNum(BigDecimalUtils.add((BigDecimal)preemptionEo.getReleaseNum(), (BigDecimal)detailDto.getNum()));
            if (BigDecimalUtils.equals((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()).booleanValue()) {
                preemptionEo.setValid(ValidFlagEnum.DISABLE.getCode());
            }
            CalcDetailDto releaseDetail = (CalcDetailDto)BeanUtil.copyProperties((Object)detailDto, CalcDetailDto.class, (String[])new String[0]);
            BaseAble.settingBatch(preemptionEo, releaseDetail);
            releaseDetail.setInventoryProperty(preemptionEo.getInventoryProperty());
            releaseDetail.setBeforePreemptNum(preemptionEo.getPreemptNum());
            releaseDetail.setAfterPreemptNum(avaliableReleaseNum);
            releaseDetail.setPreemptId(preemptionEo.getId());
            if (BigDecimalUtils.lt((BigDecimal)avaliableReleaseNum, (BigDecimal)detailDto.getNum()).booleanValue()) {
                releaseDetail.setNum(avaliableReleaseNum);
            }
            releaseDetails.add(releaseDetail);
            updatePreemptionEoList.add(preemptionEo);
        }
        this.inventoryPreemptionDomain.updatePreempt((List)updatePreemptionEoList);
        return releaseDetails;
    }

    protected List<LogicWarehouseEo> getLogicWarehouseEosAndCheck(List<CalcDetailDto> details) {
        List<String> logicWarehouseCodes = details.stream().map(CalcDetailDto::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(logicWarehouseCodes);
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        return logicWarehouseEos;
    }

    protected List<ItemSkuDto> checkSku(List<CalcDetailDto> details) {
        List<String> skuCodes = details.stream().map(CalcDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(skuCodes);
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        return skuDtoList;
    }

    protected <T extends CalcDto> void shoutLogicInventoryEosByOut(T dto, List<LogicWarehouseEo> logicWarehouseEos, List<ItemSkuDto> skuDtoList, List<LogicInventoryEo> logicInventoryEos) {
        List details = dto.getDetails();
        ArrayList shoutDetails = Lists.newArrayList();
        ArrayList shoutLogicInventoryEos = Lists.newArrayList();
        List<String> propertyList = details.stream().map(CalcDetailDto::getInventoryProperty).distinct().collect(Collectors.toList());
        List<LogicInventoryEo> logicInventoryFilterEos = this.queryLogicInventoryEos(new FindDetailInventoyBo(skuDtoList, logicWarehouseEos, new ArrayList<String>(), new HashSet<String>(), propertyList));
        Map<String, BigDecimal> availableMap = logicInventoryFilterEos.stream().collect(Collectors.toMap(r -> r.getWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch() + InventoryConfig.getCommonSeparate() + r.getInventoryProperty(), LogicInventoryEo::getAvailable, (o, o1) -> o));
        for (CalcDetailDto detail : details) {
            Object logicInventoryEo2;
            BigDecimal num = detail.getNum();
            boolean isOver = false;
            for (Object logicInventoryEo2 : logicInventoryFilterEos.stream().filter(r -> Objects.equals(detail.getLogicWarehouseCode(), r.getWarehouseCode()) && Objects.equals(detail.getSkuCode(), r.getSkuCode())).collect(Collectors.toList())) {
                String key;
                BigDecimal available;
                if (HIDDEN_BATCH.equals(logicInventoryEo2.getBatch()) || BigDecimalUtils.leZero((BigDecimal)(available = availableMap.get(key = logicInventoryEo2.getWarehouseCode() + InventoryConfig.getCommonSeparate() + logicInventoryEo2.getSkuCode() + InventoryConfig.getCommonSeparate() + logicInventoryEo2.getBatch() + InventoryConfig.getCommonSeparate() + logicInventoryEo2.getInventoryProperty()))).booleanValue() || BigDecimalUtils.leZero((BigDecimal)num).booleanValue()) continue;
                CalcDetailDto shoutDetail = new CalcDetailDto();
                BeanUtils.copyProperties((Object)detail, (Object)shoutDetail);
                shoutDetail.setBatch(logicInventoryEo2.getBatch());
                BigDecimal after = BigDecimalUtils.subtract((BigDecimal)num, (BigDecimal)available);
                if (BigDecimalUtils.leZero((BigDecimal)after).booleanValue()) {
                    shoutDetail.setNum(num);
                    shoutDetails.add(shoutDetail);
                    shoutLogicInventoryEos.add(logicInventoryEo2);
                    isOver = true;
                    BigDecimal finalNum = num;
                    availableMap.compute(key, (k, v) -> BigDecimalUtils.subtract((BigDecimal)available, (BigDecimal)finalNum));
                    break;
                }
                num = after;
                shoutDetail.setNum(available);
                shoutDetails.add(shoutDetail);
                shoutLogicInventoryEos.add(logicInventoryEo2);
                availableMap.put(key, BigDecimal.ZERO);
            }
            if (isOver) continue;
            log.info("\u5f3a\u884c\u5339\u914d\u4e2d\uff0c\u5df2\u5339\u914d\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)shoutDetails));
            boolean isExist = false;
            if (CollectionUtil.isNotEmpty((Collection)shoutDetails)) {
                logicInventoryEo2 = shoutDetails.iterator();
                while (logicInventoryEo2.hasNext()) {
                    CalcDetailDto detailDto = (CalcDetailDto)logicInventoryEo2.next();
                    if (!StringUtils.equals((CharSequence)detailDto.getSkuCode(), (CharSequence)detail.getSkuCode()) || !StringUtils.equals((CharSequence)detailDto.getLogicWarehouseCode(), (CharSequence)detail.getLogicWarehouseCode())) continue;
                    detailDto.setNum(BigDecimalUtils.add((BigDecimal)detailDto.getNum(), (BigDecimal)num));
                    isExist = !detailDto.getBatch().equals(HIDDEN_BATCH);
                    break;
                }
            }
            if (isExist) continue;
            logicInventoryEo2 = (LogicInventoryEo)logicInventoryFilterEos.stream().filter(in -> !in.getBatch().equals(HIDDEN_BATCH) && detail.getLogicWarehouseCode().equals(in.getWarehouseCode())).collect(Collectors.toList()).stream().findFirst().orElseThrow(() -> new BizException("\u51fa\u5e93\u65e0\u6279\u6b21\u4e14\u65e0\u6279\u6b21"));
            CalcDetailDto shoutDetail = new CalcDetailDto();
            BeanUtils.copyProperties((Object)detail, (Object)shoutDetail);
            shoutDetail.setBatch(logicInventoryEo2.getBatch());
            shoutDetail.setNum(num);
            shoutDetails.add(shoutDetail);
            shoutLogicInventoryEos.add(logicInventoryEo2);
        }
        dto.setDetails((List)shoutDetails);
        this.checkDetails(dto);
        HashMap logicInventoryEoMap = Maps.newHashMap();
        for (LogicInventoryEo shoutLogicInventoryEo : shoutLogicInventoryEos) {
            logicInventoryEoMap.put(shoutLogicInventoryEo.getId(), shoutLogicInventoryEo);
        }
        Lists.newArrayList(logicInventoryEoMap.values());
    }

    protected static void settingBatch(CalcInventoryDetailDto target, CalcDetailDto source) {
        if (InventoryConfig.isPreemptHiddenBatch() && StringUtils.isBlank((CharSequence)source.getBatch())) {
            target.setBatch(HIDDEN_BATCH);
        }
        if (InventoryConfig.isNoneBatch() && StringUtils.isBlank((CharSequence)source.getBatch())) {
            target.setBatch(InventoryConfig.getDefaultBatch());
        } else {
            target.setBatch(source.getBatch());
        }
    }

    protected static void settingBatch(InventoryUsageRecordEo source, CalcDetailDto target) {
        if (InventoryConfig.isPreemptHiddenBatch() && StringUtils.isBlank((CharSequence)source.getBatch())) {
            target.setBatch(HIDDEN_BATCH);
        }
        if (InventoryConfig.isNoneBatch() && StringUtils.isBlank((CharSequence)source.getBatch())) {
            target.setBatch(InventoryConfig.getDefaultBatch());
        } else {
            target.setBatch(source.getBatch());
        }
    }

    protected <T extends CalcDto> CalcInventoryDto createLogicCalcDto(T dto, SourceToTarget consumer) {
        CalcInventoryDto calcInventoryDto = this.createBaseLogicCalcDto(dto);
        ArrayList details = Lists.newArrayList();
        for (CalcDetailDto pd : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setInventoryProperty(pd.getInventoryProperty());
            detailDto.setBatch(pd.getBatch());
            detailDto.setValidNegative(dto.getValidNegative());
            detailDto.setExpireTime(pd.getExpireDate());
            detailDto.setProduceTime(pd.getProduceDate());
            consumer.accept(pd, detailDto);
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    protected <T extends CalcDto> CalcInventoryDto createBaseLogicCalcDto(T dto) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setRemark(dto.getDesc());
        calcInventoryDto.setValidNegative(dto.getValidNegative());
        return calcInventoryDto;
    }

    public List<InventoryDueInEo> transferDueIn(List<CalcDetailDto> calcDetailDtos, String sourceNo) {
        return calcDetailDtos.stream().map(re -> {
            InventoryDueInEo dueInEo = (InventoryDueInEo)BeanUtil.copyProperties((Object)re, InventoryDueInEo.class, (String[])new String[0]);
            dueInEo.setRequestNum(re.getNum());
            dueInEo.setReleaseNum(BigDecimal.ZERO);
            dueInEo.setValid(ValidFlagEnum.ENABLE.getCode());
            dueInEo.setSourceNo(sourceNo);
            dueInEo.setWarehouseCode(re.getLogicWarehouseCode());
            return dueInEo;
        }).collect(Collectors.toList());
    }

    public List<InventoryDueInEo> transferDecrDueIn(List<CalcDetailDto> calcDetailDtos, String sourceNo) {
        return calcDetailDtos.stream().map(re -> {
            InventoryDueInEo dueInEo = (InventoryDueInEo)BeanUtil.copyProperties((Object)re, InventoryDueInEo.class, (String[])new String[0]);
            dueInEo.setRequestNum(re.getNum().negate());
            dueInEo.setReleaseNum(BigDecimal.ZERO);
            dueInEo.setValid(ValidFlagEnum.ENABLE.getCode());
            dueInEo.setSourceNo(sourceNo);
            dueInEo.setWarehouseCode(re.getLogicWarehouseCode());
            return dueInEo;
        }).collect(Collectors.toList());
    }

    @NotNull
    public <CALC extends CalcDto> InventoryUsageRecordEo getBaseInventoryUsageRecordEo(CALC dto, CalcDetailDto detail, ItemSkuDto skuDto, LogicWarehouseEo warehouseEo) {
        InventoryUsageRecordEo inventoryUsageRecordEo = new InventoryUsageRecordEo();
        inventoryUsageRecordEo.setWarehouseId(warehouseEo.getId());
        inventoryUsageRecordEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        inventoryUsageRecordEo.setWarehouseName(warehouseEo.getWarehouseName());
        inventoryUsageRecordEo.setWarehouseType(warehouseEo.getWarehouseType());
        inventoryUsageRecordEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        inventoryUsageRecordEo.setSkuCode(skuDto.getSkuCode());
        inventoryUsageRecordEo.setSkuName(skuDto.getSkuName());
        inventoryUsageRecordEo.setBatch(detail.getBatch());
        inventoryUsageRecordEo.setLineNo(detail.getLineNo());
        inventoryUsageRecordEo.setPreemptNum(detail.getNum());
        inventoryUsageRecordEo.setReleaseNum(BigDecimal.ZERO);
        inventoryUsageRecordEo.setUsageType(InventoryRecordUsageTypeEnum.PREEMPT.getCode());
        inventoryUsageRecordEo.setPreOrderItemId(detail.getPreOrderItemId());
        inventoryUsageRecordEo.setActivityId(null);
        inventoryUsageRecordEo.setActivityType(null);
        inventoryUsageRecordEo.setDisplay(YesNoHelper.YES);
        inventoryUsageRecordEo.setValid(ValidFlagEnum.ENABLE.getCode());
        inventoryUsageRecordEo.setExternalOrderNo(dto.getExternalOrderNo());
        if (StringUtils.isEmpty((CharSequence)detail.getSourceNo())) {
            inventoryUsageRecordEo.setSourceNo(dto.getSourceNo());
        } else {
            log.info("\u660e\u7ec6\u884c\u7684\u6765\u6e90ID\u4e0d\u4e3a\u7a7a\uff0csourceNo:{},sourceNoDto:{}", (Object)detail.getSourceNo(), (Object)dto.getSourceNo());
            inventoryUsageRecordEo.setSourceNo(detail.getSourceNo());
        }
        inventoryUsageRecordEo.setPreOrderNo(dto.getPreOrderNo());
        inventoryUsageRecordEo.setSourceType(dto.getSourceType());
        inventoryUsageRecordEo.setBusinessType(dto.getBusinessType());
        inventoryUsageRecordEo.setInventoryProperty(detail.getInventoryProperty());
        return inventoryUsageRecordEo;
    }

    protected <DTO extends CalcDto> List<LogicInventoryEo> shoutLogicInventoryEosAndSetDetails(DTO dto, List<LogicWarehouseEo> logicWarehouseEos, List<ItemSkuDto> skuDtoList, List<LogicInventoryEo> logicInventoryEos) {
        List details = dto.getDetails();
        ArrayList shoutDetails = Lists.newArrayList();
        ArrayList shoutLogicInventoryEos = Lists.newArrayList();
        BigDecimal totalNum = BigDecimal.ZERO;
        Set<String> filterKeys = details.stream().map(r -> this.getKey(r.getLogicWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty())).collect(Collectors.toSet());
        List<String> propertyList = details.stream().map(CalcDetailDto::getInventoryProperty).distinct().collect(Collectors.toList());
        Map<String, BigDecimal> availableMap = logicInventoryEos.stream().collect(Collectors.toMap(r -> r.getWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch().toUpperCase() + InventoryConfig.getCommonSeparate() + r.getInventoryProperty(), LogicInventoryEo::getAvailable, (o, o1) -> o));
        for (CalcDetailDto detail : details) {
            Object logicInventoryEo2;
            List<Object> logicInventoryFilterEos = logicInventoryEos.stream().filter(o -> Objects.equals(o.getSkuCode(), detail.getSkuCode()) && Objects.equals(o.getWarehouseCode(), detail.getLogicWarehouseCode()) && Objects.equals(o.getInventoryProperty(), detail.getInventoryProperty())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(logicInventoryFilterEos)) {
                log.info("logicInventoryFilterEos is empty ...............");
                ItemSkuDto skuDto = skuDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detail.getSkuCode())).findFirst().orElse(null);
                AssertUtils.isFalse((null == skuDto ? 1 : 0) != 0, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728: sku: %s", (String)detail.getSkuCode());
                LogicWarehouseEo logicWarehouseEo = logicWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)detail.getLogicWarehouseCode())).findFirst().orElse(null);
                AssertUtils.isFalse((null == logicWarehouseEo ? 1 : 0) != 0, (String)"\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728: warehouse code: %s", (String)detail.getSkuCode());
                filterKeys.add(this.getKey(detail.getLogicWarehouseCode(), detail.getSkuCode(), InventoryConfig.getDefaultBatch(), detail.getInventoryProperty()));
                logicInventoryFilterEos = this.queryLogicInventoryEos(new FindDetailInventoyBo(Lists.newArrayList((Object[])new ItemSkuDto[]{skuDto}), Lists.newArrayList((Object[])new LogicWarehouseEo[]{logicWarehouseEo}), Lists.newArrayList((Object[])new String[]{InventoryConfig.getDefaultBatch()}), filterKeys, propertyList));
                if (CollectionUtil.isEmpty(logicInventoryFilterEos)) {
                    throw new BizException(String.format("\u4ed3\u5e93\uff1a%s, \u8d27\u54c1: %s \u5e93\u5b58\u8bb0\u5f55\u63d2\u5165\u9ed8\u8ba4\u6279\u6b21\u540e\uff0c\u4e0d\u5b58\u5728", detail.getLogicWarehouseCode(), detail.getSkuCode()));
                }
            }
            totalNum = BigDecimalUtils.add((BigDecimal)totalNum, (BigDecimal)detail.getNum());
            BigDecimal num = detail.getNum();
            boolean isOver = false;
            for (Object logicInventoryEo2 : logicInventoryFilterEos) {
                String key = logicInventoryEo2.getWarehouseCode() + InventoryConfig.getCommonSeparate() + logicInventoryEo2.getSkuCode() + InventoryConfig.getCommonSeparate() + logicInventoryEo2.getBatch().toUpperCase() + InventoryConfig.getCommonSeparate() + logicInventoryEo2.getInventoryProperty();
                BigDecimal available = availableMap.get(key);
                if (BigDecimalUtils.leZero((BigDecimal)available).booleanValue()) continue;
                CalcDetailDto shoutDetail = new CalcDetailDto();
                BeanUtils.copyProperties((Object)detail, (Object)shoutDetail);
                shoutDetail.setBatch(logicInventoryEo2.getBatch());
                BigDecimal after = BigDecimalUtils.subtract((BigDecimal)num, (BigDecimal)available);
                if (BigDecimalUtils.leZero((BigDecimal)after).booleanValue()) {
                    shoutDetail.setNum(num);
                    shoutDetails.add(shoutDetail);
                    shoutLogicInventoryEos.add(logicInventoryEo2);
                    isOver = true;
                    BigDecimal finalNum = num;
                    availableMap.compute(key, (k, v) -> BigDecimalUtils.subtract((BigDecimal)available, (BigDecimal)finalNum));
                    break;
                }
                num = after;
                shoutDetail.setNum(available);
                shoutDetails.add(shoutDetail);
                shoutLogicInventoryEos.add(logicInventoryEo2);
                availableMap.put(key, BigDecimal.ZERO);
            }
            if (isOver) continue;
            if (dto.getValidNegative().booleanValue() && !dto.isLendEnable() && !HIDDEN_BATCH.equals(detail.getBatch())) {
                BigDecimal reduce = logicInventoryFilterEos.stream().filter(r -> BigDecimalUtils.geZero((BigDecimal)r.getAvailable()) != false && r.getWarehouseCode().equals(detail.getLogicWarehouseCode()) && r.getSkuCode().equals(detail.getSkuCode()) && (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{detail.getBatch()}) || StringUtils.equalsIgnoreCase((CharSequence)r.getBatch(), (CharSequence)detail.getBatch()))).map(LogicInventoryEo::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                throw new BizException(String.format("\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s, \u6279\u6b21: %s [\u5f53\u524d\u53ef\u7528\u5e93\u5b58: %s]", detail.getLogicWarehouseCode(), detail.getSkuCode(), detail.getBatch(), reduce));
            }
            log.info("\u5f3a\u884c\u9884\u5360\u4e2d\uff0c\u5df2\u9884\u5360\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)shoutDetails));
            boolean isExist = false;
            if (CollectionUtil.isNotEmpty((Collection)shoutDetails)) {
                logicInventoryEo2 = shoutDetails.iterator();
                while (logicInventoryEo2.hasNext()) {
                    CalcDetailDto detailDto = (CalcDetailDto)logicInventoryEo2.next();
                    if (!StringUtils.equals((CharSequence)detailDto.getSkuCode(), (CharSequence)detail.getSkuCode()) || !StringUtils.equals((CharSequence)detailDto.getLogicWarehouseCode(), (CharSequence)detail.getLogicWarehouseCode())) continue;
                    detailDto.setNum(BigDecimalUtils.add((BigDecimal)detailDto.getNum(), (BigDecimal)num));
                    isExist = true;
                    break;
                }
            }
            if (isExist) continue;
            logicInventoryEo2 = (LogicInventoryEo)logicInventoryFilterEos.get(logicInventoryFilterEos.size() - 1);
            CalcDetailDto shoutDetail = new CalcDetailDto();
            BeanUtils.copyProperties((Object)detail, (Object)shoutDetail);
            shoutDetail.setBatch(logicInventoryEo2.getBatch());
            shoutDetail.setNum(num);
            shoutDetails.add(shoutDetail);
            shoutLogicInventoryEos.add(logicInventoryEo2);
        }
        dto.setDetails((List)shoutDetails);
        this.checkDetails(dto);
        HashMap logicInventoryEoMap = Maps.newHashMap();
        for (LogicInventoryEo shoutLogicInventoryEo : shoutLogicInventoryEos) {
            logicInventoryEoMap.put(shoutLogicInventoryEo.getId(), shoutLogicInventoryEo);
        }
        return Lists.newArrayList(logicInventoryEoMap.values());
    }

    protected <DTO extends ReleaseBaseDto> void releasePreemptAndSetDetail(DTO dto, List<InventoryUsageRecordEo> inventoryUsageRecordEos) {
        if (dto.getAllRelease().booleanValue()) {
            List preemptIds = inventoryUsageRecordEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.inventoryPreemptionDomain.allRelease(preemptIds);
            ArrayList details = Lists.newArrayList();
            for (InventoryUsageRecordEo preemptionEo : inventoryUsageRecordEos) {
                CalcDetailDto detail2 = new CalcDetailDto();
                BigDecimal availableReleaseNum = BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum());
                detail2.setNum(availableReleaseNum);
                if (BigDecimalUtils.leZero((BigDecimal)detail2.getNum()).booleanValue()) continue;
                detail2.setLineNo(preemptionEo.getLineNo());
                detail2.setSkuCode(preemptionEo.getSkuCode());
                detail2.setLogicWarehouseCode(preemptionEo.getWarehouseCode());
                detail2.setBatch(preemptionEo.getBatch());
                detail2.setInventoryProperty(preemptionEo.getInventoryProperty());
                detail2.setPreemptId(preemptionEo.getId());
                detail2.setBeforePreemptNum(availableReleaseNum);
                detail2.setAfterPreemptNum(BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)detail2.getNum()));
                detail2.setSourceNo(preemptionEo.getSourceNo());
                detail2.setSourceType(preemptionEo.getSourceType());
                details.add(detail2);
            }
            log.info("\u5168\u90e8\u91ca\u653e\u8ba1\u7b97:{}", (Object)JSONObject.toJSONString((Object)details));
            dto.setDetails((List)details);
            this.checkDetails((CalcDto)dto);
        } else {
            dto.setNoneBatch(Boolean.valueOf(false));
            dto.setNoneLineNo(Boolean.valueOf(false));
            AtomicInteger key = new AtomicInteger(1);
            dto.getDetails().forEach(r -> r.setKey(Integer.valueOf(key.getAndIncrement())));
            Map calcDetailDtoMap = dto.getDetails().stream().collect(Collectors.toMap(x -> this.getKey(x.getLineNo(), x.getLogicWarehouseCode()), Function.identity()));
            Map preOrderCalcDetailDtoMap = dto.getDetails().stream().filter(r -> Objects.nonNull(r.getPreOrderItemId())).collect(Collectors.toMap(x -> this.getKey(x.getPreOrderItemId(), x.getLogicWarehouseCode()), Function.identity()));
            Map<String, List<InventoryUsageRecordEo>> preemptLineNoMap = inventoryUsageRecordEos.stream().collect(Collectors.groupingBy(x -> this.getKey(x.getLineNo(), x.getWarehouseCode())));
            Map<String, List<InventoryUsageRecordEo>> preOrderPreemptMap = inventoryUsageRecordEos.stream().collect(Collectors.groupingBy(x -> this.getKey(x.getPreOrderItemId(), x.getWarehouseCode())));
            Map<String, List<InventoryUsageRecordEo>> warehouseSkuMap = inventoryUsageRecordEos.stream().collect(Collectors.groupingBy(x -> String.join((CharSequence)InventoryConfig.getCommonSeparate(), x.getSkuCode(), x.getWarehouseCode())));
            Map<Long, BigDecimal> warehouseSkuNumMap = inventoryUsageRecordEos.stream().collect(Collectors.toMap(BaseEo::getId, in -> BigDecimalUtils.subtract((BigDecimal)in.getPreemptNum(), (BigDecimal)in.getReleaseNum())));
            log.info("\u9884\u5360\u91ca\u653e,calcDetailDtoMap:{}, preOrderCalcDetailDtoMap:{}", (Object)JSONObject.toJSONString(calcDetailDtoMap), (Object)JSONObject.toJSONString(preOrderCalcDetailDtoMap));
            HashMap updatePreemptionEoMap = new HashMap(10);
            List calcDetailDtos = BeanUtil.copyToList((Collection)dto.getDetails(), CalcDetailDto.class);
            ArrayList newReleaseDetails = new ArrayList();
            calcDetailDtos.forEach(detail -> {
                List<InventoryUsageRecordEo> preemptionEos = this.matchDecrPreempt((CalcDetailDto)detail, preOrderPreemptMap, preemptLineNoMap, warehouseSkuMap, warehouseSkuNumMap);
                if (CollectionUtils.isEmpty(preemptionEos)) {
                    return;
                }
                preemptionEos.forEach(preemptionEo -> {
                    if (BigDecimalUtils.leZero((BigDecimal)detail.getNum()).booleanValue()) {
                        return;
                    }
                    CalcDetailDto detailDto = (CalcDetailDto)BeanUtil.copyProperties((Object)detail, CalcDetailDto.class, (String[])new String[0]);
                    BigDecimal avaliableReleaseNum = BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum());
                    if (BigDecimalUtils.leZero((BigDecimal)avaliableReleaseNum).booleanValue()) {
                        throw new BizException("\u5df2\u8d85\u9884\u5360\u91ca\u653e, \u5df2\u65e0\u53ef\u91ca\u653e\u5e93\u5b58");
                    }
                    if (BigDecimalUtils.lt((BigDecimal)avaliableReleaseNum, (BigDecimal)detailDto.getNum()).booleanValue()) {
                        detailDto.setNum(avaliableReleaseNum);
                    }
                    detailDto.setPreemptId(preemptionEo.getId());
                    detailDto.setBeforePreemptNum(avaliableReleaseNum);
                    preemptionEo.setReleaseNum(BigDecimalUtils.add((BigDecimal)preemptionEo.getReleaseNum(), (BigDecimal)detailDto.getNum()));
                    detailDto.setAfterPreemptNum(BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()));
                    detailDto.setSourceNo(preemptionEo.getSourceNo());
                    detailDto.setSourceType(preemptionEo.getSourceType());
                    detailDto.setBusinessType(preemptionEo.getBusinessType());
                    log.info("\u90e8\u5206\u91ca\u653e\u8ba1\u7b97:{}", (Object)JSONObject.toJSONString((Object)detailDto));
                    if (BigDecimalUtils.equals((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()).booleanValue()) {
                        preemptionEo.setValid(ValidFlagEnum.DISABLE.getCode());
                    }
                    detail.setNum(BigDecimalUtils.subtract((BigDecimal)detail.getNum(), (BigDecimal)detailDto.getNum()));
                    newReleaseDetails.add(detailDto);
                    warehouseSkuNumMap.put(preemptionEo.getId(), BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()));
                    updatePreemptionEoMap.putIfAbsent(preemptionEo.getId(), preemptionEo);
                });
            });
            dto.setDetails(newReleaseDetails);
            this.inventoryPreemptionDomain.updatePreempt((List)Lists.newArrayList(updatePreemptionEoMap.values()));
        }
    }

    private List<InventoryUsageRecordEo> matchDecrPreempt(CalcDetailDto detail, Map<String, List<InventoryUsageRecordEo>> preOrderPreemptMap, Map<String, List<InventoryUsageRecordEo>> preemptLineNoMap, Map<String, List<InventoryUsageRecordEo>> warehouseSkuMap, Map<Long, BigDecimal> warehouseSkuNumMap) {
        String preOrderItemKey;
        String lineKey = this.getKey(detail.getLineNo(), detail.getLogicWarehouseCode());
        List<InventoryUsageRecordEo> preemptionEos = preemptLineNoMap.getOrDefault(lineKey, preOrderPreemptMap.get(preOrderItemKey = this.getKey(detail.getPreOrderItemId(), detail.getLogicWarehouseCode())));
        if (CollectionUtils.isNotEmpty(preemptionEos)) {
            return preemptionEos;
        }
        log.error("\u91ca\u653e\u660e\u7ec6\u884c\u53f7\u5f02\u5e38,\u65e0\u6cd5\u5339\u914d\u5230\u91ca\u653e\u660e\u7ec6:{},{},{}", new Object[]{detail.getSourceNo(), detail.getSkuCode(), detail.getLineNo()});
        List<Object> inventoryPreemptionEos = warehouseSkuMap.get(String.join((CharSequence)InventoryConfig.getCommonSeparate(), detail.getSkuCode(), detail.getLogicWarehouseCode()));
        inventoryPreemptionEos = inventoryPreemptionEos.stream().map(r -> {
            if (BigDecimalUtils.leZero((BigDecimal)((BigDecimal)warehouseSkuNumMap.get(r.getId()))).booleanValue()) {
                return null;
            }
            return r;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return inventoryPreemptionEos;
    }

    public String getKey(Long preOrderItemId, String warehouseCode) {
        return String.join((CharSequence)InventoryConfig.getCommonSeparate(), String.valueOf(preOrderItemId), warehouseCode);
    }

    private <T extends InventoryUsageRecordEo> void releaseUsageProcess(List<InventoryUsageRecordEo> inventoryUsageRecordEos, CalcDetailDto calcDetailDto, List<CalcDetailDto> addDetails) {
        BigDecimal[] numArr = new BigDecimal[]{calcDetailDto.getNum()};
        for (InventoryUsageRecordEo d : inventoryUsageRecordEos) {
            if (BigDecimalUtils.leZero((BigDecimal)numArr[0]).booleanValue()) break;
            CalcDetailDto detailDto = (CalcDetailDto)BeanUtil.copyProperties((Object)calcDetailDto, CalcDetailDto.class, (String[])new String[0]);
            detailDto.setSkuCode(d.getSkuCode());
            detailDto.setLogicWarehouseCode(d.getWarehouseCode());
            BigDecimal can = BigDecimalUtils.subtract((BigDecimal)d.getPreemptNum(), (BigDecimal)d.getReleaseNum());
            if (BigDecimalUtils.ge((BigDecimal)numArr[0], (BigDecimal)can).booleanValue()) {
                d.setValid(EnableDisableEnum.DISABLE.getCode());
                d.setReleaseNum(d.getPreemptNum());
                numArr[0] = BigDecimalUtils.subtract((BigDecimal)numArr[0], (BigDecimal)can);
                detailDto.setNum(can);
                detailDto.setBatch(d.getBatch());
                addDetails.add(detailDto);
                continue;
            }
            d.setReleaseNum(BigDecimalUtils.add((BigDecimal)d.getReleaseNum(), (BigDecimal)numArr[0]));
            detailDto.setNum(numArr[0]);
            detailDto.setBatch(d.getBatch());
            addDetails.add(detailDto);
            numArr[0] = BigDecimal.ZERO;
            break;
        }
        if (BigDecimalUtils.gtZero((BigDecimal)numArr[0]).booleanValue()) {
            throw new BizException("\u5df2\u8d85\u9884\u5360\u91ca\u653e, \u5df2\u65e0\u53ef\u91ca\u653e\u5e93\u5b58");
        }
    }

    public static interface SourceToTarget {
        public void accept(CalcDetailDto var1, CalcInventoryDetailDto var2);
    }
}

