/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.constants.InventoryRecordUsageTypeEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.LockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.FindDetailInventoyBo;
import com.yunxi.dg.base.center.inventory.service.calc.ILockAble;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LockAbleImpl
extends BaseAble
implements ILockAble {
    private static final Logger log = LoggerFactory.getLogger(LockAbleImpl.class);

    @Override
    public void lock(LockDto dto) {
        log.info("warehouse inventory lock(\u9501\u5b9a\u5e93\u5b58), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        List inventoryUsageRecordEos = this.inventoryPreemptionDomain.queryBySourceNo(dto.getSourceNo(), InventoryRecordUsageTypeEnum.LOCK.getCode(), ValidFlagEnum.ENABLE.getCode());
        if (CollectionUtil.isNotEmpty((Collection)inventoryUsageRecordEos)) {
            throw new BizException(String.format("\u8be5\u5355\u636e[%s]\u5df2\u5b58\u5728\u6709\u6548\u9501\u5b9a\u8bb0\u5f55", dto.getSourceNo()));
        }
        List details = dto.getDetails();
        List<String> logicWarehouseCodes = details.stream().map(CalcDetailDto::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        List<String> skuCodes = details.stream().map(CalcDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(logicWarehouseCodes);
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(skuCodes);
        List<String> inventoryPropertyList = dto.getDetails().stream().map(CalcDetailDto::getInventoryProperty).distinct().collect(Collectors.toList());
        List<LogicInventoryEo> logicInventoryEos = this.queryLogicInventoryEos(new FindDetailInventoyBo(skuDtoList, logicWarehouseEos, Lists.newArrayList(), new HashSet<String>(), inventoryPropertyList));
        this.shoutLogicInventoryEosAndSetDetails(dto, logicWarehouseEos, skuDtoList, logicInventoryEos);
        Map itemSkuDtoMap = skuDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o, o1) -> o));
        Map warehouseEoMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (o, o1) -> o));
        this.checkDetails((CalcDto)dto);
        List usageRecordEos = dto.getDetails().stream().map(detail -> this.createInventoryPreemptEo(dto, (CalcDetailDto)detail, (ItemSkuDto)itemSkuDtoMap.get(detail.getSkuCode()), (LogicWarehouseEo)warehouseEoMap.get(detail.getLogicWarehouseCode()))).collect(Collectors.toList());
        this.inventoryPreemptionDomain.insertBatch(usageRecordEos);
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto, (source, target) -> {
            target.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)source.getNum()));
            target.setChangeLockInventory(source.getNum());
        });
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private InventoryUsageRecordEo createInventoryPreemptEo(LockDto dto, CalcDetailDto detail, ItemSkuDto skuDto, LogicWarehouseEo warehouseEo) {
        InventoryUsageRecordEo inventoryUsageRecordEo = this.getBaseInventoryUsageRecordEo(dto, detail, skuDto, warehouseEo);
        inventoryUsageRecordEo.setUsageType(InventoryRecordUsageTypeEnum.LOCK.getCode());
        inventoryUsageRecordEo.setActivityFlag(YesNoHelper.NO);
        inventoryUsageRecordEo.setRemark("\u5e93\u5b58\u9501\u5b9a");
        return inventoryUsageRecordEo;
    }
}

