/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commonsendback.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import com.yunxi.dg.base.center.enums.BusinessCallBackStrategyEnum;
import com.yunxi.dg.base.center.enums.TransferDispatcherStatusEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsReceiveReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LiteflowComponent(value="diffCalculate")
public class DiffCalculateComponent
extends NodeComponent {
    private static final Logger log = LoggerFactory.getLogger(DiffCalculateComponent.class);
    @Resource
    private IOrderUnitConversionRecordService iOrderUnitConversionRecordService;

    public void process() throws Exception {
        this.getRequestData();
    }

    public void diffCalculate(BasicsReceiveReqDto basicsReceiveBasicsReqDto, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList, BusinessCallBackStrategyEnum callBackStrategyEnum, InOutNoticeOrderEo inOutNoticeOrderEo) {
        if (!InventoryConfig.isDispatchOrderEnable()) {
            log.info("\u914d\u7f6e\u4e86\u4e0d\u89e6\u53d1\u6536\u53d1\u5dee\u5f02\u5355InventoryConfig:{}", (Object)false);
            return;
        }
        if (!BusinessCallBackStrategyEnum.TRANSFER_ORDER.getCode().equals(callBackStrategyEnum.getCode()) || !"in".equals(inOutNoticeOrderEo.getOrderType())) {
            return;
        }
        if (InventoryConfig.isDispatchOrderBatch()) {
            this.dispatchOrderBatch(basicsReceiveBasicsReqDto, inOutNoticeOrderDetailEoList, callBackStrategyEnum, inOutNoticeOrderEo);
        } else {
            this.dispatchOrderNoBatch(basicsReceiveBasicsReqDto, inOutNoticeOrderDetailEoList, callBackStrategyEnum, inOutNoticeOrderEo);
        }
    }

    private void dispatchOrderBatch(BasicsReceiveReqDto basicsReceiveBasicsReqDto, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList, BusinessCallBackStrategyEnum callBackStrategyEnum, InOutNoticeOrderEo inOutNoticeOrderEo) {
        Map itemBatchMap = inOutNoticeOrderDetailEoList.stream().collect(Collectors.toMap(r -> r.getSkuCode() + r.getBatch(), Function.identity(), (o, o1) -> o));
        log.info("itemBatchMap\uff1a {}", (Object)JSONObject.toJSONString(itemBatchMap));
        basicsReceiveBasicsReqDto.getDetailReqDtoList().forEach(detail -> {
            String key = detail.getSkuCode() + detail.getBatch();
            log.info("\u6536\u53d1\u5dee\u5f02\u5224\u65adkey:{}", (Object)key);
            log.info("\u5f00\u59cb\u8fdb\u884c\u6536\u53d1\u5dee\u5f02\u5355\u7684\u5224\u65ad,detail\uff1a{}", (Object)JSON.toJSONString((Object)detail));
            boolean exist = itemBatchMap.containsKey(key);
            if (exist) {
                InOutNoticeOrderDetailEo eo1 = (InOutNoticeOrderDetailEo)itemBatchMap.get(key);
                log.info("eo1:{}", (Object)JSON.toJSONString((Object)eo1));
                BigDecimal subtract = detail.getQuantity().subtract(eo1.getWaitQuantity());
                if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                    log.info("\u591a\u6536");
                    IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
                    calculateWeightAndVolumeBo.setDocumentCode(inOutNoticeOrderEo.getRelevanceNo());
                    IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
                    calculateWeightAndVolumeDetailBo.setQuantity(eo1.getWaitQuantity());
                    calculateWeightAndVolumeDetailBo.setSkuCode(detail.getSkuCode());
                    calculateWeightAndVolumeBo.setVolumeDetailBos(Arrays.asList(calculateWeightAndVolumeDetailBo));
                    Map<String, BasicOrderDtoExtension> basicOrderDtoExtensionMap = this.iOrderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
                    if (basicOrderDtoExtensionMap.containsKey(detail.getSkuCode() + InventoryConfig.getCommonSeparate() + eo1.getWaitQuantity())) {
                        detail.setVolume(basicOrderDtoExtensionMap.get(detail.getSkuCode() + InventoryConfig.getCommonSeparate() + eo1.getWaitQuantity()).getVolume());
                        detail.setWeight(basicOrderDtoExtensionMap.get(detail.getSkuCode() + InventoryConfig.getCommonSeparate() + eo1.getWaitQuantity()).getWeight());
                    }
                    detail.setQuantity(eo1.getWaitQuantity());
                    detail.setDispatcherStatus(TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                } else if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                    log.info("\u5c11\u6536");
                    detail.setDispatcherStatus(TransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                } else {
                    log.info("\u6b63\u5e38\u6536");
                    detail.setDispatcherStatus(TransferDispatcherStatusEnum.NO_DISPATCHER.getCode());
                }
                detail.setDispatcherQuantity(subtract);
            } else {
                log.info("\u65b0\u589e\u591a\u6536");
                detail.setDispatcherQuantity(detail.getQuantity());
                detail.setQuantity(BigDecimal.ZERO);
                detail.setVolume(new BigDecimal("0"));
                detail.setWeight(new BigDecimal("0"));
                detail.setDispatcherStatus(TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
            }
            log.info("\u6536\u53d1\u5dee\u5f02\u5355\u7684\u5224\u65ad\u7ed3\u675f,detail\uff1a{}", (Object)JSON.toJSONString((Object)detail));
        });
    }

    private void dispatchOrderNoBatch(BasicsReceiveReqDto basicsReceiveBasicsReqDto, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList, BusinessCallBackStrategyEnum callBackStrategyEnum, InOutNoticeOrderEo inOutNoticeOrderEo) {
        Map<String, List<InOutNoticeOrderDetailEo>> itemMap = inOutNoticeOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode));
        log.info("itemMap\uff1a {}", (Object)JSONObject.toJSONString(itemMap));
        Map<String, List<BasicsDetailReqDto>> detailReqMap = basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().collect(Collectors.groupingBy(a -> a.getSkuCode()));
        log.info("detailReqMap\uff1a {}", (Object)JSONObject.toJSONString(detailReqMap));
        for (Map.Entry<String, List<BasicsDetailReqDto>> entry : detailReqMap.entrySet()) {
            String skuCode = entry.getKey();
            List<BasicsDetailReqDto> basicsDetailReqDtos = entry.getValue();
            List<InOutNoticeOrderDetailEo> detailEoList = itemMap.get(skuCode);
            BigDecimal totalQuantity = basicsDetailReqDtos.stream().map(e -> e.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("skuCode:{}\uff0ctotalQuantity:{}", (Object)skuCode, (Object)JSON.toJSONString((Object)totalQuantity));
            if (CollectionUtils.isNotEmpty(detailEoList)) {
                BigDecimal quantity;
                BigDecimal newSubtract;
                BigDecimal totalWaitQuantity = detailEoList.stream().map(e -> e.getWaitQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add);
                log.info("skuCode:{}\uff0ctotalWaitQuantity:{}", (Object)skuCode, (Object)JSON.toJSONString((Object)totalWaitQuantity));
                BigDecimal subtract = BigDecimalUtils.subtract((BigDecimal)totalQuantity, (BigDecimal)totalWaitQuantity);
                if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                    log.info("\u591a\u6536");
                    for (BasicsDetailReqDto detail2 : basicsDetailReqDtos) {
                        log.info("subtract\uff1a{}", (Object)subtract);
                        if (!BigDecimalUtils.eqZero((BigDecimal)subtract).booleanValue()) {
                            newSubtract = BigDecimalUtils.subtract((BigDecimal)subtract, (BigDecimal)detail2.getQuantity());
                            quantity = BigDecimalUtils.gtZero((BigDecimal)newSubtract) != false ? detail2.getQuantity() : subtract;
                            IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
                            calculateWeightAndVolumeBo.setDocumentCode(inOutNoticeOrderEo.getRelevanceNo());
                            IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
                            calculateWeightAndVolumeDetailBo.setQuantity(detail2.getQuantity());
                            calculateWeightAndVolumeDetailBo.setSkuCode(detail2.getSkuCode());
                            calculateWeightAndVolumeBo.setVolumeDetailBos(Arrays.asList(calculateWeightAndVolumeDetailBo));
                            Map<String, BasicOrderDtoExtension> basicOrderDtoExtensionMap = this.iOrderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
                            if (basicOrderDtoExtensionMap.containsKey(detail2.getSkuCode() + InventoryConfig.getCommonSeparate() + detail2.getQuantity())) {
                                detail2.setVolume(basicOrderDtoExtensionMap.get(detail2.getSkuCode() + InventoryConfig.getCommonSeparate() + detail2.getQuantity()).getVolume());
                                detail2.setWeight(basicOrderDtoExtensionMap.get(detail2.getSkuCode() + InventoryConfig.getCommonSeparate() + detail2.getQuantity()).getWeight());
                            }
                            detail2.setQuantity(quantity);
                            detail2.setDispatcherStatus(TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                            detail2.setDispatcherQuantity(quantity);
                            subtract = newSubtract;
                            continue;
                        }
                        detail2.setDispatcherStatus(TransferDispatcherStatusEnum.NO_DISPATCHER.getCode());
                        detail2.setDispatcherQuantity(BigDecimal.ZERO);
                    }
                } else if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                    log.info("\u5c11\u6536");
                    subtract = BigDecimalUtils.abs((BigDecimal)subtract);
                    for (BasicsDetailReqDto detail2 : basicsDetailReqDtos) {
                        log.info("subtract\u7edd\u5bf9\u503c\uff1a{}", (Object)subtract);
                        if (!BigDecimalUtils.eqZero((BigDecimal)subtract).booleanValue()) {
                            newSubtract = BigDecimalUtils.subtract((BigDecimal)subtract, (BigDecimal)detail2.getQuantity());
                            quantity = BigDecimalUtils.gtZero((BigDecimal)newSubtract) != false ? detail2.getQuantity() : subtract;
                            detail2.setDispatcherQuantity(quantity);
                            detail2.setDispatcherStatus(TransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                            subtract = newSubtract;
                            continue;
                        }
                        detail2.setDispatcherStatus(TransferDispatcherStatusEnum.NO_DISPATCHER.getCode());
                        detail2.setDispatcherQuantity(BigDecimal.ZERO);
                    }
                } else {
                    log.info("\u6b63\u5e38\u6536");
                    basicsDetailReqDtos.forEach(detail -> {
                        detail.setDispatcherStatus(TransferDispatcherStatusEnum.NO_DISPATCHER.getCode());
                        detail.setDispatcherQuantity(BigDecimal.ZERO);
                    });
                }
            } else {
                log.info("\u65b0\u589e\u591a\u6536");
                basicsDetailReqDtos.forEach(detail -> {
                    detail.setDispatcherQuantity(detail.getQuantity());
                    detail.setQuantity(BigDecimal.ZERO);
                    detail.setVolume(BigDecimal.ZERO);
                    detail.setWeight(BigDecimal.ZERO);
                    detail.setDispatcherStatus(TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                });
            }
            AtomicInteger i = new AtomicInteger(1);
            basicsDetailReqDtos.stream().filter(e -> Objects.isNull(e.getLineNo())).forEach(e -> e.setLineNo(Long.valueOf((long)i.getAndIncrement() * 10L + 1L)));
            log.info("\u6536\u53d1\u5dee\u5f02\u5355\u7684\u5224\u65ad\u7ed3\u675f,basicsDetailReqDtos\uff1a{}", (Object)JSON.toJSONString(basicsDetailReqDtos));
        }
    }
}

