/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.dao.das.IThirdWarehouseDas;
import com.yunxi.dg.base.center.inventory.dao.mapper.DgThirdWarehouseMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.ThirdWarehouseReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.inventory.ThirdWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.eo.DgThirdWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicWarehouseService;
import com.yunxi.dg.base.center.inventory.service.entity.inventory.IThirdWarehouseService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgThirdWarehouseServiceImpl
implements IThirdWarehouseService {
    private static Logger logger = LoggerFactory.getLogger(DgThirdWarehouseServiceImpl.class);
    @Autowired
    private ICacheService cacheService;
    private static final String CACHE_KEY = "thirdWarehouseAll";
    @Autowired
    private IThirdWarehouseDas iThirdWarehouseDas;
    @Resource
    private DgThirdWarehouseMapper dgThirdWarehouseMapper;
    @Resource
    private IPhysicsWarehouseDomain iPhysicsWarehouseDomain;
    @Resource
    private ILogicWarehouseService iLogicWarehouseService;

    @Override
    public Long addThirdWarehouse(ThirdWarehouseReqDto addReqDto) {
        this.condition(addReqDto);
        DgThirdWarehouseEo dgThirdWarehouseEo = new DgThirdWarehouseEo();
        CubeBeanUtils.copyProperties((Object)dgThirdWarehouseEo, (Object)addReqDto, (String[])new String[0]);
        this.iThirdWarehouseDas.insert((BaseEo)dgThirdWarehouseEo);
        return dgThirdWarehouseEo.getId();
    }

    @Override
    public void modifyThirdWarehouse(ThirdWarehouseReqDto modifyReqDto) {
        AssertUtils.isTrue((!Objects.isNull(modifyReqDto) ? 1 : 0) != 0, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isTrue((!StringUtil.isEmpty((String)modifyReqDto.getWarehouseCode()) ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isTrue((!StringUtil.isEmpty((String)modifyReqDto.getWarehouseName()) ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isTrue((!Objects.isNull(modifyReqDto.getId()) ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgThirdWarehouseEo dgThirdWarehouseEo = new DgThirdWarehouseEo();
        CubeBeanUtils.copyProperties((Object)dgThirdWarehouseEo, (Object)modifyReqDto, (String[])new String[0]);
        this.iThirdWarehouseDas.updateSelective((BaseEo)dgThirdWarehouseEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void removeThirdWarehouse(List<String> ids) {
        AssertUtils.isTrue((!CollectionUtil.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String id : ids) {
            this.iThirdWarehouseDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ThirdWarehouseRespDto queryById(Long id) {
        AssertUtils.isTrue((!Objects.isNull(id) ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgThirdWarehouseEo dgThirdWarehouseEo = (DgThirdWarehouseEo)this.iThirdWarehouseDas.selectByPrimaryKey(id);
        ThirdWarehouseRespDto thirdWarehouseRespDto = new ThirdWarehouseRespDto();
        CubeBeanUtils.copyProperties((Object)thirdWarehouseRespDto, (Object)dgThirdWarehouseEo, (String[])new String[0]);
        return thirdWarehouseRespDto;
    }

    @Override
    public PageInfo<ThirdWarehouseRespDto> queryByPage(ThirdWarehouseReqDto reqDto, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper filter = new ExtQueryChainWrapper((BaseMapper)this.dgThirdWarehouseMapper, true);
        filter.orderByDesc((Object)"update_time");
        if (StringUtil.isNotEmpty((String)reqDto.getWarehouseName())) {
            filter.like((Object)"warehouse_name", (Object)reqDto.getWarehouseName());
        }
        if (StringUtil.isNotEmpty((String)reqDto.getWarehouseCode())) {
            filter.like((Object)"warehouse_code", (Object)reqDto.getWarehouseCode());
        }
        if (StringUtil.isNotEmpty((String)reqDto.getVerifySign())) {
            filter.like((Object)"verify_sign", (Object)reqDto.getVerifySign());
        }
        if (StringUtil.isNotEmpty((String)reqDto.getWmsRequest())) {
            filter.eq((Object)"wms_request", (Object)reqDto.getWmsRequest());
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getWarehouseCodeList())) {
            filter.in((Object)"warehouse_code", (Collection)reqDto.getWarehouseCodeList());
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getWarehouseNameList())) {
            filter.in((Object)"warehouse_name", (Collection)reqDto.getWarehouseNameList());
        }
        if (StringUtil.isNotEmpty((String)reqDto.getKeyword())) {
            ((ExtQueryChainWrapper)filter.like((Object)"warehouse_code", (Object)reqDto.getKeyword())).or(f -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)f.like((Object)"warehouse_name", (Object)reqDto.getKeyword());
            });
        }
        filter.orderByDesc((Object)"create_time");
        PageInfo eoPageInfo = filter.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), ThirdWarehouseRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ThirdWarehouseRespDto> queryAllByCache() {
        Long startTime = System.currentTimeMillis();
        String thirdWarehouseAllStr = (String)this.cacheService.getCache(CACHE_KEY, String.class);
        logger.info("\u4ece\u7f13\u5b58\u67e5\u8be2\u7684\u7b2c\u4e09\u65b9\u4ed3\u8017\u65f6\uff1a{}ms \u4fe1\u606f\uff1a{}", (Object)(System.currentTimeMillis() - startTime), (Object)thirdWarehouseAllStr);
        ArrayList<ThirdWarehouseRespDto> respDtos = new ArrayList();
        if (StringUtils.isBlank((CharSequence)thirdWarehouseAllStr)) {
            respDtos = this.queryByParam(new ThirdWarehouseReqDto());
            thirdWarehouseAllStr = JSON.toJSONString(respDtos);
            logger.info("\u67e5\u8be2\u6570\u636e\u5e93\u7b2c\u4e09\u65b9\u4ed3\u8017\u65f6\uff1a{}ms \u4fe1\u606f\uff1a{}", (Object)(System.currentTimeMillis() - startTime), (Object)thirdWarehouseAllStr);
            this.cacheService.setCache(CACHE_KEY, (Object)thirdWarehouseAllStr);
            logger.info("\u4fdd\u5b58\u5230\u7f13\u5b58\u6210\u529f\uff0c \u8017\u65f6{}ms", (Object)(System.currentTimeMillis() - startTime));
        } else {
            respDtos = JSON.parseArray((String)thirdWarehouseAllStr, ThirdWarehouseRespDto.class);
            logger.info("\u7b2c\u4e09\u65b9\u4ed3\u7f13\u5b58\u8f6c\u6362\u7528\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return respDtos;
    }

    @Override
    public String queryCustomerId(ThirdWarehouseReqDto reqDto) {
        if (StringUtils.isEmpty((CharSequence)reqDto.getWarehouseCode()) && StringUtils.isEmpty((CharSequence)reqDto.getLogicWarehouseCode())) {
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getWarehouseCode())) {
            DgThirdWarehouseEo thirdWarehouseEo = this.getDgThirdWarehouseEo(reqDto.getWarehouseCode());
            AssertUtils.notEmpty((String)thirdWarehouseEo.getCustomerId(), (String)"customerId\u4e0d\u5b58\u5728\uff0c\u672a\u914d\u7f6e");
            return thirdWarehouseEo.getCustomerId();
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getLogicWarehouseCode())) {
            LogicWarehouseRespDto logicWarehouseRespDto = this.iLogicWarehouseService.queryByCode(reqDto.getLogicWarehouseCode());
            AssertUtils.notEmpty((Object)logicWarehouseRespDto, (String)"\u67e5\u8be2\u5230\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728");
            AssertUtils.notEmpty((String)logicWarehouseRespDto.getPhysicsWarehouseCode(), (String)"\u8be5\u903b\u8f91\u4ed3\u7684\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
            DgThirdWarehouseEo thirdWarehouseEo = this.getDgThirdWarehouseEo(logicWarehouseRespDto.getPhysicsWarehouseCode());
            AssertUtils.notEmpty((String)thirdWarehouseEo.getCustomerId(), (String)"customerId\u4e0d\u5b58\u5728\uff0c\u672a\u914d\u7f6e");
            return thirdWarehouseEo.getCustomerId();
        }
        return null;
    }

    private DgThirdWarehouseEo getDgThirdWarehouseEo(String warehouseCode) {
        List warehouseEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iPhysicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)warehouseCode)).eq((Object)"warehouse_status", (Object)ValidFlagEnum.ENABLE.getCode())).list();
        AssertUtils.notEmpty((Collection)warehouseEoList, (String)"\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)warehouseEoList.get(0);
        String channelCode = physicsWarehouseEo.getEntitySystemCode();
        AssertUtils.notBlank((String)channelCode, (String)"\u63a8\u9001\u6e20\u9053\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgThirdWarehouseEo thirdWarehouseEo = this.iThirdWarehouseDas.queryByCode(channelCode);
        AssertUtils.notNull((Object)thirdWarehouseEo, (String)"\u6839\u636e\u6e20\u9053\u4fe1\u606f\u67e5\u4e0d\u5230\u63a8\u9001\u7b2c\u4e09\u65b9");
        return thirdWarehouseEo;
    }

    public List<ThirdWarehouseRespDto> queryByParam(ThirdWarehouseReqDto reqDto) {
        ExtQueryChainWrapper filter = new ExtQueryChainWrapper((BaseMapper)this.dgThirdWarehouseMapper, true);
        filter.orderByDesc((Object)"update_time");
        if (StringUtil.isNotEmpty((String)reqDto.getWarehouseName())) {
            filter.like((Object)"warehouse_name", (Object)reqDto.getWarehouseName());
        }
        if (StringUtil.isNotEmpty((String)reqDto.getWarehouseCode())) {
            filter.like((Object)"warehouse_code", (Object)reqDto.getWarehouseCode());
        }
        if (StringUtil.isNotEmpty((String)reqDto.getVerifySign())) {
            filter.like((Object)"verify_sign", (Object)reqDto.getVerifySign());
        }
        List eos = filter.select(new String[0]).list();
        ArrayList<ThirdWarehouseRespDto> respDtos = new ArrayList<ThirdWarehouseRespDto>();
        CubeBeanUtils.copyCollection(respDtos, (Collection)eos, ThirdWarehouseRespDto.class);
        return respDtos;
    }

    public void condition(ThirdWarehouseReqDto reqDto) {
        AssertUtils.isTrue((!Objects.isNull(reqDto) ? 1 : 0) != 0, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isTrue((!StringUtil.isEmpty((String)reqDto.getWarehouseCode()) ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isTrue((!StringUtil.isEmpty((String)reqDto.getWarehouseName()) ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgThirdWarehouseEo thirdWarehouseEo = this.iThirdWarehouseDas.queryByCode(reqDto.getWarehouseCode());
        AssertUtils.isTrue((ObjectUtil.isEmpty((Object)thirdWarehouseEo) || ObjectUtil.isNotEmpty((Object)reqDto.getId()) ? 1 : 0) != 0, (String)"\u8be5\u4ed3\u5e93\u7f16\u7801\u5df2\u5b58\u5728!");
    }
}

