/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsValidFlagEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.LogicWarehouseConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseDropdownRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseExtRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageQueryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseAddressDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseSearchReqDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicWarehouseService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogicWarehouseServiceImpl
extends BaseServiceImpl<LogicWarehouseDto, LogicWarehouseEo, ILogicWarehouseDomain>
implements ILogicWarehouseService {
    private static final Logger log = LoggerFactory.getLogger(LogicWarehouseServiceImpl.class);
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;

    public LogicWarehouseServiceImpl(ILogicWarehouseDomain domain) {
        super((IBaseDomain)domain);
    }

    public Long add(LogicWarehouseDto dto) {
        AssertUtils.isTrue((dto != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo insertEo = new LogicWarehouseEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)dto, (String[])new String[0]);
        insertEo.setId(null);
        ((ILogicWarehouseDomain)this.domain).insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Long modify(LogicWarehouseDto dto) {
        AssertUtils.isTrue((dto != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo insertEo = new LogicWarehouseEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)dto, (String[])new String[0]);
        ((ILogicWarehouseDomain)this.domain).updateSelective((BaseEo)insertEo);
        return insertEo.getId();
    }

    public IConverter<LogicWarehouseDto, LogicWarehouseEo> converter() {
        return LogicWarehouseConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<LogicWarehouseRespDto>> queryDataByParams(LogicWarehousePageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((ILogicWarehouseDomain)this.domain).queryLogicWarehouseByParams(dto));
        PageInfo dtoPageInfo = new PageInfo(new ArrayList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), dtoList, LogicWarehouseRespDto.class);
            dtoPageInfo.setList(dtoList);
            List warehouseCodes = pageInfo.getList().stream().map(LogicWarehouseEo::getWarehouseCode).collect(Collectors.toList());
            List addressEoList = this.warehouseAddressDomain.queryByWarehouseCodes(warehouseCodes, "logic");
            Map<String, WarehouseAddressEo> addressEoMap = this.getAddressMap(addressEoList);
            for (LogicWarehouseRespDto logicWarehouseRespDto : dtoList) {
                WarehouseAddressEo warehouseAddressEo = addressEoMap.get(logicWarehouseRespDto.getWarehouseCode());
                if (warehouseAddressEo == null) continue;
                WarehouseAddressDto addressDto = new WarehouseAddressDto();
                DtoHelper.eo2Dto((BaseEo)warehouseAddressEo, (BaseVo)addressDto);
                logicWarehouseRespDto.setAddressDto(addressDto);
            }
        }
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<List<LogicWarehouseRespDto>> queryListWithPhysicsWarehouse(LogicWarehousePageReqDto dto) {
        List logicWarehouseEoList = ((ILogicWarehouseDomain)this.domain).queryLogicWarehouseByParams(dto);
        ArrayList respDtoList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)logicWarehouseEoList)) {
            DtoHelper.eoList2DtoList((Collection)logicWarehouseEoList, respDtoList, LogicWarehouseRespDto.class);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(respDtoList)) {
            return new RestResponse();
        }
        List physicsWarehouseDtos = Optional.ofNullable(BeanUtil.copyToList((Collection)this.physicsWarehouseDomain.selectList((BaseEo)new PhysicsWarehouseEo(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)), PhysicsWarehouseDto.class)).orElse(new ArrayList());
        Map physicsWarehouseDtoMap = physicsWarehouseDtos.stream().collect(Collectors.toMap(PhysicsWarehouseDto::getWarehouseCode, Function.identity(), (o1, o2) -> o1));
        QueryWrapper updateAddressEoWrapper = new QueryWrapper();
        updateAddressEoWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        List warehouseAddressEos = Optional.ofNullable(this.warehouseAddressDomain.getMapper().selectList((Wrapper)updateAddressEoWrapper)).orElse(new ArrayList());
        Map addressEoMap = warehouseAddressEos.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseId, Function.identity(), (o1, o2) -> o1));
        respDtoList.forEach(o -> {
            if (physicsWarehouseDtoMap.containsKey(o.getPhysicsWarehouseCode())) {
                PhysicsWarehouseDto physicsWarehouseDto = (PhysicsWarehouseDto)physicsWarehouseDtoMap.get(o.getPhysicsWarehouseCode());
                if (addressEoMap.containsKey(physicsWarehouseDto.getId())) {
                    WarehouseAddressEo warehouseAddressEo = (WarehouseAddressEo)addressEoMap.get(physicsWarehouseDto.getId());
                    BeanUtils.copyProperties((Object)warehouseAddressEo, (Object)physicsWarehouseDto);
                }
                o.setPhysicsWarehouseInfo(physicsWarehouseDto);
            }
        });
        return new RestResponse(respDtoList);
    }

    private Map<String, WarehouseAddressEo> getAddressMap(List<WarehouseAddressEo> addressEoList) {
        HashMap map = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(addressEoList)) {
            return map;
        }
        return addressEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public RestResponse<List<LogicWarehouseRespDto>> queryListByParams(LogicWarehousePageReqDto dto) {
        List logicWarehouseEoList = ((ILogicWarehouseDomain)this.domain).queryLogicWarehouseByParams(dto);
        ArrayList respDtoList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)logicWarehouseEoList)) {
            DtoHelper.eoList2DtoList((Collection)logicWarehouseEoList, respDtoList, LogicWarehouseRespDto.class);
        }
        return new RestResponse(respDtoList);
    }

    @Override
    public List<LogicWarehouseRespDto> queryDataListByParams(LogicWarehousePageReqDto dto) {
        List logicWarehouseEoList = ((ILogicWarehouseDomain)this.domain).queryLogicWarehouseByParams(dto);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)logicWarehouseEoList)) {
            ArrayList<LogicWarehouseRespDto> respDtoList = new ArrayList<LogicWarehouseRespDto>();
            DtoHelper.eoList2DtoList((Collection)logicWarehouseEoList, respDtoList, LogicWarehouseRespDto.class);
            return respDtoList;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Long> addLogicWarehouse(LogicWarehouseDto dto) {
        this.validParams(dto);
        String warehouseCode = dto.getWarehouseCode();
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            dto.setWarehouseCode(warehouseCode);
        }
        Long logicWarehouseId = this.add(dto);
        WarehouseAddressEo warehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(dto.getPhysicsWarehouseCode());
        if (null != warehouseAddressEo) {
            WarehouseAddressEo logicAddressEo = new WarehouseAddressEo();
            CubeBeanUtils.copyProperties((Object)logicAddressEo, (Object)warehouseAddressEo, (String[])new String[0]);
            logicAddressEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
            logicAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            logicAddressEo.setWarehouseId(logicWarehouseId);
            logicAddressEo.setWarehouseCode(warehouseCode);
            logicAddressEo.setWarehouseName(dto.getWarehouseName());
            logicAddressEo.setId(null);
            this.warehouseAddressDomain.insert((BaseEo)logicAddressEo);
        }
        return new RestResponse((Object)logicWarehouseId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Long> updateLogicWarehouse(LogicWarehouseDto dto) {
        this.validParams(dto);
        AssertUtils.isTrue((null != dto.getId() ? 1 : 0) != 0, (String)"\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode()), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.modify(dto);
        this.updateLogicInventory(dto);
        WarehouseAddressEo logicAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(dto.getWarehouseCode());
        WarehouseAddressEo newLogicAddressEo = new WarehouseAddressEo();
        CubeBeanUtils.copyProperties((Object)newLogicAddressEo, (Object)logicAddressEo, (String[])new String[0]);
        newLogicAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        newLogicAddressEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        newLogicAddressEo.setWarehouseId(dto.getId());
        newLogicAddressEo.setWarehouseCode(dto.getWarehouseCode());
        newLogicAddressEo.setWarehouseName(dto.getWarehouseName());
        if (StringUtils.isNotBlank((CharSequence)dto.getPhone())) {
            newLogicAddressEo.setPhone(dto.getPhone());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getContact())) {
            newLogicAddressEo.setContacts(dto.getContact());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRemark())) {
            newLogicAddressEo.setRemark(dto.getRemark());
        }
        if (null != logicAddressEo && null != logicAddressEo.getId()) {
            this.warehouseAddressDomain.updateSelective((BaseEo)newLogicAddressEo);
        } else {
            newLogicAddressEo.setId(null);
            this.warehouseAddressDomain.insert((BaseEo)newLogicAddressEo);
        }
        return new RestResponse((Object)dto.getId());
    }

    private void updateLogicInventory(LogicWarehouseDto dto) {
        List logicInventoryEoList = ((ExtQueryChainWrapper)this.logicInventoryDomain.filter().eq((Object)"warehouse_code", (Object)dto.getWarehouseCode())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)logicInventoryEoList)) {
            for (LogicInventoryEo logicInventoryEo : logicInventoryEoList) {
                logicInventoryEo.setWarehouseName(dto.getWarehouseName());
                this.logicInventoryDomain.updateSelective((BaseEo)logicInventoryEo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Void> updateStatusByIdList(LogicWarehouseReqDto reqDto) {
        List<LogicWarehouseEo> warehouseEoList;
        AssertUtils.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqDto.getIdList()), (String)"\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getWarehouseStatus()), (String)"\u4ed3\u5e93\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        List logicWarehouseEoList = ((ILogicWarehouseDomain)this.domain).selectByIds(reqDto.getIdList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)logicWarehouseEoList) && CollectionUtils.isNotEmpty(warehouseEoList = logicWarehouseEoList.stream().filter(p -> !p.getWarehouseStatus().equals(reqDto.getWarehouseStatus())).collect(Collectors.toList()))) {
            warehouseEoList.forEach(logicWarehouseEo -> logicWarehouseEo.setWarehouseStatus(reqDto.getWarehouseStatus()));
            ((ILogicWarehouseDomain)this.domain).updateStatusByIdList(warehouseEoList);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<LogicWarehouseRespDto> queryLogicWarehouseByCode(String code) {
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)code), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo logicWarehouseEo = ((ILogicWarehouseDomain)this.domain).queryByCode(code);
        LogicWarehouseRespDto respDto = new LogicWarehouseRespDto();
        if (null != logicWarehouseEo && null != logicWarehouseEo.getId()) {
            CubeBeanUtils.copyProperties((Object)respDto, (Object)logicWarehouseEo, (String[])new String[0]);
        }
        return new RestResponse((Object)respDto);
    }

    @Override
    public RestResponse<List<LogicWarehouseDropdownRespDto>> dropdown(WarehouseSearchReqDto searchReqDto) {
        List logicWarehouseEoList = ((ILogicWarehouseDomain)this.domain).dropdown(searchReqDto);
        List respDtoList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)logicWarehouseEoList)) {
            respDtoList = BeanUtil.copyToList((Collection)logicWarehouseEoList, LogicWarehouseDropdownRespDto.class);
        }
        return new RestResponse(respDtoList);
    }

    @Override
    public LogicWarehouseExtRespDto queryLogicWarehouseAndAddressByCode(String code) {
        LogicWarehouseRespDto logicWarehouseRespDto = (LogicWarehouseRespDto)RestResponseHelper.extractData(this.queryLogicWarehouseByCode(code));
        LogicWarehouseExtRespDto extRespDto = new LogicWarehouseExtRespDto();
        if (Objects.nonNull(logicWarehouseRespDto)) {
            CubeBeanUtils.copyProperties((Object)extRespDto, (Object)logicWarehouseRespDto, (String[])new String[0]);
            WarehouseAddressEo warehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(code);
            WarehouseAddressDto warehouseAddressDto = new WarehouseAddressDto();
            CubeBeanUtils.copyProperties((Object)warehouseAddressDto, (Object)warehouseAddressEo, (String[])new String[0]);
            extRespDto.setWarehouseAddressDto(warehouseAddressDto);
        }
        return extRespDto;
    }

    @Override
    public List<LogicWarehouseRespDto> queryParam(LogicWarehousePageQueryDto logicWarehousePageQueryDto) {
        List thirdCodeList;
        String subordinateLogicWarehouseName;
        Long subordinateLogicWarehouseId;
        Long subordinatePhysicsWarehouseId;
        Long organizationId;
        String cargoEscheatageId;
        String easWarehouseCode;
        String warehouseStatus;
        String warehouseName;
        List warehouseCodeList;
        AssertUtil.isTrue((null != logicWarehousePageQueryDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Integer queryRelPhysicsWarehouse = null == logicWarehousePageQueryDto.getQueryRelPhysicsWarehouse() ? YesNoEnum.NO.getValue() : logicWarehousePageQueryDto.getQueryRelPhysicsWarehouse();
        logicWarehousePageQueryDto.setQueryRelPhysicsWarehouse(queryRelPhysicsWarehouse);
        QueryWrapper logicWarehouseEoQueryWrapper = new QueryWrapper();
        List warehouseIdList = logicWarehousePageQueryDto.getWarehouseIdList();
        if (StringUtil.isNotBlank((CharSequence)logicWarehousePageQueryDto.getWarehouseClassify())) {
            logicWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)logicWarehousePageQueryDto.getWarehouseClassify());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)warehouseIdList)) {
            logicWarehouseEoQueryWrapper.in((Object)"id", (Collection)warehouseIdList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(warehouseCodeList = logicWarehousePageQueryDto.getWarehouseCodeList()))) {
            logicWarehouseEoQueryWrapper.in((Object)"warehouse_code", (Collection)warehouseCodeList);
        }
        if (StringUtil.isNotBlank((CharSequence)logicWarehousePageQueryDto.getOrganizationCode())) {
            logicWarehouseEoQueryWrapper.eq((Object)"organization_code", (Object)logicWarehousePageQueryDto.getOrganizationCode());
        }
        if (Objects.nonNull(logicWarehousePageQueryDto.getOrganizationId())) {
            logicWarehouseEoQueryWrapper.eq((Object)"organization_id", (Object)logicWarehousePageQueryDto.getOrganizationId());
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseName = logicWarehousePageQueryDto.getWarehouseName()))) {
            logicWarehouseEoQueryWrapper.likeRight((Object)"warehouse_name", (Object)warehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseStatus = logicWarehousePageQueryDto.getWarehouseStatus()))) {
            logicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)warehouseStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(easWarehouseCode = logicWarehousePageQueryDto.getEasWarehouseCode()))) {
            logicWarehouseEoQueryWrapper.eq((Object)"eas_warehouse_code", (Object)easWarehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(cargoEscheatageId = logicWarehousePageQueryDto.getCargoEscheatageId()))) {
            logicWarehouseEoQueryWrapper.eq((Object)"cargo_escheatage_id", (Object)cargoEscheatageId);
        }
        if (null != (organizationId = logicWarehousePageQueryDto.getOrganizationId())) {
            logicWarehouseEoQueryWrapper.eq((Object)"organization_id", (Object)organizationId);
        }
        if (null != (subordinatePhysicsWarehouseId = logicWarehousePageQueryDto.getSubordinatePhysicsWarehouseId())) {
            List<RelWarehouseEo> RelWarehouseEoList = this.queryRelLogicWarehouseInfo(subordinatePhysicsWarehouseId);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(RelWarehouseEoList)) {
                log.info("\u9009\u62e9\u7684\u7269\u7406\u4ed3\u67e5\u8be2\u4e0d\u5230\u5173\u8054\u903b\u8f91\u4ed3\u4fe1\u606f");
                return Lists.newArrayList();
            }
            List logicWarehouseIdList = RelWarehouseEoList.stream().map(RelWarehouseEo::getRefWarehouseId).distinct().collect(Collectors.toList());
            logicWarehouseEoQueryWrapper.in((Object)"id", logicWarehouseIdList);
        }
        if (null != (subordinateLogicWarehouseId = logicWarehousePageQueryDto.getSubordinateLogicWarehouseId())) {
            logicWarehouseEoQueryWrapper.eq((Object)"subordinate_logic_warehouse_id", (Object)subordinateLogicWarehouseId);
        }
        if (StringUtils.isNotBlank((CharSequence)(subordinateLogicWarehouseName = logicWarehousePageQueryDto.getSubordinateLogicWarehouseName()))) {
            logicWarehouseEoQueryWrapper.eq((Object)"subordinate_logic_warehouse_name", (Object)subordinateLogicWarehouseName);
        }
        if (StringUtil.isNotBlank((CharSequence)logicWarehousePageQueryDto.getCode())) {
            logicWarehouseEoQueryWrapper.like((Object)"warehouse_code", (Object)logicWarehousePageQueryDto.getCode());
        }
        if (StringUtil.isNotBlank((CharSequence)logicWarehousePageQueryDto.getName())) {
            logicWarehouseEoQueryWrapper.like((Object)"warehouse_name", (Object)logicWarehousePageQueryDto.getName());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(thirdCodeList = logicWarehousePageQueryDto.getThirdCodeList()))) {
            logicWarehouseEoQueryWrapper.in((Object)"warehouse_corresponding_system", (Collection)thirdCodeList);
        }
        log.info("queryParam===>\u903b\u8f91\u4ed3\u6839\u636e\u53c2\u6570\u8fdb\u884c\u5217\u8868\u67e5\u8be2,logicWarehouseEoQueryWrapper:{}", (Object)logicWarehouseEoQueryWrapper);
        List LogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)logicWarehouseEoQueryWrapper);
        log.info("queryParam===>\u903b\u8f91\u4ed3\u6839\u636e\u53c2\u6570\u8fdb\u884c\u5217\u8868\u67e5\u8be2,LogicWarehouseEoList:{}", (Object)LogicWarehouseEoList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)LogicWarehouseEoList)) {
            return Lists.newArrayList();
        }
        LogicWarehouseEoList.forEach(o -> o.setThirdCode(o.getWarehouseCorrespondingSystem()));
        Map<Long, RelWarehouseEo> RelWarehouseEoMap = this.queryRelPhysicsWarehouseInfo(logicWarehousePageQueryDto, LogicWarehouseEoList);
        ArrayList resultList = Lists.newArrayList();
        for (LogicWarehouseEo LogicWarehouseEo2 : LogicWarehouseEoList) {
            LogicWarehouseRespDto csLogicWarehousePageRespDto = new LogicWarehouseRespDto();
            CubeBeanUtils.copyProperties((Object)csLogicWarehousePageRespDto, (Object)LogicWarehouseEo2, (String[])new String[0]);
            Long logicWarehouseEoId = LogicWarehouseEo2.getId();
            RelWarehouseEo RelWarehouseEo2 = RelWarehouseEoMap.get(logicWarehouseEoId);
            if (null != RelWarehouseEo2) {
                csLogicWarehousePageRespDto.setSubordinatePhysicsWarehouseId(RelWarehouseEo2.getRefWarehouseId());
                csLogicWarehousePageRespDto.setSubordinatePhysicsWarehouseName(RelWarehouseEo2.getRefWarehouseName());
                csLogicWarehousePageRespDto.setSubordinatePhysicsWarehouseCode(RelWarehouseEo2.getRefWarehouseCode());
            }
            resultList.add(csLogicWarehousePageRespDto);
        }
        return resultList;
    }

    @Override
    public LogicWarehouseRespDto queryByCode(String code) {
        LogicWarehousePageQueryDto param = new LogicWarehousePageQueryDto();
        param.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{code}));
        List<LogicWarehouseRespDto> dtos = this.queryParam(param);
        if (CollUtil.isEmpty(dtos)) {
            return null;
        }
        return dtos.get(0);
    }

    private List<RelWarehouseEo> queryRelLogicWarehouseInfo(Long subordinatePhysicsWarehouseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_id", (Object)subordinatePhysicsWarehouseId);
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List RelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)queryWrapper);
        return RelWarehouseEoList;
    }

    private Map<Long, RelWarehouseEo> queryRelPhysicsWarehouseInfo(LogicWarehousePageQueryDto logicWarehousePageQueryDto, List<LogicWarehouseEo> LogicWarehouseEoList) {
        Integer queryRelPhysicsWarehouse = logicWarehousePageQueryDto.getQueryRelPhysicsWarehouse();
        Map<Object, Object> RelWarehouseEoMap = Maps.newHashMap();
        if (YesNoEnum.NO.getValue().equals(queryRelPhysicsWarehouse)) {
            return RelWarehouseEoMap;
        }
        List queryLogicIdList = LogicWarehouseEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        QueryWrapper logicQueryWrapper = new QueryWrapper();
        logicQueryWrapper.in((Object)"warehouse_id", queryLogicIdList);
        logicQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        logicQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        logicQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List RelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)logicQueryWrapper);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)RelWarehouseEoList)) {
            RelWarehouseEoMap = RelWarehouseEoList.stream().collect(Collectors.toMap(eo -> eo.getWarehouseId(), Function.identity()));
        }
        return RelWarehouseEoMap;
    }

    private void validParams(LogicWarehouseDto dto) {
        AssertUtils.isTrue((null != dto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode()), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getWarehouseName()), (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getWarehouseStatus()), (String)"\u4ed3\u5e93\u72b6\u6001\u53c2\u6570\u6709\u8bef");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getWarehouseProperty()), (String)"\u4ed3\u5e93\u4e1a\u52a1\u5c5e\u6027\u53c2\u6570\u6709\u8bef");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getPhysicsWarehouseCode()), (String)"\u6240\u5c5e\u7269\u7406\u4ed3\u53c2\u6570\u6709\u8bef");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getOrganizationCode()), (String)"\u6240\u5c5e\u5e93\u5b58\u7ec4\u7ec7\u53c2\u6570\u6709\u8bef");
        if (null == dto.getId()) {
            LogicWarehouseEo warehouseEo = ((ILogicWarehouseDomain)this.domain).queryByCode(dto.getWarehouseCode());
            AssertUtils.isNull((Object)warehouseEo, (String)"\u8be5\u4ed3\u5e93\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)dto.getEntityWarehouseId())) {
                LogicWarehouseEo queryEo = new LogicWarehouseEo();
                queryEo.setEntityWarehouseId(dto.getEntityWarehouseId());
                List logicWarehouseEoList = ((ILogicWarehouseDomain)this.domain).selectList((BaseEo)queryEo);
                AssertUtils.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isEmpty((Collection)logicWarehouseEoList), (String)String.format("\u5b9e\u4f53\u4ed3\u5e93ID\uff1a %s  \u5df2\u7ecf\u5b58\u5728", dto.getEntityWarehouseId()));
            }
        } else {
            LogicWarehouseEo warehouseEo = ((ILogicWarehouseDomain)this.domain).queryByCode(dto.getWarehouseCode());
            AssertUtils.isTrue((null != warehouseEo ? 1 : 0) != 0, (String)"\u8be5\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728");
            if (StringUtils.isNotEmpty((CharSequence)dto.getEntityWarehouseId()) && !warehouseEo.getEntityWarehouseId().equals(dto.getEntityWarehouseId())) {
                LogicWarehouseEo queryEo = new LogicWarehouseEo();
                queryEo.setEntityWarehouseId(dto.getEntityWarehouseId());
                List logicWarehouseEoList = ((ILogicWarehouseDomain)this.domain).selectList((BaseEo)queryEo);
                AssertUtils.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isEmpty((Collection)logicWarehouseEoList), (String)String.format("\u5b9e\u4f53\u4ed3\u5e93ID\uff1a%s \u5df2\u7ecf\u5b58\u5728", dto.getEntityWarehouseId()));
            }
        }
    }
}

