/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.CommitEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.SimilEffecConfigConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryBatchDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelInventoryBatchTagDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ISimilEffecConfigDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ISimilEffecConfigDomain;
import com.yunxi.dg.base.center.inventory.dto.Schemas.DictExtRespDto;
import com.yunxi.dg.base.center.inventory.dto.Schemas.DictQueryExtReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.SimilEffecConfigDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.SimilEffecConfigDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.SimilEffecConfigDetailEo;
import com.yunxi.dg.base.center.inventory.eo.SimilEffecConfigEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.IAdjustmentOrderService;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderService;
import com.yunxi.dg.base.center.inventory.service.entity.IInventoryBatchService;
import com.yunxi.dg.base.center.inventory.service.entity.ISimilEffecConfigService;
import com.yunxi.dg.base.center.inventory.service.entity.enums.SimilEffecConfigTypeEnum;
import com.yunxi.dg.base.center.inventory.service.entity.enums.SystemTagEnum;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDetailDataQueryHelperImpl;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SimilEffecConfigServiceImpl
extends BaseServiceImpl<SimilEffecConfigDto, SimilEffecConfigEo, ISimilEffecConfigDomain>
implements ISimilEffecConfigService {
    private static final Logger log = LoggerFactory.getLogger(SimilEffecConfigServiceImpl.class);
    @Resource
    private ISimilEffecConfigDetailDomain similEffecConfigDetailDomain;
    @Resource
    private ILogicInventoryDomain logicInventoryDomain;
    @Resource
    private IInventoryBatchService iInventoryBatchService;
    @Resource
    private IInventoryBatchDomain inventoryBatchDomain;
    @Resource
    private IAdjustmentOrderService inventoryStatusAdjustmentOrderServiceImpl;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private ItemDetailDataQueryHelperImpl itemDetailDataQueryHelper;
    @Resource
    private ITransferOrderService transferOrderService;
    @Resource
    private ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Resource
    private IPcpDictQueryApiProxy pcpDictQueryApiProxy;
    @Resource
    private IRelInventoryBatchTagDomain iRelInventoryBatchTagDomain;

    public SimilEffecConfigServiceImpl(ISimilEffecConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SimilEffecConfigDto, SimilEffecConfigEo> converter() {
        return SimilEffecConfigConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Long save(SimilEffecConfigDto dto) {
        SimilEffecConfigEo configEo = (SimilEffecConfigEo)Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ISimilEffecConfigDomain)this.domain).filter().eq((Object)"config_type", (Object)dto.getConfigType())).last("limit 1")).one()).orElse(new SimilEffecConfigEo());
        CubeBeanUtils.copyProperties((Object)configEo, (Object)dto, (String[])new String[0]);
        configEo.setDaysConfig(Integer.valueOf(null != dto.getDaysConfig() ? dto.getDaysConfig() : 0));
        configEo.setItemEffecLabel(null != dto.getItemEffecLabel() && SimilEffecConfigTypeEnum.SIMILAR.getType().equals(dto.getConfigType()) ? dto.getItemEffecLabel() : SystemTagEnum.XQ_LQ.getCode());
        if (null != configEo.getId()) {
            ((ISimilEffecConfigDomain)this.domain).updateSelective((BaseEo)configEo);
        } else {
            ((ISimilEffecConfigDomain)this.domain).insert((BaseEo)configEo);
        }
        List ids = ((ExtQueryChainWrapper)this.similEffecConfigDetailDomain.filter().eq((Object)"config_type", (Object)dto.getConfigType())).list().stream().map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(ids)) {
            this.similEffecConfigDetailDomain.logicDeleteByIds(ids);
        }
        Optional.ofNullable(dto.getDetailDtos()).ifPresent(detailDtos -> {
            detailDtos.forEach(o -> o.setId(null));
            List detailEos = BeanUtil.copyToList((Collection)detailDtos, SimilEffecConfigDetailEo.class);
            this.similEffecConfigDetailDomain.insertBatch(detailEos);
        });
        return configEo.getId();
    }

    @Override
    public SimilEffecConfigDto detail(String configType) {
        SimilEffecConfigDto dto = new SimilEffecConfigDto();
        SimilEffecConfigEo eo = (SimilEffecConfigEo)((ExtQueryChainWrapper)((ISimilEffecConfigDomain)this.domain).filter().eq((Object)"config_type", (Object)configType)).one();
        List detailEos = ((ExtQueryChainWrapper)this.similEffecConfigDetailDomain.filter().eq((Object)"config_type", (Object)configType)).list();
        List detailDtos = BeanUtil.copyToList((Collection)detailEos, SimilEffecConfigDetailDto.class);
        BeanUtil.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
        dto.setDetailDtos(detailDtos);
        return dto;
    }

    @Override
    public Integer executeConfigTask(String configType) {
        SimilEffecConfigEo eo = (SimilEffecConfigEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ISimilEffecConfigDomain)this.domain).filter().eq((Object)"config_type", (Object)configType)).last("limit 1")).one();
        List detailEos = ((ExtQueryChainWrapper)this.similEffecConfigDetailDomain.filter().eq((Object)"config_type", (Object)configType)).list();
        if (CollectionUtil.isEmpty((Collection)detailEos)) {
            log.error("executeConfigTask--->\u672a\u914d\u7f6e\u4ed3\u5e93:{}", (Object)configType);
            return 0;
        }
        List logicWarehouseEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_status", (Object)ValidFlagEnum.ENABLE.getCode())).in((Object)"warehouse_code", (Collection)detailEos.stream().map(SimilEffecConfigDetailEo::getLogicWarehouseCode).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList()))).list();
        List<String> logicWarehouseCodes = logicWarehouseEos.stream().map(LogicWarehouseEo::getWarehouseCode).collect(Collectors.toList());
        InventoryBatchReqDto batchReqDto = new InventoryBatchReqDto();
        batchReqDto.setPageNum(Integer.valueOf(1));
        batchReqDto.setPageSize(Integer.valueOf(100000));
        List inventoryBatchDtos = this.iInventoryBatchService.queryPage(batchReqDto).getList();
        if (SimilEffecConfigTypeEnum.SIMILAR.getType().equals(SimilEffecConfigTypeEnum.getEnum(configType).getType())) {
            List filterList = inventoryBatchDtos.stream().filter(o -> this.similarDateCheck((InventoryBatchDto)o, eo)).collect(Collectors.toList());
            Set sieve = filterList.stream().map(in -> in.getSkuCode() + InventoryConfig.getCommonSeparate() + in.getBatch()).collect(Collectors.toSet());
            List<String> skuCodes = filterList.stream().map(InventoryBatchDto::getSkuCode).collect(Collectors.toList());
            Map<String, ItemSkuDto> itemSkuMap = ((List)Optional.ofNullable(this.itemDataQueryHelper.getByCodes(skuCodes)).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
            List<LogicInventoryEo> resultList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).eq((Object)"inventory_property", (Object)LogicWarehouseQualityEnum.QUALIFIED.getCode())).gt((Object)"available", (Object)BigDecimal.ZERO)).list().stream().filter(r -> sieve.contains(r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch())).collect(Collectors.toList());
            List<LogicInventoryEo> handleList = this.handleAvailableQuantity(resultList, inventoryBatchDtos, logicWarehouseCodes);
            List<Long> orderIds = this.generateInventoryAdjustmentOrder(handleList, itemSkuMap, logicWarehouseEos);
            return orderIds.size();
        }
        if (SimilEffecConfigTypeEnum.EFFECTIVE.getType().equals(SimilEffecConfigTypeEnum.getEnum(configType).getType())) {
            List filterList = inventoryBatchDtos.stream().filter(dto -> this.effectiveDateCheck((InventoryBatchDto)dto, eo)).collect(Collectors.toList());
            Set sieve = filterList.stream().map(in -> in.getSkuCode() + InventoryConfig.getCommonSeparate() + in.getBatch()).collect(Collectors.toSet());
            List batches = filterList.stream().map(InventoryBatchDto::getBatch).collect(Collectors.toList());
            List<String> skuCodes = filterList.stream().map(InventoryBatchDto::getSkuCode).collect(Collectors.toList());
            Map<String, DgItemSkuDetailRespDto> itemMap = ((List)Optional.ofNullable(this.itemDetailDataQueryHelper.getByCodes(skuCodes)).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
            List<LogicInventoryEo> resultList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).in((Object)"batch", batches)).eq((Object)"inventory_property", (Object)LogicWarehouseQualityEnum.QUALIFIED.getCode())).gt((Object)"available", (Object)BigDecimal.ZERO)).list().stream().filter(r -> sieve.contains(r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch())).collect(Collectors.toList());
            List<LogicInventoryEo> handleList = this.handleAvailableQuantity(resultList, inventoryBatchDtos, logicWarehouseCodes);
            List<Long> orderIds = this.generateTransferOrder(handleList, itemMap, logicWarehouseEos);
            return orderIds.size();
        }
        return 0;
    }

    private List<Long> generateTransferOrder(List<LogicInventoryEo> resultList, Map<String, DgItemSkuDetailRespDto> itemMap, List<LogicWarehouseEo> outLogicWarehouseEos) {
        if (CollectionUtil.isEmpty(resultList)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> orderIds = new ArrayList<Long>();
        DictQueryExtReqDto dictQueryReqDto = new DictQueryExtReqDto();
        dictQueryReqDto.setGroupCodes(Collections.singletonList("item_storage"));
        dictQueryReqDto.setCodes(Collections.singletonList("item_storage"));
        Map itemStorageMap = this.pcpDictQueryApiProxy.queryByParam(dictQueryReqDto).stream().collect(Collectors.toMap(DictExtRespDto::getSubValue, Function.identity(), (k1, k2) -> k1));
        Map<String, List<LogicInventoryEo>> logicInventoryEoMap = resultList.stream().collect(Collectors.groupingBy(LogicInventoryEo::getWarehouseCode));
        Map outLogicWarehouseEoMap = outLogicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Set filterKeys = outLogicWarehouseEos.stream().map(o -> o.getPhysicsWarehouseCode() + InventoryConfig.getCommonSeparate() + o.getOrganizationCode()).collect(Collectors.toSet());
        List physicsWarehouseCodes = outLogicWarehouseEos.stream().map(LogicWarehouseEo::getPhysicsWarehouseCode).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        List inLogicWarehouseEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"physics_warehouse_code", physicsWarehouseCodes)).eq((Object)"warehouse_quality", (Object)LogicWarehouseQualityEnum.PENDING.getCode())).eq((Object)"warehouse_status", (Object)ValidFlagEnum.ENABLE.getCode())).orderByDesc((Object)"create_time")).list().stream().filter(eo -> filterKeys.contains(eo.getPhysicsWarehouseCode() + InventoryConfig.getCommonSeparate() + eo.getOrganizationCode())).collect(Collectors.toList());
        Map inLogicWarehouseEoMap = inLogicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getPhysicsWarehouseCode, Function.identity(), (k1, k2) -> k1));
        logicInventoryEoMap.forEach((k, v) -> {
            LogicWarehouseEo outLogicWarehouseEo = (LogicWarehouseEo)outLogicWarehouseEoMap.get(k);
            if (Objects.isNull(outLogicWarehouseEo)) {
                log.error("\u4e34\u671f\u81ea\u52a8\u8c03\u62e8\u51fa\u4ed3\u5f02\u5e38:{}", k);
                return;
            }
            LogicWarehouseEo inLogicWarehouseEo = (LogicWarehouseEo)inLogicWarehouseEoMap.get(outLogicWarehouseEo.getPhysicsWarehouseCode());
            if (Objects.isNull(inLogicWarehouseEo)) {
                log.error("\u4e34\u671f\u81ea\u52a8\u8c03\u62e8\u5165\u4ed3\u5f02\u5e38:{}", (Object)outLogicWarehouseEo.getPhysicsWarehouseCode());
                return;
            }
            TransferOrderComboReqDto reqDto = new TransferOrderComboReqDto();
            TransferOrderReqDto orderReqDto = new TransferOrderReqDto();
            reqDto.setCommitType(CommitEnum.COMMIT.code());
            orderReqDto.setType(TransferOrderTypeEnum.NEAR_EXPIRY_PRODUCT_TRANSFER.getCode());
            orderReqDto.setBizDate(new Date());
            orderReqDto.setRemark("\u4e34\u671f\u81ea\u52a8\u8c03\u62e8");
            orderReqDto.setInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
            orderReqDto.setIsVirtual(Integer.valueOf(1));
            orderReqDto.setOutLogicWarehouseCode(outLogicWarehouseEo.getWarehouseCode());
            orderReqDto.setOutLogicWarehouseName(outLogicWarehouseEo.getWarehouseName());
            orderReqDto.setOutOrganizationCode(outLogicWarehouseEo.getOrganizationCode());
            orderReqDto.setOutOrganization(outLogicWarehouseEo.getOrganizationName());
            orderReqDto.setOutPhysicsWarehouseCode(outLogicWarehouseEo.getPhysicsWarehouseCode());
            orderReqDto.setOutPhysicsWarehouseName(outLogicWarehouseEo.getPhysicsWarehouseName());
            orderReqDto.setInLogicWarehouseCode(inLogicWarehouseEo.getWarehouseCode());
            orderReqDto.setInLogicWarehouseName(inLogicWarehouseEo.getWarehouseName());
            orderReqDto.setInPhysicsWarehouseCode(inLogicWarehouseEo.getPhysicsWarehouseCode());
            orderReqDto.setInPhysicsWarehouseName(inLogicWarehouseEo.getPhysicsWarehouseName());
            orderReqDto.setInOrganizationCode(inLogicWarehouseEo.getOrganizationCode());
            orderReqDto.setInOrganization(inLogicWarehouseEo.getOrganizationName());
            reqDto.setTransferOrderReqDto(orderReqDto);
            reqDto.setDetailList(v.stream().map(o -> {
                TransferOrderDetailReqDto detailReqDto = new TransferOrderDetailReqDto();
                detailReqDto.setSkuCode(o.getSkuCode());
                detailReqDto.setSkuName(o.getSkuName());
                detailReqDto.setBatch(o.getBatch());
                detailReqDto.setInventoryProperty(o.getInventoryProperty());
                detailReqDto.setQuantity(o.getAvailable());
                detailReqDto.setProduceTime(o.getProduceTime());
                detailReqDto.setExpireTime(o.getExpireTime());
                Optional.ofNullable(itemMap.get(o.getSkuCode())).ifPresent(i -> {
                    detailReqDto.setUnit(i.getUnit());
                    detailReqDto.setVolume(i.getVolume());
                    detailReqDto.setWeight(i.getGrossWeight());
                    if (null != i.getStorage() && Objects.nonNull(itemStorageMap.get(String.valueOf(i.getStorage())))) {
                        detailReqDto.setStorageCondition(((DictExtRespDto)itemStorageMap.get(String.valueOf(i.getStorage()))).getSubValue());
                        detailReqDto.setStorageConditionName(((DictExtRespDto)itemStorageMap.get(String.valueOf(i.getStorage()))).getSubLabel());
                    }
                });
                if (InventoryConfig.isEnableUnit() && StringUtils.isBlank((CharSequence)detailReqDto.getUnit())) {
                    return null;
                }
                return detailReqDto;
            }).collect(Collectors.toList()));
            try {
                if (CollectionUtil.isNotEmpty((Collection)reqDto.getDetailList())) {
                    Long orderId = (Long)RestResponseHelper.extractData(this.transferOrderService.add(reqDto));
                    orderIds.add(orderId);
                }
            }
            catch (Exception e) {
                log.error("\u4e34\u671f\u81ea\u52a8\u8c03\u62e8\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        });
        return orderIds;
    }

    private List<Long> generateInventoryAdjustmentOrder(List<LogicInventoryEo> resultList, Map<String, ItemSkuDto> itemSkuMap, List<LogicWarehouseEo> logicWarehouseEos) {
        if (CollectionUtil.isEmpty(resultList)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> orderIds = new ArrayList<Long>();
        Map<String, List<LogicInventoryEo>> logicInventoryEoMap = resultList.stream().collect(Collectors.groupingBy(LogicInventoryEo::getWarehouseCode));
        Map warehouseMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (o, o1) -> o));
        logicInventoryEoMap.forEach((k, v) -> {
            LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)warehouseMap.get(k);
            if (Objects.isNull(logicWarehouseEo)) {
                log.error("\u4e34\u671f\u81ea\u52a8\u51bb\u7ed3\u4ed3\u5e93\u5f02\u5e38:{}", k);
                return;
            }
            AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
            adjustmentOrderDto.setBusinessType(AdjustmentBusinessTypeEnum.INVENTORY_STATUS_ADJUSTMENT.getType());
            adjustmentOrderDto.setBizDate(new Date());
            adjustmentOrderDto.setWarehouseCode(logicWarehouseEo.getWarehouseCode());
            adjustmentOrderDto.setOrderType(AdjustmentOrderTypeEnum.BATCH_ADJUSTMENT.getType());
            adjustmentOrderDto.setWarehouseName(logicWarehouseEo.getWarehouseName());
            adjustmentOrderDto.setOrganizationCode(logicWarehouseEo.getOrganizationCode());
            adjustmentOrderDto.setOrganizationName(logicWarehouseEo.getOrganizationName());
            adjustmentOrderDto.setInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
            adjustmentOrderDto.setNewInventoryProperty(LogicWarehouseQualityEnum.FREEZE.getCode());
            adjustmentOrderDto.setPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
            adjustmentOrderDto.setPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
            adjustmentOrderDto.setEvent(DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS.getKey());
            adjustmentOrderDto.setRemark("\u4e34\u671f\u81ea\u52a8\u51bb\u7ed3");
            adjustmentOrderDto.setAdjustmentOrderDetailDtos(v.stream().map(o -> {
                AdjustmentOrderDetailDto adjustmentOrderDetailDto = new AdjustmentOrderDetailDto();
                adjustmentOrderDetailDto.setSkuCode(o.getSkuCode());
                adjustmentOrderDetailDto.setSkuName(o.getSkuName());
                adjustmentOrderDetailDto.setBatch(o.getBatch());
                adjustmentOrderDetailDto.setOrigBatch(o.getBatch());
                adjustmentOrderDetailDto.setOrigExpireTime(o.getExpireTime());
                adjustmentOrderDetailDto.setOrigProduceTime(o.getProduceTime());
                adjustmentOrderDetailDto.setInventoryProperty(o.getInventoryProperty());
                adjustmentOrderDetailDto.setNewInventoryProperty(LogicWarehouseQualityEnum.FREEZE.getCode());
                adjustmentOrderDetailDto.setExpireTime(o.getExpireTime());
                adjustmentOrderDetailDto.setProduceTime(o.getProduceTime());
                adjustmentOrderDetailDto.setChangeQuantity(o.getAvailable());
                Optional.ofNullable(itemSkuMap.get(o.getSkuCode())).ifPresent(r -> {
                    adjustmentOrderDetailDto.setUnit(r.getUnit());
                    adjustmentOrderDetailDto.setSpuName(r.getSpuName());
                    adjustmentOrderDetailDto.setSpuCode(r.getSpuCode());
                });
                if (InventoryConfig.isEnableUnit() && StringUtils.isBlank((CharSequence)adjustmentOrderDetailDto.getUnit())) {
                    return null;
                }
                return adjustmentOrderDetailDto;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
            try {
                if (CollectionUtil.isNotEmpty((Collection)adjustmentOrderDto.getAdjustmentOrderDetailDtos())) {
                    orderIds.add(this.inventoryStatusAdjustmentOrderServiceImpl.addAdjustmentOrder(adjustmentOrderDto));
                }
            }
            catch (Exception e) {
                log.error("\u4e34\u671f\u81ea\u52a8\u51bb\u7ed3\u6267\u884c\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        });
        return orderIds;
    }

    private List<LogicInventoryEo> handleAvailableQuantity(List<LogicInventoryEo> resultList, List<InventoryBatchDto> inventoryBatchDtos, List<String> logicWarehouseCodes) {
        if (CollectionUtil.isEmpty(resultList)) {
            return new ArrayList<LogicInventoryEo>();
        }
        Set skuCodes = resultList.stream().map(LogicInventoryEo::getSkuCode).collect(Collectors.toSet());
        List inventoryTotalEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryTotalDomain.filter().in((Object)"sku_code", skuCodes)).in((Object)"warehouse_code", logicWarehouseCodes)).eq((Object)"inventory_property", (Object)LogicWarehouseQualityEnum.QUALIFIED.getCode())).list();
        Map inventoryTotalEoMap = inventoryTotalEos.stream().collect(Collectors.toMap(t -> t.getSkuCode() + InventoryConfig.getCommonSeparate() + t.getWarehouseCode() + InventoryConfig.getCommonSeparate() + t.getInventoryProperty(), Function.identity(), (k1, k2) -> k1));
        Map inventoryBatchDtoMap = inventoryBatchDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + InventoryConfig.getCommonSeparate() + o.getBatch(), Function.identity(), (k1, k2) -> k1));
        resultList.forEach(r -> {
            InventoryBatchDto inventoryBatchDto = (InventoryBatchDto)inventoryBatchDtoMap.get(r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch());
            r.setExpireTime(inventoryBatchDto.getExpireTime());
            r.setProduceTime(inventoryBatchDto.getProduceTime());
        });
        Map<String, List<LogicInventoryEo>> logicInventoryEoGroupMap = resultList.stream().collect(Collectors.groupingBy(o -> o.getSkuCode() + InventoryConfig.getCommonSeparate() + o.getWarehouseCode() + InventoryConfig.getCommonSeparate() + o.getInventoryProperty()));
        return logicInventoryEoGroupMap.entrySet().stream().flatMap(e -> {
            String k = (String)e.getKey();
            List v = (List)e.getValue();
            LogicInventoryTotalEo inventoryTotalEo = (LogicInventoryTotalEo)inventoryTotalEoMap.get(k);
            BigDecimal totalAvailable = inventoryTotalEo.getAvailable();
            BigDecimal reduce = v.stream().filter(o -> Objects.nonNull(o.getAvailable())).map(LogicInventoryEo::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimalUtils.gt((BigDecimal)reduce, (BigDecimal)totalAvailable).booleanValue()) {
                Collections.sort(v, Comparator.comparing(LogicInventoryEo::getExpireTime).reversed());
                BigDecimal[] subtract = new BigDecimal[]{BigDecimalUtils.subtract((BigDecimal)reduce, (BigDecimal)totalAvailable)};
                return v.stream().peek(r -> {
                    if (BigDecimalUtils.leZero((BigDecimal)subtract[0]).booleanValue()) {
                        return;
                    }
                    if (BigDecimalUtils.gt((BigDecimal)subtract[0], (BigDecimal)r.getAvailable()).booleanValue()) {
                        r.setAvailable(BigDecimal.ZERO);
                        subtract[0] = BigDecimalUtils.subtract((BigDecimal)subtract[0], (BigDecimal)r.getAvailable());
                    } else {
                        r.setAvailable(BigDecimalUtils.subtract((BigDecimal)r.getAvailable(), (BigDecimal)subtract[0]));
                        subtract[0] = BigDecimal.ZERO;
                    }
                }).filter(r -> BigDecimalUtils.gtZero((BigDecimal)r.getAvailable()));
            }
            return v.stream();
        }).collect(Collectors.toList());
    }

    private boolean effectiveDateCheck(InventoryBatchDto dto, SimilEffecConfigEo eo) {
        if (Objects.isNull(dto.getProduceTime()) || Objects.isNull(dto.getExpireTime())) {
            return false;
        }
        long total = SimilEffecConfigServiceImpl.calculateDaysBetween(dto.getProduceTime(), dto.getExpireTime());
        BigDecimal effecRatio = eo.getItemEffecRatio();
        Integer daysConfig = Optional.ofNullable(eo.getDaysConfig()).orElse(0);
        BigDecimal calcResult = BigDecimal.valueOf(total).multiply(effecRatio).divide(BigDecimal.valueOf(100L), 6, 0).add(BigDecimal.valueOf(daysConfig.longValue()));
        BigDecimal residue = BigDecimal.valueOf(SimilEffecConfigServiceImpl.calculateDaysBetween(new Date(), dto.getExpireTime()));
        return BigDecimalUtils.ge((BigDecimal)calcResult, (BigDecimal)residue);
    }

    private boolean similarDateCheck(InventoryBatchDto dto, SimilEffecConfigEo eo) {
        if (CollectionUtil.isEmpty((Collection)dto.getExpiryDateTagList())) {
            return false;
        }
        List relInventoryBatchTagEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iRelInventoryBatchTagDomain.filter().eq((Object)"sku_code", (Object)dto.getSkuCode())).eq((Object)"batch", (Object)dto.getBatch())).list();
        AtomicLong calc = new AtomicLong();
        relInventoryBatchTagEoList.stream().filter(o -> eo.getItemEffecLabel().equals(o.getTagCode())).findFirst().ifPresent(o -> calc.set(SimilEffecConfigServiceImpl.calculateDaysBetween(o.getEffectiveTime(), o.getFailureTime())));
        if ("XQ_GQ".equals(eo.getItemEffecLabel())) {
            calc.set(0L);
        }
        Integer daysConfig = eo.getDaysConfig();
        long residue = SimilEffecConfigServiceImpl.calculateDaysBetween(new Date(), dto.getExpireTime());
        return calc.get() + (long)daysConfig.intValue() >= residue;
    }

    private static long calculateDaysBetween(Date startDate, Date endDate) {
        LocalDate start = SimilEffecConfigServiceImpl.converterLocalDate(startDate);
        LocalDate end = SimilEffecConfigServiceImpl.converterLocalDate(endDate);
        return ChronoUnit.DAYS.between(start, end);
    }

    private static LocalDate converterLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDate();
    }
}

