/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.holdMerge.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.SpringBeanUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsOutNoticePushStatusEnum;
import com.yunxi.dg.base.center.enums.MergeStrategyConfigStatusEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.MergeOrderStrategyConfigConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IMergeOrderStrategyConfigDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IMergeStrategyConfigDetailDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.HoldMergeStrategyConfigEnumDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MergeOrderStrategyConfigDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MergeOrderStrategyConfigPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MergeStrategyConfigDetailDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.MergeStrategyConfigEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderDocumentTypeEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutNoticeOrderService;
import com.yunxi.dg.base.center.inventory.service.holdMerge.IMergeStrategyConfigDetailService;
import com.yunxi.dg.base.center.inventory.service.holdMerge.IMergeStrategyConfigService;
import com.yunxi.dg.base.center.inventory.service.holdMerge.MergeOrderNoticeVo;
import com.yunxi.dg.base.center.inventory.service.holdMerge.MergeStrategyConfigInOutNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.service.holdMerge.MergeStrategyConfigMidDto;
import com.yunxi.dg.base.center.inventory.service.utils.ExtensionUtil;
import com.yunxi.dg.base.center.inventory.service.utils.SendMqHelper;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.report.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.report.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.report.proxy.query.IDgTobShopQueryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MergeStrategyConfigServiceImpl
extends BaseServiceImpl<MergeOrderStrategyConfigDto, MergeStrategyConfigEo, IMergeOrderStrategyConfigDomain>
implements IMergeStrategyConfigService {
    private static final Logger log = LoggerFactory.getLogger(MergeStrategyConfigServiceImpl.class);
    @Resource
    GenerateCodeUtil generateCodeUtil;
    @Resource
    private IMergeStrategyConfigDetailService mergeStrategyConfigDetailService;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IInOutNoticeOrderService inOutNoticeOrderService;
    @Resource
    private IDgTobShopQueryApiProxy dgTobShopQueryApiProxy;
    @Resource
    private IBaseOrderAddressDomain baseOrderAddressDomain;
    @Resource
    private IMergeStrategyConfigDetailDomain iMergeStrategyConfigDetailDomain;
    @Resource
    private SendMqHelper sendMqHelper;

    public MergeStrategyConfigServiceImpl(IMergeOrderStrategyConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<MergeOrderStrategyConfigDto, MergeStrategyConfigEo> converter() {
        return MergeOrderStrategyConfigConverter.INSTANCE;
    }

    @Override
    public Long addMergeStrategyConfig(MergeOrderStrategyConfigDto dto) {
        this.check(dto);
        dto.setStrategyCode(this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.MERGE_STRATEGY_CONFIG.getCode())));
        MergeStrategyConfigEo eo = (MergeStrategyConfigEo)this.converter().toEo((BaseDto)dto);
        ((IMergeOrderStrategyConfigDomain)this.domain).insert((BaseEo)eo);
        dto.getMergeStrategyConfigDetailDtos().forEach(detail -> {
            detail.setStrategyId(eo.getId());
            detail.setStrategyCode(dto.getStrategyCode());
        });
        this.mergeStrategyConfigDetailService.insertBatch(dto.getMergeStrategyConfigDetailDtos());
        return eo.getId();
    }

    @Override
    public Long updateMergeStrategyConfig(MergeOrderStrategyConfigDto dto) {
        this.check(dto);
        MergeStrategyConfigEo eo = (MergeStrategyConfigEo)this.converter().toEo((BaseDto)dto);
        ((IMergeOrderStrategyConfigDomain)this.domain).update((BaseEo)eo);
        this.mergeStrategyConfigDetailService.deleteMergeStrategyConfigDetailByStrategId(eo.getId());
        dto.getMergeStrategyConfigDetailDtos().forEach(detail -> {
            detail.setStrategyId(eo.getId());
            detail.setStrategyCode(dto.getStrategyCode());
        });
        this.mergeStrategyConfigDetailService.insertBatch(dto.getMergeStrategyConfigDetailDtos());
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void mergeOutNoticeOrder() {
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dr", (Object)YesNoEnum.NO.getValue())).eq((Object)"order_status", (Object)BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode())).eq((Object)"push_status", (Object)CsOutNoticePushStatusEnum.WAITING.getCode())).eq((Object)"order_type", (Object)"out")).eq((Object)"document_type", (Object)BaseOrderDocumentTypeEnum.COMMON.getCode())).lt((Object)"push_time", (Object)new Date()));
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderEos)) {
            return;
        }
        Map<String, List<BaseOrderAddressEo>> map = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().in((Object)"document_no", (Collection)inOutNoticeOrderEos.stream().map(InOutNoticeOrderEo::getRelevanceNo).collect(Collectors.toSet()))).eq((Object)"contacts_type", (Object)"consignee")).list().stream().collect(Collectors.groupingBy(BaseOrderAddressEo::getDocumentNo));
        inOutNoticeOrderEos.forEach(r -> r.setBaseOrderAddressEoList((List)map.get(r.getRelevanceNo())));
        ArrayList<InOutNoticeOrderEo> passInOutNoticeOrderEos = new ArrayList<InOutNoticeOrderEo>();
        List<MergeStrategyConfigInOutNoticeOrderDto> failInOutNoticeOrderEos = new ArrayList<MergeStrategyConfigInOutNoticeOrderDto>();
        Map<String, MergeStrategyConfigMidDto> mergeStrategyConfigMidDtoMap = this.hitRules(inOutNoticeOrderEos, passInOutNoticeOrderEos);
        List<Map<String, List<MergeStrategyConfigInOutNoticeOrderDto>>> inOutNoticeOrderMap = this.adapterRules(mergeStrategyConfigMidDtoMap);
        this.mergeInOutNoticeOrder(inOutNoticeOrderMap, passInOutNoticeOrderEos, failInOutNoticeOrderEos);
        this.pushWms(passInOutNoticeOrderEos, failInOutNoticeOrderEos);
        log.info("\u5339\u914d\u5408\u5355\u5931\u8d25\u7684\u5355\u636e:{}", (Object)JSONUtil.toJsonStr(failInOutNoticeOrderEos));
        failInOutNoticeOrderEos = failInOutNoticeOrderEos.stream().filter(r -> Objects.isNull(r.getClosingTimeConfig()) || !r.getClosingTimeConfig().match(new Date())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(failInOutNoticeOrderEos)) {
            List<MergeStrategyConfigInOutNoticeOrderDto> finalFailInOutNoticeOrderEos = failInOutNoticeOrderEos;
            InventoryConfig.registerSynchronizationAfterCommit(() -> {
                MergeOrderNoticeVo mergeOrderNoticeVo = new MergeOrderNoticeVo();
                mergeOrderNoticeVo.setOptType("mergeFail");
                mergeOrderNoticeVo.setRelevanceOrderNos(finalFailInOutNoticeOrderEos.stream().map(InOutNoticeOrderEo::getRelevanceNo).distinct().collect(Collectors.toList()));
                this.sendMqHelper.sendPublishMq(mergeOrderNoticeVo, "NOTICE_MERGE_TAG");
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void updateMergeStrategyConfigOrderStatus(List<Long> ids, String status) {
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)status), (String)"\u66f4\u65b0\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((null != ValidFlagEnum.getByCode((String)status) ? 1 : 0) != 0, (String)"\u7b56\u7565\u72b6\u6001\u503c\u4e0d\u7b26\u5408\u8981\u6c42");
        ((IMergeOrderStrategyConfigDomain)this.domain).updateMergeStrategyConfigOrderStatus(ids, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void deleteMergeStrategyConfig(List<Long> ids) {
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(id -> ((IMergeOrderStrategyConfigDomain)this.domain).deleteById(id));
    }

    @Override
    public List<InOutNoticeOrderDto> mergeOutNoticeOrderByDocumentNos(List<String> documentNos) {
        return null;
    }

    @Override
    public MergeOrderStrategyConfigDto queryId(Long id) {
        MergeStrategyConfigEo mergeStrategyConfigEo = (MergeStrategyConfigEo)((IMergeOrderStrategyConfigDomain)this.domain).getMapper().findById(id);
        List strategyConfigDetailEoList = ((ExtQueryChainWrapper)this.iMergeStrategyConfigDetailDomain.filter().eq((Object)"strategy_code", (Object)mergeStrategyConfigEo.getStrategyCode())).list();
        MergeOrderStrategyConfigDto mergeOrderStrategyConfigDto = (MergeOrderStrategyConfigDto)BeanUtil.copyProperties((Object)mergeStrategyConfigEo, MergeOrderStrategyConfigDto.class, (String[])new String[0]);
        List mergeStrategyConfigDetailDtoList = BeanUtil.copyToList((Collection)strategyConfigDetailEoList, MergeStrategyConfigDetailDto.class);
        mergeOrderStrategyConfigDto.setMergeStrategyConfigDetailDtos(mergeStrategyConfigDetailDtoList);
        return mergeOrderStrategyConfigDto;
    }

    @Override
    public PageInfo<MergeOrderStrategyConfigDto> queryPage(MergeOrderStrategyConfigPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IMergeOrderStrategyConfigDomain)this.domain).queryList(dto));
    }

    private void pushWms(List<InOutNoticeOrderEo> passInOutNoticeOrderEos, List<MergeStrategyConfigInOutNoticeOrderDto> failInOutNoticeOrderEos) {
        List<MergeStrategyConfigInOutNoticeOrderDto> noticeOrderDtos = failInOutNoticeOrderEos.stream().filter(r -> Objects.nonNull(r.getClosingTimeConfig()) && r.getClosingTimeConfig().match(new Date())).collect(Collectors.toList());
        passInOutNoticeOrderEos.forEach(inOutNoticeOrderEo -> this.inOutNoticeOrderService.pushWms(inOutNoticeOrderEo.getDocumentNo()));
        noticeOrderDtos.forEach(inOutNoticeOrderEo -> this.inOutNoticeOrderService.pushWms(inOutNoticeOrderEo.getDocumentNo()));
    }

    private void mergeInOutNoticeOrder(List<Map<String, List<MergeStrategyConfigInOutNoticeOrderDto>>> inOutNoticeOrderMapList, List<InOutNoticeOrderEo> passInOutNoticeOrderEos, List<MergeStrategyConfigInOutNoticeOrderDto> failInOutNoticeOrderEos) {
        if (inOutNoticeOrderMapList == null || inOutNoticeOrderMapList.isEmpty()) {
            return;
        }
        if (inOutNoticeOrderMapList.size() == 2) {
            Map<String, List<MergeStrategyConfigInOutNoticeOrderDto>> mainMap = inOutNoticeOrderMapList.get(0);
            Map<String, List<MergeStrategyConfigInOutNoticeOrderDto>> matchMap = inOutNoticeOrderMapList.get(1);
            HashSet processedKeys = new HashSet();
            HashSet processedElements = new HashSet();
            HashSet allProcessedElements = new HashSet();
            if (mainMap.isEmpty()) {
                this.addAllToFailList(matchMap, failInOutNoticeOrderEos);
                return;
            }
            ArrayList pairs = new ArrayList();
            mainMap.forEach((key, mainList) -> {
                processedKeys.add(key);
                Long mergeOrderQuantity = ((MergeStrategyConfigInOutNoticeOrderDto)((Object)((Object)mainList.get(0)))).getMergeOrderQuantity();
                mainList = MergeStrategyConfigServiceImpl.sort(mainList);
                int mainNum = Math.toIntExact(mergeOrderQuantity);
                List<MergeStrategyConfigInOutNoticeOrderDto> matchList = new ArrayList<MergeStrategyConfigInOutNoticeOrderDto>(matchMap.getOrDefault(key, new ArrayList()));
                matchList = MergeStrategyConfigServiceImpl.sort(matchList);
                int subNum = MergeStrategyConfigServiceImpl.getMergeQuantity(matchList).intValue() - mainNum;
                if (subNum == 0) {
                    failInOutNoticeOrderEos.addAll(matchList);
                    failInOutNoticeOrderEos.addAll(MergeStrategyConfigServiceImpl.processTime(mainList));
                    return;
                }
                int mainListSize = mainList.size();
                int matchListSize = matchList.size();
                int left = 0;
                int right = 0;
                while (left < mainListSize || right < matchListSize) {
                    ArrayList<MergeStrategyConfigInOutNoticeOrderDto> waitMergeMainList = new ArrayList<MergeStrategyConfigInOutNoticeOrderDto>();
                    left = MergeStrategyConfigServiceImpl.getNext(mainList, mainNum, left, mainListSize, processedElements, allProcessedElements, waitMergeMainList);
                    ArrayList<MergeStrategyConfigInOutNoticeOrderDto> waitMergeSubList = new ArrayList<MergeStrategyConfigInOutNoticeOrderDto>();
                    right = MergeStrategyConfigServiceImpl.getNext(matchList, subNum, right, matchListSize, processedElements, allProcessedElements, waitMergeSubList);
                    if (CollectionUtils.isEmpty(waitMergeMainList)) {
                        failInOutNoticeOrderEos.addAll(waitMergeSubList);
                        continue;
                    }
                    if (CollectionUtils.isEmpty(waitMergeSubList)) {
                        failInOutNoticeOrderEos.addAll(MergeStrategyConfigServiceImpl.processTime(waitMergeMainList));
                        continue;
                    }
                    pairs.add(new Pair(waitMergeMainList, waitMergeSubList));
                }
            });
            pairs.forEach(pair -> {
                ((List)pair.getKey()).addAll((Collection)pair.getValue());
                this.mergeOrders((List)pair.getKey(), passInOutNoticeOrderEos);
            });
            processedKeys.forEach(matchMap::remove);
            matchMap.forEach((key, list) -> list.removeAll(allProcessedElements));
            mainMap.forEach((key, list) -> {
                list.removeAll(allProcessedElements);
                list.forEach(r -> r.setClosingTimeConfig(new MergeStrategyConfigInOutNoticeOrderDto.ClosingTimeConfig()));
            });
            this.addAllToFailList(matchMap, failInOutNoticeOrderEos);
            this.addAllToFailList(mainMap, failInOutNoticeOrderEos);
        } else {
            Map<String, List<MergeStrategyConfigInOutNoticeOrderDto>> singleMap = inOutNoticeOrderMapList.get(0);
            singleMap.forEach((key, list) -> list.forEach(r -> r.setClosingTimeConfig(new MergeStrategyConfigInOutNoticeOrderDto.ClosingTimeConfig())));
            this.addAllToFailList(singleMap, failInOutNoticeOrderEos);
        }
    }

    @NotNull
    private static List<MergeStrategyConfigInOutNoticeOrderDto> processTime(List<MergeStrategyConfigInOutNoticeOrderDto> mainList) {
        return mainList.stream().peek(r -> r.setClosingTimeConfig(new MergeStrategyConfigInOutNoticeOrderDto.ClosingTimeConfig())).collect(Collectors.toList());
    }

    @NotNull
    private static List<MergeStrategyConfigInOutNoticeOrderDto> sort(List<MergeStrategyConfigInOutNoticeOrderDto> mainList) {
        return mainList.stream().peek(r -> r.setPayTime((Date)ObjectUtils.defaultIfNull((Object)r.getPayTime(), (Object)r.getCreateTime()))).sorted(Comparator.comparing(InOutNoticeOrderEo::getPayTime)).collect(Collectors.toList());
    }

    private static int getNext(List<MergeStrategyConfigInOutNoticeOrderDto> list, int num, int start, int listSize, Set<String> processedElements, Set<MergeStrategyConfigInOutNoticeOrderDto> allPre, List<MergeStrategyConfigInOutNoticeOrderDto> waitMergeList) {
        int i = 0;
        while (i < num && start < listSize) {
            MergeStrategyConfigInOutNoticeOrderDto element = list.get(start);
            ++start;
            if (!processedElements.add(element.getDocumentNo())) continue;
            waitMergeList.add(element);
            allPre.add(element);
            ++i;
        }
        return start;
    }

    private void mergeOrders(List<MergeStrategyConfigInOutNoticeOrderDto> orders, List<InOutNoticeOrderEo> passInOutNoticeOrderEos) {
        try {
            ((MergeStrategyConfigServiceImpl)SpringBeanUtil.getBean(MergeStrategyConfigServiceImpl.class)).doMergeInOutNoticeOrder(orders, passInOutNoticeOrderEos);
        }
        catch (Exception e) {
            log.error("Error merging orders", (Throwable)e);
        }
    }

    private void createPairs(List<Pair<List<MergeStrategyConfigInOutNoticeOrderDto>, List<MergeStrategyConfigInOutNoticeOrderDto>>> pairs, List<List<MergeStrategyConfigInOutNoticeOrderDto>> mainList, List<List<MergeStrategyConfigInOutNoticeOrderDto>> matchList, List<MergeStrategyConfigInOutNoticeOrderDto> failInOutNoticeOrderEos) {
        int size = Math.max(mainList.size(), matchList.size());
        for (int i = 0; i < size; ++i) {
            if (i >= mainList.size()) {
                failInOutNoticeOrderEos.addAll((Collection<MergeStrategyConfigInOutNoticeOrderDto>)matchList.get(i));
                continue;
            }
            if (i >= matchList.size()) {
                failInOutNoticeOrderEos.addAll((Collection<MergeStrategyConfigInOutNoticeOrderDto>)mainList.get(i));
                continue;
            }
            pairs.add((Pair<List<MergeStrategyConfigInOutNoticeOrderDto>, List<MergeStrategyConfigInOutNoticeOrderDto>>)new Pair(mainList.get(i), matchList.get(i)));
        }
    }

    private void addAllToFailList(Map<String, List<MergeStrategyConfigInOutNoticeOrderDto>> map, List<MergeStrategyConfigInOutNoticeOrderDto> failInOutNoticeOrderEos) {
        map.forEach((key, value) -> failInOutNoticeOrderEos.addAll((Collection<MergeStrategyConfigInOutNoticeOrderDto>)value));
    }

    private static Long getMergeQuantity(List<MergeStrategyConfigInOutNoticeOrderDto> configInOutNoticeOrderDtos) {
        return Optional.of(configInOutNoticeOrderDtos).filter(CollectionUtils::isNotEmpty).map(r -> ((MergeStrategyConfigInOutNoticeOrderDto)((Object)((Object)r.get(0)))).getMergeOrderAllQuantity()).orElse(1L);
    }

    public static <T> List<List<T>> splitList(List<T> list, int chunkSize) {
        if (chunkSize <= 0 || CollectionUtils.isEmpty(list)) {
            return new ArrayList<List<T>>();
        }
        int listSize = list.size();
        int numChunks = (listSize + chunkSize - 1) / chunkSize;
        return IntStream.range(0, numChunks).mapToObj(i -> list.subList(i * chunkSize, Math.min(listSize, (i + 1) * chunkSize))).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void doMergeInOutNoticeOrder(List<MergeStrategyConfigInOutNoticeOrderDto> eoList, List<InOutNoticeOrderEo> passInOutNoticeOrderEos) {
        String documentNo = this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.MERGE_OUT_NOTICE_ORDER.getCode()));
        BigDecimal totalQuantity = eoList.stream().map(InOutNoticeOrderEo::getTotalQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCartons = eoList.stream().map(InOutNoticeOrderEo::getTotalCartons).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal mergeQuantity = eoList.stream().map(InOutNoticeOrderEo::getMergeQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        List documentNos = eoList.stream().map(InOutNoticeOrderEo::getDocumentNo).collect(Collectors.toList());
        MergeStrategyConfigInOutNoticeOrderDto mergeStrategyConfigInOutNoticeOrderDto = this.getBaseMergeStrategyConfigInOutNoticeOrderDto(eoList, documentNo, totalQuantity, totalCartons, mergeQuantity);
        this.matchLogistics(eoList, mergeStrategyConfigInOutNoticeOrderDto);
        InOutNoticeOrderEo inOutNoticeOrderEo = new InOutNoticeOrderEo();
        BeanUtils.copyProperties((Object)((Object)mergeStrategyConfigInOutNoticeOrderDto), (Object)inOutNoticeOrderEo);
        List baseOrderAddressEoList = ((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)mergeStrategyConfigInOutNoticeOrderDto.getRelevanceNo())).list();
        List inOutNoticeOrderDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().in((Object)"document_no", documentNos)).eq((Object)"dr", (Object)YesNoEnum.NO.getValue())).list();
        Map noticeOrderEoMap = eoList.stream().collect(Collectors.toMap(InOutNoticeOrderEo::getDocumentNo, Function.identity()));
        inOutNoticeOrderDetailEos.forEach(detail -> {
            detail.setLineNo(detail.getId());
            detail.setId(null);
            String orgDocumentNo = detail.getDocumentNo();
            detail.setDocumentNo(documentNo);
            MergeStrategyConfigServiceImpl.settingMainOrderInfo(detail, noticeOrderEoMap, orgDocumentNo);
        });
        passInOutNoticeOrderEos.add(inOutNoticeOrderEo);
        this.inOutNoticeOrderDomain.insert((BaseEo)inOutNoticeOrderEo);
        this.inOutNoticeOrderDetailDomain.insertBatch(inOutNoticeOrderDetailEos);
        this.baseOrderAddressDomain.insertBatch(baseOrderAddressEoList.stream().peek(r -> {
            r.setId(null);
            r.setDocumentNo(documentNo);
        }).collect(Collectors.toList()));
        InventoryConfig.registerSynchronizationAfterCommit(() -> {
            MergeOrderNoticeVo mergeOrderNoticeVo = new MergeOrderNoticeVo();
            mergeOrderNoticeVo.setOptType("merge");
            mergeOrderNoticeVo.setRelevanceOrderNos(eoList.stream().map(InOutNoticeOrderEo::getRelevanceNo).distinct().collect(Collectors.toList()));
            mergeOrderNoticeVo.setMergeOrderNo(documentNo);
            this.sendMqHelper.sendPublishMq(mergeOrderNoticeVo, "NOTICE_MERGE_TAG");
        });
        InOutNoticeOrderEo update = new InOutNoticeOrderEo();
        update.setPushStatus(CsOutNoticePushStatusEnum.WITHOUT_PUSH.getCode());
        update.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_OUT.getCode());
        update.setMergeDocumentNo(documentNo);
        this.inOutNoticeOrderDomain.getMapper().update((Object)update, (Wrapper)Wrappers.query((Object)new InOutNoticeOrderEo()).in((Object)"document_no", documentNos));
    }

    @NotNull
    private MergeStrategyConfigInOutNoticeOrderDto getBaseMergeStrategyConfigInOutNoticeOrderDto(List<MergeStrategyConfigInOutNoticeOrderDto> eoList, String documentNo, BigDecimal totalQuantity, BigDecimal totalCartons, BigDecimal mergeQuantity) {
        MergeStrategyConfigInOutNoticeOrderDto mergeStrategyConfigInOutNoticeOrderDto = (MergeStrategyConfigInOutNoticeOrderDto)((Object)BeanUtil.copyProperties((Object)((Object)eoList.get(eoList.size() - 1)), MergeStrategyConfigInOutNoticeOrderDto.class, (String[])new String[0]));
        mergeStrategyConfigInOutNoticeOrderDto.setId(null);
        mergeStrategyConfigInOutNoticeOrderDto.setDocumentNo(documentNo);
        mergeStrategyConfigInOutNoticeOrderDto.setRelevanceNo(documentNo);
        mergeStrategyConfigInOutNoticeOrderDto.setDocumentType(BaseOrderDocumentTypeEnum.MERGE.getCode());
        mergeStrategyConfigInOutNoticeOrderDto.setJumpDocumentType(mergeStrategyConfigInOutNoticeOrderDto.getJumpDocumentType());
        mergeStrategyConfigInOutNoticeOrderDto.setJumpDocumentName(mergeStrategyConfigInOutNoticeOrderDto.getJumpDocumentName());
        mergeStrategyConfigInOutNoticeOrderDto.setDisplayBusinessType(mergeStrategyConfigInOutNoticeOrderDto.getDisplayBusinessType());
        mergeStrategyConfigInOutNoticeOrderDto.setDisplayBusinessName(mergeStrategyConfigInOutNoticeOrderDto.getDisplayBusinessName());
        mergeStrategyConfigInOutNoticeOrderDto.setExternalOrderNo(null);
        mergeStrategyConfigInOutNoticeOrderDto.setPreOrderNo(null);
        mergeStrategyConfigInOutNoticeOrderDto.setOutLogicWarehouseCode("TYHDXNC");
        mergeStrategyConfigInOutNoticeOrderDto.setOutLogicWarehouseName("TYHDXNC");
        mergeStrategyConfigInOutNoticeOrderDto.setOutPhysicsWarehouseCode(mergeStrategyConfigInOutNoticeOrderDto.getOutPhysicsWarehouseCode());
        mergeStrategyConfigInOutNoticeOrderDto.setOutPhysicsWarehouseName(mergeStrategyConfigInOutNoticeOrderDto.getOutPhysicsWarehouseName());
        mergeStrategyConfigInOutNoticeOrderDto.setTotalQuantity(totalQuantity);
        mergeStrategyConfigInOutNoticeOrderDto.setTotalCartons(totalCartons);
        mergeStrategyConfigInOutNoticeOrderDto.setMergeQuantity(mergeQuantity);
        mergeStrategyConfigInOutNoticeOrderDto.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode());
        mergeStrategyConfigInOutNoticeOrderDto.setPushStatus(CsOutNoticePushStatusEnum.WAITING.getCode());
        return mergeStrategyConfigInOutNoticeOrderDto;
    }

    private void matchLogistics(List<MergeStrategyConfigInOutNoticeOrderDto> eoList, MergeStrategyConfigInOutNoticeOrderDto mergeStrategyConfigInOutNoticeOrderDto) {
        Set log = eoList.stream().peek(r -> r.setShipmentEnterpriseCode("16".equals(r.getShippingType()) ? "" : r.getShipmentEnterpriseCode())).map(InOutNoticeOrderEo::getShipmentEnterpriseCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (log.size() == 1) {
            InOutNoticeOrderEo inOutNoticeOrderEo = eoList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getShipmentEnterpriseCode())).findFirst().orElse(new MergeStrategyConfigInOutNoticeOrderDto());
            mergeStrategyConfigInOutNoticeOrderDto.setShipmentEnterpriseCode(inOutNoticeOrderEo.getShipmentEnterpriseCode());
            mergeStrategyConfigInOutNoticeOrderDto.setShipmentEnterpriseName(inOutNoticeOrderEo.getShipmentEnterpriseName());
            mergeStrategyConfigInOutNoticeOrderDto.setShippingType(inOutNoticeOrderEo.getShippingType());
            mergeStrategyConfigInOutNoticeOrderDto.setExtension(inOutNoticeOrderEo.getExtension());
        } else {
            InOutNoticeOrderEo noticeOrderEo = eoList.get(eoList.size() - 1);
            if (StringUtils.isBlank((CharSequence)noticeOrderEo.getShopCode())) {
                return;
            }
            DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
            reqDto.setStoreCodeList((List)Lists.newArrayList((Object[])new String[]{noticeOrderEo.getShopCode()}));
            Optional.ofNullable(this.dgTobShopQueryApiProxy.queryPageShop(reqDto)).map(RestResponseHelper::extractData).map(PageSerializable::getList).filter(CollectionUtils::isNotEmpty).map(r -> (DgShopRespDto)r.get(0)).ifPresent(shopRespDto -> {
                mergeStrategyConfigInOutNoticeOrderDto.setShipmentEnterpriseCode(shopRespDto.getShipmentEnterpriseCode());
                mergeStrategyConfigInOutNoticeOrderDto.setShipmentEnterpriseName(shopRespDto.getShipmentEnterpriseName());
            });
        }
    }

    private static void settingMainOrderInfo(InOutNoticeOrderDetailEo detail, Map<String, InOutNoticeOrderEo> noticeOrderEoMap, String orgDocumentNo) {
        JSONObject jsonObject = ExtensionUtil.parseJson(detail.getExtension());
        InOutNoticeOrderEo noticeOrderEo = noticeOrderEoMap.get(orgDocumentNo);
        Optional.ofNullable(noticeOrderEo).ifPresent(r -> {
            jsonObject.put("orgDocumentNo", (Object)r.getDocumentNo());
            jsonObject.put("orgOutLogicWarehouseCode", (Object)r.getOutLogicWarehouseCode());
            jsonObject.put("orgOrganizationId", (Object)r.getOrganizationId());
            jsonObject.put("orgDisplayBusinessType", (Object)r.getDisplayBusinessType());
        });
        jsonObject.remove((Object)"extension");
        detail.setExtension(jsonObject.toJSONString());
    }

    private List<Map<String, List<MergeStrategyConfigInOutNoticeOrderDto>>> adapterRules(Map<String, MergeStrategyConfigMidDto> mergeStrategyConfigMidDtoMap) {
        ArrayList<Map<String, List<MergeStrategyConfigInOutNoticeOrderDto>>> list = new ArrayList<Map<String, List<MergeStrategyConfigInOutNoticeOrderDto>>>();
        if (null != mergeStrategyConfigMidDtoMap && !mergeStrategyConfigMidDtoMap.isEmpty()) {
            HashMap inOutNoticeOrderMap = new HashMap();
            HashMap matchInOutNoticeOrderMap = new HashMap();
            list.add(inOutNoticeOrderMap);
            list.add(matchInOutNoticeOrderMap);
            mergeStrategyConfigMidDtoMap.forEach((k, v) -> {
                MergeStrategyConfigEo mergeStrategyConfigEo = v.getMergeStrategyConfigEo();
                HoldMergeStrategyConfigEnumDto holdMergeStrategyConfigEnumDto = (HoldMergeStrategyConfigEnumDto)JSONUtil.toBean((String)mergeStrategyConfigEo.getStrategyConfig(), HoldMergeStrategyConfigEnumDto.class);
                v.getInOutNoticeOrderEos().forEach(eo -> {
                    String sb = this.getMergeKey((InOutNoticeOrderEo)eo, holdMergeStrategyConfigEnumDto);
                    if (StringUtils.isNotBlank((CharSequence)sb)) {
                        MergeStrategyConfigInOutNoticeOrderDto mergeStrategyConfigInOutNoticeOrderDto = MergeStrategyConfigServiceImpl.getMergeStrategyConfigInOutNoticeOrderDto(eo, mergeStrategyConfigEo);
                        mergeStrategyConfigInOutNoticeOrderDto.setMergeOrderQuantity(mergeStrategyConfigEo.getMergeMainOrderQuantity());
                        if (inOutNoticeOrderMap.containsKey(sb)) {
                            List mergeStrategyConfigInOutNoticeOrderDtoList = (List)inOutNoticeOrderMap.get(sb);
                            mergeStrategyConfigInOutNoticeOrderDtoList.add(mergeStrategyConfigInOutNoticeOrderDto);
                            inOutNoticeOrderMap.put(sb, mergeStrategyConfigInOutNoticeOrderDtoList);
                        } else {
                            inOutNoticeOrderMap.put(sb, Lists.newArrayList((Object[])new MergeStrategyConfigInOutNoticeOrderDto[]{mergeStrategyConfigInOutNoticeOrderDto}));
                        }
                    }
                });
                v.getLimitInOutNoticeOrderEos().forEach(eo -> {
                    String sb = this.getMergeKey((InOutNoticeOrderEo)eo, holdMergeStrategyConfigEnumDto);
                    if (StringUtils.isNotBlank((CharSequence)sb)) {
                        MergeStrategyConfigInOutNoticeOrderDto mergeStrategyConfigInOutNoticeOrderDto = MergeStrategyConfigServiceImpl.getMergeStrategyConfigInOutNoticeOrderDto(eo, mergeStrategyConfigEo);
                        mergeStrategyConfigInOutNoticeOrderDto.setMergeOrderAllQuantity(mergeStrategyConfigEo.getMergeOrderQuantity());
                        if (matchInOutNoticeOrderMap.containsKey(sb)) {
                            List mergeStrategyConfigInOutNoticeOrderDtoList = (List)matchInOutNoticeOrderMap.get(sb);
                            mergeStrategyConfigInOutNoticeOrderDtoList.add(mergeStrategyConfigInOutNoticeOrderDto);
                            matchInOutNoticeOrderMap.put(sb, mergeStrategyConfigInOutNoticeOrderDtoList);
                        } else {
                            matchInOutNoticeOrderMap.put(sb, Lists.newArrayList((Object[])new MergeStrategyConfigInOutNoticeOrderDto[]{mergeStrategyConfigInOutNoticeOrderDto}));
                        }
                    }
                });
            });
        }
        return list;
    }

    @NotNull
    private static MergeStrategyConfigInOutNoticeOrderDto getMergeStrategyConfigInOutNoticeOrderDto(InOutNoticeOrderEo eo, MergeStrategyConfigEo mergeStrategyConfigEo) {
        MergeStrategyConfigInOutNoticeOrderDto mergeStrategyConfigInOutNoticeOrderDto = new MergeStrategyConfigInOutNoticeOrderDto();
        BeanUtils.copyProperties((Object)eo, (Object)((Object)mergeStrategyConfigInOutNoticeOrderDto));
        mergeStrategyConfigInOutNoticeOrderDto.setStrategyId(mergeStrategyConfigEo.getId());
        mergeStrategyConfigInOutNoticeOrderDto.setStrategyCode(mergeStrategyConfigEo.getStrategyCode());
        mergeStrategyConfigInOutNoticeOrderDto.setStrategyName(mergeStrategyConfigEo.getStrategyName());
        Optional.ofNullable(mergeStrategyConfigEo.getClosingTimeConfig()).filter(StringUtils::isNotEmpty).ifPresent(r -> mergeStrategyConfigInOutNoticeOrderDto.setClosingTimeConfig((MergeStrategyConfigInOutNoticeOrderDto.ClosingTimeConfig)JSONUtil.toBean((String)mergeStrategyConfigEo.getClosingTimeConfig(), MergeStrategyConfigInOutNoticeOrderDto.ClosingTimeConfig.class)));
        return mergeStrategyConfigInOutNoticeOrderDto;
    }

    @NotNull
    private String getMergeKey(InOutNoticeOrderEo eo, HoldMergeStrategyConfigEnumDto holdMergeStrategyConfigEnumDto) {
        StringBuilder sb = new StringBuilder();
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getShop())) {
            sb.append(eo.getShopCode());
        }
        List baseOrderAddressEoList = eo.getBaseOrderAddressEoList();
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getContact()) && CollectionUtils.isNotEmpty((Collection)baseOrderAddressEoList)) {
            sb.append(((BaseOrderAddressEo)baseOrderAddressEoList.get(0)).getContacts());
            sb.append(((BaseOrderAddressEo)baseOrderAddressEoList.get(0)).getPhone());
        }
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getReceiveAddress()) && CollectionUtils.isNotEmpty((Collection)baseOrderAddressEoList)) {
            sb.append(((BaseOrderAddressEo)baseOrderAddressEoList.get(0)).getProvince());
            sb.append(((BaseOrderAddressEo)baseOrderAddressEoList.get(0)).getCity());
            sb.append(((BaseOrderAddressEo)baseOrderAddressEoList.get(0)).getDistrict());
            sb.append(((BaseOrderAddressEo)baseOrderAddressEoList.get(0)).getDetailAddress());
        }
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getLogicWarehouse())) {
            sb.append(eo.getOutLogicWarehouseCode());
        }
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getPhysicsWarehouse())) {
            sb.append(eo.getOutPhysicsWarehouseCode());
        }
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getCustomer()) && CollectionUtils.isNotEmpty((Collection)baseOrderAddressEoList)) {
            sb.append(((BaseOrderAddressEo)baseOrderAddressEoList.get(0)).getCustomerCode());
        }
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getBusiness())) {
            sb.append(eo.getBusinessType());
        }
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getShipmentCode())) {
            sb.append(eo.getShippingCode());
        }
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getShipmentType())) {
            sb.append(eo.getShippingType());
        }
        if (MergeStrategyConfigStatusEnum.YES.getCode().equals(holdMergeStrategyConfigEnumDto.getShop())) {
            sb.append(eo.getShopCode());
        }
        return sb.toString();
    }

    private Map<String, MergeStrategyConfigMidDto> hitRules(List<InOutNoticeOrderEo> inOutNoticeOrderEos, List<InOutNoticeOrderEo> passInOutNoticeOrderEos) {
        HashMap<String, MergeStrategyConfigMidDto> mergeStrategyConfigMidDtoMap = new HashMap<String, MergeStrategyConfigMidDto>();
        Map<String, List<InOutNoticeOrderEo>> inOutNoticeOrderEoMap = inOutNoticeOrderEos.stream().collect(Collectors.groupingBy(eo -> String.join((CharSequence)"__", eo.getOutLogicWarehouseCode(), Optional.ofNullable(eo.getBaseOrderAddressEoList()).filter(CollectionUtils::isNotEmpty).map(r -> ((BaseOrderAddressEo)r.get(0)).getCustomerCode()).orElse(""), eo.getShopCode(), eo.getDisplayBusinessType(), eo.getShippingType())));
        HashSet unMatchKey = new HashSet();
        inOutNoticeOrderEoMap.forEach((k, v) -> {
            try {
                MergeStrategyConfigMidDto mergeStrategyConfigMidDto;
                HoldMergeStrategyConfigEnumDto holdMergeStrategyConfigEnumDto = MergeStrategyConfigServiceImpl.getHoldMergeStrategyConfigEnumDto(v);
                holdMergeStrategyConfigEnumDto.setBusinessType(((InOutNoticeOrderEo)v.get(0)).getDisplayBusinessType());
                holdMergeStrategyConfigEnumDto.setLogisticsTypeLimit(((InOutNoticeOrderEo)v.get(0)).getShippingType());
                List mergeStrategyConfigEos = ((IMergeOrderStrategyConfigDomain)this.domain).queryMergeStrategyConfigByStrategyConfig(holdMergeStrategyConfigEnumDto);
                if (CollectionUtils.isEmpty((Collection)mergeStrategyConfigEos)) {
                    unMatchKey.add(k);
                    return;
                }
                if (mergeStrategyConfigMidDtoMap.containsKey(((MergeStrategyConfigEo)mergeStrategyConfigEos.get(0)).getStrategyCode())) {
                    mergeStrategyConfigMidDto = (MergeStrategyConfigMidDto)mergeStrategyConfigMidDtoMap.get(((MergeStrategyConfigEo)mergeStrategyConfigEos.get(0)).getStrategyCode());
                    mergeStrategyConfigMidDto.getInOutNoticeOrderEos().addAll((Collection<InOutNoticeOrderEo>)v);
                } else {
                    mergeStrategyConfigMidDto = new MergeStrategyConfigMidDto();
                    mergeStrategyConfigMidDto.setMergeStrategyConfigEo((MergeStrategyConfigEo)mergeStrategyConfigEos.get(0));
                    mergeStrategyConfigMidDto.getInOutNoticeOrderEos().addAll((Collection<InOutNoticeOrderEo>)v);
                }
                mergeStrategyConfigMidDtoMap.put(((MergeStrategyConfigEo)mergeStrategyConfigEos.get(0)).getStrategyCode(), mergeStrategyConfigMidDto);
            }
            catch (Exception e) {
                log.info("\u5408\u5355\u5f02\u5e38", (Throwable)e);
            }
        });
        inOutNoticeOrderEoMap.forEach((k, v) -> {
            try {
                HoldMergeStrategyConfigEnumDto holdMergeStrategyConfigEnumDto = MergeStrategyConfigServiceImpl.getHoldMergeStrategyConfigEnumDto(v);
                holdMergeStrategyConfigEnumDto.setLimitBusinessType(((InOutNoticeOrderEo)v.get(0)).getDisplayBusinessType());
                holdMergeStrategyConfigEnumDto.setAssistLogisticsTypeLimit(((InOutNoticeOrderEo)v.get(0)).getShippingType());
                List mergeStrategyConfigEos = ((IMergeOrderStrategyConfigDomain)this.domain).queryMergeStrategyConfigByStrategyConfig(holdMergeStrategyConfigEnumDto);
                if (CollectionUtils.isEmpty((Collection)mergeStrategyConfigEos)) {
                    if (unMatchKey.contains(k)) {
                        passInOutNoticeOrderEos.addAll((Collection<InOutNoticeOrderEo>)v);
                    }
                    return;
                }
                String strategyCode = ((MergeStrategyConfigEo)mergeStrategyConfigEos.get(0)).getStrategyCode();
                if (mergeStrategyConfigMidDtoMap.containsKey(strategyCode)) {
                    MergeStrategyConfigMidDto mergeStrategyConfigMidDto = (MergeStrategyConfigMidDto)mergeStrategyConfigMidDtoMap.get(strategyCode);
                    mergeStrategyConfigMidDto.getLimitInOutNoticeOrderEos().addAll((Collection<InOutNoticeOrderEo>)v);
                    mergeStrategyConfigMidDtoMap.put(strategyCode, mergeStrategyConfigMidDto);
                }
            }
            catch (Exception e) {
                log.info("\u5408\u5355\u5f02\u5e38\u5339\u914d\u5b50\u5355", (Throwable)e);
            }
        });
        return mergeStrategyConfigMidDtoMap;
    }

    @NotNull
    private static HoldMergeStrategyConfigEnumDto getHoldMergeStrategyConfigEnumDto(List<InOutNoticeOrderEo> v) {
        HoldMergeStrategyConfigEnumDto holdMergeStrategyConfigEnumDto = new HoldMergeStrategyConfigEnumDto();
        holdMergeStrategyConfigEnumDto.setWarehouse(v.get(0).getOutLogicWarehouseCode());
        holdMergeStrategyConfigEnumDto.setShopLimit(v.get(0).getShopCode());
        holdMergeStrategyConfigEnumDto.setCustomerLimit(Optional.ofNullable(v.get(0).getBaseOrderAddressEoList()).filter(CollectionUtils::isNotEmpty).map(r -> ((BaseOrderAddressEo)r.get(0)).getCustomerCode()).orElse(""));
        return holdMergeStrategyConfigEnumDto;
    }

    private void check(MergeOrderStrategyConfigDto dto) {
        AssertUtil.isTrue((null != dto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getStrategyName()), (String)"\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getStrategyStatus()), (String)"\u7b56\u7565\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getStrategyConfig()), (String)"\u7b56\u7565\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((null != dto.getMergeOrderQuantity() ? 1 : 0) != 0, (String)"\u5408\u5355\u9650\u5236\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((dto.getMergeOrderQuantity() <= 5L ? 1 : 0) != 0, (String)"\u5408\u5355\u9650\u5236\u6570\u91cf\u4e0d\u80fd\u5fc5\u987b\u5c0f\u4e8e5");
        AssertUtil.isTrue((null != ValidFlagEnum.getByCode((String)dto.getStrategyStatus()) ? 1 : 0) != 0, (String)"\u7b56\u7565\u72b6\u6001\u503c\u4e0d\u7b26\u5408\u8981\u6c42");
    }
}

