/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.listener;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.InOutResultEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.BaseOrderAddressConverter;
import com.yunxi.dg.base.center.inventory.convert.entity.InOutResultOrderConverter;
import com.yunxi.dg.base.center.inventory.convert.entity.InOutResultOrderDetailConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.baseOrder.dto.OutResultOrderWaitConfirmEventDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderDeliveryNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderDeliveryNoticeCloseEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInHangUpEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutHangUpEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderReceiveNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderReceiveNoticeCloseEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderWaitConfirmEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.InOutNoticeOrderCompleteEvent;
import com.yunxi.dg.base.center.inventory.service.business.order.AbstractBusinessOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.BusinessOrderStrategyFactory;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.service.utils.SendMqHelper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.transaction.support.TransactionCallback;

@Component
@Order(value=1)
public class BaseOrderEventListener {
    private static final Logger log = LoggerFactory.getLogger(BaseOrderEventListener.class);
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    ITransferOrderDomain transferOrderDomain;
    @Autowired
    IBaseOrderAddressDomain baseOrderAddressDomain;
    @Autowired
    private ICommonsMqService mqService;
    @Resource
    private BusinessOrderStrategyFactory businessOrderStrategyFactory;
    @Resource
    private Environment environment;
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    SendMqHelper sendMqHelper;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutBackEvent.class}, fallbackExecution=true)
    public void outBack(BaseOrderOutBackEvent event) {
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u51fa\u5e93\u56de\u4f20\u56de\u8c03\u4e1a\u52a1\u5355\u636e:{}", (Object)event.getEventName());
        this.sendMqHelper.sendPublishMq(event.getSource(), "outBack", (TransactionCallback<Boolean>)((TransactionCallback)status -> {
            log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\uff0c\u5904\u7406\u51fa\u5e93\u56de\u4f20\u56de\u8c03\u4e1a\u52a1\u5355\u636e:{}", (Object)JSON.toJSONString((Object)event.getSource()));
            AbstractBusinessOrder businessOrderStrategy = this.businessOrderStrategyFactory.createBusinessOrderStrategy(((ReceiveDeliveryResultOrderContext)event.getSource()).getRelevanceTableName());
            businessOrderStrategy.outBackEvent((ReceiveDeliveryResultOrderContext)event.getSource());
            return true;
        }));
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutBackEvent.class}, fallbackExecution=true)
    public void pushSapOut(BaseOrderOutBackEvent event) {
        log.info("\u76d1\u542c\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u63a8\u9001Sap:{}", (Object)event.getEventName());
        event.execute(source -> {
            if (InventoryConfig.getPushSapAble().canPush(PushAble.CanPushBo.builder().logicWarehouseCode(source.getLogicWarehouseCode()).relevanceTableNameEnum(source.getRelevanceTableName()).businessType(source.getBusinessType()).build())) {
                InventoryConfig.getPushSapAble().push(source);
            }
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderWaitConfirmEvent.class}, fallbackExecution=true)
    public void waitConfirm(BaseOrderWaitConfirmEvent event) {
        log.info("\u76d1\u542c\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355\uff0c\u5f85\u786e\u8ba4\u62e6\u622a\u4e8b\u4ef6:{}", (Object)event.getEventName());
        event.execute(source -> {
            List baseOrderAddressEos = ((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)source.getInOutResultOrderEo().getRelevanceNo())).list();
            OutResultOrderWaitConfirmEventDto dto = new OutResultOrderWaitConfirmEventDto();
            dto.setResultOrderDto((InOutResultOrderDto)InOutResultOrderConverter.INSTANCE.toDto((BaseEo)source.getInOutResultOrderEo()));
            dto.setResultOrderDetailDtoList(InOutResultOrderDetailConverter.INSTANCE.toDtoList(source.getInOutResultOrderDetailEoList()));
            if (CollectionUtils.isNotEmpty((Collection)baseOrderAddressEos)) {
                dto.setBaseOrderAddressDtoList(BaseOrderAddressConverter.INSTANCE.toDtoList(baseOrderAddressEos));
            }
            this.mqService.publishMessage(this.environment.resolvePlaceholders("${inventory.process.mq:PUBLISH_TOPIC}"), "PUSH_OUT_RESULT_ORDER_WAIT_CONFIRM", (Object)JSONUtil.toJsonStr((Object)dto));
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderInBackEvent.class}, fallbackExecution=true)
    public void inBack(BaseOrderInBackEvent event) {
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u5165\u5e93\u56de\u4f20\u56de\u8c03\u4e1a\u52a1\u5355\u636e:{}", (Object)event.getEventName());
        this.sendMqHelper.sendPublishMq(event.getSource(), "inBack", (TransactionCallback<Boolean>)((TransactionCallback)status -> {
            log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\uff0c\u5904\u7406\u5165\u5e93\u56de\u4f20\u56de\u8c03\u4e1a\u52a1\u5355\u636e:{}", (Object)JSON.toJSONString((Object)event.getSource()));
            AbstractBusinessOrder businessOrderStrategy = this.businessOrderStrategyFactory.createBusinessOrderStrategy(((ReceiveDeliveryResultOrderContext)event.getSource()).getRelevanceTableName());
            businessOrderStrategy.inBackEvent((ReceiveDeliveryResultOrderContext)event.getSource());
            return true;
        }));
    }

    private void sendMq(Object event, String tag) {
        this.sendMqHelper.sendPublishMq(event, tag, (TransactionCallback<Boolean>)((TransactionCallback)status -> true));
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderInNoticeCancelEvent.class}, fallbackExecution=true)
    public void inNoticeCancelEvent(BaseOrderInNoticeCancelEvent event) {
        this.sendMq(event.getSource(), "inNoticeCancelEvent");
        event.execute(e -> {
            log.info("\u5165\u5e93\u901a\u77e5\u5355\u53d6\u6d88\u4e8b\u4ef6\uff1a{}", (Object)JSON.toJSONString((Object)e));
            if (!e.isPushEvent()) {
                return;
            }
            AbstractBusinessOrder businessOrderStrategy = this.businessOrderStrategyFactory.createBusinessOrderStrategy(e.getRelevanceTableName());
            businessOrderStrategy.inNoticeCancelEvent((InOutNoticeOrderContext)e);
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutNoticeCancelEvent.class})
    public void outNoticeCancelEvent(BaseOrderOutNoticeCancelEvent event) {
        this.sendMq(event.getSource(), "outNoticeCancelEvent");
        event.execute(e -> {
            if (!e.isPushEvent()) {
                return;
            }
            AbstractBusinessOrder businessOrderStrategy = this.businessOrderStrategyFactory.createBusinessOrderStrategy(e.getRelevanceTableName());
            businessOrderStrategy.outNoticeCancelEvent((InOutNoticeOrderContext)e);
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderDeliveryNoticeCloseEvent.class})
    public void deliveryNoticeCloseEvent(BaseOrderDeliveryNoticeCloseEvent event) {
        this.sendMq(event.getSource(), "deliveryNoticeCloseEvent");
        event.execute(source -> {
            AbstractBusinessOrder businessOrderStrategy = this.businessOrderStrategyFactory.createBusinessOrderStrategy(source.getRelevanceTableName());
            businessOrderStrategy.deliveryNoticeCloseEvent((ReceiveDeliveryNoticeOrderContext)source);
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderReceiveNoticeCloseEvent.class})
    public void receiveNoticeCloseEvent(BaseOrderReceiveNoticeCloseEvent event) {
        this.mqService.publishMessage("receiveNoticeCloseEvent", (Object)JSONObject.toJSONString((Object)event.getSource()));
        event.execute(source -> {
            AbstractBusinessOrder businessOrderStrategy = this.businessOrderStrategyFactory.createBusinessOrderStrategy(source.getRelevanceTableName());
            businessOrderStrategy.receiveNoticeCloseEvent((ReceiveDeliveryNoticeOrderContext)source);
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutNoticeGenEvent.class}, fallbackExecution=true)
    public void outNoticeGenEvent(BaseOrderOutNoticeGenEvent event) {
        this.mqService.publishMessage("outNoticeGenEvent", (Object)JSONObject.toJSONString((Object)event.getSource()));
        event.execute(e -> {});
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderInNoticeGenEvent.class}, fallbackExecution=true)
    public void inNoticeGenEvent(BaseOrderInNoticeGenEvent event) {
        this.mqService.publishMessage("inNoticeGenEvent", (Object)JSONObject.toJSONString((Object)event.getSource()));
        event.execute(e -> {});
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={InOutNoticeOrderCompleteEvent.class}, fallbackExecution=true)
    public void inOutNoticeOrderComplete(InOutNoticeOrderCompleteEvent event) {
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u51fa\u5165\u5e93\u901a\u77e5\u5b8c\u6210\u4e8b\u4ef6:{}", (Object)JSONObject.toJSONString((Object)event.getSource()));
        this.mqService.publishMessage("inOutNoticeOrderComplete", (Object)JSONObject.toJSONString((Object)event.getSource()));
        event.execute(e -> {
            List eos = this.inOutResultOrderDomain.queryByPreOrderNo(e.getInOutNoticeOrderEo().getDocumentNo());
            if (CollectionUtils.isNotEmpty(eos = eos.stream().filter(eo -> BaseOrderStatusEnum.ORO_HANG_UP.getCode().equals(eo.getOrderStatus()) || BaseOrderStatusEnum.IRO_HANG_UP.getCode().equals(eo.getOrderStatus())).collect(Collectors.toList()))) {
                InOutNoticeOrderEo eo2 = new InOutNoticeOrderEo();
                eo2.setId(e.getInOutNoticeOrderEo().getId());
                eo2.setInOutResult(InOutResultEnum.HANG_UP.getCode());
                this.inOutNoticeOrderDomain.updateSelective((BaseEo)eo2);
            }
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutHangUpEvent.class}, fallbackExecution=true)
    public void outHangUp(BaseOrderOutHangUpEvent event) {
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u6302\u8d77\u7684\u51fa\u5e93\u7ed3\u679c\u5355\u4e1a\u52a1\u5355\u636e:{}", (Object)JSON.toJSONString((Object)event.getSource()));
        this.mqService.publishMessage("outHangUp", (Object)JSONObject.toJSONString((Object)event.getSource()));
        event.execute(this::updateInOutResult);
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderInHangUpEvent.class}, fallbackExecution=true)
    public void inHangUp(BaseOrderInHangUpEvent event) {
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u6302\u8d77\u7684\u5165\u5e93\u7ed3\u679c\u5355\u4e1a\u52a1\u5355\u636e:{}", (Object)JSON.toJSONString((Object)event.getSource()));
        this.sendMq(event.getSource(), "inHangUp");
        event.execute(this::updateInOutResult);
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderDeliveryNoticeCancelEvent.class}, fallbackExecution=true)
    public void baseOrderDeliveryNoticeCancel(BaseOrderDeliveryNoticeCancelEvent event) {
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u53d6\u6d88\u7684\u53d1\u8d27\u901a\u77e5\u5355\u4e1a\u52a1\u5355\u636e:{}", (Object)JSON.toJSONString((Object)event.getSource()));
        this.sendMq(event.getSource(), "baseOrderDeliveryNoticeCancel");
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderReceiveNoticeCancelEvent.class}, fallbackExecution=true)
    public void baseOrderReceiveNoticeCancel(BaseOrderReceiveNoticeCancelEvent event) {
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u53d6\u6d88\u7684\u6536\u8d27\u901a\u77e5\u5355\u4e1a\u52a1\u5355\u636e:{}", (Object)JSON.toJSONString((Object)event.getSource()));
        this.sendMq(event.getSource(), "baseOrderReceiveNoticeCancel");
    }

    private void updateInOutResult(InOutResultOrderContext source) {
        List eos = this.inOutNoticeOrderDomain.queryByDocumentNo(source.getInOutResultOrderEo().getPreOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)eos)) {
            eos.forEach(e -> e.setInOutResult(InOutResultEnum.HANG_UP.getCode()));
            this.inOutNoticeOrderDomain.getMapper().updateBatchByIds(eos);
        }
    }
}

