/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.pda.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.vo.BaseVo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.convert.entity.LogisticsPrintRecordConverter;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsPrintRecordDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogisticsPrintRecordDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPrintRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsPrintRecordCallbackDto;
import com.yunxi.dg.base.center.inventory.eo.LogisticsPrintRecordEo;
import com.yunxi.dg.base.center.inventory.service.pda.ILogisticsPrintRecordService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogisticsPrintRecordServiceImpl
extends BaseServiceImpl<LogisticsPrintRecordDto, LogisticsPrintRecordEo, ILogisticsPrintRecordDomain>
implements ILogisticsPrintRecordService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsPrintRecordServiceImpl.class);
    @Resource
    private ILogisticsPrintRecordDas logisticsPrintRecordDas;
    @Resource
    private IObjectStorageService objectStorageService;

    public LogisticsPrintRecordServiceImpl(ILogisticsPrintRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogisticsPrintRecordDto, LogisticsPrintRecordEo> converter() {
        return LogisticsPrintRecordConverter.INSTANCE;
    }

    @Override
    public Long addLogisticsPrintRecord(LogisticsPrintRecordDto addReqDto) {
        LogisticsPrintRecordEo logisticsPrintRecordEo = new LogisticsPrintRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)logisticsPrintRecordEo);
        this.logisticsPrintRecordDas.insert((BaseEo)logisticsPrintRecordEo);
        return logisticsPrintRecordEo.getId();
    }

    @Override
    public void modifyLogisticsPrintRecord(LogisticsPrintRecordDto modifyReqDto) {
        LogisticsPrintRecordEo logisticsPrintRecordEo = new LogisticsPrintRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)logisticsPrintRecordEo);
        this.logisticsPrintRecordDas.updateSelective((BaseEo)logisticsPrintRecordEo);
    }

    @Override
    public void callBack(LogisticsPrintRecordCallbackDto logisticsPrintRecordCallbackDto) {
        log.info("\u6253\u5370\u63a5\u6536\u5230\u56de\u8c03\u62a5\u6587:{}", (Object)JSONObject.toJSONString((Object)logisticsPrintRecordCallbackDto));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)logisticsPrintRecordCallbackDto.getCallbackInfoList()), (String)"\u56de\u8c03\u5185\u5bb9\u4e3a\u7a7a");
        logisticsPrintRecordCallbackDto.getCallbackInfoList().forEach(detail -> {
            LogisticsPrintRecordEo printRecordEo = new LogisticsPrintRecordEo();
            printRecordEo.setPrintStatus(detail.getStatus());
            printRecordEo.setPrintImageUrl(String.join((CharSequence)",", detail.getFileUrls()));
            this.logisticsPrintRecordDas.updateSelective((BaseEo)printRecordEo);
        });
    }

    @Override
    public void compensate(Date date) {
        List printRecordEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPrintRecordDas.filter().eq((Object)"print_status", (Object)Lists.newArrayList((Object[])new Integer[]{4, 2}))).le((Object)"update_time", (Object)date)).list();
    }

    @Override
    public void deleteOldFile(Date date) {
        List printRecordEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPrintRecordDas.filter().eq((Object)"print_status", (Object)Lists.newArrayList((Object[])new Integer[]{3}))).le((Object)"update_time", (Object)date)).list();
        String bucket = "print";
        printRecordEos.forEach(r -> {
            this.objectStorageService.delete(bucket, r.getId() + ".pdf");
            this.objectStorageService.delete(bucket, r.getId() + ".text");
            String[] split = r.getPrintImageUrl().split(",");
            Stream.of(split).forEach(p -> this.objectStorageService.delete(bucket, p.substring(p.lastIndexOf("/") + 1)));
        });
    }
}

