/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.pda.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.LogisticsPrintTemplateConverter;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsPrintTemplateDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogisticsPrintTemplateDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPrintTemplateDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPrintTemplatePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsPrintTemplateEnableDto;
import com.yunxi.dg.base.center.inventory.eo.LogisticsPrintTemplateEo;
import com.yunxi.dg.base.center.inventory.service.pda.ILogisticsPrintTemplateService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogisticsPrintTemplateServiceImpl
extends BaseServiceImpl<LogisticsPrintTemplateDto, LogisticsPrintTemplateEo, ILogisticsPrintTemplateDomain>
implements ILogisticsPrintTemplateService {
    private static Logger logger = LoggerFactory.getLogger(LogisticsPrintTemplateServiceImpl.class);
    @Resource
    private ILogisticsPrintTemplateDas logisticsPrintTemplateDas;

    public LogisticsPrintTemplateServiceImpl(ILogisticsPrintTemplateDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogisticsPrintTemplateDto, LogisticsPrintTemplateEo> converter() {
        return LogisticsPrintTemplateConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addLogisticsPrintTemplate(LogisticsPrintTemplateDto addReqDto) {
        LogisticsPrintTemplateEo logisticsPrintTemplateEo = new LogisticsPrintTemplateEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)logisticsPrintTemplateEo);
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPrintTemplateDas.filter().eq((Object)"logistics_company_code", (Object)addReqDto.getLogisticsCompanyCode())).eq(!InventoryConfig.isPadModule(), (Object)"channel_code", (Object)addReqDto.getChannelCode())).eq((Object)"olp_id", (Object)addReqDto.getOlpId())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BizException("\u5df2\u7ecf\u5b58\u5728\u91cd\u590d\u7684\u9762\u5355\u6a21\u7248");
        }
        this.logisticsPrintTemplateDas.insert((BaseEo)logisticsPrintTemplateEo);
        return logisticsPrintTemplateEo.getId();
    }

    @Override
    public void modifyLogisticsPrintTemplate(LogisticsPrintTemplateDto modifyReqDto) {
        LogisticsPrintTemplateEo logisticsPrintTemplateEo = new LogisticsPrintTemplateEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)logisticsPrintTemplateEo);
        this.logisticsPrintTemplateDas.updateSelective((BaseEo)logisticsPrintTemplateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLogisticsPrintTemplate(Long id) {
        this.logisticsPrintTemplateDas.logicDeleteById(id);
    }

    @Override
    public PageInfo<LogisticsPrintTemplateDto> queryByPage(LogisticsPrintTemplateDto reqDto, Integer pageNum, Integer pageSize) {
        LogisticsPrintTemplateEo logisticsPrintTemplateEo = new LogisticsPrintTemplateEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)logisticsPrintTemplateEo);
        PageInfo eoPageInfo = ((ILogisticsPrintTemplateDomain)this.domain).selectPage((BaseEo)logisticsPrintTemplateEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, LogisticsPrintTemplateDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public RestResponse<PageInfo<LogisticsPrintTemplateDto>> queryByPageNew(LogisticsPrintTemplatePageReqDto queryDto, Integer currentPage, Integer pageSize) {
        LogisticsPrintTemplateEo logisticsPrintTemplateEo = new LogisticsPrintTemplateEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)logisticsPrintTemplateEo);
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ILogisticsPrintTemplateDomain)this.domain).filter().in(CollectionUtils.isNotEmpty((Collection)queryDto.getChannelCodeList()), (Object)"channel_code", (Collection)queryDto.getChannelCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getLogisticsCodeList()), (Object)"logistics_company_code", (Collection)queryDto.getLogisticsCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getModelsList()), (Object)"models", (Collection)queryDto.getModelsList())).ge(ObjectUtil.isNotNull((Object)queryDto.getCreateTimeStarter()), (Object)"create_time", (Object)queryDto.getCreateTimeStarter())).le(ObjectUtil.isNotNull((Object)queryDto.getCreateTimeEnd()), (Object)"create_time", (Object)queryDto.getCreateTimeEnd())).ge(ObjectUtil.isNotNull((Object)queryDto.getUpdateTimeStarter()), (Object)"update_time", (Object)queryDto.getUpdateTimeStarter())).le(ObjectUtil.isNotNull((Object)queryDto.getUpdateTimeEnd()), (Object)"update_time", (Object)queryDto.getUpdateTimeEnd())).like(ObjectUtil.isNotNull((Object)queryDto.getCreatePerson()), (Object)"create_person", (Object)queryDto.getCreatePerson())).like(ObjectUtil.isNotNull((Object)queryDto.getUpdatePerson()), (Object)"update_person", (Object)queryDto.getUpdatePerson())).like(ObjectUtil.isNotNull((Object)queryDto.getCode()), (Object)"code", (Object)queryDto.getCode())).like(ObjectUtil.isNotNull((Object)queryDto.getName()), (Object)"name", (Object)queryDto.getName())).like(ObjectUtil.isNotNull((Object)queryDto.getStandardTemplateCode()), (Object)"standardTemplateCode", (Object)queryDto.getStandardTemplateCode())).like(ObjectUtil.isNotNull((Object)queryDto.getStandardTemplateName()), (Object)"standardTemplateName", (Object)queryDto.getStandardTemplateName())).page(currentPage, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, LogisticsPrintTemplateDto.class);
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public List<LogisticsPrintTemplateDto> queryByParam(LogisticsPrintTemplateDto reqDto) {
        logger.info("\u67e5\u8be2\u5e73\u53f0\u9762\u5355\u6a21\u677f\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.logisticsPrintTemplateDas.filter().orderByDesc((Object)"id");
        if (StringUtils.isNotBlank((CharSequence)reqDto.getLogisticsCompanyCode())) {
            sqlFilters.eq((Object)"logistics_company_code", (Object)reqDto.getLogisticsCompanyCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getLogisticsCompanyName())) {
            sqlFilters.like((Object)"logistics_company_name", (Object)reqDto.getLogisticsCompanyName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCode())) {
            sqlFilters.eq((Object)"code", (Object)reqDto.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getName())) {
            sqlFilters.like((Object)"name", (Object)reqDto.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getModels())) {
            sqlFilters.like((Object)"models", (Object)reqDto.getModels());
        }
        if (null != reqDto.getPrintTemplateType()) {
            sqlFilters.eq((Object)"print_template_type", (Object)reqDto.getPrintTemplateType());
        }
        if (null != reqDto.getId()) {
            sqlFilters.eq((Object)"id", (Object)reqDto.getId());
        }
        if (null != reqDto.getOlpId()) {
            sqlFilters.eq((Object)"olp_id", (Object)reqDto.getOlpId());
        }
        List list = sqlFilters.list();
        ArrayList<LogisticsPrintTemplateDto> logisticsPrintTemplateRespDtoList = new ArrayList<LogisticsPrintTemplateDto>();
        CubeBeanUtils.copyCollection(logisticsPrintTemplateRespDtoList, (Collection)list, LogisticsPrintTemplateDto.class);
        return logisticsPrintTemplateRespDtoList;
    }

    @Override
    public RestResponse<Void> enable(LogisticsPrintTemplateEnableDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getIds())) {
            return RestResponse.VOID;
        }
        LogisticsPrintTemplateEo logisticsPrintTemplateEo = new LogisticsPrintTemplateEo();
        logisticsPrintTemplateEo.setIsSystem(dto.getStatus());
        this.logisticsPrintTemplateDas.getMapper().update((Object)logisticsPrintTemplateEo, (Wrapper)Wrappers.query((Object)new LogisticsPrintTemplateEo()).in((Object)"id", (Collection)dto.getIds()));
        return RestResponse.VOID;
    }
}

