/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.event;

import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractBaseOrderEvent<T extends BaseOrderBaseContext>
extends ApplicationEvent {
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseOrderEvent.class);

    public AbstractBaseOrderEvent(T source) {
        super(source);
    }

    public T getSource() {
        return (T)((BaseOrderBaseContext)super.getSource());
    }

    public abstract String getEventName();

    public void execute(Consumer<T> function) {
        this.beforeLog();
        try {
            function.accept(this.getSource());
        }
        catch (Exception e) {
            this.errorLog();
            e.printStackTrace();
            log.error("AbstractBaseOrderEvent:{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        this.afterLog();
    }

    protected void beforeLog() {
        Object source = this.getSource();
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u6267\u884c\u5f00\u59cb\uff0c\u5904\u7406:{}\u5904\u7406\u7684\u5355\u53f7:{}", (Object)this.getEventName(), (Object)((BaseOrderBaseContext)source).getDocumentNo());
    }

    protected void afterLog() {
        Object source = this.getSource();
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u6267\u884c\u5b8c\u6210\uff0c\u5904\u7406:{}\u5904\u7406\u7684\u5355\u53f7:{}", (Object)this.getEventName(), (Object)((BaseOrderBaseContext)source).getDocumentNo());
    }

    protected void errorLog() {
        Object source = this.getSource();
        log.error("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u5904\u7406:{}\u5904\u7406\u7684\u5355\u53f7:{}", (Object)this.getEventName(), (Object)((BaseOrderBaseContext)source).getDocumentNo());
    }
}

