/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.exceptions.BizException;
import com.yunxi.dg.base.center.enums.AssemblyDisassemblyOrderBizTypeEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.OrderLineClassifyEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderDocumentTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.AssembleDisassembleOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderUnhookFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper.AbstractBaseOrderFacadeHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper.IInOutBackBaseOrderFacadeHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper.IUnHookBaseOrderFacadeHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.helper.BaseOrderExtensionHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.AdjustResultOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UnHookBaseOrderFacadeHelper
extends AbstractBaseOrderFacadeHelper
implements IUnHookBaseOrderFacadeHelper {
    private static final Logger log = LoggerFactory.getLogger(UnHookBaseOrderFacadeHelper.class);
    @Resource
    private InOutResultOrderAble outResultOrderAbleImpl;
    @Resource
    private AdjustResultOrderAbleImpl adjustResultOrderAble;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    private InOutResultOrderAble inResultOrderAbleImpl;
    @Resource
    private InOutNoticeOrderAble inNoticeOrderAbleImpl;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private InOutNoticeOrderAble outNoticeOrderAbleImpl;
    @Resource
    protected IInOutBackBaseOrderFacadeHelper inOutBackBaseOrderFacadeHelper;

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void inOutResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        switch (facadeBo.getOrderType()) {
            case "in": {
                this.inResultOrderUnhook(facadeBo);
                break;
            }
            case "out": {
                boolean isMerge;
                boolean bl = isMerge = !facadeBo.isOnlyProcessResult() && this.isMerge(facadeBo);
                if (isMerge) {
                    this.mergeOutResultOrderUnhook(facadeBo);
                    break;
                }
                this.outResultOrderUnhook(facadeBo);
                break;
            }
            case "in_out": {
                this.adjustResultOrderUnhook(facadeBo);
                break;
            }
            case "assembly_disassembly": {
                this.assemblyDisassemblyResultOrderUnhook(facadeBo);
                break;
            }
        }
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void inResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        InOutResultOrderContext inOutResultOrderContext = this.wrapperUnhookContext(facadeBo);
        inOutResultOrderContext.setNoticeEnd(InventoryConfig.isMultipleIn(facadeBo.getInOutResultOrderEo().getJumpDocumentType(), facadeBo.getInOutResultOrderEo().getDisplayBusinessType()));
        this.inResultOrderAbleImpl.unhook(inOutResultOrderContext);
        if (facadeBo.isOnlyProcessResult()) {
            return;
        }
        List receiveDeliveryResultOrderEos = this.receiveDeliveryResultOrderDomain.queryByPreOrderNo(facadeBo.getDocumentNo());
        if (CollectionUtils.isEmpty((Collection)receiveDeliveryResultOrderEos)) {
            ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
            resultOrderContext.setPreOrderNo(inOutResultOrderContext.getDocumentNo());
            this.inOutBackBaseOrderFacadeHelper.receiveResultOrderGen(resultOrderContext);
            InventoryConfig.pushEvent(new BaseOrderInBackEvent(resultOrderContext));
        }
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, InOutNoticeOrderContext.class, (String[])new String[0]);
        outNoticeOrderContext.setDocumentNo(inOutResultOrderContext.getPreOrderNo());
        this.inNoticeOrderAbleImpl.complete(outNoticeOrderContext);
        inOutResultOrderContext.execComplete(inOutResultOrderContext);
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void outResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        InOutResultOrderContext inOutResultOrderContext = this.wrapperUnhookContext(facadeBo);
        inOutResultOrderContext.setNoticeEnd(InventoryConfig.isMultipleOut(facadeBo.getInOutResultOrderEo().getJumpDocumentType(), facadeBo.getInOutResultOrderEo().getDisplayBusinessType()));
        this.outResultOrderAbleImpl.unhook(inOutResultOrderContext);
        if (facadeBo.isOnlyProcessResult()) {
            return;
        }
        List receiveDeliveryResultOrderEos = this.receiveDeliveryResultOrderDomain.queryByPreOrderNo(facadeBo.getDocumentNo());
        if (CollectionUtils.isEmpty((Collection)receiveDeliveryResultOrderEos)) {
            ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
            resultOrderContext.setPreOrderNo(inOutResultOrderContext.getDocumentNo());
            this.inOutBackBaseOrderFacadeHelper.deliveryResultOrderGen(resultOrderContext);
            InventoryConfig.pushEvent(new BaseOrderOutBackEvent(resultOrderContext));
        }
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, InOutNoticeOrderContext.class, (String[])new String[0]);
        outNoticeOrderContext.setDocumentNo(inOutResultOrderContext.getPreOrderNo());
        this.outNoticeOrderAbleImpl.complete(outNoticeOrderContext);
        inOutResultOrderContext.execComplete(inOutResultOrderContext);
    }

    @NotNull
    private InOutResultOrderContext wrapperUnhookContext(InOutResultOrderUnhookFacadeBo facadeBo) {
        InOutResultOrderEo inOutResultOrderEo = Optional.ofNullable(facadeBo.getInOutResultOrderEo()).orElseGet(() -> (InOutResultOrderEo)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"document_no", (Object)facadeBo.getDocumentNo())).oneOpt().orElseThrow(() -> new BizException("\u65e0\u6cd5\u627e\u5230\u7ed3\u679c\u5355:{}", facadeBo.getDocumentNo())));
        InOutResultOrderContext inOutResultOrderContext = (InOutResultOrderContext)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderContext.class, (String[])new String[0]);
        inOutResultOrderContext.setInOutResultOrderEo(inOutResultOrderEo);
        inOutResultOrderContext.setDocumentNo(inOutResultOrderEo.getDocumentNo());
        inOutResultOrderContext.setInOutResultOrderDetailEoList(Optional.ofNullable(facadeBo.getInOutResultOrderEoList()).filter(CollectionUtils::isNotEmpty).orElseGet(() -> ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"document_no", (Object)facadeBo.getDocumentNo())).list()));
        BeanUtil.copyProperties((Object)inOutResultOrderEo, (Object)inOutResultOrderContext, (String[])new String[0]);
        inOutResultOrderContext.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutResultOrderEo.getRelevanceTableName()));
        inOutResultOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.getByCode(inOutResultOrderEo.getOrderType()));
        inOutResultOrderContext.setOrderBasicsDetailReqDtoList(inOutResultOrderContext.getInOutResultOrderDetailEoList().stream().map(re -> {
            BaseOrderDetailReqDto reqDto = (BaseOrderDetailReqDto)((Object)((Object)BeanUtil.copyProperties((Object)re, BaseOrderDetailReqDto.class, (String[])new String[]{"id"})));
            reqDto.setSnCodes(DataExtractUtils.strToList((String)re.getSnCode(), (String)","));
            reqDto.setRelateId(re.getId());
            reqDto.setOnlyRecord(OrderLineClassifyEnum.PACKAGING_MATERIALS.getCode().equals(re.getOrderLineClassify()));
            return reqDto;
        }).collect(Collectors.toList()));
        BaseOrderExtensionHelper.loadByExtension(inOutResultOrderContext, inOutResultOrderEo);
        inOutResultOrderContext.setShippingInfoReqDtoList(DataExtractUtils.jsonStrToList((String)inOutResultOrderEo.getShippingJson(), CsWmsShippingInfoReqDto.class));
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)inOutResultOrderContext.getRelevanceTableName()) && StringUtils.isBlank((CharSequence)inOutResultOrderContext.getTransferInLogicWarehouseCode())) {
            ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutResultOrderEo.getPreOrderNo())).oneOpt().ifPresent(r -> inOutResultOrderContext.setTransferInLogicWarehouseCode(r.getInLogicWarehouseCode()));
        }
        inOutResultOrderContext.setFullBatchInOutResult(true);
        inOutResultOrderContext.setNoticeEndStatus(InventoryConfig.isNoticeEndStatus());
        return inOutResultOrderContext;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void mergeOutResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        InOutResultOrderContext inOutResultOrderContext = this.wrapperUnhookContext(facadeBo);
        inOutResultOrderContext.setNoticeEnd(InventoryConfig.isMultipleOut(facadeBo.getInOutResultOrderEo().getJumpDocumentType(), facadeBo.getInOutResultOrderEo().getDisplayBusinessType()));
        this.outResultOrderAbleImpl.unhook(inOutResultOrderContext);
        if (facadeBo.isOnlyProcessResult()) {
            return;
        }
        List<BaseOrderDetailReqDto> detailReqDtoList = facadeBo.getOrderBasicsDetailReqDtoList();
        List<Long> longs = detailReqDtoList.stream().map(BaseOrderDetailReqDto::getLineNo).collect(Collectors.toList());
        AbstractBaseOrderFacadeHelper.LoadMergeResult result = this.getLoadMergeResult(longs);
        result.detailMap.forEach((k, v) -> {
            InOutResultOrderFacadeBo inFacadeBo = this.getInOutResultOrderFacadeBo(facadeBo, (String)k, (List<InOutNoticeOrderDetailEo>)v, result.noticeOrderEoMap);
            this.inOutBackBaseOrderFacadeHelper.outResultOrderGen(inFacadeBo);
        });
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, InOutNoticeOrderContext.class, (String[])new String[0]);
        outNoticeOrderContext.setDocumentNo(inOutResultOrderContext.getPreOrderNo());
        this.outNoticeOrderAbleImpl.complete(outNoticeOrderContext);
    }

    private boolean isMerge(InOutResultOrderUnhookFacadeBo facadeBo) {
        return BaseOrderDocumentTypeEnum.MERGE.getCode().equals(((InOutNoticeOrderEo)ObjectUtils.defaultIfNull((Object)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)facadeBo.getInOutResultOrderEo().getDocumentNo())).last(" limit 1 ")).one(), (Object)new InOutNoticeOrderEo())).getDocumentType());
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void adjustResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        InOutResultOrderContext inOutResultOrderContext = this.wrapperUnhookContext(facadeBo);
        this.adjustResultOrderAble.unhook(inOutResultOrderContext);
        if (facadeBo.isOnlyProcessResult()) {
            return;
        }
        InOutResultOrderEo inOutResultOrderEo = inOutResultOrderContext.getInOutResultOrderEo();
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)inOutResultOrderEo.getRelevanceNo())).notIn((Object)"order_status", new Object[]{BaseOrderStatusEnum.ONO_CANCEL.getCode(), BaseOrderStatusEnum.INO_CANCEL.getCode()})).list();
        Map<String, List<InOutNoticeOrderDetailEo>> inOutMap = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)inOutResultOrderEo.getRelevanceNo())).notIn((Object)"order_status", new Object[]{BaseOrderStatusEnum.ONO_CANCEL.getCode(), BaseOrderStatusEnum.INO_CANCEL.getCode()})).list().stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getDocumentNo));
        inOutNoticeOrderEos.stream().filter(r -> "in".equals(r.getOrderType())).findFirst().ifPresent(r -> {
            InOutResultOrderFacadeBo inFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)inOutResultOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            inFacadeBo.setPushEvent(true);
            inFacadeBo.setInOutNoticeOrderEo((InOutNoticeOrderEo)r);
            inFacadeBo.setInOutNoticeOrderDetailEos((List)inOutMap.get(r.getDocumentNo()));
            this.inOutBackBaseOrderFacadeHelper.inResultOrderGen(inFacadeBo);
        });
        inOutNoticeOrderEos.stream().filter(r -> "out".equals(r.getOrderType())).findFirst().ifPresent(r -> {
            InOutResultOrderFacadeBo inFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)inOutResultOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            inFacadeBo.setPushEvent(true);
            inFacadeBo.setInOutNoticeOrderEo((InOutNoticeOrderEo)r);
            inFacadeBo.setInOutNoticeOrderDetailEos((List)inOutMap.get(r.getDocumentNo()));
            this.inOutBackBaseOrderFacadeHelper.outResultOrderGen(inFacadeBo);
        });
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void assemblyDisassemblyResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        List<BaseOrderDetailReqDto> detailReqDtos;
        InOutResultOrderContext inOutResultOrderContext = this.wrapperUnhookContext(facadeBo);
        this.assemblyDisassemblyResultOrderAble.unhook(inOutResultOrderContext);
        if (facadeBo.isOnlyProcessResult()) {
            return;
        }
        InOutResultOrderEo inOutResultOrderEo = inOutResultOrderContext.getInOutResultOrderEo();
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)inOutResultOrderEo.getRelevanceNo())).eq((Object)"order_type", (Object)"out")).notIn((Object)"order_status", new Object[]{BaseOrderStatusEnum.ONO_CANCEL.getCode(), BaseOrderStatusEnum.INO_CANCEL.getCode()})).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos), (String)"\u51fa\u5e93\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        List noticeOrderDetailEos = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo())).list();
        this.cover(inOutResultOrderContext.getOrderBasicsDetailReqDtoList(), inOutNoticeOrderEo);
        this.assembleDisassembleResultOrderComplete(inOutResultOrderContext, inOutNoticeOrderEo);
        int type = AssemblyDisassemblyOrderBizTypeEnum.getByName((String)inOutNoticeOrderEo.getDisplayBusinessType()).getPackType();
        List<BaseOrderDetailReqDto> orderBasicsDetailReqDtoList = inOutResultOrderContext.getOrderBasicsDetailReqDtoList();
        List<BaseOrderDetailReqDto> outNoticeOrderDetailEos = orderBasicsDetailReqDtoList.stream().filter(x -> x.getPackType() == type).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(outNoticeOrderDetailEos)) {
            InOutResultOrderFacadeBo inFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            inFacadeBo.setPushEvent(false);
            inFacadeBo.setInOutNoticeOrderEo(inOutNoticeOrderEo);
            inFacadeBo.setInOutNoticeOrderDetailEos(noticeOrderDetailEos);
            inFacadeBo.setOrderBasicsDetailReqDtoList(outNoticeOrderDetailEos);
            this.inOutBackBaseOrderFacadeHelper.outResultOrderGen(inFacadeBo);
        }
        if (CollectionUtils.isNotEmpty(detailReqDtos = orderBasicsDetailReqDtoList.stream().filter(x -> x.getPackType() != type).collect(Collectors.toList()))) {
            AssembleDisassembleOrderFacadeBo noticeOrderFacadeBo = (AssembleDisassembleOrderFacadeBo)BeanUtil.copyProperties((Object)facadeBo, AssembleDisassembleOrderFacadeBo.class, (String[])new String[0]);
            noticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(detailReqDtos);
            noticeOrderFacadeBo.setAutoComplete(true);
            this.assembleDisassembleReceiveGen(noticeOrderFacadeBo, inOutNoticeOrderEo);
        }
    }
}

