/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.FutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseFutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractInOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InNoticeOrderAbleImpl
extends AbstractInOutNoticeOrderAble {
    private static final Logger log = LoggerFactory.getLogger(InNoticeOrderAbleImpl.class);
    @Autowired
    ICalcInventoryService calcInventoryService;

    @Override
    protected void wrapperGenerateAfter(InOutNoticeOrderContext context) {
        if (!context.getUpdateInventory().booleanValue() || !this.canNoticeInventoryProcess(context) || CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)context.getRelevanceTableName())) {
            return;
        }
        FutureInDto futureInDto = new FutureInDto();
        this.wrapper(context, (CalcDto)futureInDto);
        if (CollectionUtils.isNotEmpty((Collection)futureInDto.getDetails())) {
            this.calcInventoryService.futureIn(futureInDto);
        }
    }

    private void wrapper(InOutNoticeOrderContext context, CalcDto transferInDto) {
        context.wrapperInventoryOd(transferInDto);
        List detailDtos = context.getInOutNoticeOrderDetailEoList().stream().filter(r -> BigDecimalUtils.eqZero((BigDecimal)r.getWaitQuantity()) == false).map(detail -> this.getCalcDetailDto(context, (InOutNoticeOrderDetailEo)detail)).collect(Collectors.toList());
        transferInDto.setDetails(detailDtos);
        transferInDto.setValidNegative(Boolean.valueOf(false));
    }

    public CalcDetailDto getCalcDetailDto(InOutNoticeOrderContext context, InOutNoticeOrderDetailEo detail) {
        CalcDetailDto detailDto = new CalcDetailDto();
        detailDto.setBatch(detail.getBatch());
        detailDto.setExpireDate(detail.getExpireTime());
        detailDto.setLineNo(detail.getLineNo());
        detailDto.setLogicWarehouseCode(context.getLogicWarehouseCode());
        detailDto.setProduceDate(detail.getProduceTime());
        detailDto.setSkuCode(detail.getSkuCode());
        detailDto.setNum(detail.getWaitQuantity());
        detailDto.setInventoryProperty(detail.getInventoryProperty());
        return detailDto;
    }

    @Override
    protected void wrapperGenerate(InOutNoticeOrderContext context) {
        context.getInOutNoticeOrderEo().setInLogicWarehouseCode(context.getLogicWarehouseCode());
        context.getInOutNoticeOrderEo().setInLogicWarehouseName(context.getLogicWarehouseName());
        context.getInOutNoticeOrderEo().setInPhysicsWarehouseCode(context.getPhysicsWarehouseCode());
        context.getInOutNoticeOrderEo().setInPhysicsWarehouseName(context.getPhysicsWarehouseName());
    }

    @Override
    public boolean validCancel(InOutNoticeOrderContext context) {
        if (!super.validCancel(context)) {
            return false;
        }
        if (BaseOrderStatusEnum.INO_CANCEL.getCode().equals(context.getInOutNoticeOrderEo().getOrderStatus())) {
            log.error("\u5df2\u53d6\u6d88\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u53d6\u6d88:{}", (Object)context.getDocumentNo());
            return false;
        }
        return true;
    }

    @Override
    protected String getCompleteStatus(InOutNoticeOrderContext inOutNoticeOrderContext) {
        return inOutNoticeOrderContext.isNoticeEnd() ? (inOutNoticeOrderContext.isNoticeEndStatus() ? BaseOrderStatusEnum.FINISH_OVER.getCode() : BaseOrderStatusEnum.INO_TOTAL_IN.getCode()) : BaseOrderStatusEnum.INO_PORTION_IN.getCode();
    }

    @Override
    public boolean validClose(InOutNoticeOrderContext context) {
        return super.validClose(context);
    }

    @Override
    public void doClose(InOutNoticeOrderContext context) {
        super.doClose(context);
        log.info("\u5165\u5e93\u901a\u77e5\u5355\u6267\u884c\u5b8c\u7ed3\u903b\u8f91\uff1a{}", (Object)JSON.toJSONString((Object)context));
        InOutNoticeOrderEo inOutNoticeOrderEo = context.getInOutNoticeOrderEo();
        this.updateStatus(inOutNoticeOrderEo, BaseOrderStatusEnum.FINISH_OVER);
        this.handlerFutureIn(context, inOutNoticeOrderEo);
        this.updateDetailQuantity(context);
    }

    @Override
    public void doCancel(InOutNoticeOrderContext context) {
        log.info("\u5165\u5e93\u901a\u77e5\u5355\u6267\u884c\u53d6\u6d88\u903b\u8f91\uff1a{}", (Object)JSON.toJSONString((Object)context));
        super.doCancel(context);
        InOutNoticeOrderEo inOutNoticeOrderEo = context.getInOutNoticeOrderEo();
        this.updateStatus(inOutNoticeOrderEo, BaseOrderStatusEnum.INO_CANCEL);
        this.handlerFutureIn(context, inOutNoticeOrderEo);
        this.updateDetailQuantity(context);
    }

    private void handlerFutureIn(InOutNoticeOrderContext context, InOutNoticeOrderEo inOutNoticeOrderEo) {
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)context.getRelevanceTableName()) || !context.getUpdateInventory().booleanValue()) {
            return;
        }
        List detailList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)context.getDocumentNo())).list();
        context.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        context.setSourceType(context.getSourceType());
        context.setExternalOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        context.setLogicWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
        context.setBusinessType((String)DataExtractUtils.ifNullElse((Object)inOutNoticeOrderEo.getDisplayBusinessType(), (Object)inOutNoticeOrderEo.getBusinessType()));
        context.setOrderBasicsDetailReqDtoList(BeanUtil.copyToList((Collection)detailList, BaseOrderDetailReqDto.class, (CopyOptions)CopyOptions.create().setIgnoreProperties(new String[]{"id"})));
        context.setInOutNoticeOrderDetailEoList(detailList);
        ReleaseFutureInDto futureInDto = new ReleaseFutureInDto();
        this.wrapper(context, (CalcDto)futureInDto);
        if (CollectionUtils.isNotEmpty((Collection)futureInDto.getDetails())) {
            this.calcInventoryService.releaseFutureIn(futureInDto);
        }
    }
}

