/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CommitEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.LogicLockOrderConverter;
import com.yunxi.dg.base.center.inventory.convert.entity.LogicLockOrderDetailConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IAutomaticAuditPolicyDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicLockOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicLockOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicLockOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicLockOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicLockOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicLockOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.LogicLockOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.ILogicLockOrderService;
import com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.enums.LogicLockOrderContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.enums.LogicLockOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.enums.LogicLockOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineMap;
import com.yunxi.dg.base.center.inventory.statemachine.executor.LogicLockOrderStatemachineExecutor;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogicLockOrderServiceImpl
extends BaseServiceImpl<LogicLockOrderDto, LogicLockOrderEo, ILogicLockOrderDomain>
implements ILogicLockOrderService {
    private static final Logger log = LoggerFactory.getLogger(LogicLockOrderServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private GenerateCodeUtil generateCodeUtil;
    @Resource
    private ILogicLockOrderDetailDomain iLogicLockOrderDetailDomain;
    @Resource
    private LogicLockOrderStatemachineExecutor logicLockOrderStatemachineExecutor;
    @Resource
    private IAutomaticAuditPolicyDomain automaticAuditPolicyDomain;
    @Resource
    private ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IInventoryPreemptionDomain inventoryPreemptionDomain;

    public LogicLockOrderServiceImpl(ILogicLockOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogicLockOrderDto, LogicLockOrderEo> converter() {
        return LogicLockOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrder(LogicLockOrderDto dto) {
        log.info("\u4fdd\u5b58\u903b\u8f91\u9501\u5e93\u5355\u53c2\u6570: {}", (Object)LogUtils.buildLogContent((Object)dto));
        this.checkData(dto);
        AssertUtils.notEmpty((Collection)dto.getDetailDtoList(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        if (!Lists.newArrayList((Object[])new String[]{"SAVE", "COMMIT"}).contains(dto.getCommitType())) {
            throw new BizException("\u4fdd\u5b58\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        return Objects.nonNull(dto.getId()) ? this.doEdit(dto) : this.doAdd(dto);
    }

    private void checkData(LogicLockOrderDto dto) {
        String today = DateUtil.today();
        if (null == dto.getLockStartDate() || null == dto.getLockEndDate()) {
            throw new BizException("\u9501\u5e93\u5f00\u59cb\u65f6\u95f4\u6216\u8005\u9501\u5e93\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DateUtil.compare((Date)dto.getLockStartDate(), (Date)DateUtil.parseDate((CharSequence)today)) < 0) {
            throw new BizException("\u9501\u5e93\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (DateUtil.compare((Date)dto.getLockEndDate(), (Date)dto.getLockStartDate()) < 0) {
            throw new BizException("\u9501\u5e93\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e\u9501\u5e93\u5f00\u59cb\u65f6\u95f4");
        }
    }

    private Long doSave(LogicLockOrderDto dto, boolean isEdit) {
        boolean isAutoAudit;
        List detailDtoList = dto.getDetailDtoList();
        LogicLockOrderEo logicLockOrderEo = (LogicLockOrderEo)LogicLockOrderConverter.INSTANCE.toEo((BaseDto)dto);
        ArrayList detailEoList = Lists.newArrayList();
        detailDtoList.forEach(o -> {
            LogicLockOrderDetailEo logicLockOrderDetailEo = (LogicLockOrderDetailEo)LogicLockOrderDetailConverter.INSTANCE.toEo((BaseDto)o);
            logicLockOrderDetailEo.setId(null);
            logicLockOrderDetailEo.setOrderNo(logicLockOrderEo.getOrderNo());
            detailEoList.add(logicLockOrderDetailEo);
        });
        StatemachineMap storageOrderDetailListMap = new StatemachineMap();
        storageOrderDetailListMap.put(LogicLockOrderContextEnum.LOGIC_LOCK_ORDER_DETAIL.getCode(), detailEoList);
        storageOrderDetailListMap.put(LogicLockOrderContextEnum.UPDATE_LOGIC_LOCK_ORDER.getCode(), dto);
        StatemachineExecutorBo<LogicLockOrderEo> logicLockOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<LogicLockOrderEo>();
        logicLockOrderEoStatemachineExecutorBo.setEo(logicLockOrderEo);
        logicLockOrderEoStatemachineExecutorBo.setVariables(storageOrderDetailListMap);
        this.logicLockOrderStatemachineExecutor.execute(LogicLockOrderStatusEventEnum.SAVE, logicLockOrderEoStatemachineExecutorBo);
        if (CommitEnum.COMMIT.code().equals(dto.getCommitType()) && (isAutoAudit = this.automaticAuditPolicyDomain.isAutoAudit(logicLockOrderEo.getOrderType(), logicLockOrderEo.getBusinessType()))) {
            this.doAutoAudit(logicLockOrderEo);
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.getEditType((boolean)isEdit), (String)"EMPTY", (String)logicLockOrderEo.getOrderNo(), (String)logicLockOrderEo.getOrderType());
        return logicLockOrderEo.getId();
    }

    private void doAutoAudit(LogicLockOrderEo logicLockOrderEo) {
        LogicLockOrderDto logicLockOrderDto = new LogicLockOrderDto();
        logicLockOrderDto.setOrderNo(logicLockOrderEo.getOrderNo());
        logicLockOrderDto.setAuditResult("1");
        logicLockOrderDto.setAuditRemark("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
        this.audit(logicLockOrderDto);
    }

    private Long doAdd(LogicLockOrderDto dto) {
        String oderNo = this.generateCodeUtil.generateCode(CodeGenEnum.LOGIC_LOCK_ORDER);
        dto.setOrderStatus(LogicLockOrderStatusEnum.INIT.getKey());
        dto.setOrderNo(oderNo);
        return this.doSave(dto, Boolean.FALSE);
    }

    private Long doEdit(LogicLockOrderDto dto) {
        LogicLockOrderEo orderEo = (LogicLockOrderEo)((ILogicLockOrderDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)orderEo, (String)"\u5355\u636e\u4e0d\u5b58\u5728");
        dto.setOrderNo(orderEo.getOrderNo());
        return this.doSave(dto, Boolean.TRUE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void audit(LogicLockOrderDto logicLockOrderDto) {
        AssertUtils.notEmpty((String)logicLockOrderDto.getOrderNo(), (String)"\u903b\u8f91\u9501\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((String)logicLockOrderDto.getAuditResult(), (String)"\u5ba1\u6838\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        LogicLockOrderEo orderEo = ((ILogicLockOrderDomain)this.domain).queryLogicLockOrderEo(logicLockOrderDto);
        orderEo.setAuditRemark(logicLockOrderDto.getAuditRemark());
        StatemachineExecutorBo<LogicLockOrderEo> logicLockOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<LogicLockOrderEo>();
        logicLockOrderEoStatemachineExecutorBo.setEo(orderEo);
        boolean isApproved = true;
        if (YesNoEnum.YES.getValue().toString().equals(logicLockOrderDto.getAuditResult())) {
            this.logicLockOrderStatemachineExecutor.execute(LogicLockOrderStatusEventEnum.AUDIT, logicLockOrderEoStatemachineExecutorBo);
        } else {
            isApproved = false;
            this.logicLockOrderStatemachineExecutor.execute(LogicLockOrderStatusEventEnum.AUDITFAILED, logicLockOrderEoStatemachineExecutorBo);
        }
        String remark = StrUtil.emptyToDefault((CharSequence)logicLockOrderDto.getAuditRemark(), (String)"EMPTY");
        OptUtil.addOptLog((String)OperationLogTypeEnum.getAuditType((boolean)isApproved), (String)remark, (String)orderEo.getOrderNo(), (String)orderEo.getOrderType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void submit(LogicLockOrderDto logicLockOrderDto) {
        AssertUtils.notEmpty((String)logicLockOrderDto.getOrderNo(), (String)"\u903b\u8f91\u9501\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LogicLockOrderEo orderEo = ((ILogicLockOrderDomain)this.domain).queryLogicLockOrderEo(logicLockOrderDto);
        LogicLockOrderDto lockOrderDto = (LogicLockOrderDto)this.converter().toDto((BaseEo)orderEo);
        this.checkData(lockOrderDto);
        StatemachineExecutorBo<LogicLockOrderEo> logicLockOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<LogicLockOrderEo>();
        logicLockOrderEoStatemachineExecutorBo.setEo(orderEo);
        this.logicLockOrderStatemachineExecutor.execute(LogicLockOrderStatusEventEnum.SUBMIT, logicLockOrderEoStatemachineExecutorBo);
        boolean isAutoAudit = this.automaticAuditPolicyDomain.isAutoAudit(orderEo.getOrderType(), orderEo.getBusinessType());
        if (isAutoAudit) {
            this.doAutoAudit(orderEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void withdraw(LogicLockOrderDto logicLockOrderDto) {
        LogicLockOrderEo orderEo = ((ILogicLockOrderDomain)this.domain).queryLogicLockOrderEo(logicLockOrderDto);
        StatemachineExecutorBo<LogicLockOrderEo> executorBo = new StatemachineExecutorBo<LogicLockOrderEo>();
        executorBo.setEo(orderEo);
        this.logicLockOrderStatemachineExecutor.execute(LogicLockOrderStatusEventEnum.WITHDRAW, executorBo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(LogicLockOrderDto logicLockOrderDto) {
        LogicLockOrderEo orderEo = ((ILogicLockOrderDomain)this.domain).queryLogicLockOrderEo(logicLockOrderDto);
        StatemachineExecutorBo<LogicLockOrderEo> logicLockOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<LogicLockOrderEo>();
        logicLockOrderEoStatemachineExecutorBo.setEo(orderEo);
        this.logicLockOrderStatemachineExecutor.execute(LogicLockOrderStatusEventEnum.CANCEL, logicLockOrderEoStatemachineExecutorBo);
    }

    @Override
    public PageInfo<LogicLockOrderDto> queryPage(LogicLockOrderPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((ILogicLockOrderDomain)this.domain).queryList(dto));
    }

    @Override
    public LogicLockOrderDto queryOrderNo(LogicLockOrderPageReqDto dto) {
        AssertUtils.notEmpty((String)dto.getOrderNo(), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LogicLockOrderDto queryDto = new LogicLockOrderDto();
        queryDto.setOrderNo(dto.getOrderNo());
        LogicLockOrderEo logicLockOrderEo = ((ILogicLockOrderDomain)this.domain).queryLogicLockOrderEo(queryDto);
        LogicLockOrderDto logicLockOrderDto = (LogicLockOrderDto)LogicLockOrderConverter.INSTANCE.toDto((BaseEo)logicLockOrderEo);
        List<LogicLockOrderDetailDto> detailDtoList = Lists.newArrayList();
        if (null != dto.getQueryType() && dto.getQueryType().equals(YesNoEnum.YES.getValue())) {
            List orderDetailEoList = ((ExtQueryChainWrapper)this.iLogicLockOrderDetailDomain.filter().eq((Object)"order_no", (Object)dto.getOrderNo())).list();
            for (LogicLockOrderDetailEo eo : orderDetailEoList) {
                LogicLockOrderDetailDto detailDto = (LogicLockOrderDetailDto)LogicLockOrderDetailConverter.INSTANCE.toDto((BaseEo)eo);
                detailDtoList.add(detailDto);
            }
        } else {
            LogicLockOrderPageReqDto reqDto = new LogicLockOrderPageReqDto();
            reqDto.setOrderNo(dto.getOrderNo());
            detailDtoList = ((ILogicLockOrderDomain)this.domain).queryDetailList(reqDto);
        }
        List skuCodeList = detailDtoList.stream().map(LogicLockOrderDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        List inventoryPropertyList = detailDtoList.stream().map(LogicLockOrderDetailDto::getInventoryProperty).distinct().collect(Collectors.toList());
        ItemQueryDgReqDto itemQueryDto = new ItemQueryDgReqDto();
        itemQueryDto.setSkuCodes(skuCodeList);
        Map itemMap = this.itemSkuDgQueryApiProxy.querySkuList(itemQueryDto).stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        Map inventoryTotalEoMap = Optional.ofNullable(this.logicInventoryTotalDomain.queryByWarehouseCodesAndSkuCodes((List)Lists.newArrayList((Object[])new String[]{logicLockOrderDto.getLogicWarehouseCode()}), skuCodeList, inventoryPropertyList)).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(o -> o.getWarehouseCode() + "_" + o.getSkuCode() + "_" + o.getInventoryProperty(), Function.identity(), (k1, k2) -> k1));
        for (LogicLockOrderDetailDto detailDto : detailDtoList) {
            String key = logicLockOrderEo.getLogicWarehouseCode() + "_" + detailDto.getSkuCode() + "_" + detailDto.getInventoryProperty();
            detailDto.setAvailable(BigDecimalUtils.check((BigDecimal)Optional.ofNullable(inventoryTotalEoMap.get(key)).orElse(new LogicInventoryTotalEo()).getAvailable()));
            DgItemSkuDetailRespDto dgItemSkuDetailRespDto = (DgItemSkuDetailRespDto)itemMap.get(detailDto.getSkuCode());
            if (null == dgItemSkuDetailRespDto) continue;
            detailDto.setStorage(String.valueOf(dgItemSkuDetailRespDto.getStorage()));
            detailDto.setSpecification(this.spliceString(dgItemSkuDetailRespDto.getSpecOne(), dgItemSkuDetailRespDto.getSpecTwo()));
            detailDto.setUnit(dgItemSkuDetailRespDto.getUnit());
        }
        logicLockOrderDto.setDetailDtoList(detailDtoList);
        return logicLockOrderDto;
    }

    @Override
    public LogicLockOrderDto queryBatchOrderNo(LogicLockOrderPageReqDto dto) {
        AssertUtils.notEmpty((String)dto.getOrderNo(), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LogicLockOrderDto queryDto = new LogicLockOrderDto();
        queryDto.setOrderNo(dto.getOrderNo());
        LogicLockOrderEo logicLockOrderEo = ((ILogicLockOrderDomain)this.domain).queryLogicLockOrderEo(queryDto);
        LogicLockOrderDto logicLockOrderDto = (LogicLockOrderDto)LogicLockOrderConverter.INSTANCE.toDto((BaseEo)logicLockOrderEo);
        LogicLockOrderPageReqDto orderPageReqDto = new LogicLockOrderPageReqDto();
        orderPageReqDto.setOrderNo(dto.getOrderNo());
        List detailDtoList = ((ILogicLockOrderDomain)this.domain).queryBatchDetailList(orderPageReqDto);
        logicLockOrderDto.setDetailDtoList(detailDtoList);
        return logicLockOrderDto;
    }

    private String groupingByKey(InventoryUsageRecordEo eo) {
        return eo.getSkuCode() + "_" + eo.getInventoryProperty();
    }

    @Override
    public PageInfo<LogicLockOrderDetailDto> queryDetailPage(LogicLockOrderPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List detailDtoList = ((ILogicLockOrderDomain)this.domain).queryDetailList(dto);
        List skuCodeList = detailDtoList.stream().map(LogicLockOrderDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        ItemQueryDgReqDto itemQueryDto = new ItemQueryDgReqDto();
        itemQueryDto.setSkuCodes(skuCodeList);
        Map itemMap = this.itemSkuDgQueryApiProxy.querySkuList(itemQueryDto).stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        for (LogicLockOrderDetailDto detailDto : detailDtoList) {
            DgItemSkuDetailRespDto dgItemSkuDetailRespDto = (DgItemSkuDetailRespDto)itemMap.get(detailDto.getSkuCode());
            if (null == dgItemSkuDetailRespDto) continue;
            detailDto.setStorage(String.valueOf(dgItemSkuDetailRespDto.getStorage()));
            detailDto.setSpecification(this.spliceString(dgItemSkuDetailRespDto.getSpecOne(), dgItemSkuDetailRespDto.getSpecTwo()));
        }
        return new PageInfo(detailDtoList);
    }

    @Override
    public void updateStatusBatch(LogicLockOrderDto dto) {
        log.info("\u6279\u91cf\u66f4\u65b0\u903b\u8f91\u9501\u5e93\u5355\u72b6\u6001\u5165\u53c2={}", (Object)LogUtils.buildLogContent((Object)dto));
        LogicLockOrderDto lockOrderDto = Optional.ofNullable(dto).orElse(new LogicLockOrderDto());
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{LogicLockOrderStatusEnum.WAIT_EFFECTIVE.getKey(), LogicLockOrderStatusEnum.IN_EFFECT.getKey()});
        LogicLockOrderPageReqDto reqDto = (LogicLockOrderPageReqDto)BeanUtil.copyProperties((Object)lockOrderDto, LogicLockOrderPageReqDto.class, (String[])new String[0]);
        reqDto.setOrderStatusList((List)orderStatusList);
        List logicLockOrderDtos = ((ILogicLockOrderDomain)this.domain).queryList(reqDto);
        if (CollectionUtils.isEmpty((Collection)logicLockOrderDtos)) {
            log.info("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u903b\u8f91\u9501\u5e93\u5355");
            return;
        }
        List orderNoList = logicLockOrderDtos.stream().map(LogicLockOrderDto::getOrderNo).collect(Collectors.toList());
        LogicLockOrderPageReqDto orderPageReqDto = new LogicLockOrderPageReqDto();
        orderPageReqDto.setOrderNoList(orderNoList);
        List lockOrderDetailDtoList = ((ILogicLockOrderDomain)this.domain).queryBatchDetailList(orderPageReqDto).stream().filter(o -> BigDecimalUtils.gtZero((BigDecimal)o.getQuantity())).collect(Collectors.toList());
        for (LogicLockOrderDto logicLockOrderDto : logicLockOrderDtos) {
            String today = DateUtil.today();
            List detailDtoList = lockOrderDetailDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getOrderNo(), (CharSequence)logicLockOrderDto.getOrderNo())).collect(Collectors.toList());
            LogicLockOrderEo orderEo = (LogicLockOrderEo)BeanUtil.copyProperties((Object)logicLockOrderDto, LogicLockOrderEo.class, (String[])new String[0]);
            StatemachineMap logicLockOrderDetailListMap = new StatemachineMap();
            logicLockOrderDetailListMap.put(LogicLockOrderContextEnum.UPDATE_LOGIC_LOCK_ORDER.getCode(), logicLockOrderDto);
            logicLockOrderDetailListMap.put(LogicLockOrderContextEnum.LOGIC_LOCK_ORDER_DETAILDTO.getCode(), detailDtoList);
            StatemachineExecutorBo<LogicLockOrderEo> logicLockOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<LogicLockOrderEo>();
            logicLockOrderEoStatemachineExecutorBo.setEo(orderEo);
            logicLockOrderEoStatemachineExecutorBo.setVariables(logicLockOrderDetailListMap);
            try {
                if (StringUtils.equals((CharSequence)logicLockOrderDto.getOrderStatus(), (CharSequence)LogicLockOrderStatusEnum.WAIT_EFFECTIVE.getKey()) && DateUtil.compare((Date)logicLockOrderDto.getLockStartDate(), (Date)DateUtil.parseDate((CharSequence)today)) <= 0) {
                    this.logicLockOrderStatemachineExecutor.execute(LogicLockOrderStatusEventEnum.EFFECTIVE, logicLockOrderEoStatemachineExecutorBo);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)logicLockOrderDto.getOrderStatus(), (CharSequence)LogicLockOrderStatusEnum.IN_EFFECT.getKey()) || DateUtil.compare((Date)logicLockOrderDto.getLockEndDate(), (Date)DateUtil.parseDate((CharSequence)today)) >= 0) continue;
                this.logicLockOrderStatemachineExecutor.execute(LogicLockOrderStatusEventEnum.COMPLETED, logicLockOrderEoStatemachineExecutorBo);
            }
            catch (Exception e) {
                log.info("\u4fee\u6539\u72b6\u6001\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
    }

    private String spliceString(String a, String b) {
        StringBuilder stringBuilder = new StringBuilder();
        if (a != null && !a.isEmpty()) {
            stringBuilder.append(a);
        }
        if (b != null && !b.isEmpty() && a != null && !a.isEmpty()) {
            stringBuilder.append(", ");
        }
        if (b != null && !b.isEmpty()) {
            stringBuilder.append(b);
        }
        return stringBuilder.toString();
    }

    @Override
    public void release(LogicLockOrderDto dto) {
        log.info("\u91ca\u653e\u9501\u5b9a\u5e93\u5b58\u5165\u53c2:{}", (Object)LogUtils.buildLogContent((Object)dto));
        AssertUtils.notEmpty((String)dto.getOrderNo(), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((String)dto.getReleaseType(), (String)"\u91ca\u653e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        LogicLockOrderEo orderEo = ((ILogicLockOrderDomain)this.domain).queryLogicLockOrderEo(dto);
        List detailDtoList = Lists.newArrayList();
        if (StringUtils.equals((CharSequence)dto.getReleaseType(), (CharSequence)String.valueOf(YesNoEnum.NO.getValue()))) {
            AssertUtils.notEmpty((Collection)dto.getDetailDtoList(), (String)"\u90e8\u5206\u91ca\u653e\uff0c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            boolean isZero = dto.getDetailDtoList().stream().anyMatch(o -> BigDecimalUtils.gtZero((BigDecimal)o.getQuantity()));
            if (!isZero) {
                throw new BizException("\u660e\u7ec6\u4e0d\u80fd\u5168\u4e3a0");
            }
            detailDtoList = dto.getDetailDtoList();
        } else {
            LogicLockOrderPageReqDto reqDto = new LogicLockOrderPageReqDto();
            reqDto.setOrderNo(dto.getOrderNo());
            detailDtoList = ((ILogicLockOrderDomain)this.domain).queryBatchDetailList(reqDto);
        }
        List orderDetailDtos = detailDtoList.stream().peek(o -> AssertUtils.notEmpty((Object)o.getId(), (String)"\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a")).filter(o -> BigDecimalUtils.gtZero((BigDecimal)o.getQuantity())).collect(Collectors.toList());
        StatemachineMap logicLockOrderDetailListMap = new StatemachineMap();
        logicLockOrderDetailListMap.put(LogicLockOrderContextEnum.LOGIC_LOCK_ORDER_DETAILDTO.getCode(), orderDetailDtos);
        logicLockOrderDetailListMap.put(LogicLockOrderContextEnum.UPDATE_LOGIC_LOCK_ORDER.getCode(), dto);
        StatemachineExecutorBo<LogicLockOrderEo> logicLockOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<LogicLockOrderEo>();
        logicLockOrderEoStatemachineExecutorBo.setEo(orderEo);
        logicLockOrderEoStatemachineExecutorBo.setVariables(logicLockOrderDetailListMap);
        this.logicLockOrderStatemachineExecutor.execute(LogicLockOrderStatusEventEnum.COMPLETED, logicLockOrderEoStatemachineExecutorBo);
    }
}

