/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.action;

import cn.hutool.core.bean.BeanUtil;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentChangeTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentInventoryContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class AdjustmentInventoryTransactionAction
extends AbstractAction<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentInventoryTransactionAction.class);
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;

    @Override
    public void doExecute(StateContext<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> context) {
        log.info("\u8fdb\u5165\u5e93\u5b58\u8c03\u6574\u5355\u5e93\u5b58\u5904\u7406\u52a8\u4f5c");
        StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
        AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)executorBo.getEo();
        List adjustmentOrderDetailEos = (List)executorBo.getVariables(AdjustmentInventoryContextEnum.ADJUSTMENT_INVENTORY_ORDER_DETAIL.getCode());
        Map<String, List<AdjustmentOrderDetailEo>> adjustmentOrderDetailEoMap = adjustmentOrderDetailEos.stream().collect(Collectors.groupingBy(AdjustmentOrderDetailEo::getChangeType));
        Map<Object, OrderUnitConversionRecordEo> unitConversionRecordDtoMap = this.getUnitConversionRecordDtoMap(adjustmentOrderEo.getAdjustmentNo());
        List<AdjustmentOrderDetailEo> decreaseDetailEoList = adjustmentOrderDetailEoMap.get(AdjustmentChangeTypeEnum.DECREASE.getCode());
        List<AdjustmentOrderDetailEo> increaseDetailEoList = adjustmentOrderDetailEoMap.get(AdjustmentChangeTypeEnum.INCREASE.getCode());
        ReceiveDeliveryNoticeOrderFacadeBo noticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        ArrayList<BaseOrderDetailReqDto> orderDetailReqDtos = new ArrayList<BaseOrderDetailReqDto>();
        noticeOrderFacadeBo.setRelevanceNo(adjustmentOrderEo.getAdjustmentNo());
        noticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.IN_ADJUSTMENT_ORDER);
        noticeOrderFacadeBo.setAutoComplete(Optional.ofNullable(StatemachineHelper.getExecutorBo(context).getVariables().get("autoComplete")).map(r -> (Boolean)r).orElse(true));
        noticeOrderFacadeBo.setSendWms(YesNoEnum.YES.getValue().equals(adjustmentOrderEo.getPushWms()));
        noticeOrderFacadeBo.setLogicWarehouseCode(adjustmentOrderEo.getWarehouseCode());
        noticeOrderFacadeBo.setLogicWarehouseName(adjustmentOrderEo.getWarehouseName());
        noticeOrderFacadeBo.setBusinessType(adjustmentOrderEo.getBusinessType());
        noticeOrderFacadeBo.setDisplayBusinessType(adjustmentOrderEo.getBusinessType());
        noticeOrderFacadeBo.setExternalOrderNo(adjustmentOrderEo.getExternalOrderNo());
        noticeOrderFacadeBo.setBizDate(adjustmentOrderEo.getBizDate());
        noticeOrderFacadeBo.setRemark(adjustmentOrderEo.getRemark());
        noticeOrderFacadeBo.setValidNegative(InventoryConfig.isCheckInventory());
        if (CollectionUtils.isNotEmpty(decreaseDetailEoList)) {
            noticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_TO_ADJUST.getCode());
            decreaseDetailEoList.forEach(orderDetailEo -> {
                OrderUnitConversionRecordEo unitEo = (OrderUnitConversionRecordEo)unitConversionRecordDtoMap.get(this.getKey(orderDetailEo.getSkuCode(), orderDetailEo.getChangeQuantity(), orderDetailEo.getUnit()));
                BaseOrderDetailReqDto baseOrderDetailReqDto = new BaseOrderDetailReqDto();
                baseOrderDetailReqDto.setBatch(orderDetailEo.getBatch());
                baseOrderDetailReqDto.setPreOrderItemId(orderDetailEo.getId());
                baseOrderDetailReqDto.setProduceTime(orderDetailEo.getProduceTime());
                baseOrderDetailReqDto.setExpireTime(orderDetailEo.getExpireTime());
                baseOrderDetailReqDto.setSkuCode(orderDetailEo.getSkuCode());
                baseOrderDetailReqDto.setSkuName(orderDetailEo.getSkuName());
                baseOrderDetailReqDto.setInventoryProperty(orderDetailEo.getInventoryProperty());
                baseOrderDetailReqDto.setQuantity(BeanUtil.isNotEmpty((Object)unitEo, (String[])new String[0]) ? unitEo.getToNum() : orderDetailEo.getChangeQuantity());
                orderDetailReqDtos.add(baseOrderDetailReqDto);
            });
            noticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(orderDetailReqDtos);
            this.baseOrderFacade.deliveryNoticeOrderGen(noticeOrderFacadeBo);
        }
        if (CollectionUtils.isNotEmpty(increaseDetailEoList)) {
            noticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.IN_TO_ADJUST.getCode());
            orderDetailReqDtos.clear();
            increaseDetailEoList.forEach(orderDetailEo -> {
                OrderUnitConversionRecordEo unitEo = (OrderUnitConversionRecordEo)unitConversionRecordDtoMap.get(this.getKey(orderDetailEo.getSkuCode(), orderDetailEo.getChangeQuantity(), orderDetailEo.getUnit()));
                BaseOrderDetailReqDto baseOrderDetailReqDto = new BaseOrderDetailReqDto();
                baseOrderDetailReqDto.setBatch(orderDetailEo.getBatch());
                baseOrderDetailReqDto.setPreOrderItemId(orderDetailEo.getId());
                baseOrderDetailReqDto.setProduceTime(orderDetailEo.getProduceTime());
                baseOrderDetailReqDto.setExpireTime(orderDetailEo.getExpireTime());
                baseOrderDetailReqDto.setSkuCode(orderDetailEo.getSkuCode());
                baseOrderDetailReqDto.setInventoryProperty(orderDetailEo.getInventoryProperty());
                baseOrderDetailReqDto.setSkuName(orderDetailEo.getSkuName());
                baseOrderDetailReqDto.setQuantity(BeanUtil.isNotEmpty((Object)unitEo, (String[])new String[0]) ? unitEo.getToNum() : orderDetailEo.getChangeQuantity());
                orderDetailReqDtos.add(baseOrderDetailReqDto);
            });
            noticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(orderDetailReqDtos);
            this.baseOrderFacade.receiveNoticeOrderGen(noticeOrderFacadeBo);
        }
    }

    private Map<Object, OrderUnitConversionRecordEo> getUnitConversionRecordDtoMap(String adjustmentNo) {
        return this.orderUnitConversionRecordService.getRecordByOrderNo(adjustmentNo).stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getNum(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
    }

    private Object getKey(String skuCode, BigDecimal num, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + num.setScale(6) + InventoryConfig.getCommonSeparate() + currentUnit;
    }

    private String getBatchSkuKey(String batch, String skuCode) {
        return batch + InventoryConfig.getCommonSeparate() + skuCode;
    }
}

