/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.order;

import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.service.business.order.AbstractAdapter;
import com.yunxi.dg.base.center.inventory.service.business.order.AbstractBusinessOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.impl.AdjustmentOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.impl.AfterSaleOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.impl.AssemblyDisassemblyOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.impl.OtherStorageOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.impl.PlanOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.impl.SaleOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.impl.SaleRefundOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.impl.TransferOrder;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class BusinessOrderStrategyFactory {
    @Resource
    private AbstractAdapter abstractAdapter;
    @Resource
    private AfterSaleOrder afterSaleOrder;
    @Resource
    private OtherStorageOrder otherStorageOrder;
    @Resource
    private PlanOrder planOrder;
    @Resource
    private SaleRefundOrder saleRefundOrder;
    @Resource
    private TransferOrder transferOrder;
    @Resource
    private AdjustmentOrder adjustmentOrder;
    @Resource
    private AssemblyDisassemblyOrder assemblyDisassemblyOrder;
    @Resource
    private SaleOrder saleOrder;

    public AbstractBusinessOrder createBusinessOrderStrategy(CsRelevanceTableNameEnum type) {
        switch (type) {
            case CS_ORDER_AFTER_SALE: {
                return this.afterSaleOrder;
            }
            case CS_ORDER_SALE_REFUND: {
                return this.saleRefundOrder;
            }
            case IN_OTHER_STORAGE_ORDER: {
                return this.otherStorageOrder;
            }
            case PLAN_ORDER: {
                return this.planOrder;
            }
            case CS_TRANSFER_ORDER: {
                return this.transferOrder;
            }
            case IN_ADJUSTMENT_ORDER: {
                return this.adjustmentOrder;
            }
            case ASSEMBLY_DISASSEMBLY_ORDER: {
                return this.assemblyDisassemblyOrder;
            }
            case CS_ORDER_SALE: {
                return this.saleOrder;
            }
        }
        return this.abstractAdapter;
    }
}

